/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.p10ss.util;

import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.UUID;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.net.HttpUtil;
import org.anyline.p10ss.util.P10ssConfig;
import org.anyline.util.BasicUtil;
import org.anyline.util.encrypt.MD5Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class P10ssUtil {
    private static final Logger log = LoggerFactory.getLogger(P10ssUtil.class);
    private static DataSet accessTokens = new DataSet();
    private P10ssConfig config = null;
    private static Hashtable<String, P10ssUtil> instances = new Hashtable();

    public static P10ssUtil getInstance() {
        return P10ssUtil.getInstance("default");
    }

    public P10ssUtil(P10ssConfig config) {
        this.config = config;
    }

    public P10ssUtil(String key, DataRow config) {
        P10ssConfig conf;
        this.config = conf = P10ssConfig.parse(key, config);
        instances.put(key, this);
    }

    public static P10ssUtil reg(String key, DataRow config) {
        P10ssConfig conf = P10ssConfig.reg(key, config);
        P10ssUtil util = new P10ssUtil(conf);
        instances.put(key, util);
        return util;
    }

    public static P10ssUtil getInstance(String key) {
        P10ssConfig config;
        P10ssUtil util;
        if (BasicUtil.isEmpty((Object)key)) {
            key = "default";
        }
        if (null == (util = instances.get(key)) && null != (config = P10ssConfig.getInstance(key))) {
            util = new P10ssUtil(config);
            instances.put(key, util);
        }
        return util;
    }

    public P10ssConfig getConfig() {
        return this.config;
    }

    private DataRow api(P10ssConfig.URL url, Map<String, Object> params) {
        DataRow result = null;
        long time = System.currentTimeMillis() / 1000L;
        params.put("client_id", this.config.APP_ID);
        params.put("timestamp", time);
        params.put("sign", this.sign(time));
        params.put("id", UUID.randomUUID().toString());
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/x-www-form-urlencoded");
        String txt = HttpUtil.post(header, (String)url.getCode(), (String)"UTF-8", params).getText();
        log.warn("[invoike api][result:{}]", (Object)txt);
        DataRow row = DataRow.parseJson((String)txt);
        if (row.getInt("error", Integer.valueOf(-1)) == 0) {
            result = row.getRow("body");
            if (null == result) {
                result = new DataRow();
            }
            result.put("success", (Object)true);
        } else {
            result = new DataRow();
            result.put("success", (Object)false);
            result.put("error", (Object)row.getString("error_description"));
        }
        return result;
    }

    public DataRow getAccessToken() {
        DataRow row = null;
        row = accessTokens.getRow(new String[]{"APP_ID", this.config.APP_ID});
        if (null == row) {
            row = this.newAccessToken();
        } else if (row.isExpire()) {
            row = this.refreshAccessToken(row.getString("refresh_token"));
        }
        return row;
    }

    public DataRow getAccessToken(String code) {
        DataRow row = null;
        row = this.newAccessToken(code);
        return row;
    }

    public DataRow newAccessToken() {
        DataRow row = null;
        if (BasicUtil.isEmpty((Object)this.config.ACCESS_TOKEN_SERVER)) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("grant_type", "client_credentials");
            params.put("scope", "all");
            row = this.api(P10ssConfig.URL.ACCESS_TOKEN, params);
            log.warn("[new access token][token:{}]", (Object)row);
        } else {
            String url = this.config.ACCESS_TOKEN_SERVER + "?appid=" + this.config.APP_ID + "&secret=" + this.config.APP_SECRET;
            String text = HttpUtil.post((String)url).getText();
            row = DataRow.parseJson((String)text);
            log.warn("[new access token][server:{}][token:{}]", (Object)this.config.ACCESS_TOKEN_SERVER, (Object)row);
        }
        row.put("APP_ID", (Object)this.config.APP_ID);
        accessTokens.addRow(row);
        return row;
    }

    public DataRow newAccessToken(String code) {
        DataRow row = null;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("grant_type", "authorization_code");
        params.put("code", code);
        params.put("scope", "all");
        row = this.api(P10ssConfig.URL.ACCESS_TOKEN, params);
        log.warn("[new access token][code:{}][token:{}]", (Object)code, (Object)row);
        row.put("APP_ID", (Object)this.config.APP_ID);
        return row;
    }

    public DataRow refreshAccessToken(String refresh) {
        DataRow row = null;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("grant_type", "refresh_token");
        params.put("scope", "all");
        params.put("refresh_token", refresh);
        row = this.api(P10ssConfig.URL.ACCESS_TOKEN, params);
        return row;
    }

    public String createAuthorizeCodeUrl(String redirect, String state) {
        try {
            redirect = URLEncoder.encode(redirect, "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String url = "https://open-api.10ss.net/oauth/authorize?response_type=code&client_id=" + this.config.APP_ID + "&redirect_uri=" + redirect + "&state=" + state;
        return url;
    }

    public void addPrinter(String code, String secret, String phone, String name) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("machine_code", code);
        params.put("msign", secret);
        if (BasicUtil.isNotEmpty((Object)phone)) {
            params.put("phone", phone);
        }
        if (BasicUtil.isNotEmpty((Object)name)) {
            params.put("print_name", name);
        }
        DataRow token = this.getAccessToken();
        params.put("access_token", token.getString("access_token"));
        DataRow row = this.api(P10ssConfig.URL.ADD_PRINTER, params);
        if (!row.getBoolean("success", Boolean.valueOf(false)).booleanValue()) {
            throw new Exception(row.getString("error"));
        }
    }

    public void addPrinter(String code, String secret) throws Exception {
        this.addPrinter(code, secret, null, null);
    }

    public DataRow print(String machine, String order, String text) throws Exception {
        DataRow token = this.getAccessToken();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("machine_code", machine);
        if (BasicUtil.isNotEmpty((Object)order)) {
            params.put("origin_id", order);
        }
        params.put("content", text);
        params.put("access_token", token.getString("access_token"));
        return this.api(P10ssConfig.URL.PRINT_TEXT, params);
    }

    private String sign(long time) {
        String result = MD5Util.crypto((String)(this.config.APP_ID + time + this.config.APP_SECRET)).toLowerCase();
        return result;
    }
}

