/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.poi.excel;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.anyline.entity.html.Table;
import org.anyline.entity.html.Td;
import org.anyline.entity.html.Tr;
import org.anyline.office.docx.util.DocxUtil;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.FileUtil;
import org.anyline.util.regular.RegularUtil;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelUtil {
    public static final String OFFICE_EXCEL_XLS = "xls";
    public static final String OFFICE_EXCEL_XLSX = "xlsx";

    public static List<List<String>> read(File file, int sheet, int rows, int foot) {
        List<List<String>> list = null;
        try {
            Workbook workbook = ExcelUtil.getWorkbook(file);
            list = ExcelUtil.read(workbook.getSheetAt(sheet), rows, foot);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static List<List<String>> read(File file, int sheet, int rows) {
        List<List<String>> list = null;
        try {
            Workbook workbook = ExcelUtil.getWorkbook(file);
            list = ExcelUtil.read(workbook.getSheetAt(sheet), rows, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static int[] position(Sheet sheet, int rows, int cols, String regex) {
        int row = -1;
        int col = -1;
        int last = sheet.getLastRowNum();
        for (int r = rows; r <= last; ++r) {
            ArrayList list = new ArrayList();
            Row line = sheet.getRow(r);
            if (line != null) {
                short cells = line.getLastCellNum();
                for (int c = cols; c < cells; ++c) {
                    Cell cell = line.getCell(c);
                    String value = null;
                    value = cell != null ? (ExcelUtil.isMerged(sheet, r, c) ? ExcelUtil.getMergedRegionValue(sheet, r, c) : ExcelUtil.value(cell)) : ExcelUtil.getMergedRegionValue(sheet, r, c);
                    if (null == value || !RegularUtil.match((String)value, (String)regex)) continue;
                    row = r;
                    col = c;
                    break;
                }
            }
            if (row != -1) break;
        }
        return new int[]{row, col};
    }

    public static int[] position(InputStream is, int sheet, int rows, int cols, String regex) {
        try {
            Workbook workbook = ExcelUtil.getWorkbook(is);
            return ExcelUtil.position(workbook.getSheetAt(sheet), rows, cols, regex);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new int[]{-1, -1};
        }
    }

    public static int[] position(InputStream is, String sheet, int rows, int cols, String regex) {
        try {
            Workbook workbook = ExcelUtil.getWorkbook(is);
            return ExcelUtil.position(workbook.getSheet(sheet), rows, cols, regex);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new int[]{-1, -1};
        }
    }

    public static int[] position(InputStream is, int sheet, String regex) {
        return ExcelUtil.position(is, sheet, 0, 0, regex);
    }

    public static int[] position(InputStream is, String sheet, String regex) {
        return ExcelUtil.position(is, sheet, 0, 0, regex);
    }

    public static int[] position(InputStream is, String regex) {
        return ExcelUtil.position(is, 0, 0, 0, regex);
    }

    public static int[] position(File file, int sheet, int rows, int cols, String regex) {
        try {
            Workbook workbook = ExcelUtil.getWorkbook(file);
            return ExcelUtil.position(workbook.getSheetAt(sheet), rows, cols, regex);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new int[]{-1, -1};
        }
    }

    public static int[] position(File file, String sheet, int rows, int cols, String regex) {
        try {
            Workbook workbook = ExcelUtil.getWorkbook(file);
            return ExcelUtil.position(workbook.getSheet(sheet), rows, cols, regex);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new int[]{-1, -1};
        }
    }

    public static int[] position(File file, int sheet, String regex) {
        return ExcelUtil.position(file, sheet, 0, 0, regex);
    }

    public static int[] position(File file, String sheet, String regex) {
        return ExcelUtil.position(file, sheet, 0, 0, regex);
    }

    public static int[] position(File file, String regex) {
        return ExcelUtil.position(file, 0, 0, 0, regex);
    }

    public static List<List<String>> read(InputStream is, int sheet, int rows) {
        return ExcelUtil.read(is, sheet, rows, 0);
    }

    public static List<List<String>> read(InputStream is, int sheet, int rows, int foot) {
        List<List<String>> list = null;
        try {
            Workbook workbook = ExcelUtil.getWorkbook(is);
            list = ExcelUtil.read(workbook.getSheetAt(sheet), rows, foot);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static List<List<String>> read(File file, int sheet) {
        return ExcelUtil.read(file, sheet, 0);
    }

    public static List<List<String>> read(InputStream is, int sheet) {
        return ExcelUtil.read(is, sheet, 0);
    }

    public static List<List<String>> read(File file) {
        return ExcelUtil.read(file, 0, 0);
    }

    public static List<List<String>> read(InputStream is) {
        return ExcelUtil.read(is, 0, 0);
    }

    public static List<List<String>> read(File file, String sheet, int rows) {
        List<List<String>> list = null;
        try {
            Workbook workbook = ExcelUtil.getWorkbook(file);
            list = ExcelUtil.read(workbook.getSheet(sheet), rows, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static List<List<String>> read(File file, String sheet, int rows, int foot) {
        List<List<String>> list = null;
        try {
            Workbook workbook = ExcelUtil.getWorkbook(file);
            list = ExcelUtil.read(workbook.getSheet(sheet), rows, foot);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static List<List<String>> read(InputStream is, String sheet, int rows, int foot) {
        List<List<String>> list = null;
        try {
            Workbook workbook = ExcelUtil.getWorkbook(is);
            list = ExcelUtil.read(workbook.getSheet(sheet), rows, foot);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static List<List<String>> read(InputStream is, String sheet, int rows) {
        return ExcelUtil.read(is, sheet, rows, 0);
    }

    public static List<List<String>> read(File file, String sheet) {
        return ExcelUtil.read(file, sheet, 0);
    }

    public static List<List<String>> read(InputStream is, String sheet) {
        return ExcelUtil.read(is, sheet, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Workbook getWorkbook(File file) throws EncryptedDocumentException, InvalidFormatException, IOException {
        FileInputStream is = null;
        Workbook wb = null;
        String suffix = FileUtil.getSuffixFileName((File)file);
        if (OFFICE_EXCEL_XLS.equals(suffix) || OFFICE_EXCEL_XLSX.equals(suffix)) {
            try {
                is = new FileInputStream(file);
                wb = WorkbookFactory.create((InputStream)is);
            }
            finally {
                if (is != null) {
                    ((InputStream)is).close();
                }
                if (wb != null) {
                    wb.close();
                }
            }
        } else {
            throw new IllegalArgumentException("\u975eExcel\u6587\u4ef6");
        }
        return wb;
    }

    public static Workbook getWorkbook(InputStream is) throws EncryptedDocumentException, InvalidFormatException, IOException {
        Workbook wb = null;
        try {
            wb = WorkbookFactory.create((InputStream)is);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (wb != null) {
                wb.close();
            }
        }
        return wb;
    }

    public static List<List<String>> read(Sheet sheet, int start, int end) {
        ArrayList<List<String>> lists = new ArrayList<List<String>>();
        if (sheet != null) {
            int max;
            int last = max = sheet.getLastRowNum();
            if (end < 0) {
                last = max + end;
            } else if (end > 0) {
                last = end;
            }
            for (int r = start; r <= last; ++r) {
                ArrayList<String> list = new ArrayList<String>();
                Row row = sheet.getRow(r);
                if (row == null) continue;
                int cells = row.getLastCellNum();
                for (int c = 0; c < cells; ++c) {
                    Cell cell = row.getCell(c);
                    String value = null;
                    value = cell != null ? (ExcelUtil.isMerged(sheet, r, c) ? ExcelUtil.getMergedRegionValue(sheet, r, c) : ExcelUtil.value(cell)) : ExcelUtil.getMergedRegionValue(sheet, r, c);
                    list.add(value);
                }
                lists.add(list);
            }
        }
        return lists;
    }

    public static boolean isMerged(Sheet sheet, int row, int col) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress range = sheet.getMergedRegion(i);
            int firstColumn = range.getFirstColumn();
            int lastColumn = range.getLastColumn();
            int firstRow = range.getFirstRow();
            int lastRow = range.getLastRow();
            if (row < firstRow || row > lastRow || col < firstColumn || col > lastColumn) continue;
            return true;
        }
        return false;
    }

    public static String getMergedRegionValue(Sheet sheet, int row, int col) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress ca = sheet.getMergedRegion(i);
            int firstColumn = ca.getFirstColumn();
            int lastColumn = ca.getLastColumn();
            int firstRow = ca.getFirstRow();
            int lastRow = ca.getLastRow();
            if (row < firstRow || row > lastRow || col < firstColumn || col > lastColumn) continue;
            Row fRow = sheet.getRow(firstRow);
            Cell fCell = fRow.getCell(firstColumn);
            return ExcelUtil.value(fCell);
        }
        return null;
    }

    public static List<String> values(File file, int sheet, int row) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Workbook workbook = WorkbookFactory.create((File)file);
            return ExcelUtil.values(workbook.getSheetAt(sheet), row);
        }
        catch (Exception e) {
            e.printStackTrace();
            return list;
        }
    }

    public static List<String> values(InputStream is, int sheet, int row) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Workbook workbook = WorkbookFactory.create((InputStream)is);
            return ExcelUtil.values(workbook.getSheetAt(sheet), row);
        }
        catch (Exception e) {
            e.printStackTrace();
            return list;
        }
    }

    public static List<String> values(InputStream is, int row) {
        return ExcelUtil.values(is, 0, row);
    }

    public static List<String> values(File file, int row) {
        return ExcelUtil.values(file, 0, row);
    }

    public static List<String> values(File file, String sheet, int row) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Workbook workbook = WorkbookFactory.create((File)file);
            return ExcelUtil.values(workbook.getSheet(sheet), row);
        }
        catch (Exception e) {
            e.printStackTrace();
            return list;
        }
    }

    public static List<String> values(InputStream is, String sheet, int row) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Workbook workbook = WorkbookFactory.create((InputStream)is);
            return ExcelUtil.values(workbook.getSheet(sheet), row);
        }
        catch (Exception e) {
            e.printStackTrace();
            return list;
        }
    }

    public static List<String> values(Sheet sheet, int row) {
        ArrayList<String> list = new ArrayList<String>();
        Row r = sheet.getRow(row);
        int rowNum = r.getLastCellNum();
        for (int i = 0; i < rowNum; ++i) {
            list.add(ExcelUtil.value(r.getCell(i)));
        }
        return list;
    }

    public static List<String> values(String path, int sheet, int row) {
        return ExcelUtil.values(new File(path), sheet, row);
    }

    public static List<String> values(String path, String sheet, int row) {
        return ExcelUtil.values(new File(path), sheet, row);
    }

    public static List<String> values(String path, int row) {
        return ExcelUtil.values(new File(path), 0, row);
    }

    public static String value(Sheet sheet, int row, int col) {
        return ExcelUtil.value(sheet.getRow(row).getCell(col));
    }

    public static String value(String path, int sheet, int row, int col) {
        File file = new File(path);
        return ExcelUtil.value(file, sheet, row, col);
    }

    public static String value(Workbook workbook, int sheet, int row, int col) {
        return ExcelUtil.value(workbook.getSheetAt(sheet), row, col);
    }

    public static String value(Workbook workbook, String sheet, int row, int col) {
        return ExcelUtil.value(workbook.getSheet(sheet), row, col);
    }

    public static String value(File file, int sheet, int row, int col) {
        try {
            Workbook workbook = WorkbookFactory.create((File)file);
            return ExcelUtil.value(workbook, sheet, row, col);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String value(File file, String sheet, int row, int col) {
        try {
            Workbook workbook = WorkbookFactory.create((File)file);
            return ExcelUtil.value(workbook, sheet, row, col);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String value(InputStream is, int sheet, int row, int col) {
        try {
            Workbook workbook = WorkbookFactory.create((InputStream)is);
            return ExcelUtil.value(workbook, sheet, row, col);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String value(InputStream is, String sheet, int row, int col) {
        try {
            Workbook workbook = WorkbookFactory.create((InputStream)is);
            return ExcelUtil.value(workbook, sheet, row, col);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String value(InputStream is, int row, int col) {
        return ExcelUtil.value(is, 0, row, col);
    }

    public static void value(String path, int sheet, int row, int col, String value) {
        ExcelUtil.value(new File(path), sheet, row, col, value);
    }

    public static void value(String path, int row, int col, String value) {
        ExcelUtil.value(new File(path), 0, row, col, value);
    }

    public static void value(String path, String sheet, int row, int col, String value) {
        ExcelUtil.value(new File(path), sheet, row, col, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void value(File file, int sheet, int row, int col, String value) {
        OutputStream os = null;
        try {
            File tempFile = FileUtil.createTempFile((File)file);
            FileInputStream is = new FileInputStream(tempFile);
            XSSFWorkbook workbook = new XSSFWorkbook((InputStream)is);
            ExcelUtil.value(workbook.getSheetAt(sheet), row, col, value);
            is.close();
            tempFile.delete();
            os = new FileOutputStream(file);
            workbook.write(os);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != os) {
                try {
                    os.flush();
                    os.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void value(File file, String sheet, int row, int col, String value) {
        OutputStream os = null;
        try {
            File tempFile = FileUtil.createTempFile((File)file);
            FileInputStream is = new FileInputStream(tempFile);
            XSSFWorkbook workbook = new XSSFWorkbook((InputStream)is);
            ExcelUtil.value(workbook.getSheet(sheet), row, col, value);
            is.close();
            tempFile.delete();
            os = new FileOutputStream(file);
            workbook.write(os);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != os) {
                try {
                    os.flush();
                    os.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void value(String path, int sheet, int row, int col, double value) {
        ExcelUtil.value(new File(path), sheet, row, col, value);
    }

    public static void value(String path, int row, int col, double value) {
        ExcelUtil.value(new File(path), 0, row, col, value);
    }

    public static void value(String path, String sheet, int row, int col, double value) {
        ExcelUtil.value(new File(path), sheet, row, col, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void value(File file, int sheet, int row, int col, double value) {
        OutputStream os = null;
        try {
            File tempFile = FileUtil.createTempFile((File)file);
            FileInputStream is = new FileInputStream(tempFile);
            XSSFWorkbook workbook = new XSSFWorkbook((InputStream)is);
            ExcelUtil.value(workbook.getSheetAt(sheet), row, col, value);
            is.close();
            tempFile.delete();
            os = new FileOutputStream(file);
            workbook.write(os);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != os) {
                try {
                    os.flush();
                    os.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void value(File file, String sheet, int row, int col, double value) {
        OutputStream os = null;
        try {
            File tempFile = FileUtil.createTempFile((File)file);
            FileInputStream is = new FileInputStream(tempFile);
            XSSFWorkbook workbook = new XSSFWorkbook((InputStream)is);
            ExcelUtil.value(workbook.getSheet(sheet), row, col, value);
            is.close();
            tempFile.delete();
            os = new FileOutputStream(file);
            workbook.write(os);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != os) {
                try {
                    os.flush();
                    os.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void value(String path, int sheet, int row, int col, int value) {
        ExcelUtil.value(new File(path), sheet, row, col, value);
    }

    public static void value(String path, String sheet, int row, int col, int value) {
        ExcelUtil.value(new File(path), sheet, row, col, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void value(File file, int sheet, int row, int col, int value) {
        OutputStream os = null;
        try {
            File tempFile = FileUtil.createTempFile((File)file);
            FileInputStream is = new FileInputStream(tempFile);
            XSSFWorkbook workbook = new XSSFWorkbook((InputStream)is);
            ExcelUtil.value(workbook.getSheetAt(sheet), row, col, value);
            is.close();
            tempFile.delete();
            os = new FileOutputStream(file);
            workbook.write(os);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != os) {
                try {
                    os.flush();
                    os.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void value(File file, String sheet, int row, int col, int value) {
        OutputStream os = null;
        try {
            File tempFile = FileUtil.createTempFile((File)file);
            FileInputStream is = new FileInputStream(tempFile);
            XSSFWorkbook workbook = new XSSFWorkbook((InputStream)is);
            ExcelUtil.value(workbook.getSheet(sheet), row, col, value);
            is.close();
            tempFile.delete();
            os = new FileOutputStream(file);
            workbook.write(os);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != os) {
                try {
                    os.flush();
                    os.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void value(Sheet sheet, int row, int col, String value) {
        Cell cell;
        Row r = sheet.getRow(row);
        if (null == r) {
            r = sheet.createRow(row);
        }
        if (null == (cell = r.getCell(col))) {
            cell = r.createCell(col);
        }
        cell.setCellValue(value);
    }

    public static void value(Sheet sheet, int row, int col, double value) {
        Cell cell;
        Row r = sheet.getRow(row);
        if (null == r) {
            r = sheet.createRow(row);
        }
        if (null == (cell = r.getCell(col))) {
            cell = r.createCell(col);
        }
        cell.setCellValue(value);
    }

    public static void value(Sheet sheet, int row, int col, int value) {
        Cell cell;
        Row r = sheet.getRow(row);
        if (null == r) {
            r = sheet.createRow(row);
        }
        if (null == (cell = r.getCell(col))) {
            cell = r.createCell(col);
        }
        cell.setCellValue((double)value);
    }

    public static String value(Cell cell) {
        if (cell == null || cell.toString().trim().equals("")) {
            return "";
        }
        Object value = "";
        switch (cell.getCellType()) {
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    Date date = cell.getDateCellValue();
                    SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    value = formater.format(date);
                    break;
                }
                cell.setCellType(CellType.STRING);
                value = cell.getStringCellValue();
                break;
            }
            case STRING: {
                value = cell.getStringCellValue();
                break;
            }
            case BOOLEAN: {
                value = "" + cell.getBooleanCellValue();
                break;
            }
            case FORMULA: {
                value = cell.getCellFormula();
                break;
            }
            case BLANK: {
                value = "";
                break;
            }
            case ERROR: {
                value = "";
                break;
            }
            default: {
                value = "";
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean export(OutputStream os, String sheet, int insert, List<String> headers, List<String> keys, Collection<?> set) {
        try {
            XSSFWorkbook workbook = null;
            XSSFSheet sht = null;
            workbook = new XSSFWorkbook();
            if (BasicUtil.isEmpty((Object)sheet)) {
                sheet = "sheet1";
            }
            sht = workbook.createSheet(sheet);
            ExcelUtil.write((Sheet)sht, insert, headers, keys, set);
            workbook.write(os);
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                os.flush();
                os.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private static void write(Sheet sheet, int insert, List<String> headers, List<String> keys, Collection<?> set) {
        if (null != headers && headers.size() > 0) {
            Row row = sheet.createRow(insert++);
            int c = 0;
            for (String header : headers) {
                Cell cell = row.createCell(c++);
                cell.setCellType(CellType.STRING);
                cell.setCellValue(header);
            }
        }
        int num = 1;
        for (Object item : set) {
            Row row = sheet.createRow(insert++);
            int c = 0;
            for (String key : keys) {
                Cell cell = row.createCell(c++);
                cell.setCellType(CellType.STRING);
                if (key.equals("${num}")) {
                    cell.setCellValue((double)num);
                    continue;
                }
                cell.setCellValue(BeanUtil.parseFinalValue(item, (String)key, (String)""));
            }
            ++num;
        }
    }

    public static boolean export(File file, String sheet, int insert, Table table) {
        FileOutputStream os = null;
        try {
            XSSFWorkbook workbook = null;
            XSSFSheet sht = null;
            if (file.exists()) {
                File tempFile = FileUtil.createTempFile((File)file);
                FileInputStream is = new FileInputStream(tempFile);
                workbook = new XSSFWorkbook((InputStream)is);
                if (BasicUtil.isEmpty((Object)sheet)) {
                    sht = workbook.getSheetAt(0);
                } else {
                    sht = workbook.getSheet(sheet);
                    if (null == sht) {
                        sht = workbook.createSheet(sheet);
                    }
                }
                is.close();
                tempFile.delete();
            } else {
                workbook = new XSSFWorkbook();
                if (BasicUtil.isEmpty((Object)sheet)) {
                    sheet = "sheet1";
                }
                sht = workbook.createSheet(sheet);
            }
            File dir = file.getParentFile();
            if (null != dir && !dir.exists()) {
                file.getParentFile().mkdirs();
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            os = new FileOutputStream(file);
            ExcelUtil.write(workbook, os, (Sheet)sht, insert, table);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean export(File file, Table table) {
        String sheet = "sheet1";
        return ExcelUtil.export(file, sheet, 0, table);
    }

    public static boolean export(File file, String sheet, Table table) {
        return ExcelUtil.export(file, sheet, 0, table);
    }

    public static boolean export(File template, OutputStream os, String sheet, int insert, Table table) {
        try {
            XSSFSheet sht = null;
            FileInputStream is = new FileInputStream(template);
            XSSFWorkbook workbook = new XSSFWorkbook((InputStream)is);
            if (BasicUtil.isEmpty((Object)sheet)) {
                sht = workbook.getSheetAt(0);
            } else {
                sht = workbook.getSheet(sheet);
                if (null == sht) {
                    sht = workbook.createSheet(sheet);
                }
            }
            is.close();
            ExcelUtil.write(workbook, os, (Sheet)sht, insert, table);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean export(File template, File file, String sheet, int insert, Table table) {
        try {
            XSSFSheet sht = null;
            FileInputStream is = new FileInputStream(template);
            XSSFWorkbook workbook = new XSSFWorkbook((InputStream)is);
            if (BasicUtil.isEmpty((Object)sheet)) {
                sht = workbook.getSheetAt(0);
            } else {
                sht = workbook.getSheet(sheet);
                if (null == sht) {
                    sht = workbook.createSheet(sheet);
                }
            }
            is.close();
            FileUtil.create((File)file, (boolean)false);
            ExcelUtil.write(workbook, new FileOutputStream(file), (Sheet)sht, insert, table);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean export(File template, File file, int sheet, int insert, Table table) {
        try {
            XSSFSheet sht = null;
            FileInputStream is = new FileInputStream(template);
            XSSFWorkbook workbook = new XSSFWorkbook((InputStream)is);
            sht = workbook.getSheetAt(sheet);
            is.close();
            FileUtil.create((File)file, (boolean)false);
            ExcelUtil.write(workbook, new FileOutputStream(file), (Sheet)sht, insert, table);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean export(File template, OutputStream os, Table table) {
        return ExcelUtil.export(template, os, "", 0, table);
    }

    public static boolean export(OutputStream os, String sheet, int insert, Table table) {
        try {
            XSSFWorkbook workbook = new XSSFWorkbook();
            if (BasicUtil.isEmpty((Object)sheet)) {
                sheet = "sheet1";
            }
            XSSFSheet sht = workbook.createSheet(sheet);
            ExcelUtil.write(workbook, os, (Sheet)sht, insert, table);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private static Row row(Sheet sheet, int r) {
        Row row = null;
        int last = sheet.getLastRowNum();
        if (r <= last) {
            row = sheet.getRow(r);
            if (null == row) {
                row = sheet.createRow(r);
            }
        } else {
            row = sheet.createRow(r);
        }
        return row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void write(XSSFWorkbook workbook, OutputStream os, Sheet sheet, int insert, Table table) {
        try {
            int size = table.getTrs().size();
            int last = sheet.getLastRowNum();
            if (last > 0 && last >= insert && size > 0) {
                sheet.shiftRows(insert, last, size);
            }
            List trs = table.getTrs();
            for (Tr tr : trs) {
                Row row = ExcelUtil.row(sheet, insert);
                List tds = tr.getTds();
                for (Td td : tds) {
                    Map styles;
                    Cell prevCell;
                    Row prevRow;
                    short lastCellIndex;
                    int rowspan = td.getRowspan();
                    int colspan = td.getColspan();
                    int colIndex = td.getColIndex();
                    int x = td.getColIndex();
                    int y = td.getRowIndex();
                    int offset = td.getOffset();
                    CellStyle style = null;
                    if (insert - 1 > 0 && colIndex + offset >= (lastCellIndex = (prevRow = sheet.getRow(insert - 1)).getLastCellNum()) && null != (prevCell = prevRow.getCell(colIndex + offset))) {
                        style = prevCell.getCellStyle();
                    }
                    if (null != (styles = td.getStyles()) || !styles.isEmpty()) {
                        if (null == style) {
                            style = sheet.getWorkbook().createCellStyle();
                        }
                        ExcelUtil.parseStyle(style, styles);
                        Font font = sheet.getWorkbook().createFont();
                        font = ExcelUtil.parseFont(font, styles);
                        if (null != font) {
                            style.setFont(font);
                        }
                    }
                    if (rowspan > 1 || colspan > 1) {
                        int firstRow = insert;
                        int lastRow = firstRow + rowspan - 1;
                        int firstCol = x + offset;
                        int lastCol = firstCol + colspan - 1;
                        CellRangeAddress region = new CellRangeAddress(firstRow, lastRow, firstCol, lastCol);
                        sheet.addMergedRegion(region);
                        for (int rr = 1; rr < rowspan; ++rr) {
                            Row mergeRow = ExcelUtil.row(sheet, insert + rr);
                            for (int cc = 0; cc < colspan; ++cc) {
                                Cell mergeCell = mergeRow.createCell(colIndex + offset + cc);
                                mergeCell.setCellStyle(style);
                            }
                        }
                        if (colspan > 1) {
                            for (int cc = 1; cc < colspan; ++cc) {
                                Cell mergeCell = row.createCell(colIndex + offset + cc);
                                if (null == style) continue;
                                mergeCell.setCellStyle(style);
                            }
                        }
                    }
                    Cell cell = row.createCell(colIndex + offset);
                    if (null != style) {
                        cell.setCellStyle(style);
                    }
                    cell.setCellType(CellType.STRING);
                    cell.setCellValue(td.getTextTrim());
                }
                ++insert;
            }
            workbook.write(os);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                os.flush();
                os.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static BorderStyle parseBorderStyle(Map<String, String> styles, String side) {
        BorderStyle result = BorderStyle.NONE;
        String style = styles.get("border-" + side + "-style");
        if (BasicUtil.isEmpty((Object)style)) {
            style = styles.get("border-style");
        }
        if (BasicUtil.isNotEmpty((Object)style)) {
            result = "solid".equalsIgnoreCase(style) ? BorderStyle.THIN : ("double".equalsIgnoreCase(style) ? BorderStyle.DOUBLE : ("dashed".equalsIgnoreCase(style) ? BorderStyle.DASHED : ("dotted".equalsIgnoreCase(style) ? BorderStyle.DOTTED : ("thick".equalsIgnoreCase(style) ? BorderStyle.THICK : BorderStyle.THIN))));
        }
        return result;
    }

    private static CellStyle parseStyle(CellStyle style, Map<String, String> styles) {
        if (null != styles) {
            String verticalAlign;
            style.setBorderTop(ExcelUtil.parseBorderStyle(styles, "top"));
            style.setBorderBottom(ExcelUtil.parseBorderStyle(styles, "bottom"));
            style.setBorderRight(ExcelUtil.parseBorderStyle(styles, "right"));
            style.setBorderLeft(ExcelUtil.parseBorderStyle(styles, "left"));
            String textAlign = styles.get("text-align");
            if (BasicUtil.isNotEmpty((Object)textAlign)) {
                if ("center".equals(textAlign)) {
                    style.setAlignment(HorizontalAlignment.CENTER);
                } else if ("left".equals(textAlign)) {
                    style.setAlignment(HorizontalAlignment.LEFT);
                } else if ("right".equals(textAlign)) {
                    style.setAlignment(HorizontalAlignment.RIGHT);
                }
            }
            if (BasicUtil.isNotEmpty((Object)(verticalAlign = styles.get("vertical-align")))) {
                if ("center".equals(verticalAlign) || "middle".equals(verticalAlign)) {
                    style.setVerticalAlignment(VerticalAlignment.CENTER);
                } else if ("top".equals(verticalAlign)) {
                    style.setVerticalAlignment(VerticalAlignment.TOP);
                } else if ("bottom".equals(verticalAlign)) {
                    style.setVerticalAlignment(VerticalAlignment.BOTTOM);
                }
            }
        }
        return style;
    }

    private static Font parseFont(Font font, Map<String, String> styles) {
        if (null != styles) {
            String underline;
            int weight;
            String fontWeight;
            String italics;
            String strike;
            String fontFamily;
            String fontSize = styles.get("font-size");
            if (null != fontSize) {
                short pt = 0;
                if (fontSize.endsWith("px")) {
                    int px = BasicUtil.parseInt((Object)fontSize.replace("px", ""), (Integer)0);
                    pt = (short)DocxUtil.px2pt((double)px);
                } else if (fontSize.endsWith("pt")) {
                    pt = BasicUtil.parseInt((Object)fontSize.replace("pt", ""), (Integer)0).shortValue();
                }
                if (pt > 0) {
                    font.setFontHeightInPoints(pt);
                }
            }
            if (BasicUtil.isNotEmpty((Object)(fontFamily = styles.get("font-family")))) {
                font.setFontName(fontFamily);
            }
            if (null != (strike = styles.get("strike")) && strike.equalsIgnoreCase("true")) {
                font.setStrikeout(true);
            }
            if (null != (italics = styles.get("italic")) && italics.equalsIgnoreCase("true")) {
                font.setItalic(true);
            }
            if (null != (fontWeight = styles.get("font-weight")) && fontWeight.length() > 0 && (weight = BasicUtil.parseInt((Object)fontWeight, (Integer)0).intValue()) >= 700) {
                font.setBold(true);
            }
            if (null != (underline = styles.get("underline"))) {
                font.setUnderline((byte)1);
            }
            return font;
        }
        return null;
    }

    public static boolean export(File file, int rows, List<String> headers, List<String> keys, Collection<?> set) {
        return ExcelUtil.export(file, "sheet1", rows, headers, keys, set);
    }

    public static boolean export(OutputStream os, int rows, List<String> headers, List<String> keys, Collection<?> set) {
        return ExcelUtil.export(os, "sheet1", rows, headers, keys, set);
    }

    public static boolean export(File file, List<String> keys, Collection<?> set) {
        return ExcelUtil.export(file, 0, null, keys, set);
    }

    public static boolean export(OutputStream os, List<String> keys, Collection<?> set) {
        return ExcelUtil.export(os, 0, null, keys, set);
    }

    public static boolean export(File file, List<String> headers, List<String> keys, Collection<?> set) {
        return ExcelUtil.export(file, 0, headers, keys, set);
    }

    public static boolean export(OutputStream os, List<String> headers, List<String> keys, Collection<?> set) {
        return ExcelUtil.export(os, 0, headers, keys, set);
    }

    public static boolean export(File file, int rows, List<String> keys, Collection<?> set) {
        return ExcelUtil.export(file, rows, null, keys, set);
    }

    public static boolean export(OutputStream os, int rows, List<String> keys, Collection<?> set) {
        return ExcelUtil.export(os, rows, null, keys, set);
    }

    public static boolean export(File file, String sheet, int rows, Collection<?> set, String ... configs) {
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<String> keys = new ArrayList<String>();
        if (null != configs) {
            for (String config : configs) {
                String[] tmps = config.split(":");
                if (tmps.length == 2) {
                    headers.add(tmps[0]);
                    keys.add(tmps[1]);
                    continue;
                }
                keys.add(config);
            }
            if (headers.size() != keys.size()) {
                headers = new ArrayList();
            }
        }
        return ExcelUtil.export(file, sheet, rows, headers, keys, set);
    }

    public static boolean export(OutputStream os, String sheet, int rows, Collection<?> set, String ... configs) {
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<String> keys = new ArrayList<String>();
        if (null != configs) {
            for (String config : configs) {
                String[] tmps = config.split(":");
                if (tmps.length == 2) {
                    headers.add(tmps[0]);
                    keys.add(tmps[1]);
                    continue;
                }
                keys.add(config);
            }
            if (headers.size() != keys.size()) {
                headers = new ArrayList();
            }
        }
        return ExcelUtil.export(os, sheet, rows, headers, keys, set);
    }

    public static boolean export(File file, int rows, Collection<?> set, String ... configs) {
        return ExcelUtil.export(file, "", rows, set, configs);
    }

    public static boolean export(OutputStream os, int rows, Collection<?> set, String ... configs) {
        return ExcelUtil.export(os, "", rows, set, configs);
    }

    public static boolean export(File file, Collection<?> set, String ... configs) {
        return ExcelUtil.export(file, 0, set, configs);
    }

    public static boolean export(OutputStream os, Collection<?> set, String ... configs) {
        return ExcelUtil.export(os, 0, set, configs);
    }

    public static boolean export(File template, File file, String sheet, int insert, List<String> headers, List<String> keys, Collection<?> set) {
        try {
            FileUtil.create((File)file, (boolean)false);
            return ExcelUtil.export(template, (OutputStream)new FileOutputStream(file), sheet, insert, headers, keys, set);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean export(File file, String sheet, int insert, List<String> headers, List<String> keys, Collection<?> set) {
        FileOutputStream os = null;
        try {
            XSSFWorkbook workbook = null;
            XSSFSheet sht = null;
            if (file.length() == 0L) {
                file.delete();
            }
            if (file.exists()) {
                File tempFile = FileUtil.createTempFile((File)file);
                FileInputStream is = new FileInputStream(tempFile);
                workbook = new XSSFWorkbook((InputStream)is);
                if (BasicUtil.isEmpty((Object)sheet)) {
                    sht = workbook.getSheetAt(0);
                } else {
                    sht = workbook.getSheet(sheet);
                    if (null == sht) {
                        sht = workbook.createSheet(sheet);
                    }
                }
                is.close();
                tempFile.delete();
            } else {
                FileUtil.create((File)file, (boolean)false);
                workbook = new XSSFWorkbook();
                if (BasicUtil.isEmpty((Object)sheet)) {
                    sheet = "sheet1";
                }
                sht = workbook.createSheet(sheet);
            }
            os = new FileOutputStream(file);
            ExcelUtil.write(workbook, os, (Sheet)sht, insert, headers, keys, set);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void write(XSSFWorkbook workbook, OutputStream os, Sheet sheet, int insert, List<String> headers, List<String> keys, Collection<?> set) {
        try {
            int size = set.size();
            int last = sheet.getLastRowNum();
            if (last > 0 && last >= insert && size > 0) {
                sheet.shiftRows(insert, last, size);
            }
            ExcelUtil.write(sheet, insert, headers, keys, set);
            workbook.write(os);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                os.flush();
                os.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean export(File template, OutputStream os, String sheet, int insert, List<String> headers, List<String> keys, Collection<?> set) {
        try {
            XSSFWorkbook workbook = null;
            XSSFSheet sht = null;
            if (null != template && template.exists()) {
                FileInputStream is = new FileInputStream(template);
                workbook = new XSSFWorkbook((InputStream)is);
                if (BasicUtil.isNotEmpty((Object)sheet)) {
                    workbook.setSheetName(0, sheet);
                }
                sht = workbook.getSheetAt(0);
                is.close();
            } else {
                workbook = new XSSFWorkbook();
                if (BasicUtil.isEmpty((Object)sheet)) {
                    sheet = "sheet1";
                }
                sht = workbook.createSheet(sheet);
            }
            ExcelUtil.write(workbook, os, (Sheet)sht, insert, headers, keys, set);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean export(File template, File file, int rows, List<String> headers, List<String> keys, Collection<?> set) {
        return ExcelUtil.export(template, file, "sheet1", rows, headers, keys, set);
    }

    public static boolean export(File template, OutputStream os, int rows, List<String> headers, List<String> keys, Collection<?> set) {
        return ExcelUtil.export(template, os, "sheet1", rows, headers, keys, set);
    }

    public static boolean export(File template, File file, List<String> keys, Collection<?> set) {
        return ExcelUtil.export(template, file, 0, null, keys, set);
    }

    public static boolean export(File template, OutputStream os, List<String> keys, Collection<?> set) {
        return ExcelUtil.export(template, os, 0, null, keys, set);
    }

    public static boolean export(File template, File file, List<String> headers, List<String> keys, Collection<?> set) {
        return ExcelUtil.export(template, file, 0, headers, keys, set);
    }

    public static boolean export(File template, OutputStream os, List<String> headers, List<String> keys, Collection<?> set) {
        return ExcelUtil.export(template, os, 0, headers, keys, set);
    }

    public static boolean export(File template, File file, int insert, List<String> keys, Collection<?> set) {
        return ExcelUtil.export(template, file, insert, null, keys, set);
    }

    public static boolean export(File template, OutputStream os, int insert, List<String> keys, Collection<?> set) {
        return ExcelUtil.export(template, os, insert, null, keys, set);
    }

    public static boolean export(File template, File file, String sheet, int rows, Collection<?> set, String ... configs) {
        try {
            FileUtil.create((File)file, (boolean)false);
            return ExcelUtil.export(template, (OutputStream)new FileOutputStream(file), sheet, rows, set, configs);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean export(File template, OutputStream os, String sheet, int insert, Collection<?> set, String ... configs) {
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<String> keys = new ArrayList<String>();
        if (null != configs) {
            for (String config : configs) {
                String[] tmps = config.split(":");
                if (tmps.length == 2) {
                    headers.add(tmps[0]);
                    keys.add(tmps[1]);
                    continue;
                }
                keys.add(config);
            }
            if (headers.size() != keys.size()) {
                headers = new ArrayList();
            }
        }
        return ExcelUtil.export(template, os, sheet, insert, headers, keys, set);
    }

    public static boolean export(File template, File file, int insert, Collection<?> set, String ... configs) {
        return ExcelUtil.export(template, file, null, insert, set, configs);
    }

    public static boolean export(File template, File file, int insert, Table table) {
        return ExcelUtil.export(template, file, null, insert, table);
    }

    public static boolean export(File template, OutputStream os, int insert, Collection<?> set, String ... configs) {
        return ExcelUtil.export(template, os, null, insert, set, configs);
    }

    public static boolean export(File template, OutputStream os, int insert, Table table) {
        return ExcelUtil.export(template, os, null, insert, table);
    }

    public static boolean export(File template, File file, Collection<?> set, String ... configs) {
        return ExcelUtil.export(template, file, 0, set, configs);
    }

    public static boolean export(File template, File file, Table table) {
        return ExcelUtil.export(template, file, "", 0, table);
    }

    public static boolean export(File template, OutputStream os, Collection<?> set, String ... configs) {
        return ExcelUtil.export(template, os, 0, set, configs);
    }

    public static boolean merge(Sheet sheet, int firstRow, int lastRow, int firstCol, int lastCol) {
        try {
            sheet.addMergedRegion(new CellRangeAddress(firstRow, lastRow, firstCol, lastCol));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

