/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.poi.excel.io;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.poi.excel.ExcelUtil;

public class ExcelReader {
    private File file = null;
    private int head = -1;
    private int data = -1;
    private int foot = 0;
    private int sheet = -1;
    private String sheetName = null;
    private InputStream is;

    public static ExcelReader init() {
        return new ExcelReader();
    }

    public DataSet read() {
        DataSet set;
        block7: {
            set = new DataSet();
            if (!(null != this.is || null != this.file && this.file.exists())) {
                return set;
            }
            int fr = 0;
            List<List<String>> list = null;
            list = null != this.is ? (this.sheet != -1 ? ExcelUtil.read(this.is, this.sheet, fr, this.foot) : (null != this.sheetName ? ExcelUtil.read(this.is, this.sheetName, fr, this.foot) : ExcelUtil.read(this.is, 0, fr, this.foot))) : (this.sheet != -1 ? ExcelUtil.read(this.file, this.sheet, fr, this.foot) : (null != this.sheetName ? ExcelUtil.read(this.file, this.sheetName, fr, this.foot) : ExcelUtil.read(this.file, 0, fr, this.foot)));
            if (list.size() <= 0) break block7;
            if (this.head != -1) {
                List<String> headers = list.get(this.head);
                int size = headers.size();
                int rows = -1;
                for (List<String> item : list) {
                    if (++rows < this.data || rows == this.head) continue;
                    DataRow row = new DataRow();
                    for (int i = 0; i < size; ++i) {
                        String key = headers.get(i).trim();
                        String value = item.get(i);
                        row.put(key, (Object)value);
                    }
                    set.add(row);
                }
            } else {
                int rows = -1;
                for (List<String> item : list) {
                    if (++rows < this.data) continue;
                    DataRow row = new DataRow();
                    int size = item.size();
                    for (int i = 0; i < size; ++i) {
                        String value = item.get(i);
                        row.put(i + "", (Object)value);
                    }
                    set.add(row);
                }
            }
        }
        return set;
    }

    public ExcelReader setHead(int head) {
        this.head = head;
        return this;
    }

    public ExcelReader setFile(File file) {
        this.file = file;
        return this;
    }

    public ExcelReader setData(int data) {
        this.data = data;
        return this;
    }

    public ExcelReader setFoot(int foot) {
        this.foot = foot;
        return this;
    }

    public ExcelReader setSheet(int sheet) {
        this.sheet = sheet;
        return this;
    }

    public ExcelReader setSheet(String sheet) {
        this.sheetName = sheet;
        return this;
    }

    public InputStream getInputStream() {
        return this.is;
    }

    public ExcelReader setInputStream(InputStream is) {
        this.is = is;
        return this;
    }
}

