/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.office.docx.entity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.anyline.handler.Uploader;
import org.anyline.office.docx.entity.WDocument;
import org.anyline.office.docx.entity.Welement;
import org.anyline.office.docx.entity.Wtable;
import org.anyline.office.docx.entity.Wtc;
import org.anyline.office.docx.util.DocxUtil;
import org.anyline.util.BasicUtil;
import org.dom4j.Element;

public class Wtr
extends Welement {
    private Wtable parent;
    private List<Wtc> wtcs = new ArrayList<Wtc>();
    private String widthUnit = "px";

    public Wtr(WDocument doc, Wtable parent, Element src) {
        this.root = doc;
        this.src = src;
        this.parent = parent;
        this.load();
    }

    @Override
    public void reload() {
        this.load();
    }

    private Wtr load() {
        this.wtcs.clear();
        List items = this.src.elements("tc");
        for (Element tc : items) {
            Wtc wtc = new Wtc(this.root, this, tc);
            this.wtcs.add(wtc);
        }
        return this;
    }

    public Wtable getParent() {
        return this.parent;
    }

    public Wtr setHeight(String height) {
        int dxa = DocxUtil.dxa(height);
        Element pr = DocxUtil.addElement(this.src, "trPr");
        DocxUtil.addElement(pr, "trHeight", "val", "" + dxa);
        return this;
    }

    public Wtr setHeight(int height) {
        return this.setHeight(height + this.widthUnit);
    }

    public Wtr setHeight(double height) {
        return this.setHeight(height + this.widthUnit);
    }

    public List<Wtc> getWtcs() {
        if (this.wtcs.isEmpty()) {
            List elements = this.src.elements("tc");
            for (Element element : elements) {
                Wtc tc = new Wtc(this.root, this, element);
                this.wtcs.add(tc);
            }
        }
        return this.wtcs;
    }

    public Wtc getTc(int index) {
        return this.wtcs.get(index);
    }

    public String getWidthUnit() {
        return this.widthUnit;
    }

    public void setWidthUnit(String widthUnit) {
        this.widthUnit = widthUnit;
        for (Wtc tc : this.wtcs) {
            tc.setWidthUnit(widthUnit);
        }
    }

    public Wtc tc(String bookmark) {
        List<Wtc> tcs = this.tcs(bookmark);
        if (!tcs.isEmpty()) {
            return tcs.get(0);
        }
        return null;
    }

    public List<Wtc> tcs(String bookmark) {
        ArrayList<Wtc> list = new ArrayList<Wtc>();
        if (null != bookmark) {
            for (Wtc item : this.wtcs) {
                String txt = item.getTexts();
                if (!txt.contains(bookmark)) continue;
                list.add(item);
            }
        }
        return list;
    }

    public Wtc getTcWithColspan(int index, boolean prev) {
        int qty = -1;
        for (Wtc tc : this.wtcs) {
            if ((qty += tc.getColspan()) == index) {
                return tc;
            }
            if (qty <= index) continue;
            if (!prev) break;
            return tc;
        }
        return null;
    }

    public List<Wtc> getTcs() {
        return this.wtcs;
    }

    private Wtr removeBorder() {
        List<Wtc> tcs = this.getWtcs();
        for (Wtc tc : tcs) {
            tc.removeBorder();
        }
        return this;
    }

    public Wtr setBorder() {
        List<Wtc> tcs = this.getWtcs();
        for (Wtc tc : tcs) {
            tc.setBorder();
        }
        return this;
    }

    public Wtr setBorder(int size, String color, String style) {
        List<Wtc> tcs = this.getWtcs();
        for (Wtc tc : tcs) {
            tc.setBorder(size, color, style);
        }
        return this;
    }

    public Wtr setTopBorder(int size, String color, String style) {
        List<Wtc> tcs = this.getWtcs();
        for (Wtc tc : tcs) {
            tc.setTopBorder(size, color, style);
        }
        return this;
    }

    public Wtr removeTopBorder() {
        List<Wtc> tcs = this.getWtcs();
        for (Wtc tc : tcs) {
            tc.removeTopBorder();
        }
        return this;
    }

    public Wtr setBottomBorder(int size, String color, String style) {
        List<Wtc> tcs = this.getWtcs();
        for (Wtc tc : tcs) {
            tc.setBottomBorder(size, color, style);
        }
        return this;
    }

    public Wtr removeBottomBorder() {
        List<Wtc> tcs = this.getWtcs();
        for (Wtc tc : tcs) {
            tc.removeBottomBorder();
        }
        return this;
    }

    public Wtr setColor(String color) {
        List<Wtc> tcs = this.getWtcs();
        for (Wtc tc : tcs) {
            tc.setColor(color);
        }
        return this;
    }

    public Wtr setFont(String size, String eastAsia, String ascii, String hint) {
        List<Wtc> tcs = this.getWtcs();
        for (Wtc tc : tcs) {
            tc.setFont(size, eastAsia, ascii, hint);
        }
        return this;
    }

    public Wtr setFontSize(String size) {
        List<Wtc> tcs = this.getWtcs();
        for (Wtc tc : tcs) {
            tc.setFontSize(size);
        }
        return this;
    }

    public Wtr setFontFamily(String font) {
        List<Wtc> tcs = this.getWtcs();
        for (Wtc tc : tcs) {
            tc.setFontFamily(font);
        }
        return this;
    }

    public Wtr setAlign(String align) {
        List<Wtc> tcs = this.getWtcs();
        for (Wtc tc : tcs) {
            tc.setAlign(align);
        }
        return this;
    }

    public Wtr setVerticalAlign(String align) {
        List<Wtc> tcs = this.getWtcs();
        for (Wtc tc : tcs) {
            tc.setVerticalAlign(align);
        }
        return this;
    }

    public Wtr setBackgroundColor(String color) {
        List<Wtc> tcs = this.getWtcs();
        for (Wtc tc : tcs) {
            tc.setBackgroundColor(color);
        }
        return this;
    }

    public Wtr removeStyle() {
        for (Wtc tc : this.wtcs) {
            tc.removeStyle();
        }
        return this;
    }

    public Wtr removeBackgroundColor() {
        for (Wtc tc : this.wtcs) {
            tc.removeBackgroundColor();
        }
        return this;
    }

    public Wtr removeColor() {
        for (Wtc tc : this.wtcs) {
            tc.removeColor();
        }
        return this;
    }

    public Wtr replace(String src, String tar) {
        for (Wtc tc : this.wtcs) {
            tc.replace(src, tar);
        }
        return this;
    }

    public Wtr setBold() {
        for (Wtc tc : this.wtcs) {
            tc.setBold();
        }
        return this;
    }

    public Wtr setBold(boolean bold) {
        for (Wtc tc : this.wtcs) {
            tc.setBold(bold);
        }
        return this;
    }

    public Wtr setUnderline(boolean underline) {
        for (Wtc tc : this.wtcs) {
            tc.setUnderline(underline);
        }
        return this;
    }

    public Wtr setUnderline() {
        this.setUnderline(true);
        return this;
    }

    public Wtr setStrike(boolean strike) {
        for (Wtc tc : this.wtcs) {
            tc.setStrike(strike);
        }
        return this;
    }

    public Wtr setStrike() {
        this.setStrike(true);
        return this;
    }

    public Wtr setItalic(boolean italic) {
        for (Wtc tc : this.wtcs) {
            tc.setItalic(italic);
        }
        return this;
    }

    public Wtr setItalic() {
        return this.setItalic(true);
    }

    public Wtr setPadding(String side, double padding) {
        for (Wtc tc : this.wtcs) {
            tc.setPadding(side, padding);
        }
        return this;
    }

    public Wtr setPadding(String side, String padding) {
        for (Wtc tc : this.wtcs) {
            tc.setPadding(side, padding);
        }
        return this;
    }

    public Wtr setPadding(String side, int padding) {
        for (Wtc tc : this.wtcs) {
            tc.setPadding(side, padding);
        }
        return this;
    }

    public Wtr setLeftPadding(double padding) {
        for (Wtc tc : this.wtcs) {
            tc.setLeftPadding(padding);
        }
        return this;
    }

    public Wtr setLeftPadding(String padding) {
        for (Wtc tc : this.wtcs) {
            tc.setLeftPadding(padding);
        }
        return this;
    }

    public Wtr setLeftPadding(int padding) {
        for (Wtc tc : this.wtcs) {
            tc.setLeftPadding(padding);
        }
        return this;
    }

    public Wtr setRightPadding(double padding) {
        for (Wtc tc : this.wtcs) {
            tc.setRightPadding(padding);
        }
        return this;
    }

    public Wtr setRightPadding(String padding) {
        for (Wtc tc : this.wtcs) {
            tc.setRightPadding(padding);
        }
        return this;
    }

    public Wtr setRightPadding(int padding) {
        for (Wtc tc : this.wtcs) {
            tc.setRightPadding(padding);
        }
        return this;
    }

    public Wtr setTopPadding(double padding) {
        for (Wtc tc : this.wtcs) {
            tc.setTopPadding(padding);
        }
        return this;
    }

    public Wtr setTopPadding(String padding) {
        for (Wtc tc : this.wtcs) {
            tc.setTopPadding(padding);
        }
        return this;
    }

    public Wtr setTopPadding(int padding) {
        for (Wtc tc : this.wtcs) {
            tc.setTopPadding(padding);
        }
        return this;
    }

    public Wtr setBottomPadding(double padding) {
        for (Wtc tc : this.wtcs) {
            tc.setBottomPadding(padding);
        }
        return this;
    }

    public Wtr setBottomPadding(String padding) {
        for (Wtc tc : this.wtcs) {
            tc.setBottomPadding(padding);
        }
        return this;
    }

    public Wtr setBottomPadding(int padding) {
        for (Wtc tc : this.wtcs) {
            tc.setBottomPadding(padding);
        }
        return this;
    }

    public Wtr setPadding(double padding) {
        for (Wtc tc : this.wtcs) {
            tc.setPadding(padding);
        }
        return this;
    }

    public Wtr setPadding(String padding) {
        for (Wtc tc : this.wtcs) {
            tc.setPadding(padding);
        }
        return this;
    }

    public Wtr setPadding(int padding) {
        for (Wtc tc : this.wtcs) {
            tc.setPadding(padding);
        }
        return this;
    }

    public Wtr clone(boolean content) {
        Wtr tr = new Wtr(this.root, this.getParent(), this.getSrc().createCopy());
        if (!content) {
            tr.removeContent();
        }
        return tr;
    }

    @Override
    public LinkedHashMap<String, String> styles() {
        int height;
        Element h;
        LinkedHashMap<String, String> styles = new LinkedHashMap<String, String>();
        Element pr = this.src.element("trPr");
        if (null != pr && null != (h = pr.element("trHeight")) && (height = BasicUtil.parseInt((Object)h.attributeValue("val"), (Integer)0).intValue()) > 0) {
            styles.put("height", (int)DocxUtil.dxa2px(height) + "px");
        }
        return styles;
    }

    @Override
    public String html(Uploader uploader, int lvl) {
        StringBuilder builder = new StringBuilder();
        LinkedHashMap styles = new LinkedHashMap();
        StringBuilder body = new StringBuilder();
        Iterator items = this.src.elementIterator();
        while (items.hasNext()) {
            Element item = (Element)items.next();
            String tag = item.getName();
            if (!tag.equalsIgnoreCase("tc")) continue;
            body.append("\n");
            body.append(new Wtc(this.getDoc(), this, item).html(uploader, lvl + 1));
        }
        this.t(builder, lvl);
        builder.append("<tr");
        this.styles(builder);
        builder.append(">");
        builder.append((CharSequence)body);
        builder.append("\n");
        this.t(builder, lvl);
        builder.append("</tr>");
        return builder.toString();
    }
}

