/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.office.docx.entity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.anyline.handler.Uploader;
import org.anyline.office.docx.entity.WDocument;
import org.anyline.office.docx.entity.Welement;
import org.anyline.office.docx.entity.Wr;
import org.anyline.office.docx.entity.Wtable;
import org.anyline.office.docx.util.DocxUtil;
import org.anyline.util.BasicUtil;
import org.dom4j.Element;

public class Wp
extends Welement {
    private List<Wr> wrs = new ArrayList<Wr>();

    public Wp(WDocument doc, Element src) {
        this.root = doc;
        this.src = src;
        this.load();
    }

    @Override
    public void reload() {
        this.load();
    }

    private void load() {
        this.wrs.clear();
        List elements = this.src.elements("r");
        for (Element element : elements) {
            Wr wr = new Wr(this.root, element);
            this.wrs.add(wr);
        }
    }

    public Wp setColor(String color) {
        for (Wr wr : this.wrs) {
            wr.setColor(color);
        }
        Element pr = DocxUtil.addElement(this.src, "pPr");
        DocxUtil.addElement(pr, "color", "val", color.replace("#", ""));
        return this;
    }

    public Wp setFont(String size, String eastAsia, String ascii, String hint) {
        for (Wr wr : this.wrs) {
            wr.setFont(size, eastAsia, ascii, hint);
        }
        int pt = DocxUtil.fontSize(size);
        Element pr = DocxUtil.addElement(this.src, "pPr");
        DocxUtil.addElement(pr, "sz", "val", "" + pt);
        DocxUtil.addElement(pr, "rFonts", "eastAsia", eastAsia);
        DocxUtil.addElement(pr, "rFonts", "ascii", ascii);
        DocxUtil.addElement(pr, "rFonts", "hint", hint);
        return this;
    }

    public Wp setFontSize(String size) {
        for (Wr wr : this.wrs) {
            wr.setFontSize(size);
        }
        int pt = DocxUtil.fontSize(size);
        Element pr = DocxUtil.addElement(this.src, "pPr");
        DocxUtil.addElement(pr, "sz", "val", "" + pt);
        return this;
    }

    public Wp setFontFamily(String font) {
        for (Wr wr : this.wrs) {
            wr.setFontFamily(font);
        }
        Element pr = DocxUtil.addElement(this.src, "pPr");
        DocxUtil.addElement(pr, "rFonts", "eastAsia", font);
        DocxUtil.addElement(pr, "rFonts", "ascii", font);
        DocxUtil.addElement(pr, "rFonts", "hAnsi", font);
        DocxUtil.addElement(pr, "rFonts", "cs", font);
        DocxUtil.addElement(pr, "rFonts", "hint", font);
        return this;
    }

    public Wp setAlign(String align) {
        Element pr = DocxUtil.addElement(this.src, "pPr");
        DocxUtil.addElement(pr, "jc", "val", align);
        return this;
    }

    public Wp setBackgroundColor(String color) {
        Element pr = DocxUtil.addElement(this.src, "pPr");
        color = color.replace("#", "");
        DocxUtil.addElement(pr, "highlight", "val", color);
        for (Wr wr : this.wrs) {
            wr.setBackgroundColor(color);
        }
        return this;
    }

    public Wp setBold(boolean bold) {
        Element pr = DocxUtil.addElement(this.src, "pPr");
        Element b = pr.element("b");
        if (bold) {
            if (null == b) {
                pr.addElement("w:b");
            }
        } else if (null != b) {
            pr.remove(b);
        }
        for (Wr wr : this.wrs) {
            wr.setBold(bold);
        }
        return this;
    }

    public Wp setUnderline(boolean underline) {
        Element pr = DocxUtil.addElement(this.src, "pPr");
        Element u = pr.element("u");
        if (underline) {
            if (null == u) {
                DocxUtil.addElement(pr, "u", "val", "single");
            }
        } else if (null != u) {
            pr.remove(u);
        }
        for (Wr wr : this.wrs) {
            wr.setUnderline(underline);
        }
        return this;
    }

    public Wp setStrike(boolean strike) {
        Element pr = DocxUtil.addElement(this.src, "pPr");
        Element s = pr.element("strike");
        if (strike) {
            if (null == s) {
                pr.addElement("w:strike");
            }
        } else if (null != s) {
            pr.remove(s);
        }
        for (Wr wr : this.wrs) {
            wr.setStrike(strike);
        }
        return this;
    }

    public Wp setItalic(boolean italic) {
        Element pr = DocxUtil.addElement(this.src, "pPr");
        DocxUtil.addElement(pr, "i", "val", "" + italic);
        for (Wr wr : this.wrs) {
            wr.setItalic(italic);
        }
        return this;
    }

    public Wp removeStyle() {
        Element pr = this.src.element("pPr");
        if (null != pr) {
            this.src.remove(pr);
        }
        for (Wr wr : this.wrs) {
            wr.removeStyle();
        }
        return this;
    }

    public Wp removeBackgroundColor() {
        DocxUtil.removeElement(this.src, "shd");
        return this;
    }

    public Wp removeColor() {
        DocxUtil.removeElement(this.src, "color");
        return this;
    }

    public Wp addWr(Wr wr) {
        this.wrs.add(wr);
        return this;
    }

    public Wp replace(String target, String replacement) {
        for (Wr wr : this.wrs) {
            wr.replace(target, replacement);
        }
        return this;
    }

    @Override
    public LinkedHashMap<String, String> styles() {
        Element rpr;
        LinkedHashMap<String, String> styles = new LinkedHashMap<String, String>();
        Element pr = this.src.element("pPr");
        if (null != pr && null != (rpr = pr.element("rPr"))) {
            String val;
            Element jc;
            int val2;
            Element size;
            String hint;
            Element font;
            String val3;
            Element highlight;
            String val4;
            Element color = rpr.element("color");
            if (null != color && null != (val4 = this.color(color.attributeValue("val")))) {
                styles.put("color", val4);
            }
            if (null != (highlight = pr.element("highlight")) && null != (val3 = this.color(highlight.attributeValue("val")))) {
                styles.put("background-color", val3);
            }
            if (null != (font = pr.element("rFonts")) && null != (hint = font.attributeValue("hint"))) {
                styles.put("font-family", hint);
            }
            if (null == (size = pr.element("sz"))) {
                size = pr.element("szCs");
            }
            if (null != size && (val2 = BasicUtil.parseInt((Object)size.attributeValue("val"), (Integer)0).intValue()) > 0) {
                styles.put("font-size", val2 + "pt");
            }
            if (null != (jc = pr.element("jc")) && null != (val = jc.attributeValue("val"))) {
                styles.put("text-align", val);
            }
        }
        return styles;
    }

    @Override
    public String html(Uploader uploader, int lvl) {
        StringBuilder builder = new StringBuilder();
        StringBuilder body = new StringBuilder();
        Iterator items = this.src.elementIterator();
        while (items.hasNext()) {
            Element item = (Element)items.next();
            String tag = item.getName();
            if (tag.equalsIgnoreCase("r")) {
                body.append("\n");
                body.append(new Wr(this.getDoc(), item).html(uploader, lvl + 1));
                continue;
            }
            if (!tag.equalsIgnoreCase("tbl")) continue;
            body.append("\n");
            body.append(new Wtable(this.getDoc(), item).html(uploader, lvl + 1));
        }
        this.t(builder, lvl);
        builder.append("<div");
        this.styles(builder);
        builder.append(">");
        builder.append((CharSequence)body);
        builder.append("\n");
        this.t(builder, lvl);
        builder.append("</div>");
        return builder.toString();
    }
}

