/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.office.docx.entity;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.anyline.handler.Uploader;
import org.anyline.office.docx.entity.WDocument;
import org.anyline.office.docx.entity.Welement;
import org.anyline.office.docx.entity.Wt;
import org.anyline.office.docx.util.DocxUtil;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.HtmlUtil;
import org.dom4j.Element;

public class Wr
extends Welement {
    public Wr(WDocument doc, Element src) {
        this.root = doc;
        this.src = src;
    }

    public List<Wt> getWts() {
        ArrayList<Wt> wts = new ArrayList<Wt>();
        List ts = this.src.elements("t");
        for (Element t : ts) {
            Wt wt = new Wt(this.root, t);
            wts.add(wt);
        }
        return wts;
    }

    public Wr setColor(String color) {
        Element pr = DocxUtil.addElement(this.src, "rPr");
        DocxUtil.addElement(pr, "color", "val", color.replace("#", ""));
        return this;
    }

    public Wr setFont(String size, String eastAsia, String ascii, String hint) {
        int pt = DocxUtil.fontSize(size);
        Element pr = DocxUtil.addElement(this.src, "rPr");
        DocxUtil.addElement(pr, "sz", "val", pt + "");
        DocxUtil.addElement(pr, "rFonts", "eastAsia", eastAsia);
        DocxUtil.addElement(pr, "rFonts", "ascii", ascii);
        DocxUtil.addElement(pr, "rFonts", "hint", hint);
        return this;
    }

    public Wr setFontSize(String size) {
        int pt = DocxUtil.fontSize(size);
        Element pr = DocxUtil.addElement(this.src, "rPr");
        DocxUtil.addElement(pr, "sz", "val", pt + "");
        return this;
    }

    public Wr setFontFamily(String font) {
        Element pr = DocxUtil.addElement(this.src, "rPr");
        DocxUtil.addElement(pr, "rFonts", "eastAsia", font);
        DocxUtil.addElement(pr, "rFonts", "ascii", font);
        DocxUtil.addElement(pr, "rFonts", "hAnsi", font);
        DocxUtil.addElement(pr, "rFonts", "cs", font);
        DocxUtil.addElement(pr, "rFonts", "hint", font);
        return this;
    }

    public Wr setBackgroundColor(String color) {
        Element pr = DocxUtil.addElement(this.src, "rPr");
        DocxUtil.addElement(pr, "highlight", "val", color.replace("#", ""));
        return this;
    }

    public Wr setBold(boolean bold) {
        Element pr = DocxUtil.addElement(this.src, "rPr");
        Element b = pr.element("b");
        if (bold) {
            if (null == b) {
                pr.addElement("w:b");
            }
        } else if (null != b) {
            pr.remove(b);
        }
        return this;
    }

    public Wr setUnderline(boolean underline) {
        Element pr = DocxUtil.addElement(this.src, "rPr");
        Element u = pr.element("u");
        if (underline) {
            if (null == u) {
                DocxUtil.addElement(pr, "u", "val", "single");
            }
        } else if (null != u) {
            pr.remove(u);
        }
        return this;
    }

    public Wr setStrike(boolean strike) {
        Element pr = DocxUtil.addElement(this.src, "rPr");
        Element s = pr.element("strike");
        if (strike) {
            if (null == s) {
                pr.addElement("w:strike");
            }
        } else if (null != s) {
            pr.remove(s);
        }
        return this;
    }

    public Wr setVerticalAlign(String align) {
        Element pr = DocxUtil.addElement(this.src, "rPr");
        DocxUtil.addElement(pr, "vertAlign", "val", align);
        return this;
    }

    public Wr setItalic(boolean italic) {
        Element pr = DocxUtil.addElement(this.src, "rPr");
        DocxUtil.addElement(pr, "i", "val", italic + "");
        return this;
    }

    public Wr removeStyle() {
        Element pr = this.src.element("rPr");
        if (null != pr) {
            this.src.remove(pr);
        }
        return this;
    }

    public Wr removeBackgroundColor() {
        DocxUtil.removeElement(this.src, "highlight");
        return this;
    }

    public Wr removeColor() {
        DocxUtil.removeElement(this.src, "color");
        return this;
    }

    public Wr replace(String target, String replacement) {
        List<Wt> wts = this.getWts();
        for (Wt wt : wts) {
            String text = wt.getText();
            text = text.replace(target, replacement);
            if (this.root.IS_HTML_ESCAPE) {
                text = HtmlUtil.display((String)text);
            }
            wt.setText(text);
        }
        return this;
    }

    @Override
    public LinkedHashMap<String, String> styles() {
        LinkedHashMap<String, String> styles = new LinkedHashMap<String, String>();
        Element pr = this.src.element("rPr");
        if (null != pr) {
            String val;
            Element jc;
            int val2;
            Element size;
            String hint;
            Element font;
            String val3;
            Element highlight;
            String val4;
            Element color = pr.element("color");
            if (null != color && null != (val4 = this.color(color.attributeValue("val")))) {
                styles.put("color", val4);
            }
            if (null != (highlight = pr.element("highlight")) && null != (val3 = this.color(highlight.attributeValue("val")))) {
                styles.put("background-color", val3);
            }
            if (null != (font = pr.element("rFonts")) && null != (hint = font.attributeValue("hint"))) {
                styles.put("font-family", hint);
            }
            if (null == (size = pr.element("sz"))) {
                size = pr.element("szCs");
            }
            if (null != size && (val2 = BasicUtil.parseInt((Object)size.attributeValue("val"), (Integer)0).intValue()) > 0) {
                styles.put("font-size", val2 + "pt");
            }
            if (null != (jc = pr.element("jc")) && null != (val = jc.attributeValue("val"))) {
                styles.put("text-align", val);
            }
        }
        return styles;
    }

    @Override
    public String html() {
        return this.html(null, 0);
    }

    @Override
    public String html(Uploader uploader) {
        return this.html(uploader, 0);
    }

    @Override
    public String html(Uploader uploader, int lvl) {
        StringBuilder builder = new StringBuilder();
        StringBuilder body = new StringBuilder();
        Iterator items = this.src.elementIterator();
        while (items.hasNext()) {
            Element item = (Element)items.next();
            String tag = item.getName();
            if (tag.equalsIgnoreCase("t")) {
                body.append(item.getText());
                continue;
            }
            if (!tag.equalsIgnoreCase("drawing")) continue;
            String img = this.img(uploader, item);
            body.append(img);
        }
        this.t(builder, lvl);
        builder.append("<span");
        this.styles(builder);
        builder.append(">");
        builder.append((CharSequence)body);
        builder.append("</span>");
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String img(Uploader uploader, Element element) {
        Element rel;
        String embed;
        Element blip;
        if (null == uploader) {
            uploader = this.root.getUploader();
        }
        StringBuilder builder = new StringBuilder();
        Element pic = this.child(element, "inline", "graphic", "graphicData", "pic");
        if (null != pic && null != (blip = this.child(pic, "blipFill", "blip")) && null != (embed = blip.attributeValue("embed")) && null != (rel = this.root.rel(embed))) {
            String target = rel.attributeValue("Target");
            InputStream is = this.root.read("word/" + target);
            try {
                int width = 0;
                int height = 0;
                Element ext = this.child(pic, "spPr", "xfrm", "ext");
                if (null != ext) {
                    width = (int)DocxUtil.emu2px(BasicUtil.parseInt((Object)ext.attributeValue("cx"), (Integer)0).intValue());
                    height = (int)DocxUtil.emu2px(BasicUtil.parseInt((Object)ext.attributeValue("cy"), (Integer)0).intValue());
                }
                builder.append("<img src='");
                if (null == uploader) {
                    byte[] bytes = BeanUtil.stream2bytes((InputStream)is);
                    String base64 = Base64.getEncoder().encodeToString(bytes);
                    builder.append("data:image/png;base64,").append(base64);
                } else {
                    String url = uploader.upload(null, is);
                    builder.append(url);
                }
                builder.append("'");
                if (width > 0 && height > 0) {
                    builder.append(" style='width:").append(width).append("px; height:").append(height).append("px;'");
                }
                builder.append("/>");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    is.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return builder.toString();
    }
}

