/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.office.docx.entity;

import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.anyline.entity.html.Table;
import org.anyline.entity.html.Td;
import org.anyline.entity.html.Tr;
import org.anyline.handler.Downloader;
import org.anyline.handler.Uploader;
import org.anyline.office.docx.entity.Welement;
import org.anyline.office.docx.entity.Wp;
import org.anyline.office.docx.entity.Wtable;
import org.anyline.office.docx.util.DocxUtil;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.DomUtil;
import org.anyline.util.HtmlUtil;
import org.anyline.util.NumberUtil;
import org.anyline.util.StyleParser;
import org.anyline.util.ZipUtil;
import org.anyline.util.regular.RegularUtil;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WDocument
extends Welement {
    private static Logger log = LoggerFactory.getLogger(WDocument.class);
    private File file;
    private String charset = "UTF-8";
    private String xml = null;
    private Document doc = null;
    public boolean IS_HTML_ESCAPE = false;
    private String relsXml = null;
    private Document rels;
    private Map<String, Map<String, String>> styles = new HashMap<String, Map<String, String>>();
    private Map<String, String> replaces = new HashMap<String, String>();
    private Uploader uploader;
    private Downloader downloader;
    private int listNum = 0;

    public WDocument(File file) {
        this.file = file;
    }

    public WDocument(String file) {
        this.file = new File(file);
    }

    public WDocument(File file, String charset) {
        this.file = file;
        this.charset = charset;
    }

    public WDocument(String file, String charset) {
        this.file = new File(file);
        this.charset = charset;
    }

    private void load() {
        if (null == this.xml) {
            try {
                this.xml = ZipUtil.read((File)this.file, (String)"word/document.xml", (String)this.charset);
                this.relsXml = ZipUtil.read((File)this.file, (String)"word/_rels/document.xml.rels", (String)this.charset);
                this.doc = DocumentHelper.parseText((String)this.xml);
                this.rels = DocumentHelper.parseText((String)this.relsXml);
                this.src = this.doc.getRootElement().element("body");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void reload() {
        try {
            this.xml = ZipUtil.read((File)this.file, (String)"word/document.xml", (String)this.charset);
            this.relsXml = ZipUtil.read((File)this.file, (String)"word/_rels/document.xml.rels", (String)this.charset);
            this.doc = DocumentHelper.parseText((String)this.xml);
            this.rels = DocumentHelper.parseText((String)this.relsXml);
            this.src = this.doc.getRootElement().element("body");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Element rel(String id) {
        if (null != id) {
            List elements = this.rels.getRootElement().elements();
            for (Element element : elements) {
                if (!id.equalsIgnoreCase(element.attributeValue("Id"))) continue;
                return element;
            }
        }
        return null;
    }

    public InputStream read(String path) {
        InputStream is = ZipUtil.read((File)this.file, (String)path);
        return is;
    }

    public void flush() {
        try {
            this.xml = DomUtil.format((Document)this.doc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadStyle(String html) {
        Map map = StyleParser.load((String)html);
        for (String key : map.keySet()) {
            this.styles.put(key, (Map<String, String>)map.get(key));
        }
    }

    public void replace(String key, String content) {
        if (null == key && key.trim().length() == 0) {
            return;
        }
        this.replaces.put(key, content);
    }

    public void replace(String key, File ... words) {
        this.replace(key, BeanUtil.array2list((Object[][])new File[][]{words}));
    }

    public void replace(String key, List<File> words) {
        if (null != words) {
            StringBuilder content = new StringBuilder();
            for (File word : words) {
                content.append("<word>").append(word.getAbsolutePath()).append("</word>");
            }
            this.replaces.put(key, content.toString());
        }
    }

    public void save() {
        this.save(Charset.forName("UTF-8"));
    }

    public void save(Charset charset) {
        try {
            this.load();
            this.replace(this.src, this.replaces);
            this.checkContentTypes();
            this.checkMergeCol();
            ZipUtil.replace((File)this.file, (String)"word/document.xml", (String)DomUtil.format((Document)this.doc), (Charset)charset);
            ZipUtil.replace((File)this.file, (String)"word/_rels/document.xml.rels", (String)DomUtil.format((Document)this.rels), (Charset)charset);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void replace(Element box, Map<String, String> replaces) {
        List ts = DomUtil.elements((Element)box, (String)"t");
        for (Element t : ts) {
            String txt = t.getTextTrim();
            List<String> flags = DocxUtil.splitKey(txt);
            if (flags.size() == 0) continue;
            Collections.reverse(flags);
            Element r = t.getParent();
            List elements = r.elements();
            int index = elements.indexOf(t);
            Element prev = null;
            if (index < elements.size() - 1) {
                prev = (Element)elements.get(index + 1);
            }
            for (int i = 0; i < flags.size(); ++i) {
                String flag;
                String content = flag = flags.get(i);
                String key = null;
                if (flag.startsWith("${") && flag.endsWith("}")) {
                    key = flag.substring(2, flag.length() - 1);
                    content = replaces.get(key);
                    if (null == content) {
                        content = replaces.get(flag);
                    }
                } else if (flag.startsWith("{") && flag.endsWith("}")) {
                    key = flag.substring(1, flag.length() - 1);
                    content = replaces.get(key);
                    if (null == content) {
                        content = replaces.get(flag);
                    }
                } else {
                    content = replaces.get(flag);
                }
                if (null == content) continue;
                List<Element> list = this.parseHtml(r, prev, content);
            }
            elements.remove(t);
        }
        List bookmarks = DomUtil.elements((Element)box, (String)"bookmarkStart");
        for (Element bookmark : bookmarks) {
            this.replaceBookmark(bookmark, replaces);
        }
    }

    private void checkMergeCol() {
        List tables = DomUtil.elements((Element)this.doc.getRootElement(), (String)"tbl");
        for (Element table : tables) {
            Element tblGrid;
            int max = 0;
            boolean isMerge = false;
            List trs = DomUtil.elements((Element)table, (String)"tr");
            for (Element tr : trs) {
                int size = 0;
                List tcs = DomUtil.elements((Element)tr, (String)"tc");
                for (Element tc : tcs) {
                    Element grid;
                    int colspan = 1;
                    Element pr = DomUtil.element((Element)tc, (String)"tcPr");
                    if (null != pr && null != (grid = DomUtil.element((Element)pr, (String)"gridSpan"))) {
                        colspan = BasicUtil.parseInt((Object)grid.attributeValue("w:val"), (Integer)1);
                    }
                    if (colspan > 1) {
                        isMerge = true;
                    }
                    size += colspan;
                }
                if (size <= max) continue;
                max = size;
            }
            if (!isMerge) continue;
            int tableWidth = 5000;
            Element tblW = DomUtil.element((Element)table, (String)"tblW");
            if (null != tblW) {
                tableWidth = BasicUtil.parseInt((Object)tblW.attributeValue("w:w"), (Integer)5000);
            }
            if (null == (tblGrid = DomUtil.element((Element)table, (String)"tblGrid"))) {
                tblGrid = DocxUtil.addElement(table, "tblGrid");
            }
            List gridCols = DomUtil.elements((Element)tblGrid, (String)"gridCol");
            int width = tableWidth / max;
            for (int i = gridCols.size(); i < max; ++i) {
                Element gridCol = tblGrid.addElement("w:gridCol");
                gridCol.addAttribute("w:w", width + "");
            }
        }
    }

    private void checkContentTypes() {
        try {
            String xml = ZipUtil.read((File)this.file, (String)"[Content_Types].xml", (String)this.charset);
            Document doc = DocumentHelper.parseText((String)xml);
            Element root = doc.getRootElement();
            this.checkContentTypes(root, "png", "image/png");
            this.checkContentTypes(root, "jpg", "image/jpeg");
            this.checkContentTypes(root, "jpeg", "image/jpeg");
            this.checkContentTypes(root, "gif", "image/gif");
            this.checkContentTypes(root, "tiff", "image/tiff");
            this.checkContentTypes(root, "pict", "image/pict");
            ZipUtil.replace((File)this.file, (String)"[Content_Types].xml", (String)DomUtil.format((Document)doc));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkContentTypes(Element root, String extension, String type) {
        List elements = root.elements("Default");
        for (Element element : elements) {
            if (!extension.equals(element.attributeValue("Extension"))) continue;
            return;
        }
        Element element = root.addElement("Default");
        element.addAttribute("Extension", extension);
        element.addAttribute("ContentType", type);
    }

    public Element before(Element element, String html) {
        List<Element> list;
        Element parent = element.getParent();
        List elements = parent.elements();
        int index = elements.indexOf(element) - 1;
        Element prev = null;
        if (index >= 0) {
            prev = (Element)elements.get(index);
        }
        if ((list = this.parseHtml(parent, prev, html)).isEmpty()) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    public Element before(Element point, Element element) {
        Element parent = point.getParent();
        List elements = parent.elements();
        int index = elements.indexOf(point);
        elements.add(index, element);
        return element;
    }

    public Element before(Element point, Wtable table) {
        Element src = table.getSrc();
        this.before(point, src);
        return src;
    }

    public Element after(Element point, Element element) {
        Element parent = point.getParent();
        List elements = parent.elements();
        int index = elements.indexOf(point) + 1;
        if (index >= elements.size() - 1) {
            elements.add(element);
        } else {
            elements.add(index, element);
        }
        return element;
    }

    public Element after(Element point, Wtable table) {
        Element src = table.getSrc();
        this.after(point, src);
        return src;
    }

    public Element after(Element element, String html) {
        Element parent = element.getParent();
        List<Element> list = this.parseHtml(parent, element, html);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    public Element insert(Element parent, String html) {
        List<Element> list = this.parseHtml(parent, null, html);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    public Element insert(int index, Element parent, String html) {
        List elements = parent.elements();
        if (index <= 1) {
            index = 1;
        } else if (index >= elements.size()) {
            index = elements.size() - 1;
        }
        Element prev = (Element)elements.get(index - 1);
        List<Element> list = this.parseHtml(parent, prev, html);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    public Element insert(Element parent, Element element) {
        parent.elements().add(element);
        return element;
    }

    public Element insert(Element parent, Wtable table) {
        Element src = table.getSrc();
        this.insert(parent, src);
        return src;
    }

    public Element insert(int index, Element parent, Element element) {
        List elements = parent.elements();
        elements.add(index, element);
        return element;
    }

    public Element insert(int index, Element parent, Wtable table) {
        Element src = table.getSrc();
        this.insert(index, parent, src);
        return src;
    }

    public Element parent(String bookmark, String tag) {
        this.load();
        Element bk = DocxUtil.bookmark(this.doc.getRootElement(), bookmark);
        return DocxUtil.getParent(bk, tag);
    }

    public Element parent(String bookmark) {
        return this.parent(bookmark, null);
    }

    public Wtable table(String bookmark) {
        Element src = this.parent(bookmark, "tbl");
        if (null != src) {
            return new Wtable(this, src);
        }
        return null;
    }

    public List<Wtable> tables(boolean recursion) {
        if (!recursion) {
            return this.tables();
        }
        this.load();
        ArrayList<Wtable> tables = new ArrayList<Wtable>();
        List<Element> elements = this.children(this.src);
        for (Element element : elements) {
            if (!element.getName().equals("tbl")) continue;
            Wtable table = new Wtable(this, element);
            tables.add(table);
        }
        return tables;
    }

    private List<Element> children(Element parent) {
        ArrayList<Element> result = new ArrayList<Element>();
        List items = parent.elements();
        for (Element item : items) {
            result.add(item);
            result.addAll(this.children(item));
        }
        return result;
    }

    public List<Wtable> tables() {
        this.load();
        ArrayList<Wtable> tables = new ArrayList<Wtable>();
        List elements = this.src.elements("tbl");
        for (Element element : elements) {
            Wtable table = new Wtable(this, element);
            tables.add(table);
        }
        return tables;
    }

    public void setOrient(Element prev, String orient, Map<String, String> styles) {
        int index = WDocument.index(this.src, prev);
        Element p = this.src.addElement("w:p");
        Element pr = p.addElement("pPr");
        DocxUtil.setOrient(pr, orient, styles);
        List elements = this.src.elements();
        if (index > -1 && index < elements.size() - 1) {
            elements.remove(p);
            elements.add(index + 1, p);
        }
    }

    public void setOrient(Element prev, String orient) {
        this.setOrient(prev, orient, null);
    }

    public void insertPageBreak(Element prev) {
        int index = WDocument.index(this.src, prev);
        Element p = this.src.addElement("w:p");
        p.addElement("w:r").addElement("w:br").addAttribute("w:type", "page");
        p.addElement("w:r").addElement("w:lastRenderedPageBreak");
        List elements = this.src.elements();
        if (index > -1 && index < elements.size() - 1) {
            elements.remove(p);
            elements.add(index + 1, p);
        }
    }

    public Uploader getUploader() {
        return this.uploader;
    }

    public void setUploader(Uploader uploader) {
        this.uploader = uploader;
    }

    public Downloader getDownloader() {
        return this.downloader;
    }

    public void setDownloader(Downloader downloader) {
        this.downloader = downloader;
    }

    public static int index(Element parent, Element element) {
        int index = parent.indexOf((Node)element);
        while (element.getParent() != parent) {
            if ((element = element.getParent()).getParent() != parent) continue;
            index = parent.indexOf((Node)element);
            break;
        }
        return index;
    }

    private void replaceBookmark(Element start, Map<String, String> replaces) {
        String id = start.attributeValue("id");
        Element end = DomUtil.element((Element)this.src, (String)"bookmarkEnd", (String)"id", (String)id);
        String name = start.attributeValue("name");
        String content = replaces.get(name);
        if (null == content) {
            return;
        }
        boolean isblock = DocxUtil.isBlock(content);
        Element startParent = start.getParent();
        Element endParent = end.getParent();
        if (isblock) {
            if (startParent == endParent) {
                Element nEndP = startParent.getParent().addElement("w:p");
                endParent.elements().remove(end);
                nEndP.elements().add(end);
                DocxUtil.after(nEndP, startParent);
            }
            DomUtil.remove((Element)startParent, (List)DomUtil.afters((Element)start, (String)"t"));
            DomUtil.remove((Element)endParent, (List)DomUtil.befores((Element)end, (String)"t"));
            this.parseHtml(startParent.getParent(), startParent, content);
        } else if (startParent == endParent) {
            DomUtil.remove((Element)startParent, (List)DomUtil.betweens((Element)start, (Element)end, (String[])new String[]{"t"}));
            this.parseHtml(startParent, start, content);
        } else {
            DomUtil.remove((Element)startParent, (List)DomUtil.afters((Element)start, (String)"t"));
            DomUtil.remove((Element)endParent, (List)DomUtil.befores((Element)end, (String)"t"));
            this.parseHtml(startParent, start, content);
        }
    }

    public Element pr(Element element, Map<String, String> styles) {
        return DocxUtil.pr(element, styles);
    }

    private List<Element> parseHtml(Element box, Element prev, String html) {
        ArrayList<Element> list = new ArrayList<Element>();
        if (null == html || html.trim().length() == 0) {
            return list;
        }
        this.styles.clear();
        List styles = RegularUtil.cuts((String)html, (boolean)true, (String[])new String[]{"<style", ">", "</style>"});
        for (String style : styles) {
            this.loadStyle(style);
            html = html.replace(style, "");
        }
        try {
            if (this.IS_HTML_ESCAPE) {
                html = HtmlUtil.name2code((String)html);
            }
            html = "<root>" + html + "</root>";
            Document doc = DocumentHelper.parseText((String)html);
            Element root = doc.getRootElement();
            this.parseHtml(box, prev, root, null, true);
            int size = root.elements().size();
            List elements = box.elements();
            int index = elements.indexOf(prev);
            for (int i = 0; i < size; ++i) {
                list.add((Element)elements.get(index + i + 1));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public Element parent(Element element, String ... tags) {
        Element parent = null;
        if (this.contains(tags, element.getName())) {
            return element;
        }
        parent = element.getParent();
        if (null == parent) {
            return null;
        }
        while (!this.contains(tags, parent.getName()) && null != (parent = parent.getParent())) {
        }
        return parent;
    }

    public Element pp(Element element) {
        String tag = "p";
        Element parent = null;
        if (element.getName().equalsIgnoreCase(tag)) {
            parent = element.getParent();
        } else if (element.getName().equalsIgnoreCase("tc")) {
            parent = element;
        } else {
            parent = element.getParent();
            while (true) {
                if (null == parent) {
                    return this.doc.getRootElement().element("body");
                }
                if (parent.getName().equalsIgnoreCase(tag)) {
                    parent = parent.getParent();
                    break;
                }
                if (parent.getName().equalsIgnoreCase("tc")) break;
                parent = parent.getParent();
            }
        }
        return parent;
    }

    public Element p(Element element) {
        return this.parent(element, "p");
    }

    private boolean contains(String[] list, String item) {
        for (String i : list) {
            if (!i.equalsIgnoreCase(item)) continue;
            return true;
        }
        return false;
    }

    private void split(Element element) {
        Element parent = this.parent(element, "p");
        int pindex = DocxUtil.index(parent);
        this.split(parent.getParent(), parent, element, pindex);
    }

    private Element split(Element box, Element parent, Element stop, int index) {
        Element element = null;
        if (null != parent) {
            List elements = parent.elements();
            for (Element item : elements) {
            }
        }
        return element;
    }

    public Element table(Element box, Element after, Element src) {
        int r;
        Element tbl = src.addElement("w:tbl");
        Element tblPr = tbl.addElement("w:tblPr");
        Table table = new Table();
        Map<String, String> styles = this.style(src);
        this.pr(tbl, styles);
        table.setStyles(styles);
        List html_rows = src.elements("tr");
        for (Element row : html_rows) {
            Tr tr = new Tr();
            tr.setStyles(this.style(row));
            table.addTr(tr);
        }
        int rows_size = html_rows.size();
        int cols_size = 0;
        if (rows_size > 0) {
            Element html_row = (Element)html_rows.get(0);
            List cols = html_row.elements("td");
            for (Element col : cols) {
                int colspan = BasicUtil.parseInt((Object)col.attributeValue("colspan"), (Integer)1);
                cols_size += colspan;
            }
        }
        Td[][] cells = new Td[rows_size][cols_size];
        for (r = 0; r < rows_size; ++r) {
            Tr tr = table.getTr(r);
            for (int c = 0; c < cols_size; ++c) {
                Td td;
                cells[r][c] = td = new Td();
                tr.addTd(td);
            }
        }
        for (r = 0; r < rows_size; ++r) {
            Element html_row = (Element)html_rows.get(r);
            String row_style = html_row.attributeValue("style");
            List cols = html_row.elements("td");
            int tcIndex = 0;
            int tdIndex = 0;
            while (tdIndex < cols.size()) {
                Element html_col = (Element)cols.get(tdIndex);
                String text = html_col.getTextTrim();
                Td tc = cells[r][tcIndex];
                int merge_qty = 0;
                while (!tc.isEmpty()) {
                    tc = cells[r][tcIndex + ++merge_qty];
                }
                tc.setSrc(html_col);
                if (this.IS_HTML_ESCAPE) {
                    text = HtmlUtil.display((String)text);
                }
                tc.setText(text);
                Map tdStyles = StyleParser.join((Map)tc.getStyles(), this.style(html_col));
                tdStyles = StyleParser.parse((Map)tdStyles, (String)html_col.attributeValue("style"), (boolean)true);
                tc.setStyles(tdStyles);
                tc.setClazz(html_col.attributeValue("class"));
                int rowspan = BasicUtil.parseInt((Object)html_col.attributeValue("rowspan"), (Integer)1);
                int colspan = BasicUtil.parseInt((Object)html_col.attributeValue("colspan"), (Integer)1);
                if (rowspan > 1) {
                    tc.setMerge(1);
                    for (int i = r + 1; i <= r + rowspan - 1; ++i) {
                        for (int j = tcIndex + 1; j < tcIndex + colspan; ++j) {
                            Td merge = cells[i][j];
                            merge.setRemove(true);
                        }
                        Td merge = cells[i][tcIndex + merge_qty];
                        merge.setMerge(2);
                    }
                }
                if (colspan > 1) {
                    tc.setColspan(colspan);
                    for (int j = r; j < r + rowspan; ++j) {
                        if (j > r) {
                            Td merge = cells[j][tcIndex];
                            merge.setMerge(2);
                            merge.setColspan(colspan);
                        }
                        for (int i = tcIndex + merge_qty + 1; i < tcIndex + merge_qty + colspan; ++i) {
                            Td cur = cells[j][i];
                            cur.setRemove(true);
                        }
                    }
                }
                tcIndex += colspan - 1;
                ++tdIndex;
                ++tcIndex;
            }
        }
        Element word = src.element("word");
        if (null != word) {
            this.word(tbl, null, word, styles);
        }
        for (int r2 = 0; r2 < rows_size; ++r2) {
            Tr tr = table.getTr(r2);
            this.tr(tbl, tr);
        }
        DocxUtil.after(tbl, after);
        return tbl;
    }

    public Element tr(Element parent, Tr tr) {
        Element etr = parent.addElement("w:tr");
        Map styles = StyleParser.inherit((Map)tr.getStyles(), (Map)tr.getTable().getStyles());
        tr.setStyles(styles);
        this.pr(etr, tr.getStyles());
        for (Td td : tr.getTds()) {
            Element tc = this.tc(etr, td);
        }
        return etr;
    }

    public Element tc(Element parent, Td td) {
        Element tc = null;
        int merge = td.getMerge();
        int colspan = td.getColspan();
        boolean remove = td.isRemove();
        if (!remove) {
            tc = parent.addElement("w:tc");
            Element tcPr = DocxUtil.addElement(tc, "tcPr");
            if (merge > 0) {
                Element vMerge = tcPr.addElement("w:vMerge");
                if (merge == 1) {
                    vMerge.addAttribute("w:val", "restart");
                }
            }
            if (colspan > 1) {
                Element span = tcPr.addElement("w:gridSpan");
                span.addAttribute("w:val", colspan + "");
            }
            if (tcPr.elements().size() == 0) {
                // empty if block
            }
            Map styles = StyleParser.inherit((Map)td.getStyles(), (Map)td.getTr().getStyles());
            this.pr(tc, styles);
            if (merge != 2) {
                if (null != td.getSrc()) {
                    this.parseHtml(tc, null, td.getSrc(), StyleParser.inherit(null, (Map)styles), false);
                }
            } else {
                this.p(tc, "", null);
            }
        }
        return tc;
    }

    private Element inline(Element parent, Element prev, String text, Map<String, String> styles, boolean copyPrevStyle) {
        Element p;
        Element r;
        String pname = parent.getName();
        if (pname.equalsIgnoreCase("r")) {
            r = parent;
            this.pr(parent, styles);
            DocxUtil.after(r, prev);
        } else if (pname.equalsIgnoreCase("tc")) {
            p = DocxUtil.addElement(parent, "p");
            r = DocxUtil.addElement(p, "r");
            this.pr(r, styles);
            DocxUtil.after(r, prev);
        } else if (pname.equalsIgnoreCase("p")) {
            this.pr(parent, styles);
            r = parent.addElement("w:r");
            if (copyPrevStyle && null != prev) {
                Element prevR = this.prevStyle(prev);
                DocxUtil.copyStyle(r, prevR, true);
            }
            DocxUtil.after(r, prev);
        } else if (pname.equalsIgnoreCase("body")) {
            p = parent.addElement("w:p");
            this.pr(p, styles);
            r = p.addElement("w:r");
            DocxUtil.after(p, prev);
        } else {
            throw new RuntimeException("text.parent\u5f02\u5e38:" + parent.getName());
        }
        this.pr(r, styles);
        Element t = r.addElement("w:t");
        if (this.IS_HTML_ESCAPE) {
            text = HtmlUtil.display((String)text);
        }
        t.setText(text.trim());
        return r;
    }

    public Element prevStyle(Element prev) {
        Element prevStyle = null;
        if (prev.getName().equals("r")) {
            prevStyle = prev;
        } else {
            Element tmp = DocxUtil.prev(prev);
            if (null != tmp) {
                String tmpName = tmp.getName();
                if (tmpName.equals("r")) {
                    prevStyle = tmp;
                } else if (tmpName.equals("pPr")) {
                    prevStyle = tmp;
                } else if (tmpName.equals("p")) {
                    prevStyle = tmp;
                }
            }
        }
        return prevStyle;
    }

    public Element block(Element parent, Element prev, Element element, Map<String, String> styles) {
        Element box = null;
        String pname = parent.getName();
        Element newPrev = null;
        Element wp = null;
        if (null != styles && null != styles.get("page-break-after")) {
            Element pageP = parent.addElement("w:p");
            pageP.addElement("w:r").addElement("w:br").addAttribute("w:type", "page");
            pageP.addElement("w:r").addElement("w:lastRenderedPageBreak");
            DocxUtil.after(pageP, prev);
            return pageP;
        }
        this.pr(parent, styles);
        if (pname.equalsIgnoreCase("p")) {
            box = parent.addElement("w:r");
            if (!DocxUtil.isEmpty(parent)) {
                prev = box.addElement("w:br");
            }
            DocxUtil.after(box, prev);
            newPrev = parent;
            wp = parent;
        } else if (pname.equalsIgnoreCase("r")) {
            box = parent.getParent().addElement("w:r");
            if (!DocxUtil.isEmpty(parent)) {
                prev = box.addElement("w:br");
            }
            DocxUtil.after(box, prev);
            wp = newPrev = parent.getParent();
        } else if (pname.equalsIgnoreCase("tc")) {
            Element p = parent.element("p");
            box = null != p && DocxUtil.isEmpty(p) ? p : parent.addElement("w:p");
            DocxUtil.after(box, prev);
            newPrev = box;
            wp = box;
        } else if (pname.equalsIgnoreCase("body")) {
            newPrev = box = parent.addElement("w:p");
            DocxUtil.after(box, prev);
            wp = box;
        } else {
            throw new RuntimeException("div.parent \u5f02\u5e38:" + pname + ":" + element.getName() + ":" + element.getTextTrim());
        }
        this.pr(box, styles);
        this.parseHtml(box, prev, element, styles, false);
        return newPrev;
    }

    private Element ol(Element parent, Element prev, Element element, Map<String, String> styles) {
        styles = StyleParser.parse(styles, (String)element.attributeValue("style"), (boolean)true);
        if (!DocxUtil.hasParent(element, "ol")) {
            ++this.listNum;
        }
        List lis = element.elements();
        for (Element li : lis) {
            String liName = li.getName();
            if (liName.equalsIgnoreCase("ol")) {
                prev = this.ol(this.src, prev, li, styles);
                continue;
            }
            prev = this.li(this.src, prev, li, styles);
        }
        return prev;
    }

    private List<Map<String, String>> lis(Element parent) {
        ArrayList<Map<String, String>> lis = new ArrayList<Map<String, String>>();
        Iterator nodes = parent.nodeIterator();
        while (nodes.hasNext()) {
            Element element;
            String tag;
            Node node = (Node)nodes.next();
            short type = node.getNodeType();
            if (type == 3 || type != 1 || !(tag = (element = (Element)node).getName()).equalsIgnoreCase("li")) continue;
            HashMap<String, String> li = new HashMap<String, String>();
            li.put("tag", tag);
            lis.add(li);
        }
        return lis;
    }

    private Element li(Element parent, Element prev, Element element, Map<String, String> styles) {
        Element box = parent.addElement("w:p");
        int lvl = this.lvl(element);
        styles.put("list-lvl", lvl + "");
        styles.put("list-num", this.listNum + "");
        this.pr(box, styles);
        DocxUtil.after(box, prev);
        prev = this.parseHtml(box, prev, element, styles, false);
        return prev;
    }

    private int lvl(Element li) {
        int lvl = -1;
        while ((li = li.getParent()) != null) {
            if (!li.getName().equalsIgnoreCase("ol")) continue;
            ++lvl;
        }
        return lvl;
    }

    private Element word(Element parent, Element prev, Element element, Map<String, String> styles) {
        String path = element.getTextTrim();
        String bookmark = element.attributeValue("bookmark");
        return this.word(parent, prev, new File(path), bookmark, styles);
    }

    private Element word(Element parent, Element prev, File word, String bookmark, Map<String, String> styles) {
        Element newPrev = null;
        String wxml = ZipUtil.read((File)word, (String)"word/document.xml", (String)this.charset);
        try {
            Element wsrc = DocumentHelper.parseText((String)wxml).getRootElement().element("body");
            List<Element> elements = null;
            if (null != bookmark) {
                Element start = DocxUtil.bookmark(wsrc, bookmark);
                elements = DocxUtil.betweens(start, "tr", "tblGrid", "p");
            } else {
                elements = wsrc.elements();
            }
            if (null != elements) {
                for (Element element : elements) {
                    String name = element.getName();
                    if ("sectPr".equalsIgnoreCase(name)) continue;
                    element.getParent().remove(element);
                    if (parent.getName().equalsIgnoreCase(element.getName())) {
                        this.addElements(parent, element.elements(), true);
                    } else {
                        parent.elements().add(element);
                    }
                    newPrev = element;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newPrev;
    }

    private void addElements(Element parent, List<Element> elements, boolean over) {
        for (Element element : elements) {
            String name = element.getName();
            element.getParent().remove(element);
            List exists = DomUtil.elements((Element)parent, (String)name, (boolean)false);
            if (null != exists && exists.size() > 0) {
                if (!over) continue;
                DomUtil.remove((Element)parent, (List)exists);
                parent.elements().add(element);
                continue;
            }
            parent.elements().add(element);
        }
    }

    private Element img(Element parent, Element prev, Element element, Map<String, String> styles) {
        boolean isFloat;
        int idx;
        String subfix;
        Element p;
        Element r;
        String pname = parent.getName();
        if (pname.equalsIgnoreCase("r")) {
            r = parent;
            this.pr(parent, styles);
            DocxUtil.after(r, prev);
        } else if (pname.equalsIgnoreCase("tc")) {
            p = parent.element("p");
            if (null == p || !DocxUtil.isEmpty(p)) {
                p = parent.addElement("w:p");
            }
            this.pr(p, styles);
            r = p.addElement("w:r");
            DocxUtil.after(r, prev);
        } else if (pname.equalsIgnoreCase("p")) {
            this.pr(parent, styles);
            r = parent.addElement("w:r");
        } else if (pname.equalsIgnoreCase("body")) {
            p = parent.addElement("w:p");
            this.pr(p, styles);
            r = p.addElement("w:r");
            DocxUtil.after(p, prev);
        } else {
            throw new RuntimeException("text.parent\u5f02\u5e38:" + parent.getName());
        }
        styles = StyleParser.inherit(this.style(element), styles);
        this.pr(r, styles);
        String widthType = DocxUtil.widthType((String)styles.get("width"));
        int width = 0;
        if (!"pct".equalsIgnoreCase(widthType)) {
            width = DocxUtil.px2emu((int)DocxUtil.dxa2px(DocxUtil.dxa((String)styles.get("width"))));
        }
        String heightType = DocxUtil.widthType((String)styles.get("height"));
        int height = 0;
        if (!"pct".equalsIgnoreCase(heightType)) {
            height = DocxUtil.px2emu((int)DocxUtil.dxa2px(DocxUtil.dxa((String)styles.get("height"))));
        }
        String rdm = System.currentTimeMillis() + "";
        String rId = "rId" + rdm;
        String src = element.attributeValue("body");
        if (BasicUtil.isEmpty((Object)src)) {
            src = element.attributeValue("src");
        }
        if (null == (subfix = element.attributeValue("type")) && (subfix = (idx = src.lastIndexOf(".")) != -1 ? src.substring(idx + 1) : "jpg").length() > 20) {
            subfix = "jpeg";
        }
        File tmpdir = new File(System.getProperty("java.io.tmpdir"));
        File img = null;
        try {
            if (RegularUtil.isUrl((String)src)) {
                img = new File(tmpdir, "image" + rdm + "." + subfix);
                if (null != this.downloader) {
                    this.downloader.download(src, img);
                } else {
                    log.error("\u672a\u63d0\u4f9b downloader,\u65e0\u6cd5\u4e0b\u8f7d:{}", (Object)src);
                }
            } else {
                if (src.startsWith("file:")) {
                    src = src.substring("file:".length());
                }
                img = new File(src);
            }
            HashMap<String, File> map = new HashMap<String, File>();
            map.put("word/media/" + img.getName(), img);
            ZipUtil.append(map, (File)this.file);
            if (RegularUtil.isUrl((String)src) && img.exists()) {
                img.delete();
            }
            Element relRoot = this.rels.getRootElement();
            Element imgRel = relRoot.addElement("Relationship");
            imgRel.addAttribute("Id", rId);
            imgRel.addAttribute("Type", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/image");
            imgRel.addAttribute("Target", "media/" + img.getName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Element draw = r.addElement("w:drawing");
        Element box = null;
        String positionType = (String)styles.get("position");
        boolean bl = isFloat = "relative".equalsIgnoreCase(positionType) || "fixed".equalsIgnoreCase(positionType);
        if (isFloat) {
            box = draw.addElement("wp:anchor");
            box.addAttribute("distT", "0");
            box.addAttribute("distB", "0");
            box.addAttribute("distL", "114300");
            box.addAttribute("distR", "114300");
            int zIndex = BasicUtil.parseInt(styles.get("z-index"), (Integer)100);
            box.addAttribute("relativeHeight", zIndex + "");
            box.addAttribute("behindDoc", "0");
            box.addAttribute("locked", "0");
            box.addAttribute("layoutInCell", "0");
            box.addAttribute("allowOverlap", "1");
            int offsetX = (int)DocxUtil.dxa2emu(DocxUtil.dxa((String)styles.get("offset-x")));
            int offsetY = (int)DocxUtil.dxa2emu(DocxUtil.dxa((String)styles.get("offset-y")));
            Element simplePos = box.addElement("wp:simplePos");
            if ("fixed".equals(positionType)) {
                box.addAttribute("simplePos", "1");
                simplePos.addAttribute("x", offsetX + "");
                simplePos.addAttribute("y", offsetY + "");
            } else {
                box.addAttribute("simplePos", "0");
                simplePos.addAttribute("x", "0");
                simplePos.addAttribute("y", "0");
                String relativeX = (String)styles.get("relative-x");
                Element positionH = box.addElement("wp:positionH");
                positionH.addAttribute("relativeFrom", relativeX);
                Element posOffsetH = positionH.addElement("wp:posOffset");
                posOffsetH.setText(offsetX + "");
                String relativeY = (String)styles.get("relative-y");
                Element positionV = box.addElement("wp:positionV");
                positionV.addAttribute("relativeFrom", relativeY);
                Element posOffsetV = positionV.addElement("wp:posOffset");
                posOffsetV.setText(offsetY + "");
            }
        } else {
            box = draw.addElement("wp:inline");
            box.addAttribute("distT", "0");
            box.addAttribute("distB", "0");
            box.addAttribute("distL", "0");
            box.addAttribute("distR", "0");
        }
        Element extent = box.addElement("wp:extent");
        extent.addAttribute("cx", width + "");
        extent.addAttribute("cy", height + "");
        Element effectExtent = box.addElement("wp:effectExtent");
        effectExtent.addAttribute("l", "0");
        effectExtent.addAttribute("r", "0");
        effectExtent.addAttribute("t", "0");
        effectExtent.addAttribute("b", "0");
        if (isFloat) {
            box.addElement("wp:wrapNone");
        }
        Element docPr = box.addElement("wp:docPr");
        int docPrId = NumberUtil.random((int)0, (int)100);
        docPr.addAttribute("id", docPrId + "");
        docPr.addAttribute("name", "\u56fe\u7247" + rdm);
        docPr.addAttribute("descr", img.getName());
        Element cNvGraphicFramePr = box.addElement("wp:cNvGraphicFramePr");
        Element graphicFrameLocks = cNvGraphicFramePr.addElement("a:graphicFrameLocks", "http://schemas.openxmlformats.org/drawingml/2006/main");
        graphicFrameLocks.addAttribute("xmlns:a", "http://schemas.openxmlformats.org/drawingml/2006/main");
        graphicFrameLocks.addAttribute("noChangeAspect", "1");
        Element graphic = box.addElement("a:graphic", "http://schemas.openxmlformats.org/drawingml/2006/main");
        graphic.addAttribute("xmlns:a", "http://schemas.openxmlformats.org/drawingml/2006/main");
        Element graphicData = graphic.addElement("a:graphicData");
        graphicData.addAttribute("uri", "http://schemas.openxmlformats.org/drawingml/2006/picture");
        Element pic = graphicData.addElement("pic:pic", "http://schemas.openxmlformats.org/drawingml/2006/picture");
        pic.addAttribute("xmlns:pic", "http://schemas.openxmlformats.org/drawingml/2006/picture");
        Element nvPicPr = pic.addElement("pic:nvPicPr");
        Element cNvPr = nvPicPr.addElement("pic:cNvPr");
        cNvPr.addAttribute("id", docPrId + "");
        cNvPr.addAttribute("name", img.getName());
        Element cNvPicPr = nvPicPr.addElement("pic:cNvPicPr");
        Element blipFill = pic.addElement("pic:blipFill");
        Element blip = blipFill.addElement("a:blip");
        blip.addAttribute("r:embed", rId);
        Element stretch = blipFill.addElement("a:stretch");
        Element fillRect = stretch.addElement("a:fillRect");
        Element spPr = pic.addElement("pic:spPr");
        Element xfrm = spPr.addElement("a:xfrm");
        Element off = xfrm.addElement("a:off");
        off.addAttribute("x", "0");
        off.addAttribute("y", "0");
        Element ext = xfrm.addElement("a:ext");
        ext.addAttribute("cx", width + "");
        ext.addAttribute("cy", height + "");
        Element prstGeom = spPr.addElement("a:prstGeom");
        prstGeom.addAttribute("prst", "rect");
        prstGeom.addElement("a:avLst");
        DocxUtil.after(r, prev);
        return r;
    }

    public Element parseHtml(Element parent, Element prev, Element html, Map<String, String> styles, boolean copyPrevStyle) {
        String pname = parent.getName();
        String txt = html.getTextTrim();
        if (html.elements().size() == 0) {
            txt = txt.trim();
            html.setText(txt);
        }
        Iterator nodes = html.nodeIterator();
        boolean empty = true;
        while (nodes.hasNext()) {
            Node node = (Node)nodes.next();
            String tag = node.getName();
            short type = node.getNodeType();
            if (type == 3) {
                Element r;
                String text = node.getText().trim();
                if (text.length() <= 0) continue;
                empty = false;
                prev = r = this.inline(parent, prev, text, styles, copyPrevStyle);
                continue;
            }
            if (type != 1) continue;
            empty = false;
            Element element = (Element)node;
            Map itemStyles = StyleParser.inherit(this.style(element), styles);
            String display = (String)itemStyles.get("display");
            if ("none".equalsIgnoreCase(display)) continue;
            if ("table".equalsIgnoreCase(tag)) {
                Element tbl;
                Element box = null;
                if (pname.equalsIgnoreCase("tc")) {
                    box = parent;
                    this.pr(box, styles);
                } else {
                    box = pname.equalsIgnoreCase("p") ? parent.addElement("w:r") : this.doc.getRootElement().element("body");
                }
                prev = tbl = this.table(box, prev, element);
                continue;
            }
            if ("div".equalsIgnoreCase(tag)) {
                if ("inline".equalsIgnoreCase(display) || "inline-block".equalsIgnoreCase(display)) {
                    prev = this.parseHtml(parent, prev, element, itemStyles, false);
                    continue;
                }
                prev = this.block(parent, prev, element, itemStyles);
                continue;
            }
            if ("span".equalsIgnoreCase(tag)) {
                if ("block".equalsIgnoreCase(display)) {
                    prev = this.block(parent, prev, element, itemStyles);
                    continue;
                }
                prev = this.parseHtml(parent, prev, element, itemStyles, false);
                continue;
            }
            if ("img".equalsIgnoreCase(tag)) {
                Element img;
                prev = img = this.img(parent, prev, element, styles);
                continue;
            }
            if ("word".equalsIgnoreCase(tag)) {
                Element word;
                prev = word = this.word(parent, prev, element, styles);
                continue;
            }
            if ("ol".equalsIgnoreCase(tag)) {
                prev = this.ol(this.src, prev, element, itemStyles);
                continue;
            }
            if ("li".equalsIgnoreCase(tag)) {
                prev = this.li(this.src, prev, element, itemStyles);
                continue;
            }
            if ("br".equalsIgnoreCase(tag)) {
                prev = parent.addElement("w:br");
                continue;
            }
            if ("u".equalsIgnoreCase(tag)) {
                itemStyles.put("underline", "true");
                prev = this.parseHtml(parent, prev, element, itemStyles, false);
                continue;
            }
            if ("b".equalsIgnoreCase(tag)) {
                itemStyles.put("font-weight", "700");
                prev = this.parseHtml(parent, prev, element, itemStyles, false);
                continue;
            }
            if ("i".equalsIgnoreCase(tag)) {
                itemStyles.put("italics", "true");
                prev = this.parseHtml(parent, prev, element, itemStyles, false);
                continue;
            }
            if ("del".equalsIgnoreCase(tag)) {
                itemStyles.put("strike", "true");
                prev = this.parseHtml(parent, prev, element, itemStyles, false);
                continue;
            }
            if ("sup".equalsIgnoreCase(tag)) {
                itemStyles.put("vertical-align", "superscript");
                prev = this.parseHtml(parent, prev, element, itemStyles, false);
                continue;
            }
            if ("sub".equalsIgnoreCase(tag)) {
                itemStyles.put("vertical-align", "subscript");
                prev = this.parseHtml(parent, prev, element, itemStyles, false);
                continue;
            }
            prev = this.parseHtml(parent, prev, element, itemStyles, false);
        }
        if (empty && "tc".equalsIgnoreCase(pname)) {
            parent.addElement("w:p");
        }
        return prev;
    }

    public WDocument remove(Element element) {
        element.getParent().remove(element);
        this.reload();
        return this;
    }

    public WDocument remove(Wtable table) {
        Element element = table.getSrc();
        element.getParent().remove(element);
        this.reload();
        return this;
    }

    public Element parseHtml(Element parent, Element prev, Element html, Map<String, String> styles) {
        return this.parseHtml(parent, prev, html, styles, false);
    }

    public Element p(Element parent, String text, Map<String, String> styles) {
        while (parent.getName().equalsIgnoreCase("p")) {
            parent = parent.getParent();
        }
        Element p = parent.addElement("w:p");
        this.pr(p, styles);
        if (null != text && text.trim().length() > 0) {
            Element r = this.r(p, text, styles);
        }
        return p;
    }

    public Element r(Element parent, String text, Map<String, String> styles) {
        Element r = null;
        if (null != text && text.trim().length() > 0) {
            r = parent.addElement("w:r");
            this.pr(r, styles);
            Element t = r.addElement("w:t");
            if (this.IS_HTML_ESCAPE) {
                text = HtmlUtil.display((String)text);
            }
            t.setText(text);
        }
        return r;
    }

    public Map<String, String> style(Element element) {
        String string;
        String tag;
        int index = element.getParent().elements(element.getName()).indexOf(element);
        String nth = ":nth-child(even)";
        if ((index + 1) % 2 == 0) {
            nth = ":nth-child(odd)";
        }
        Map<String, String> result = new HashMap<String, String>();
        if (null == element) {
            return result;
        }
        String parentName = null;
        ArrayList<String> parentClassList = new ArrayList<String>();
        Element parent = element.getParent();
        if (null != parent) {
            parentName = parent.getName();
            String parentClass = parent.attributeValue("class");
            if (null != parentClass) {
                String[] tmps = parentClass.trim().split(" ");
                for (String string2 : tmps) {
                    String string3 = string2.trim();
                    if (string3.length() <= 0) continue;
                    parentClassList.add(string3);
                }
            }
        }
        if ((tag = element.getName()).equalsIgnoreCase("table")) {
            result = StyleParser.parse(result, (String)"border:1px solid auto;");
        } else if (tag.equalsIgnoreCase("td")) {
            result = StyleParser.parse(result, (String)"vertical-align:center;");
        }
        String name = element.getName();
        for (String string4 : parentClassList) {
            StyleParser.join(result, this.styles.get("." + string4 + " " + name), (boolean)true);
            StyleParser.join(result, this.styles.get("." + string4 + " " + name + nth), (boolean)true);
        }
        if (null != parentName) {
            StyleParser.join(result, this.styles.get(parentName + " " + name), (boolean)true);
            StyleParser.join(result, this.styles.get(parentName + " " + name + nth), (boolean)true);
        }
        StyleParser.join(result, this.styles.get(name), (boolean)true);
        StyleParser.join(result, this.styles.get(name + nth), (boolean)true);
        String clazz = element.attributeValue("class");
        if (null != clazz) {
            String[] stringArray;
            for (String c : stringArray = clazz.split(" ")) {
                if (null != parentName) {
                    StyleParser.join(result, this.styles.get(parentName + " ." + c), (boolean)true);
                    StyleParser.join(result, this.styles.get(parentName + " ." + c + nth), (boolean)true);
                }
                for (String string5 : parentClassList) {
                    StyleParser.join(result, this.styles.get("." + string5 + " ." + c), (boolean)true);
                    StyleParser.join(result, this.styles.get("." + string5 + " ." + nth), (boolean)true);
                }
                StyleParser.join(result, this.styles.get("." + c), (boolean)true);
                StyleParser.join(result, this.styles.get("." + c + nth), (boolean)true);
            }
        }
        if (null != (string = element.attributeValue("id"))) {
            StyleParser.join(result, this.styles.get("#" + string), (boolean)true);
        }
        result = StyleParser.parse(result, (String)element.attributeValue("style"), (boolean)true);
        return result;
    }

    public String listStyle(String key) {
        return DocxUtil.listStyle(this.file, key, this.charset);
    }

    public Element insert(Element prev, File file) {
        Element last = null;
        WDocument idoc = new WDocument(file);
        idoc.load();
        Element src = idoc.getSrc();
        List inserts = DomUtil.elements((Element)src, (String)"p,tbl");
        int index = WDocument.index(src, prev);
        List elements = src.elements();
        for (Element insert : inserts) {
            insert.getParent().remove(insert);
            elements.add(index++, insert);
            last = insert;
        }
        return last;
    }

    public List<String> listStyles() {
        return DocxUtil.listStyles(this.file, this.charset);
    }

    @Override
    public String html(Uploader uploader, int lvl) {
        StringBuilder builder = new StringBuilder();
        if (null == this.src) {
            this.reload();
        }
        Iterator it = this.src.elementIterator();
        while (it.hasNext()) {
            Element item = (Element)it.next();
            String tag = item.getName();
            if (tag.equalsIgnoreCase("p")) {
                builder.append(new Wp(this, item).html(uploader, lvl + 1));
                continue;
            }
            if (!tag.equalsIgnoreCase("tbl")) continue;
            builder.append(new Wtable(this, item).html(uploader, lvl + 1));
        }
        return builder.toString();
    }
}

