/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.office.docx.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.anyline.util.BasicUtil;
import org.anyline.util.DomUtil;
import org.anyline.util.StyleParser;
import org.anyline.util.ZipUtil;
import org.anyline.util.regular.RegularUtil;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocxUtil {
    private static Logger log = LoggerFactory.getLogger(DocxUtil.class);
    public static double PT_PER_PX = 0.75;
    public static int IN_PER_PT = 72;
    public static double CM_PER_PT = 28.3;
    public static double MM_PER_PT = 2.83;
    public static int EMU_PER_PX = 9525;
    public static int EMU_PER_DXA = 635;
    private static Map<String, Integer> fontSizes = new HashMap<String, Integer>(){
        {
            this.put("\u521d\u53f7", 84);
            this.put("\u5c0f\u521d", 72);
            this.put("\u4e00\u53f7", 52);
            this.put("\u5c0f\u4e00", 48);
            this.put("\u4e8c\u53f7", 44);
            this.put("\u5c0f\u4e8c", 36);
            this.put("\u4e09\u53f7", 33);
            this.put("\u5c0f\u4e09", 30);
            this.put("\u56db\u53f7", 28);
            this.put("\u5c0f\u56db", 24);
            this.put("\u4e94\u53f7", 21);
            this.put("\u5c0f\u4e94", 18);
            this.put("\u516d\u53f7", 15);
            this.put("\u5c0f\u516d", 13);
            this.put("\u4e03\u53f7", 11);
            this.put("\u516b\u53f7", 10);
        }
    };

    public static String listStyle(File docx, String key, String charset) {
        try {
            String num_xml = ZipUtil.read((File)docx, (String)"word/document.xml", (String)charset);
            Document document = DocumentHelper.parseText((String)num_xml);
            List ts = DomUtil.elements((Element)document.getRootElement(), (String)"t");
            for (Element t : ts) {
                String val;
                Element numId;
                Element numPr;
                Element pr;
                if (!t.getTextTrim().contains(key) || null == (pr = t.getParent().getParent().element("pPr")) || null == (numPr = pr.element("numPr")) || null == (numId = numPr.element("numId")) || null == (val = numId.attributeValue("val"))) continue;
                return val;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static List<String> listStyles(File docx, String charset) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            String num_xml = ZipUtil.read((File)docx, (String)"word/numbering.xml", (String)charset);
            Document document = DocumentHelper.parseText((String)num_xml);
            List nums = document.getRootElement().elements("num");
            for (Element num : nums) {
                list.add(num.attributeValue("numId"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static void merge(String charset, File ... files) {
        if (null != files && files.length > 1) {
            ArrayList<String> docs = new ArrayList<String>();
            for (File file : files) {
                docs.add(ZipUtil.read((File)file, (String)"word/document.xml", (String)charset));
            }
            String result = DocxUtil.merge(docs);
            try {
                Document document = DocumentHelper.parseText((String)result);
                Element root = document.getRootElement().element("body");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String merge(List<String> docs) {
        String result = null;
        return result;
    }

    public static void copyStyle(Element src, Element copy, boolean override) {
        if (null == src || null == copy) {
            return;
        }
        String name = src.getName();
        String prName = name + "Pr";
        Element srcPr = src.element(prName);
        if (override) {
            src.remove(srcPr);
            srcPr = null;
        }
        Element pr = null;
        String copyName = copy.getName();
        pr = copyName.equals(prName) ? copy : DomUtil.element((Element)copy, (String)prName);
        if (null != pr) {
            if (null == srcPr) {
                Element newPr = pr.createCopy();
                src.elements().add(0, newPr);
            } else {
                List items = pr.elements();
                ArrayList<Element> newItems = new ArrayList<Element>();
                for (Element item : items) {
                    String itemName = item.getName();
                    Element srcItem = srcPr.element(itemName);
                    if (override) {
                        srcPr.remove(srcItem);
                        srcItem = null;
                    }
                    if (null == srcItem) {
                        Element newItem = item.createCopy();
                        newItems.add(newItem);
                        continue;
                    }
                    List attributes = item.attributes();
                    for (Attribute attribute : attributes) {
                        Attribute srcAttribute;
                        String attributeName;
                        String attributeFullName = attributeName = attribute.getName();
                        String attributeNamespace = attribute.getNamespacePrefix();
                        if (BasicUtil.isNotEmpty((Object)attributeNamespace)) {
                            attributeFullName = attributeNamespace + ":" + attributeName;
                        }
                        if (null == (srcAttribute = srcItem.attribute(attributeName))) {
                            srcAttribute = srcItem.attribute(attributeFullName);
                        }
                        if (override && null != srcAttribute) {
                            srcItem.remove(srcAttribute);
                            srcAttribute = null;
                        }
                        if (null != srcAttribute) continue;
                        srcItem.attributeValue(attributeFullName, attribute.getStringValue());
                    }
                }
                srcPr.elements().addAll(newItems);
            }
        }
    }

    public static void copyStyle(Element src, Element copy) {
        DocxUtil.copyStyle(src, copy, false);
    }

    public static Element prevByName(Element element) {
        Element prev = null;
        List elements = DomUtil.elements((Element)DocxUtil.top(element), (String)element.getName());
        int index = elements.indexOf(element);
        if (index > 0) {
            prev = (Element)elements.get(index - 1);
        }
        return prev;
    }

    public static Element prevByName(Element parent, Element element) {
        Element prev = null;
        List elements = DomUtil.elements((Element)parent, (String)element.getName());
        int index = elements.indexOf(element);
        if (index > 0) {
            prev = (Element)elements.get(index - 1);
        }
        return prev;
    }

    public static Element nextByName(Element element) {
        Element prev = null;
        List elements = DomUtil.elements((Element)DocxUtil.top(element), (String)element.getName());
        int index = elements.indexOf(element);
        if (index < elements.size() - 1 && index > 0) {
            prev = (Element)elements.get(index + 1);
        }
        return prev;
    }

    public static Element nextByName(Element parent, Element element) {
        Element prev = null;
        List elements = DomUtil.elements((Element)parent, (String)element.getName());
        int index = elements.indexOf(element);
        if (index < elements.size() - 1 && index > 0) {
            prev = (Element)elements.get(index + 1);
        }
        return prev;
    }

    public static Element top(Element element) {
        Element top = element.getParent();
        while (null != top.getParent()) {
            top = top.getParent();
        }
        return top;
    }

    public static Element prev(Element element) {
        Element prev = null;
        List elements = element.getParent().elements();
        int index = elements.indexOf(element);
        if (index > 0) {
            prev = (Element)elements.get(index - 1);
        }
        return prev;
    }

    public static String prevName(Element element) {
        Element prev = DocxUtil.prev(element);
        if (null != prev) {
            return prev.getName();
        }
        return "";
    }

    public static Element last(Element element) {
        Element last = null;
        List elements = element.getParent().elements();
        if (elements.size() > 0) {
            last = (Element)elements.get(elements.size() - 1);
        }
        return last;
    }

    public static String lastName(Element element) {
        Element last = DocxUtil.last(element);
        if (null != last) {
            return last.getName();
        }
        return "";
    }

    public static boolean isEmpty(Element element) {
        List elements = DomUtil.elements((Element)element, (String)"drawing,tbl,t");
        for (Element item : elements) {
            String name = item.getName();
            if (name.equalsIgnoreCase("drawing")) {
                return false;
            }
            if (name.equalsIgnoreCase("tbl")) {
                return false;
            }
            if (!name.equalsIgnoreCase("t") || item.getTextTrim().length() <= 0) continue;
            return false;
        }
        return element.getTextTrim().length() <= 0;
    }

    private static boolean isEmpty(List<Element> elements) {
        for (Element item : elements) {
            String name = item.getName();
            if (!name.equalsIgnoreCase("r") && !name.equalsIgnoreCase("t") && !name.equalsIgnoreCase("tbl")) continue;
            return false;
        }
        return true;
    }

    public static boolean hasParent(Element element, String parent) {
        for (Element p = element.getParent(); null != p; p = p.getParent()) {
            if (!p.getName().equalsIgnoreCase(parent)) continue;
            return true;
        }
        return false;
    }

    public static Element getParent(Element element, String tag) {
        Element p;
        if (null == tag) {
            return p;
        }
        for (p = element.getParent(); null != p; p = p.getParent()) {
            if (!p.getName().equalsIgnoreCase(tag)) continue;
            return p;
        }
        return null;
    }

    public static void after(Element src, Element ref) {
        if (null == ref || null == src) {
            return;
        }
        if (ref.getParent() == src.getParent()) {
            List elements = ref.getParent().elements();
            int index = elements.indexOf(ref) + 1;
            elements.remove(src);
            if (index > elements.size() - 1) {
                elements.add(src);
            } else {
                elements.add(index, src);
            }
        } else {
            DocxUtil.after(src, ref.getParent());
        }
    }

    public static void after(List<Element> srcs, Element ref) {
        if (null == ref || null == srcs) {
            return;
        }
        int size = srcs.size();
        for (int i = size - 1; i >= 0; --i) {
            Element src = srcs.get(i);
        }
        for (Element src : srcs) {
            DocxUtil.after(src, ref);
        }
    }

    public static void before(Element src, Element ref) {
        if (null == ref || null == src) {
            return;
        }
        List elements = ref.getParent().elements();
        int index = elements.indexOf(ref);
        while (!elements.contains(src)) {
            if (null != (src = src.getParent())) continue;
            return;
        }
        elements.remove(src);
        elements.add(index, src);
    }

    public static int index(Element element) {
        int index = -1;
        List elements = element.getParent().elements();
        index = elements.indexOf(element);
        return index;
    }

    public static List<String> splitKey(String txt) {
        return DocxUtil.splitKey(txt, "\\$\\{.*?\\}");
    }

    public static List<String> splitKey(String txt, String regex) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            List keys = RegularUtil.fetch((String)txt, (String)regex);
            int size = keys.size();
            if (size > 0) {
                String key = (String)keys.get(keys.size() - 1);
                int index = txt.lastIndexOf(key);
                String t1 = txt.substring(0, index);
                String t2 = txt.substring(index + key.length());
                if (t2.length() > 0) {
                    list.addAll(DocxUtil.splitKey(t2));
                }
                list.add(key);
                if (t1.length() > 0) {
                    list.addAll(DocxUtil.splitKey(t1));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static void border(Element border, Map<String, String> styles) {
        DocxUtil.border(border, "top", styles);
        DocxUtil.border(border, "right", styles);
        DocxUtil.border(border, "bottom", styles);
        DocxUtil.border(border, "left", styles);
        DocxUtil.border(border, "insideH", styles);
        DocxUtil.border(border, "insideV", styles);
        DocxUtil.border(border, "tl2br", styles);
        DocxUtil.border(border, "tr2bl", styles);
    }

    public static void border(Element border, String side, Map<String, String> styles) {
        Element item = null;
        String width = styles.get("border-" + side + "-width");
        String style = styles.get("border-" + side + "-style");
        String color = styles.get("border-" + side + "-color");
        int dxa = DocxUtil.dxa(width);
        int line = (int)(DocxUtil.dxa2pt(dxa) * 8.0) / 4 * 4;
        if (BasicUtil.isNotEmpty((Object)width)) {
            item = DocxUtil.addElement(border, side);
            item.addAttribute("w:sz", line + "");
            item.addAttribute("w:val", style);
            item.addAttribute("w:color", color);
        }
    }

    public static void padding(Element margin, Map<String, String> styles) {
        DocxUtil.padding(margin, "top", styles);
        DocxUtil.padding(margin, "start", styles);
        DocxUtil.padding(margin, "bottom", styles);
        DocxUtil.padding(margin, "end", styles);
    }

    public static void padding(Element margin, String side, Map<String, String> styles) {
        String width = styles.get("padding-" + side);
        int dxa = DocxUtil.dxa(width);
        if (BasicUtil.isNotEmpty((Object)width)) {
            Element item = DocxUtil.addElement(margin, side);
            item.addAttribute("w:w", dxa + "");
            item.addAttribute("w:type", "dxa");
        }
    }

    public static int fontSize(String size) {
        int pt = 0;
        if (fontSizes.containsKey(size)) {
            pt = fontSizes.get(size);
        } else if (size.endsWith("px")) {
            int px = BasicUtil.parseInt((Object)size.replace("px", ""), (Integer)0);
            pt = (int)DocxUtil.px2pt(px);
        } else if (size.endsWith("pt")) {
            pt = BasicUtil.parseInt((Object)size.replace("pt", ""), (Integer)0);
        }
        return pt;
    }

    public static void font(Element pr, Map<String, String> styles) {
        String fontFamilyHint;
        String fontFamilyComplex;
        String fontFamilyhAnsi;
        String fontFamilyEast;
        String fontFamilyAscii;
        String fontFamily;
        String italics;
        String strike;
        String underline;
        int weight;
        String fontWeight;
        String fontSize = styles.get("font-size");
        if (null != fontSize) {
            int pt = 0;
            if (fontSizes.containsKey(fontSize)) {
                pt = fontSizes.get(fontSize);
            } else if (fontSize.endsWith("px")) {
                int px = BasicUtil.parseInt((Object)fontSize.replace("px", ""), (Integer)0);
                pt = (int)DocxUtil.px2pt(px);
            } else if (fontSize.endsWith("pt")) {
                pt = BasicUtil.parseInt((Object)fontSize.replace("pt", ""), (Integer)0);
            }
            if (pt > 0) {
                DocxUtil.addElement(pr, "sz", "val", pt + "");
            }
        }
        if (null != (fontWeight = styles.get("font-weight")) && fontWeight.length() > 0 && (weight = BasicUtil.parseInt((Object)fontWeight, (Integer)0).intValue()) >= 700) {
            DocxUtil.addElement(pr, "b", "val", "true");
        }
        if (null != (underline = styles.get("underline"))) {
            if (underline.equalsIgnoreCase("true") || underline.equalsIgnoreCase("single")) {
                DocxUtil.addElement(pr, "u", "val", "single");
            } else {
                DocxUtil.addElement(pr, "u", "val", underline);
            }
        }
        if (null != (strike = styles.get("strike"))) {
            if (strike.equalsIgnoreCase("true")) {
                DocxUtil.addElement(pr, "dstrike", "val", "true");
            } else if ("none".equalsIgnoreCase(strike) || "false".equalsIgnoreCase(strike)) {
                DocxUtil.addElement(pr, "dstrike", "val", "false");
            }
        }
        if (null != (italics = styles.get("italic"))) {
            if (italics.equalsIgnoreCase("true")) {
                DocxUtil.addElement(pr, "i", "val", "true");
            } else if ("none".equalsIgnoreCase(italics) || "false".equalsIgnoreCase(italics)) {
                DocxUtil.addElement(pr, "i", "val", "false");
            }
        }
        if (null != (fontFamily = styles.get("font-family"))) {
            DocxUtil.addElement(pr, "rFonts", "eastAsia", fontFamily);
        }
        if (null != (fontFamilyAscii = styles.get("font-family-ascii"))) {
            DocxUtil.addElement(pr, "rFonts", "ascii", fontFamilyAscii);
        }
        if (null != (fontFamilyEast = styles.get("font-family-east"))) {
            DocxUtil.addElement(pr, "rFonts", "eastAsia", fontFamilyEast);
        }
        if (null != (fontFamilyEast = styles.get("font-family-eastAsia"))) {
            DocxUtil.addElement(pr, "rFonts", "eastAsia", fontFamilyEast);
        }
        if (null != (fontFamilyhAnsi = styles.get("font-family-height"))) {
            DocxUtil.addElement(pr, "rFonts", "hAnsi", fontFamilyhAnsi);
        }
        if (null != (fontFamilyhAnsi = styles.get("font-family-hAnsi"))) {
            DocxUtil.addElement(pr, "rFonts", "hAnsi", fontFamilyhAnsi);
        }
        if (null != (fontFamilyComplex = styles.get("font-family-complex"))) {
            DocxUtil.addElement(pr, "rFonts", "cs", fontFamilyComplex);
        }
        if (null != (fontFamilyComplex = styles.get("font-family-cs"))) {
            DocxUtil.addElement(pr, "rFonts", "cs", fontFamilyComplex);
        }
        if (null != (fontFamilyHint = styles.get("font-family-hint"))) {
            DocxUtil.addElement(pr, "rFonts", "hint", fontFamilyHint);
        }
    }

    public static void background(Element pr, Map<String, String> styles) {
        String color = styles.get("background-color");
        if (null != color) {
            DocxUtil.addElement(pr, "shd", "color", "auto");
            DocxUtil.addElement(pr, "shd", "val", "clear");
            DocxUtil.addElement(pr, "shd", "fill", color.replace("#", ""));
        }
    }

    public static Element addElement(Element parent, String tag, String key, String value) {
        Element element = DocxUtil.addElement(parent, tag);
        DocxUtil.addAttribute(element, key, value);
        return element;
    }

    public static void addAttribute(Element element, String key, String value) {
        Attribute attribute = element.attribute(key);
        if (null == attribute) {
            attribute = element.attribute("w:" + key);
        }
        if (null != attribute) {
            element.remove(attribute);
        }
        element.addAttribute("w:" + key, value);
    }

    public static Element addElement(Element parent, String tag) {
        Element element = parent.element(tag);
        if (null == element) {
            element = parent.addElement("w:" + tag);
        }
        return element;
    }

    public static Element next(Element parent, Element child) {
        List elements;
        int index;
        Element next = null;
        while (child.getParent() != parent && null != (child = child.getParent())) {
        }
        if (null != child && (index = (elements = parent.elements()).indexOf(child)) != -1 && ++index > 0 && index < elements.size() - 1) {
            next = (Element)elements.get(index);
        }
        return next;
    }

    public static Element prev(Element parent, Element child) {
        List elements;
        int index;
        Element next = null;
        while (child.getParent() != parent && null != (child = child.getParent())) {
        }
        if (null != child && (index = (elements = parent.elements()).indexOf(child)) != -1 && --index > 0 && index < elements.size() - 1) {
            next = (Element)elements.get(index);
        }
        return next;
    }

    public static String text(Element element) {
        String text = "";
        Iterator nodes = element.nodeIterator();
        while (nodes.hasNext()) {
            Node node = (Node)nodes.next();
            short type = node.getNodeType();
            if (type == 3) {
                text = text + node.getText().trim();
                continue;
            }
            text = text + DocxUtil.text((Element)node);
        }
        return text.trim();
    }

    public static boolean isBlock(String text) {
        if (null != text) {
            List styles = RegularUtil.cuts((String)text, (boolean)true, (String[])new String[]{"<style", ">", "</style>"});
            for (String style : styles) {
                text = text.replace(style, "");
            }
            if ((text = text.trim()).startsWith("<div") || text.startsWith("<ul") || text.startsWith("<ol") || text.startsWith("<table")) {
                return true;
            }
        }
        return false;
    }

    public static List<Element> betweens(Element bookmark, String ... tags) {
        String id = bookmark.attributeValue("id");
        Element end = null;
        List ends = bookmark.getParent().elements("bookmarkEnd");
        for (Element item : ends) {
            if (!id.equals(item.attributeValue("id"))) continue;
            end = item;
            break;
        }
        return DomUtil.betweens((Element)bookmark, end, (String[])tags);
    }

    public static Element bookmark(Element parent, String name) {
        Element start = DomUtil.element((Element)parent, (String)"bookmarkStart", (String)"name", (String)name);
        return start;
    }

    public static Element pr(Element element, String styles) {
        return DocxUtil.pr(element, StyleParser.parse((String)styles));
    }

    public static Element pr(Element element, Map<String, String> styles) {
        if (null == styles) {
            styles = new HashMap<String, String>();
        }
        String name = element.getName();
        String prName = name + "Pr";
        Element pr = DocxUtil.addElement(element, prName);
        if ("p".equalsIgnoreCase(name)) {
            Element numPr;
            for (String sk : styles.keySet()) {
                Element numPr2;
                String sv = styles.get(sk);
                if (BasicUtil.isEmpty((Object)sv)) continue;
                if (sk.equalsIgnoreCase("list-style-type")) {
                    DocxUtil.addElement(pr, "pStyle", "val", sv);
                    continue;
                }
                if (sk.equalsIgnoreCase("list-lvl")) {
                    numPr2 = DocxUtil.addElement(pr, "numPr");
                    DocxUtil.addElement(numPr2, "ilvl", "val", sv + "");
                    continue;
                }
                if (sk.equalsIgnoreCase("numFmt")) {
                    numPr2 = DocxUtil.addElement(pr, "numPr");
                    DocxUtil.addElement(numPr2, "numFmt", "val", sv + "");
                    continue;
                }
                if ("text-align".equalsIgnoreCase(sk)) {
                    DocxUtil.addElement(pr, "jc", "val", sv);
                    continue;
                }
                if (sk.equalsIgnoreCase("margin-left")) {
                    DocxUtil.addElement(pr, "ind", "left", DocxUtil.dxa(sv) + "");
                    continue;
                }
                if (sk.equalsIgnoreCase("margin-right")) {
                    DocxUtil.addElement(pr, "ind", "right", DocxUtil.dxa(sv) + "");
                    continue;
                }
                if (sk.equalsIgnoreCase("margin-top")) {
                    DocxUtil.addElement(pr, "spacing", "before", DocxUtil.dxa(sv) + "");
                    continue;
                }
                if (sk.equalsIgnoreCase("margin-bottom")) {
                    DocxUtil.addElement(pr, "spacing", "after", DocxUtil.dxa(sv) + "");
                    continue;
                }
                if (sk.equalsIgnoreCase("padding-left")) {
                    DocxUtil.addElement(pr, "ind", "left", DocxUtil.dxa(sv) + "");
                    continue;
                }
                if (sk.equalsIgnoreCase("padding-right")) {
                    DocxUtil.addElement(pr, "ind", "right", DocxUtil.dxa(sv) + "");
                    continue;
                }
                if (sk.equalsIgnoreCase("padding-top")) {
                    DocxUtil.addElement(pr, "spacing", "before", DocxUtil.dxa(sv) + "");
                    continue;
                }
                if (sk.equalsIgnoreCase("padding-bottom")) {
                    DocxUtil.addElement(pr, "spacing", "after", DocxUtil.dxa(sv) + "");
                    continue;
                }
                if (sk.equalsIgnoreCase("text-indent")) {
                    DocxUtil.addElement(pr, "ind", "firstLine", DocxUtil.dxa(sv) + "");
                    continue;
                }
                if (!sk.equalsIgnoreCase("line-height")) continue;
                DocxUtil.addElement(pr, "spacing", "line", DocxUtil.dxa(sv) + "");
            }
            if (styles.containsKey("list-style-num")) {
                numPr = DocxUtil.addElement(pr, "numPr");
                DocxUtil.addElement(numPr, "numId", "val", styles.get("list-style-num"));
            } else if (styles.containsKey("list-num")) {
                numPr = DocxUtil.addElement(pr, "numPr");
                DocxUtil.addElement(numPr, "numId", "val", styles.get("list-num"));
            }
            if (styles.containsKey("page-size-orient")) {
                String orient = styles.get("page-size-orient");
                if (!"landscape".equalsIgnoreCase(orient)) {
                    orient = "portrait";
                }
                DocxUtil.setOrient(pr, orient, styles);
            }
            Element border = DocxUtil.addElement(pr, "bdr");
            DocxUtil.border(border, styles);
        } else if ("r".equalsIgnoreCase(name)) {
            for (String sk : styles.keySet()) {
                String sv = styles.get(sk);
                if (BasicUtil.isEmpty((Object)sv)) continue;
                if (sk.equalsIgnoreCase("color")) {
                    DocxUtil.addElement(pr, "color", "val", sv.replace("#", ""));
                    continue;
                }
                if (sk.equalsIgnoreCase("background-color")) {
                    DocxUtil.addElement(pr, "highlight", "val", sv.replace("#", ""));
                    continue;
                }
                if (!sk.equalsIgnoreCase("vertical-align")) continue;
                DocxUtil.addElement(pr, "vertAlign", "val", sv);
            }
            Element border = DocxUtil.addElement(pr, "bdr");
            DocxUtil.border(border, styles);
            DocxUtil.font(pr, styles);
        } else if ("tbl".equalsIgnoreCase(name)) {
            Element mar = DocxUtil.addElement(pr, "tblCellMar");
            for (String sk : styles.keySet()) {
                String sv = styles.get(sk);
                if (BasicUtil.isEmpty((Object)sv)) continue;
                if (sk.equalsIgnoreCase("width")) {
                    DocxUtil.addElement(pr, "tblW", "w", DocxUtil.dxa(sv) + "");
                    DocxUtil.addElement(pr, "tblW", "type", DocxUtil.widthType(sv));
                    continue;
                }
                if (sk.equalsIgnoreCase("color")) continue;
                if (sk.equalsIgnoreCase("margin-left")) {
                    DocxUtil.addElement(pr, "tblInd", "w", DocxUtil.dxa(sv) + "");
                    DocxUtil.addElement(pr, "tblInd", "type", "dxa");
                    continue;
                }
                if (sk.equalsIgnoreCase("padding-left")) {
                    DocxUtil.addElement(mar, "left", "w", DocxUtil.dxa(sv) + "");
                    DocxUtil.addElement(mar, "left", "type", "dxa");
                    continue;
                }
                if (sk.equalsIgnoreCase("padding-right")) {
                    DocxUtil.addElement(mar, "right", "w", DocxUtil.dxa(sv) + "");
                    DocxUtil.addElement(mar, "right", "type", "dxa");
                    DocxUtil.addElement(mar, "end", "w", DocxUtil.dxa(sv) + "");
                    DocxUtil.addElement(mar, "end", "type", "dxa");
                    continue;
                }
                if (sk.equalsIgnoreCase("padding-top")) {
                    DocxUtil.addElement(mar, "top", "w", DocxUtil.dxa(sv) + "");
                    DocxUtil.addElement(mar, "top", "type", "dxa");
                    continue;
                }
                if (!sk.equalsIgnoreCase("padding-bottom")) continue;
                DocxUtil.addElement(mar, "bottom", "w", DocxUtil.dxa(sv) + "");
                DocxUtil.addElement(mar, "bottom", "type", "dxa");
            }
            Element border = DocxUtil.addElement(pr, "tblBorders");
            DocxUtil.border(border, styles);
            DocxUtil.background(pr, styles);
        } else if ("tr".equalsIgnoreCase(name)) {
            for (String sk : styles.keySet()) {
                String sv = styles.get(sk);
                if (BasicUtil.isEmpty((Object)sv)) continue;
                if ("repeat-header".equalsIgnoreCase(sk)) {
                    DocxUtil.addElement(pr, "tblHeader", "val", "true");
                    continue;
                }
                if ("min-height".equalsIgnoreCase(sk)) {
                    DocxUtil.addElement(pr, "trHeight", "hRule", "atLeast");
                    DocxUtil.addElement(pr, "trHeight", "val", (int)DocxUtil.dxa2pt(DocxUtil.dxa(sv)) * 20 + "");
                    continue;
                }
                if (!"height".equalsIgnoreCase(sk)) continue;
                DocxUtil.addElement(pr, "trHeight", "hRule", "exact");
                DocxUtil.addElement(pr, "trHeight", "val", (int)DocxUtil.dxa2pt(DocxUtil.dxa(sv)) * 20 + "");
            }
        } else if ("tc".equalsIgnoreCase(name)) {
            for (String sk : styles.keySet()) {
                String sv = styles.get(sk);
                if (BasicUtil.isEmpty((Object)sv)) continue;
                Element mar = DocxUtil.addElement(pr, "tcMar");
                if ("vertical-align".equalsIgnoreCase(sk)) {
                    DocxUtil.addElement(pr, "vAlign", "val", sv);
                    continue;
                }
                if ("text-align".equalsIgnoreCase(sk)) {
                    DocxUtil.addElement(pr, "jc", "val", sv);
                    continue;
                }
                if (sk.equalsIgnoreCase("white-space")) {
                    DocxUtil.addElement(pr, "noWrap");
                    continue;
                }
                if (sk.equalsIgnoreCase("width")) {
                    DocxUtil.addElement(pr, "tcW", "w", DocxUtil.dxa(sv) + "");
                    DocxUtil.addElement(pr, "tcW", "type", DocxUtil.widthType(sv));
                    continue;
                }
                if (sk.equalsIgnoreCase("padding-left")) {
                    DocxUtil.addElement(mar, "left", "w", DocxUtil.dxa(sv) + "");
                    DocxUtil.addElement(mar, "left", "type", "dxa");
                    continue;
                }
                if (sk.equalsIgnoreCase("padding-right")) {
                    DocxUtil.addElement(mar, "right", "w", DocxUtil.dxa(sv) + "");
                    DocxUtil.addElement(mar, "right", "type", "dxa");
                    DocxUtil.addElement(mar, "end", "w", DocxUtil.dxa(sv) + "");
                    DocxUtil.addElement(mar, "end", "type", "dxa");
                    continue;
                }
                if (sk.equalsIgnoreCase("padding-top")) {
                    DocxUtil.addElement(mar, "top", "w", DocxUtil.dxa(sv) + "");
                    DocxUtil.addElement(mar, "top", "type", "dxa");
                    continue;
                }
                if (!sk.equalsIgnoreCase("padding-bottom")) continue;
                DocxUtil.addElement(mar, "bottom", "w", DocxUtil.dxa(sv) + "");
                DocxUtil.addElement(mar, "bottom", "type", "dxa");
            }
            Element padding = DocxUtil.addElement(pr, "tcMar");
            DocxUtil.padding(padding, styles);
            Element border = DocxUtil.addElement(pr, "tcBorders");
            DocxUtil.border(border, styles);
            DocxUtil.background(pr, styles);
        }
        if (pr.elements().size() == 0) {
            element.remove(pr);
        }
        return pr;
    }

    public static void setOrient(Element pr, String orient, Map<String, String> styles) {
        String w = styles.get("page-size-w");
        String h = styles.get("page-size-h");
        String top = styles.get("page-margin-top");
        String right = styles.get("page-margin-right");
        String bottom = styles.get("page-margin-bottom");
        String left = styles.get("page-margin-left");
        String header = styles.get("page-margin-left");
        String footer = styles.get("page-margin-left");
        header = ((String)BasicUtil.evl((Object[])new String[]{header, "851"})).toString();
        footer = ((String)BasicUtil.evl((Object[])new String[]{footer, "992"})).toString();
        if ("portrait".equalsIgnoreCase(orient)) {
            w = ((String)BasicUtil.evl((Object[])new String[]{w, "11906"})).toString();
            h = ((String)BasicUtil.evl((Object[])new String[]{h, "16838"})).toString();
            top = ((String)BasicUtil.evl((Object[])new String[]{top, "1440"})).toString();
            right = ((String)BasicUtil.evl((Object[])new String[]{right, "1134"})).toString();
            bottom = ((String)BasicUtil.evl((Object[])new String[]{bottom, "1440"})).toString();
            left = ((String)BasicUtil.evl((Object[])new String[]{left, "1531"})).toString();
        } else {
            w = ((String)BasicUtil.evl((Object[])new String[]{w, "16838"})).toString();
            h = ((String)BasicUtil.evl((Object[])new String[]{h, "11906"})).toString();
            top = ((String)BasicUtil.evl((Object[])new String[]{top, "1531"})).toString();
            right = ((String)BasicUtil.evl((Object[])new String[]{right, "1134"})).toString();
            bottom = ((String)BasicUtil.evl((Object[])new String[]{bottom, "1440"})).toString();
            left = ((String)BasicUtil.evl((Object[])new String[]{left, "1531"})).toString();
        }
        Element sectPr = DocxUtil.addElement(pr, "sectPr");
        DocxUtil.addElement(sectPr, "pgSz", "w", w);
        DocxUtil.addElement(sectPr, "pgSz", "h", h);
        DocxUtil.addElement(sectPr, "pgSz", "orient", orient);
        DocxUtil.addElement(sectPr, "pgMar", "top", top);
        DocxUtil.addElement(sectPr, "pgMar", "right", right);
        DocxUtil.addElement(sectPr, "pgMar", "bottom", bottom);
        DocxUtil.addElement(sectPr, "pgMar", "left", left);
        DocxUtil.addElement(sectPr, "pgMar", "header", header);
        DocxUtil.addElement(sectPr, "pgMar", "footer", footer);
    }

    public static void removeAttribute(Element element, String attribute) {
        Attribute att = element.attribute("w:" + attribute);
        if (null != att) {
            element.remove(att);
        }
    }

    public static void removeContent(Element parent) {
        List ts = DomUtil.elements((Element)parent, (String)"t");
        for (Object t : ts) {
            t.getParent().remove((Element)t);
        }
        List imgs = DomUtil.elements((Element)parent, (String)"drawing");
        for (Element img : imgs) {
            img.getParent().remove(img);
        }
        List brs = DomUtil.elements((Element)parent, (String)"br");
        for (Element br : brs) {
            br.getParent().remove(br);
        }
    }

    public static void removeElement(Element parent, String element) {
        List elements = DomUtil.elements((Element)parent, (String)element);
        for (Element item : elements) {
            item.getParent().remove(item);
        }
    }

    public static void replace(Element src, Map<String, String> replaces) {
        List ts = DomUtil.elements((Element)src, (String)"t");
        for (Element t : ts) {
            String txt = t.getTextTrim();
            List<String> flags = DocxUtil.splitKey(txt);
            if (flags.size() == 0) continue;
            Collections.reverse(flags);
            Element r = t.getParent();
            List elements = r.elements();
            int index = elements.indexOf(t);
            for (int i = 0; i < flags.size(); ++i) {
                String flag;
                String content = flag = flags.get(i);
                String key = null;
                if (flag.startsWith("${") && flag.endsWith("}")) {
                    key = flag.substring(2, flag.length() - 1);
                    content = replaces.get(key);
                    if (null == content) {
                        content = replaces.get(flag);
                    }
                } else if (flag.startsWith("{") && flag.endsWith("}") && null == (content = replaces.get(key = flag.substring(1, flag.length() - 1)))) {
                    content = replaces.get(flag);
                }
                txt = txt.replace(flag, content);
            }
            t.setText(txt);
        }
    }

    public static int dxa(String src) {
        int dxa = 0;
        if (null != src) {
            if ((src = src.trim().toLowerCase()).endsWith("px")) {
                src = src.replace("px", "");
                dxa = DocxUtil.px2dxa(BasicUtil.parseInt((Object)src, (Integer)0));
            } else if (src.endsWith("cm")) {
                src = src.replace("cm", "");
                dxa = DocxUtil.cm2dxa(BasicUtil.parseDouble((Object)src, (Double)0.0));
            } else if (src.endsWith("\u5398\u7c73")) {
                src = src.replace("\u5398\u7c73", "");
                dxa = DocxUtil.cm2dxa(BasicUtil.parseDouble((Object)src, (Double)0.0));
            } else if (src.endsWith("pt")) {
                src = src.replace("pt", "");
                dxa = DocxUtil.pt2dxa(BasicUtil.parseInt((Object)src, (Integer)0).intValue());
            } else {
                dxa = src.endsWith("%") ? (int)(BasicUtil.parseDouble((Object)src.replace("%", ""), (Double)0.0) / 100.0 * 5000.0) : (src.endsWith("dxa") ? BasicUtil.parseInt((Object)src.replace("dxa", ""), (Integer)0) : DocxUtil.px2dxa(BasicUtil.parseInt((Object)src, (Integer)0)));
            }
        }
        return dxa;
    }

    public static String widthType(String width) {
        if (null != width && width.trim().endsWith("%")) {
            return "pct";
        }
        if (null != width && width.trim().endsWith("dxa")) {
            return "dxa";
        }
        return "dxa";
    }

    public static int px2dxa(int px) {
        return DocxUtil.pt2dxa(DocxUtil.px2pt(px));
    }

    public static int px2dxa(double px) {
        return DocxUtil.pt2dxa(DocxUtil.px2pt(px));
    }

    public static int pt2dxa(double pt) {
        return (int)(pt * 20.0);
    }

    public static double dxa2pt(double dxa) {
        return dxa / 20.0;
    }

    public static double dxa2px(double dxa) {
        return DocxUtil.pt2px(DocxUtil.dxa2pt(dxa));
    }

    public static int px2emu(int px) {
        return px * EMU_PER_PX;
    }

    public static double dxa2emu(double dxa) {
        return dxa * (double)EMU_PER_DXA;
    }

    public static double emu2px(double emu) {
        return emu / (double)EMU_PER_PX;
    }

    public static double pt2px(double pt) {
        return pt / PT_PER_PX;
    }

    public static double in2px(double in) {
        return DocxUtil.in2pt(in) * PT_PER_PX;
    }

    public static double px2in(double px) {
        return DocxUtil.pt2in(DocxUtil.px2pt(px));
    }

    public static double cm2px(double cm) {
        return DocxUtil.cm2pt(cm) * PT_PER_PX;
    }

    public static double px2cm(double px) {
        return DocxUtil.pt2cm(DocxUtil.px2pt(px));
    }

    public static double mm2px(double mm) {
        return DocxUtil.mm2pt(mm) * PT_PER_PX;
    }

    public static double px2mm(double px) {
        return DocxUtil.pt2mm(DocxUtil.px2pt(px));
    }

    public static double pt2in(double pt) {
        return pt / (double)IN_PER_PT;
    }

    public static double pt2mm(double mm) {
        return mm / MM_PER_PT;
    }

    public static double pt2cm(double in) {
        return in / CM_PER_PT;
    }

    public static double px2pt(double px) {
        return px * PT_PER_PX;
    }

    public static double in2pt(double in) {
        return in * (double)IN_PER_PT;
    }

    public static double mm2pt(double mm) {
        return mm * MM_PER_PT;
    }

    public static double cm2pt(double cm) {
        return cm * CM_PER_PT;
    }

    public static int cm2dxa(double cm) {
        return DocxUtil.px2dxa(DocxUtil.cm2px(cm));
    }
}

