/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.office.docx.entity;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.handler.Uploader;
import org.anyline.office.docx.entity.WDocument;
import org.anyline.office.docx.util.DocxUtil;
import org.anyline.util.BasicUtil;
import org.anyline.util.DomUtil;
import org.dom4j.Element;

public class Welement {
    protected WDocument root;
    protected Element src;

    public void reload() {
    }

    public void replace(Map<String, String> replaces) {
        this.root.replace(this.src, replaces);
    }

    public void removeContent() {
        DocxUtil.removeContent(this.src);
    }

    public WDocument getDoc() {
        return this.root;
    }

    public void setDoc(WDocument doc) {
        this.root = doc;
    }

    public Element getSrc() {
        return this.src;
    }

    public void setSrc(Element src) {
        this.src = src;
    }

    public List<Element> bookmarks() {
        List bookmarks = DomUtil.elements((Element)this.src, (String)"bookmarkStart");
        return bookmarks;
    }

    public List<String> placeholders() {
        return this.placeholders("\\$\\{.*?\\}");
    }

    public List<Element> placeholders(boolean element) {
        return this.placeholders(element, "\\$\\{.*?\\}");
    }

    public List<Element> placeholders(boolean element, String regex) {
        ArrayList<Element> list = new ArrayList<Element>();
        try {
            List ts = DomUtil.elements((Element)this.src, (String)"t");
            for (Element t : ts) {
                String txt = t.getTextTrim();
                List<String> flags = DocxUtil.splitKey(txt, regex);
                if (flags.isEmpty()) continue;
                list.add(t);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public List<String> placeholders(String regex) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            List ts = DomUtil.elements((Element)this.src, (String)"t");
            for (Element t : ts) {
                String txt = t.getTextTrim();
                List<String> flags = DocxUtil.splitKey(txt, regex);
                if (flags.isEmpty()) continue;
                for (String flag : flags) {
                    String key = null;
                    if (!flag.startsWith("${") || !flag.endsWith("}")) continue;
                    key = flag.substring(2, flag.length() - 1);
                    list.add(key);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public List<String> getTextList() {
        ArrayList<String> texts = new ArrayList<String>();
        List ts = DomUtil.elements((Element)this.src, (String)"t");
        for (Element t : ts) {
            texts.add(t.getTextTrim());
        }
        return texts;
    }

    public String getTexts() {
        List<String> list = this.getTextList();
        StringBuilder builder = new StringBuilder();
        for (String item : list) {
            if (null == item) continue;
            builder.append(item);
        }
        return builder.toString();
    }

    public String getText() {
        Element t = this.src.element("t");
        if (null != t) {
            return t.getText();
        }
        return null;
    }

    protected int index(Integer index, int size) {
        if (null == index) {
            return 0;
        }
        return BasicUtil.index((int)index, (int)size);
    }

    public Element child(Element parent, String ... tags) {
        if (null != tags) {
            Element element = parent;
            for (String tag : tags) {
                if (null == element) continue;
                element = element.element(tag);
            }
            return element;
        }
        return null;
    }

    protected void t(StringBuilder builder, int lvl) {
        for (int i = 0; i < lvl; ++i) {
            builder.append("\t");
        }
    }

    public LinkedHashMap<String, String> styles() {
        LinkedHashMap<String, String> styles = new LinkedHashMap<String, String>();
        return styles;
    }

    public LinkedHashMap<String, String> styles(StringBuilder builder) {
        LinkedHashMap<String, String> styles = this.styles();
        if (!styles.isEmpty()) {
            builder.append(" style = '");
            for (String key : styles.keySet()) {
                builder.append(key).append(":").append(styles.get(key)).append(";");
            }
            builder.append("'");
        }
        return styles;
    }

    public String color(String color) {
        return color;
    }

    public String html() {
        return this.html(null, 0);
    }

    public String html(int lvl) {
        return this.html(null, lvl);
    }

    public String html(Uploader uploader) {
        return this.html(uploader, 0);
    }

    public String html(Uploader uploader, int lvl) {
        return "";
    }
}

