/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.office.docx.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.anyline.office.docx.entity.WDocument;
import org.anyline.office.docx.entity.Wp;
import org.anyline.office.docx.entity.Wtable;
import org.anyline.office.docx.entity.Wtr;
import org.anyline.office.docx.util.DocxUtil;
import org.anyline.util.BasicUtil;
import org.anyline.util.DomUtil;
import org.anyline.util.StyleParser;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class Wtc {
    private WDocument doc;
    private Element src;
    private Wtr parent;
    private List<Wp> wps = new ArrayList<Wp>();
    private String widthUnit = "px";

    public Wtc(WDocument doc, Wtr parent, Element src) {
        this.doc = doc;
        this.src = src;
        this.parent = parent;
        this.load();
    }

    public Wtc reload() {
        this.load();
        return this;
    }

    private Wtc load() {
        this.wps.clear();
        List ps = this.src.elements("p");
        for (Element p : ps) {
            Wp wp = new Wp(this.doc, p);
            this.wps.add(wp);
        }
        return this;
    }

    public WDocument getDoc() {
        return this.doc;
    }

    public void setDoc(WDocument doc) {
        this.doc = doc;
    }

    public Element getSrc() {
        return this.src;
    }

    public void setSrc(Element src) {
        this.src = src;
    }

    public List<String> getBookmarks() {
        ArrayList<String> list = new ArrayList<String>();
        List marks = DomUtil.elements((Element)this.src, (String)"bookmarkStart");
        for (Element mark : marks) {
            list.add(mark.attributeValue("name"));
        }
        return list;
    }

    public String getBookmark() {
        Element mark = DomUtil.element((Element)this.src, (String)"bookmarkStart");
        if (null != mark) {
            return mark.attributeValue("name");
        }
        return null;
    }

    public Wtc setBorder(String side, String style) {
        return this;
    }

    public String getWidthUnit() {
        return this.widthUnit;
    }

    public void setWidthUnit(String widthUnit) {
        this.widthUnit = widthUnit;
    }

    public int getColspan() {
        Element gridSpan;
        Element tcPr = this.src.element("tcPr");
        if (null != tcPr && null != (gridSpan = tcPr.element("gridSpan"))) {
            return BasicUtil.parseInt((Object)gridSpan.attributeValue("val"), (int)1);
        }
        return 1;
    }

    public int getRowspan() {
        String val;
        Element vMerge;
        Element tcPr = this.src.element("tcPr");
        if (null != tcPr && null != (vMerge = tcPr.element("vMerge")) && !"restart".equalsIgnoreCase(val = vMerge.attributeValue("val"))) {
            return -1;
        }
        return 1;
    }

    public Wtc left() {
        Wtc left = null;
        List<Wtc> tcs = this.parent.getTcs();
        int index = tcs.indexOf(this);
        if (index > 0) {
            left = tcs.get(index - 1);
        }
        return left;
    }

    public Wtc right() {
        Wtc right = null;
        List<Wtc> tcs = this.parent.getTcs();
        int index = tcs.indexOf(this);
        if (index < tcs.size() - 1) {
            right = tcs.get(index + 1);
        }
        return right;
    }

    public Wtc bottom() {
        Wtc bottom = null;
        Wtable table = this.parent.getParent();
        List<Wtr> trs = table.getTrs();
        int y = trs.indexOf(this.parent);
        if (y < trs.size() - 1) {
            Wtr tr = trs.get(y + 1);
            int x = this.parent.getTcs().indexOf(this);
            bottom = tr.getTc(x);
        }
        return bottom;
    }

    public Wtc top() {
        Wtc top = null;
        Wtable table = this.parent.getParent();
        List<Wtr> trs = table.getTrs();
        int y = trs.indexOf(this.parent);
        if (y < trs.size() - 1 && y > 0) {
            Wtr tr = trs.get(y - 1);
            int x = this.parent.getTcs().indexOf(this);
            top = tr.getTc(x);
        }
        return top;
    }

    public Wtc removeLeftBorder() {
        this.removeBorder(this.src, "left");
        Wtc left = this.left();
        if (null != left) {
            this.removeBorder(left.getSrc(), "right");
        }
        return this;
    }

    public Wtc removeRightBorder() {
        this.removeBorder(this.src, "right");
        Wtc right = this.right();
        if (null != right) {
            this.removeBorder(right.getSrc(), "left");
        }
        return this;
    }

    public Wtc removeTopBorder() {
        this.removeBorder(this.src, "top");
        Wtc top = this.top();
        if (null != top) {
            this.removeBorder(top.getSrc(), "bottom");
        }
        return this;
    }

    public Wtc removeBottomBorder() {
        this.removeBorder(this.src, "bottom");
        Wtc bottom = this.bottom();
        if (null != bottom) {
            this.removeBorder(bottom.getSrc(), "top");
        }
        return this;
    }

    public Wtc removeTl2brBorder() {
        this.removeBorder(this.src, "tl2br");
        return this;
    }

    public Wtc removeTr2blBorder() {
        this.removeBorder(this.src, "tr2bl");
        return this;
    }

    private void removeBorder(Element tc, String side) {
        Element tcPr = DocxUtil.addElement(tc, "tcPr");
        Element borders = DocxUtil.addElement(tcPr, "tcBorders");
        Element border = DocxUtil.addElement(borders, side);
        border.addAttribute("w:val", "nil");
        DocxUtil.removeAttribute(border, "sz");
        DocxUtil.removeAttribute(border, "space");
        DocxUtil.removeAttribute(border, "color");
    }

    public Wtc removeBorder() {
        this.removeLeftBorder();
        this.removeRightBorder();
        this.removeTopBorder();
        this.removeBottomBorder();
        this.removeTl2brBorder();
        this.removeTr2blBorder();
        return this;
    }

    public Wtc setBorder() {
        this.setLeftBorder();
        this.setRightBorder();
        this.setTopBorder();
        this.setBottomBorder();
        return this;
    }

    public Wtc setBorder(int size, String color, String style) {
        this.setLeftBorder(size, color, style);
        this.setRightBorder(size, color, style);
        this.setTopBorder(size, color, style);
        this.setBottomBorder(size, color, style);
        this.setTl2brBorder(size, color, style);
        this.setTr2blBorder(size, color, style);
        return this;
    }

    public Wtc setLeftBorder() {
        this.setBorder(this.src, "left", 4, "auto", "single");
        return this;
    }

    public Wtc setRightBorder() {
        this.setBorder(this.src, "right", 4, "auto", "single");
        return this;
    }

    public Wtc setTopBorder() {
        this.setBorder(this.src, "top", 4, "auto", "single");
        return this;
    }

    public Wtc setBottomBorder() {
        this.setBorder(this.src, "bottom", 4, "auto", "single");
        return this;
    }

    public Wtc setTl2brBorder() {
        this.setBorder(this.src, "tl2br", 4, "auto", "single");
        return this;
    }

    public Wtc setTl2brBorder(String top, String bottom) {
        this.setBorder(this.src, "tl2br", 4, "auto", "single");
        String html = "<div style='text-align:right;'>" + top + "</div><div style='text-align:left;'>" + bottom + "</div>";
        this.setHtml(html);
        return this;
    }

    public Wtc setTr2blBorder() {
        this.setBorder(this.src, "tr2bl", 4, "auto", "single");
        return this;
    }

    public Wtc setTr2blBorder(String top, String bottom) {
        this.setBorder(this.src, "tr2bl", 4, "auto", "single");
        String html = "<div style='text-align:left;'>" + top + "</div><div style='text-align:right;'>" + bottom + "</div>";
        this.setHtml(html);
        return this;
    }

    public Wtc setLeftBorder(int size, String color, String style) {
        this.setBorder(this.src, "left", size, color, style);
        return this;
    }

    public Wtc setRightBorder(int size, String color, String style) {
        this.setBorder(this.src, "right", size, color, style);
        return this;
    }

    public Wtc setTopBorder(int size, String color, String style) {
        this.setBorder(this.src, "top", size, color, style);
        return this;
    }

    public Wtc setBottomBorder(int size, String color, String style) {
        this.setBorder(this.src, "bottom", size, color, style);
        return this;
    }

    public Wtc setTl2brBorder(int size, String color, String style) {
        this.setBorder(this.src, "tl2br", size, color, style);
        return this;
    }

    public Wtc setTr2blBorder(int size, String color, String style) {
        this.setBorder(this.src, "tr2bl", size, color, style);
        return this;
    }

    private void setBorder(Element tc, String side, int size, String color, String style) {
        Element tcPr = DocxUtil.addElement(tc, "tcPr");
        Element borders = DocxUtil.addElement(tcPr, "tcBorders");
        Element border = DocxUtil.addElement(borders, side);
        border.addAttribute("w:val", style);
        border.addAttribute("w:sz", size + "");
        border.addAttribute("w:color", color.replace("#", ""));
        border.addAttribute("w:space", "0");
    }

    public Wtc setBottomPadding(String padding) {
        return this.setPadding(this.src, "bottom", padding);
    }

    public Wtc setBottomPadding(int padding) {
        return this.setPadding(this.src, "bottom", padding);
    }

    public Wtc setBottomPadding(double padding) {
        return this.setPadding(this.src, "bottom", padding);
    }

    public Wtc setTopPadding(String padding) {
        return this.setPadding(this.src, "top", padding);
    }

    public Wtc setTopPadding(int padding) {
        return this.setPadding(this.src, "top", padding);
    }

    public Wtc setTopPadding(double padding) {
        return this.setPadding(this.src, "top", padding);
    }

    public Wtc setRightPadding(String padding) {
        return this.setPadding(this.src, "right", padding);
    }

    public Wtc setRightPadding(int padding) {
        return this.setPadding(this.src, "right", padding);
    }

    public Wtc setRightPadding(double padding) {
        return this.setPadding(this.src, "right", padding);
    }

    public Wtc setLeftPadding(String padding) {
        return this.setPadding(this.src, "left", padding);
    }

    public Wtc setLeftPadding(int padding) {
        return this.setPadding(this.src, "left", padding);
    }

    public Wtc setLeftPadding(double padding) {
        return this.setPadding(this.src, "left", padding);
    }

    public Wtc setPadding(String side, String padding) {
        return this.setPadding(this.src, side, padding);
    }

    public Wtc setPadding(String side, int padding) {
        return this.setPadding(this.src, side, padding);
    }

    public Wtc setPadding(String side, double padding) {
        return this.setPadding(this.src, side, padding);
    }

    public Wtc setPadding(String padding) {
        this.setPadding(this.src, "top", padding);
        this.setPadding(this.src, "bottom", padding);
        this.setPadding(this.src, "right", padding);
        this.setPadding(this.src, "left", padding);
        return this;
    }

    public Wtc setPadding(int padding) {
        return this.setPadding(padding + this.widthUnit);
    }

    public Wtc setPadding(double padding) {
        return this.setPadding(padding + this.widthUnit);
    }

    private Wtc setPadding(Element tc, String side, int padding) {
        return this.setPadding(tc, side, padding + this.widthUnit);
    }

    private Wtc setPadding(Element tc, String side, double padding) {
        return this.setPadding(tc, side, padding + this.widthUnit);
    }

    private Wtc setPadding(Element tc, String side, String padding) {
        Element pr = DocxUtil.addElement(tc, "tcPr");
        Element mar = DocxUtil.addElement(pr, "tcMar");
        DocxUtil.addElement(mar, side, "w", DocxUtil.dxa(padding) + "");
        DocxUtil.addElement(mar, side, "type", "dxa");
        return this;
    }

    public Wtc setColor(String color) {
        for (Wp wp : this.wps) {
            wp.setColor(color);
        }
        return this;
    }

    public Wtc setFont(String size, String eastAsia, String ascii, String hint) {
        for (Wp wp : this.wps) {
            wp.setFont(size, eastAsia, ascii, hint);
        }
        return this;
    }

    public Wtc setFontSize(String size) {
        for (Wp wp : this.wps) {
            wp.setFontSize(size);
        }
        return this;
    }

    public Wtc setFontFamily(String font) {
        for (Wp wp : this.wps) {
            wp.setFontFamily(font);
        }
        return this;
    }

    public Wtc setWidth(String width) {
        Element pr = DocxUtil.addElement(this.src, "tcPr");
        DocxUtil.addElement(pr, "tcW", "w", DocxUtil.dxa(width) + "");
        DocxUtil.addElement(pr, "tcW", "type", DocxUtil.widthType(width));
        return this;
    }

    public Wtc setWidth(int width) {
        return this.setWidth(this.widthUnit + this.widthUnit);
    }

    public Wtc setWidth(double width) {
        return this.setWidth(this.widthUnit + this.widthUnit);
    }

    public Wtc setAlign(String align) {
        Element pr = DocxUtil.addElement(this.src, "tcPr");
        DocxUtil.addElement(pr, "jc", "val", align);
        for (Wp wp : this.wps) {
            wp.setAlign(align);
        }
        return this;
    }

    public Wtc setVerticalAlign(String align) {
        Element pr = DocxUtil.addElement(this.src, "tcPr");
        if (align.equals("middle")) {
            align = "center";
        }
        DocxUtil.addElement(pr, "vAlign", "val", align);
        return this;
    }

    public Wtc setBackgroundColor(String color) {
        Element pr = DocxUtil.addElement(this.src, "tcPr");
        DocxUtil.addElement(pr, "shd", "color", "auto");
        DocxUtil.addElement(pr, "shd", "val", "clear");
        DocxUtil.addElement(pr, "shd", "fill", color.replace("#", ""));
        for (Wp wp : this.wps) {
        }
        return this;
    }

    public Wtc removeStyle() {
        Element pr = this.src.element("tcPr");
        if (null != pr) {
            this.src.remove(pr);
        }
        for (Wp wp : this.wps) {
            wp.removeStyle();
        }
        return this;
    }

    public Wtc removeBackgroundColor() {
        DocxUtil.removeElement(this.src, "shd");
        return this;
    }

    public Wtc removeColor() {
        DocxUtil.removeElement(this.src, "color");
        return this;
    }

    public Wtc setBold(boolean bold) {
        for (Wp wp : this.wps) {
            wp.setBold(bold);
        }
        return this;
    }

    public Wtc setBold() {
        this.setBold(true);
        return this;
    }

    public Wtc setUnderline(boolean underline) {
        for (Wp wp : this.wps) {
            wp.setUnderline(underline);
        }
        return this;
    }

    public Wtc setUnderline() {
        this.setUnderline(true);
        return this;
    }

    public Wtc setStrike(boolean strike) {
        for (Wp wp : this.wps) {
            wp.setStrike(strike);
        }
        return this;
    }

    public Wtc setStrike() {
        this.setStrike(true);
        return this;
    }

    public Wtc setItalic(boolean italic) {
        for (Wp wp : this.wps) {
            wp.setItalic(italic);
        }
        return this;
    }

    public Wtc setItalic() {
        return this.setItalic(true);
    }

    public List<Wp> getWps() {
        return this.wps;
    }

    public Wtc setHtml(String html) {
        DocxUtil.removeContent(this.src);
        try {
            Document doc = DocumentHelper.parseText((String)("<root>" + html + "</root>"));
            Element root = doc.getRootElement();
            this.doc.parseHtml(this.src, null, root, null, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    public Wtc setHtml(Element html) {
        String tag = html.getName();
        DocxUtil.removeContent(this.src);
        List elements = html.elements();
        if (html.elements().size() > 0) {
            this.doc.block(this.src, null, html, null);
        } else {
            this.setText(html.getText(), StyleParser.parse((String)html.attributeValue("style")));
        }
        return this;
    }

    public void remove() {
        this.src.getParent().remove(this.src);
        this.parent.getTcs().remove(this);
    }

    public Wtc setText(String text) {
        this.setText(text, null);
        return this;
    }

    public Wtc setText(String text, Map<String, String> styles) {
        DocxUtil.removeContent(this.src);
        Element p = DocxUtil.addElement(this.src, "p");
        Element r = DocxUtil.addElement(p, "r");
        Element t = DocxUtil.addElement(r, "t");
        t.setText(text);
        DocxUtil.pr(r, styles);
        return this;
    }

    public Wtc addText(String text) {
        Element p = DocxUtil.addElement(this.src, "p");
        Element r = DocxUtil.addElement(p, "r");
        Element t = r.addElement("w:t");
        t.setText(text);
        return this;
    }

    public List<String> getTextList() {
        ArrayList<String> texts = new ArrayList<String>();
        List ts = DomUtil.elements((Element)this.src, (String)"t");
        for (Element t : ts) {
            texts.add(t.getTextTrim());
        }
        return texts;
    }

    public String getTexts() {
        List<String> list = this.getTextList();
        String texts = "";
        for (String item : list) {
            if (null == item) continue;
            texts = texts + item;
        }
        return texts;
    }

    public String getText() {
        Element t = this.src.element("t");
        if (null != t) {
            return t.getText();
        }
        return null;
    }

    public Wtc replace(String src, String tar) {
        for (Wp wp : this.wps) {
            wp.replace(src, tar);
        }
        return this;
    }
}

