/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.office.docx.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.anyline.entity.html.TableBuilder;
import org.anyline.office.docx.entity.WDocument;
import org.anyline.office.docx.entity.Wtc;
import org.anyline.office.docx.entity.Wtr;
import org.anyline.office.docx.util.DocxUtil;
import org.anyline.util.StyleParser;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class Wtable {
    private WDocument doc;
    private Element src;
    private String widthUnit = "px";
    private List<Wtr> wtrs = new ArrayList<Wtr>();
    private boolean isAutoLoad = true;

    public Wtable(WDocument doc) {
        this.doc = doc;
        this.load();
    }

    public Wtable(WDocument doc, Element src) {
        this.doc = doc;
        this.src = src;
        this.load();
    }

    public void reload() {
        this.load();
    }

    private void load() {
        this.wtrs.clear();
        List elements = this.src.elements("tr");
        for (Element element : elements) {
            Wtr tr = new Wtr(this.doc, this, element);
            this.wtrs.add(tr);
        }
    }

    public Wtr getTr(String bookmark) {
        Element src = this.getParent(bookmark, "tr");
        Wtr tr = new Wtr(this.doc, this, src);
        return tr;
    }

    public Element getParent(String bookmark, String tag) {
        return this.doc.getParent(bookmark, tag);
    }

    private Wtr tr(Wtr template, Element src) {
        Wtr tr = new Wtr(this.doc, this, template.getSrc().createCopy());
        tr.removeContent();
        List tds = src.elements("td");
        for (int i = 0; i < tds.size(); ++i) {
            Wtc wtc = tr.getTc(i);
            Element td = (Element)tds.get(i);
            Map styles = StyleParser.parse((String)td.attributeValue("style"));
            wtc.setHtml(td);
        }
        return tr;
    }

    private Wtr tr(Element src) {
        Element tr = this.src.addElement("w:tr");
        Wtr wtr = new Wtr(this.doc, this, tr);
        List tds = src.elements("td");
        for (int i = 0; i < tds.size(); ++i) {
            Element tc = tr.addElement("w:tc");
            Wtc wtc = new Wtc(this.doc, wtr, tc);
            Element td = (Element)tds.get(i);
            wtc.setHtml(td);
        }
        return wtr;
    }

    public void insert(String html) {
        this.insert(-1, html);
    }

    public void insert(Object data, String ... cols) {
        Wtr template = this.getTemplate(-1);
        this.insert(-1, template, data, cols);
    }

    public void insert(int index, Object data, String ... cols) {
        Wtr template = this.getTemplate(index);
        this.insert(index, template, data, cols);
    }

    public Wtr getTemplate(int index) {
        Wtr template = null;
        int size = this.wtrs.size();
        if (size > 0) {
            if (index >= size) {
                index = size - 1;
            }
            template = index == 0 ? this.wtrs.get(0) : (index == -1 ? this.wtrs.get(size - 1) : this.wtrs.get(index - 1));
        }
        return template;
    }

    public void insert(Wtr template, Object data, String ... cols) {
        this.insert(-1, template, data, cols);
    }

    public void insert(int index, Wtr template, Object data, String ... cols) {
        ArrayList<Object> datas = null;
        if (data instanceof Collection) {
            datas = (ArrayList<Object>)data;
        } else {
            datas = new ArrayList<Object>();
            datas.add(data);
        }
        TableBuilder builder = TableBuilder.init().setFields(cols).setDatas(datas);
        String html = builder.build().build(false);
        this.insert(index, template, html);
    }

    public Wtable insert(int index, Wtr template, int qty) {
        List trs = this.src.elements("tr");
        for (int i = 0; i < qty; ++i) {
            Element newTr = template.getSrc().createCopy();
            DocxUtil.removeContent(newTr);
            if (index != -1) {
                trs.add(index++, newTr);
                continue;
            }
            trs.add(newTr);
        }
        this.reload();
        return this;
    }

    public Wtable insert(int index, int qty) {
        int size = this.wtrs.size();
        if (size > 0) {
            Wtr template = this.getTemplate(index);
            return this.insert(index, template, qty);
        }
        return this;
    }

    public void insert(int index, String html) {
        List trs = this.src.elements("tr");
        Wtr template = this.getTemplate(index);
        if (trs.size() > 1 && index == -1) {
            index = trs.size() - 1;
        }
        this.insert(-1, template, html);
    }

    public void insert(Wtr template, String html) {
        int index = -1;
        if (null != template) {
            List trs = this.src.elements("tr");
            index = trs.indexOf(template.getSrc());
        }
        this.insert(index, template, html);
    }

    public void insert(int index, Wtr template, String html) {
        List trs = this.src.elements("tr");
        if (index == -1 && null != template) {
            index = trs.indexOf(template.getSrc());
        }
        try {
            Document doc = DocumentHelper.parseText((String)("<root>" + html + "</root>"));
            Element root = doc.getRootElement();
            List rows = root.elements("tr");
            for (Element row : rows) {
                Element newTr = null;
                if (null != template) {
                    newTr = this.tr(template, row).getSrc();
                } else {
                    newTr = this.tr(row).getSrc();
                    trs.remove(newTr);
                }
                if (index >= 0) {
                    trs.add(index++, newTr);
                    continue;
                }
                trs.add(newTr);
            }
            if (this.isAutoLoad) {
                this.reload();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void remove(int index) {
        List trs = this.src.elements("tr");
        if (index < trs.size() && index >= 0) {
            trs.remove(index);
        }
        if (this.isAutoLoad) {
            this.reload();
        }
    }

    public void remove(Wtr tr) {
        List trs = this.src.elements("tr");
        trs.remove(tr.getSrc());
        if (this.isAutoLoad) {
            this.reload();
        }
    }

    public String getText(int row, int col) {
        String text = null;
        List trs = this.src.elements("tr");
        Element tr = (Element)trs.get(row);
        List tcs = tr.elements("tc");
        Element tc = (Element)tcs.get(col);
        text = DocxUtil.text(tc);
        return text;
    }

    public Wtable setText(int row, int col, String text) {
        return this.setText(row, col, text, null);
    }

    public Wtc addText(int row, int col, String text) {
        return this.getTc(row, col).addText(text);
    }

    public Wtable setText(int row, int col, String text, Map<String, String> styles) {
        Wtc tc = this.getTc(row, col);
        if (null != tc) {
            tc.setText(text, styles);
        }
        return this;
    }

    public Wtable setHtml(int row, int col, String html) {
        Wtc tc = this.getTc(row, col);
        if (null != tc) {
            tc.setHtml(html);
        }
        return this;
    }

    public Wtable addColumns(int qty) {
        this.insertColumns(-1, qty);
        return this;
    }

    public Wtable insertColumns(int col, int qty) {
        List trs = this.src.elements("tr");
        for (Element tr : trs) {
            List tcs = tr.elements("tc");
            int cols = tcs.size();
            if (cols > 0 && col < cols) {
                Element template = null;
                template = col == 0 ? (Element)tcs.get(0) : (col == -1 ? (Element)tcs.get(cols - 1) : (Element)tcs.get(col - 1));
                int index = col;
                for (int i = 0; i < qty; ++i) {
                    Element newTc = template.createCopy();
                    DocxUtil.removeContent(newTc);
                    if (col == -1) {
                        tcs.add(newTc);
                        continue;
                    }
                    tcs.add(index++, newTc);
                }
                continue;
            }
            for (int i = 0; i < qty; ++i) {
                tr.addElement("w:tc").addElement("w:p");
            }
        }
        if (this.isAutoLoad) {
            this.reload();
        }
        return this;
    }

    public Wtable insertRows(int index, int qty) {
        if (this.wtrs.size() > 0) {
            this.insertRows(this.getTemplate(index), index, qty);
        }
        return this;
    }

    public Wtable insertRows(Wtr template, int index, int qty) {
        List trs = this.src.elements("tr");
        if (trs.size() > 0) {
            for (int i = 0; i < qty; ++i) {
                Element newTr = template.getSrc().createCopy();
                DocxUtil.removeContent(newTr);
                if (index != -1) {
                    trs.add(index++, newTr);
                    continue;
                }
                trs.add(newTr);
            }
        }
        if (this.isAutoLoad) {
            this.reload();
        }
        return this;
    }

    public Wtable addRows(int qty) {
        return this.insertRows(-1, qty);
    }

    public Wtable addRows(int col, int qty) {
        return this.insertRows(col, qty);
    }

    public int getTrSize() {
        return this.src.elements("tr").size();
    }

    public Wtable setWidth(String width) {
        Element pr = DocxUtil.addElement(this.src, "tblPr");
        DocxUtil.addElement(pr, "tcW", "w", DocxUtil.dxa(width) + "");
        DocxUtil.addElement(pr, "tcW", "type", DocxUtil.widthType(width));
        return this;
    }

    public Wtable setWidth(int width) {
        return this.setWidth(width + this.widthUnit);
    }

    public Wtable setWidth(double width) {
        return this.setWidth(width + this.widthUnit);
    }

    public Wtable merge(int row, int col, int rowspan, int colspan) {
        this.reload();
        for (int r = row; r < row + rowspan; ++r) {
            for (int c = col; c < col + colspan; ++c) {
                Wtc tc = this.getTc(r, c);
                Element pr = DocxUtil.addElement(tc.getSrc(), "tcPr");
                if (rowspan > 1) {
                    if (r == row) {
                        DocxUtil.addElement(pr, "vMerge", "val", "restart");
                    } else {
                        DocxUtil.addElement(pr, "vMerge");
                    }
                }
                if (colspan <= 1) continue;
                if (c == col) {
                    DocxUtil.addElement(pr, "gridSpan", "val", colspan + "");
                    continue;
                }
                tc.remove();
            }
        }
        this.reload();
        return this;
    }

    public List<Wtr> getTrs() {
        return this.wtrs;
    }

    public Wtr getTr(int index) {
        return this.wtrs.get(index);
    }

    public Wtc getTc(int row, int col) {
        Wtr wtr = this.getTr(row);
        if (null == wtr) {
            return null;
        }
        return wtr.getTc(col);
    }

    public Wtable removeBorder() {
        this.removeTopBorder();
        this.removeBottomBorder();
        this.removeLeftBorder();
        this.removeRightBorder();
        this.removeInsideHBorder();
        this.removeInsideVBorder();
        this.removeTl2brBorder();
        this.removeTr2blBorder();
        return this;
    }

    public Wtable removeTopBorder() {
        this.removeBorder(this.src, "top");
        return this;
    }

    public Wtable removeLeftBorder() {
        this.removeBorder(this.src, "left");
        return this;
    }

    public Wtable removeRightBorder() {
        this.removeBorder(this.src, "right");
        return this;
    }

    public Wtable removeBottomBorder() {
        this.removeBorder(this.src, "bottom");
        return this;
    }

    public Wtable removeInsideVBorder() {
        this.removeBorder(this.src, "insideV");
        return this;
    }

    public Wtable removeTl2brBorder() {
        this.removeBorder(this.src, "tl2br");
        return this;
    }

    public Wtable removeTr2blBorder() {
        this.removeBorder(this.src, "tr2bl");
        return this;
    }

    public Wtable removeInsideHBorder() {
        this.removeBorder(this.src, "insideH");
        return this;
    }

    public Wtable removeTcBorder() {
        for (Wtr tr : this.wtrs) {
            List<Wtc> tcs = tr.getTcs();
            for (Wtc tc : tcs) {
                tc.removeBorder();
            }
        }
        return this;
    }

    public Wtable removeTcColor() {
        for (Wtr tr : this.wtrs) {
            List<Wtc> tcs = tr.getTcs();
            for (Wtc tc : tcs) {
                tc.removeColor();
            }
        }
        return this;
    }

    public Wtable removeTcBackgroundColor() {
        for (Wtr tr : this.wtrs) {
            List<Wtc> tcs = tr.getTcs();
            for (Wtc tc : tcs) {
                tc.removeBackgroundColor();
            }
        }
        return this;
    }

    private void removeBorder(Element tbl, String side) {
        Element tcPr = DocxUtil.addElement(tbl, "tblPr");
        Element borders = DocxUtil.addElement(tcPr, "tblBorders");
        Element border = DocxUtil.addElement(borders, side);
        border.addAttribute("w:val", "nil");
        DocxUtil.removeAttribute(border, "sz");
        DocxUtil.removeAttribute(border, "space");
        DocxUtil.removeAttribute(border, "color");
    }

    public Wtr removeTopBorder(int row) {
        Wtr tr = this.getTr(row);
        List<Wtc> tcs = tr.getTcs();
        for (Wtc tc : tcs) {
            tc.removeTopBorder();
        }
        return tr;
    }

    public Wtr removeBottomBorder(int row) {
        Wtr tr = this.getTr(row);
        tr.removeBottomBorder();
        return tr;
    }

    public Wtable removeLeftBorder(int col) {
        for (Wtr tr : this.wtrs) {
            Wtc tc = tr.getTcWithColspan(col, true);
            if (null == tc) continue;
            tc.removeLeftBorder();
        }
        return this;
    }

    public Wtable removeRightBorder(int col) {
        for (Wtr tr : this.wtrs) {
            Wtc tc = tr.getTcWithColspan(col, false);
            if (null == tc) continue;
            tc.removeRightBorder();
        }
        return this;
    }

    public Wtc removeLeftBorder(int row, int col) {
        return this.getTc(row, col).removeLeftBorder();
    }

    public Wtc removeRightBorder(int row, int col) {
        return this.getTc(row, col).removeRightBorder();
    }

    public Wtc removeTopBorder(int row, int col) {
        return this.getTc(row, col).removeTopBorder();
    }

    public Wtc removeBottomBorder(int row, int col) {
        return this.getTc(row, col).removeBottomBorder();
    }

    public Wtc removeTl2brBorder(int row, int col) {
        return this.getTc(row, col).removeTl2brBorder();
    }

    public Wtc removeTr2blBorder(int row, int col) {
        return this.getTc(row, col).removeBorder();
    }

    public Wtc removeBorder(int row, int col) {
        return this.getTc(row, col).removeLeftBorder().removeRightBorder().removeTopBorder().removeBottomBorder().removeTl2brBorder().removeTr2blBorder();
    }

    public Wtr setBorder(int row) {
        Wtr tr = this.getTr(row);
        tr.setBorder();
        return tr;
    }

    public Wtable setCellBorder() {
        for (Wtr tr : this.wtrs) {
            tr.setBorder();
        }
        return this;
    }

    public Wtc setBorder(int row, int col) {
        return this.getTc(row, col).setLeftBorder().setRightBorder().setTopBorder().setBottomBorder().setTl2brBorder().setTr2blBorder();
    }

    public Wtc setBorder(int row, int col, int size, String color, String style) {
        return this.getTc(row, col).setBorder(size, color, style);
    }

    public Wtc setLeftBorder(int row, int col) {
        return this.getTc(row, col).setLeftBorder();
    }

    public Wtc setRightBorder(int row, int col) {
        return this.getTc(row, col).setRightBorder();
    }

    public Wtc setTopBorder(int row, int col) {
        return this.getTc(row, col).setTopBorder();
    }

    public Wtc setBottomBorder(int row, int col) {
        return this.getTc(row, col).setBottomBorder();
    }

    public Wtc setTl2brBorder(int row, int col) {
        return this.getTc(row, col).setTl2brBorder();
    }

    public Wtc setTl2brBorder(int row, int col, String top, String bottom) {
        return this.getTc(row, col).setTl2brBorder(top, bottom);
    }

    public Wtc setTr2blBorder(int row, int col) {
        return this.getTc(row, col).setTr2blBorder();
    }

    public Wtc setTr2blBorder(int row, int col, String top, String bottom) {
        return this.getTc(row, col).setTr2blBorder(top, bottom);
    }

    public Wtc setLeftBorder(int row, int col, int size, String color, String style) {
        return this.getTc(row, col).setLeftBorder(size, color, style);
    }

    public Wtc setRightBorder(int row, int col, int size, String color, String style) {
        return this.getTc(row, col).setRightBorder(size, color, style);
    }

    public Wtc setTopBorder(int row, int col, int size, String color, String style) {
        return this.getTc(row, col).setTopBorder(size, color, style);
    }

    public Wtc setBottomBorder(int row, int col, int size, String color, String style) {
        return this.getTc(row, col).setBottomBorder(size, color, style);
    }

    public Wtc setTl2brBorder(int row, int col, int size, String color, String style) {
        return this.getTc(row, col).setTl2brBorder(size, color, style);
    }

    public Wtc setTr2blBorder(int row, int col, int size, String color, String style) {
        return this.getTc(row, col).setTr2blBorder(size, color, style);
    }

    public Wtable setLeftBorder(int cols, int size, String color, String style) {
        for (Wtr tr : this.wtrs) {
            tr.getTc(cols).setLeftBorder(size, color, style);
        }
        return this;
    }

    public Wtable setRightBorder(int cols, int size, String color, String style) {
        for (Wtr tr : this.wtrs) {
            tr.getTc(cols).setRightBorder(size, color, style);
        }
        return this;
    }

    public Wtr setTopBorder(int rows, int size, String color, String style) {
        return this.getTr(rows).setTopBorder(size, color, style);
    }

    public Wtr setBottomBorder(int rows, int size, String color, String style) {
        return this.getTr(rows).setBottomBorder(size, color, style);
    }

    public Wtc setColor(int row, int col, String color) {
        return this.getTc(row, col).setColor(color);
    }

    public Wtr setColor(int rows, String color) {
        Wtr tr = this.getTr(rows);
        tr.setColor(color);
        return tr;
    }

    public Wtc setFont(int row, int col, String size, String eastAsia, String ascii, String hint) {
        return this.getTc(row, col).setFont(size, eastAsia, ascii, hint);
    }

    public Wtr setFont(int rows, String size, String eastAsia, String ascii, String hint) {
        Wtr tr = this.getTr(rows);
        tr.setFont(size, eastAsia, ascii, hint);
        return tr;
    }

    public Wtc setFontSize(int row, int col, String size) {
        return this.getTc(row, col).setFontSize(size);
    }

    public Wtr setFontSize(int rows, String size) {
        Wtr tr = this.getTr(rows);
        tr.setFontSize(size);
        return tr;
    }

    public Wtc setFontFamily(int row, int col, String font) {
        return this.getTc(row, col).setFontFamily(font);
    }

    public Wtr setFontFamily(int rows, String font) {
        Wtr tr = this.getTr(rows);
        tr.setFontFamily(font);
        return tr;
    }

    public Wtc setWidth(int row, int col, String width) {
        return this.getTc(row, col).setWidth(width);
    }

    public Wtc setWidth(int row, int col, int width) {
        return this.getTc(row, col).setWidth(width);
    }

    public Wtc setWidth(int row, int col, double width) {
        return this.getTc(row, col).setWidth(width);
    }

    public Wtable setWidth(int cols, String width) {
        for (Wtr tr : this.wtrs) {
            tr.getTc(cols).setWidth(width);
        }
        return this;
    }

    public Wtable setWidth(int cols, int width) {
        for (Wtr tr : this.wtrs) {
            tr.getTc(cols).setWidth(width);
        }
        return this;
    }

    public Wtable setWidth(int cols, double width) {
        for (Wtr tr : this.wtrs) {
            tr.getTc(cols).setWidth(width);
        }
        return this;
    }

    public Wtr setHeight(int rows, String height) {
        Wtr tr = this.getTr(rows);
        tr.setHeight(height);
        return tr;
    }

    public Wtr setHeight(int rows, int height) {
        return this.setHeight(rows, height + this.widthUnit);
    }

    public Wtr setHeight(int rows, double height) {
        return this.setHeight(rows, height + this.widthUnit);
    }

    public Wtc setAlign(int row, int col, String align) {
        return this.getTc(row, col).setAlign(align);
    }

    public Wtr setAlign(int rows, String align) {
        Wtr tr = this.getTr(rows);
        tr.setAlign(align);
        return tr;
    }

    public Wtable setAlign(String align) {
        for (Wtr tr : this.wtrs) {
            tr.setAlign(align);
        }
        return this;
    }

    public Wtc setVerticalAlign(int row, int col, String align) {
        return this.getTc(row, col).setVerticalAlign(align);
    }

    public Wtr setVerticalAlign(int rows, String align) {
        Wtr tr = this.getTr(rows);
        tr.setVerticalAlign(align);
        return tr;
    }

    public Wtable setVerticalAlign(String align) {
        for (Wtr tr : this.wtrs) {
            tr.setVerticalAlign(align);
        }
        return this;
    }

    public Wtc setBottomPadding(int row, int col, String padding) {
        return this.getTc(row, col).setBottomPadding(padding);
    }

    public Wtc setBottomPadding(int row, int col, int padding) {
        return this.getTc(row, col).setBottomPadding(padding);
    }

    public Wtc setBottomPadding(int row, int col, double padding) {
        return this.getTc(row, col).setBottomPadding(padding);
    }

    public Wtr setBottomPadding(int rows, String padding) {
        Wtr tr = this.getTr(rows);
        tr.setBottomPadding(padding);
        return tr;
    }

    public Wtr setBottomPadding(int rows, int padding) {
        Wtr tr = this.getTr(rows);
        tr.setBottomPadding(padding);
        return tr;
    }

    public Wtr setBottomPadding(int rows, double padding) {
        Wtr tr = this.getTr(rows);
        tr.setBottomPadding(padding);
        return tr;
    }

    public Wtable setBottomPadding(String padding) {
        for (Wtr tr : this.wtrs) {
            tr.setBottomPadding(padding);
        }
        return this;
    }

    public Wtable setBottomPadding(int padding) {
        for (Wtr tr : this.wtrs) {
            tr.setBottomPadding(padding);
        }
        return this;
    }

    public Wtable setBottomPadding(double padding) {
        for (Wtr tr : this.wtrs) {
            tr.setBottomPadding(padding);
        }
        return this;
    }

    public Wtc setTopPadding(int row, int col, String padding) {
        return this.getTc(row, col).setTopPadding(padding);
    }

    public Wtc setTopPadding(int row, int col, int padding) {
        return this.getTc(row, col).setTopPadding(padding);
    }

    public Wtc setTopPadding(int row, int col, double padding) {
        return this.getTc(row, col).setTopPadding(padding);
    }

    public Wtr setTopPadding(int rows, String padding) {
        Wtr tr = this.getTr(rows);
        tr.setTopPadding(padding);
        return tr;
    }

    public Wtr setTopPadding(int rows, int padding) {
        Wtr tr = this.getTr(rows);
        tr.setTopPadding(padding);
        return tr;
    }

    public Wtr setTopPadding(int rows, double padding) {
        Wtr tr = this.getTr(rows);
        tr.setTopPadding(padding);
        return tr;
    }

    public Wtable setTopPadding(String padding) {
        for (Wtr tr : this.wtrs) {
            tr.setTopPadding(padding);
        }
        return this;
    }

    public Wtable setTopPadding(int padding) {
        for (Wtr tr : this.wtrs) {
            tr.setTopPadding(padding);
        }
        return this;
    }

    public Wtable setTopPadding(double padding) {
        for (Wtr tr : this.wtrs) {
            tr.setTopPadding(padding);
        }
        return this;
    }

    public Wtc setRightPadding(int row, int col, String padding) {
        return this.getTc(row, col).setRightPadding(padding);
    }

    public Wtc setRightPadding(int row, int col, int padding) {
        return this.getTc(row, col).setRightPadding(padding);
    }

    public Wtc setRightPadding(int row, int col, double padding) {
        return this.getTc(row, col).setRightPadding(padding);
    }

    public Wtr setRightPadding(int rows, String padding) {
        Wtr tr = this.getTr(rows);
        tr.setRightPadding(padding);
        return tr;
    }

    public Wtr setRightPadding(int rows, int padding) {
        Wtr tr = this.getTr(rows);
        tr.setRightPadding(padding);
        return tr;
    }

    public Wtr setRightPadding(int rows, double padding) {
        Wtr tr = this.getTr(rows);
        tr.setRightPadding(padding);
        return tr;
    }

    public Wtable setRightPadding(String padding) {
        for (Wtr tr : this.wtrs) {
            tr.setRightPadding(padding);
        }
        return this;
    }

    public Wtable setRightPadding(int padding) {
        for (Wtr tr : this.wtrs) {
            tr.setRightPadding(padding);
        }
        return this;
    }

    public Wtable setRightPadding(double padding) {
        for (Wtr tr : this.wtrs) {
            tr.setRightPadding(padding);
        }
        return this;
    }

    public Wtc setLeftPadding(int row, int col, String padding) {
        return this.getTc(row, col).setLeftPadding(padding);
    }

    public Wtc setLeftPadding(int row, int col, int padding) {
        return this.getTc(row, col).setLeftPadding(padding);
    }

    public Wtc setLeftPadding(int row, int col, double padding) {
        return this.getTc(row, col).setLeftPadding(padding);
    }

    public Wtr setLeftPadding(int rows, String padding) {
        Wtr tr = this.getTr(rows);
        tr.setLeftPadding(padding);
        return tr;
    }

    public Wtr setLeftPadding(int rows, int padding) {
        Wtr tr = this.getTr(rows);
        tr.setLeftPadding(padding);
        return tr;
    }

    public Wtr setLeftPadding(int rows, double padding) {
        Wtr tr = this.getTr(rows);
        tr.setLeftPadding(padding);
        return tr;
    }

    public Wtable setLeftPadding(String padding) {
        for (Wtr tr : this.wtrs) {
            tr.setLeftPadding(padding);
        }
        return this;
    }

    public Wtable setLeftPadding(int padding) {
        for (Wtr tr : this.wtrs) {
            tr.setLeftPadding(padding);
        }
        return this;
    }

    public Wtable setLeftPadding(double padding) {
        for (Wtr tr : this.wtrs) {
            tr.setLeftPadding(padding);
        }
        return this;
    }

    public Wtc setPadding(int row, int col, String side, String padding) {
        return this.getTc(row, col).setPadding(side, padding);
    }

    public Wtc setPadding(int row, int col, String side, int padding) {
        return this.getTc(row, col).setPadding(side, padding);
    }

    public Wtc setPadding(int row, int col, String side, double padding) {
        return this.getTc(row, col).setPadding(side, padding);
    }

    public Wtr setPadding(int rows, String side, String padding) {
        Wtr tr = this.getTr(rows);
        tr.setPadding(side, padding);
        return tr;
    }

    public Wtr setPadding(int rows, String side, int padding) {
        Wtr tr = this.getTr(rows);
        tr.setPadding(side, padding);
        return tr;
    }

    public Wtr setPadding(int rows, String side, double padding) {
        Wtr tr = this.getTr(rows);
        tr.setPadding(side, padding);
        return tr;
    }

    public Wtable setPadding(String side, String padding) {
        for (Wtr tr : this.wtrs) {
            tr.setPadding(side, padding);
        }
        return this;
    }

    public Wtable setPadding(String side, int padding) {
        for (Wtr tr : this.wtrs) {
            tr.setPadding(side, padding);
        }
        return this;
    }

    public Wtable setPadding(String side, double padding) {
        for (Wtr tr : this.wtrs) {
            tr.setPadding(side, padding);
        }
        return this;
    }

    public Wtc setPadding(int row, int col, String padding) {
        return this.getTc(row, col).setPadding(padding);
    }

    public Wtc setPadding(int row, int col, int padding) {
        return this.getTc(row, col).setPadding(padding);
    }

    public Wtc setPadding(int row, int col, double padding) {
        return this.getTc(row, col).setPadding(padding);
    }

    public Wtr setPadding(int rows, String padding) {
        Wtr tr = this.getTr(rows);
        tr.setPadding(padding);
        return tr;
    }

    public Wtr setPadding(int rows, int padding) {
        Wtr tr = this.getTr(rows);
        tr.setPadding(padding);
        return tr;
    }

    public Wtr setPadding(int rows, double padding) {
        Wtr tr = this.getTr(rows);
        tr.setPadding(padding);
        return tr;
    }

    public Wtable setPadding(String padding) {
        for (Wtr tr : this.wtrs) {
            tr.setPadding(padding);
        }
        return this;
    }

    public Wtable setPadding(int padding) {
        for (Wtr tr : this.wtrs) {
            tr.setPadding(padding);
        }
        return this;
    }

    public Wtable setPadding(double padding) {
        for (Wtr tr : this.wtrs) {
            tr.setPadding(padding);
        }
        return this;
    }

    public Wtc setBackgroundColor(int row, int col, String color) {
        return this.getTc(row, col).setBackgroundColor(color);
    }

    public Wtr setBackgroundColor(int row, String color) {
        Wtr tr = this.getTr(row);
        tr.setBackgroundColor(color);
        return tr;
    }

    public Wtable setBackgroundColor(String color) {
        for (Wtr tr : this.wtrs) {
            tr.setBackgroundColor(color);
        }
        return this;
    }

    public Wtc removeStyle(int row, int col) {
        return this.getTc(row, col).removeStyle();
    }

    public Wtr removeStyle(int row) {
        Wtr tr = this.getTr(row);
        tr.removeContent();
        return tr;
    }

    public Wtable removeStyle() {
        for (Wtr tr : this.wtrs) {
            tr.removeStyle();
        }
        return this;
    }

    public Wtc removeBackgroundColor(int row, int col) {
        return this.getTc(row, col).removeBackgroundColor();
    }

    public Wtr removeBackgroundColor(int row) {
        Wtr tr = this.getTr(row);
        tr.removeBackgroundColor();
        return tr;
    }

    public Wtable removeBackgroundColor() {
        for (Wtr tr : this.wtrs) {
            tr.removeBackgroundColor();
        }
        return this;
    }

    public Wtc removeColor(int row, int col) {
        return this.getTc(row, col).removeColor();
    }

    public Wtr removeColor(int row) {
        Wtr tr = this.getTr(row);
        tr.removeColor();
        return tr;
    }

    public Wtable removeColor() {
        for (Wtr tr : this.wtrs) {
            tr.removeColor();
        }
        return this;
    }

    public Wtc setBold(int row, int col, boolean bold) {
        return this.getTc(row, col).setBold(bold);
    }

    public Wtc setBold(int row, int col) {
        return this.setBold(row, col, true);
    }

    public Wtr setBold(int rows) {
        return this.setBold(rows, true);
    }

    public Wtr setBold(int rows, boolean bold) {
        Wtr tr = this.getTr(rows);
        tr.setBold(bold);
        return tr;
    }

    public Wtable setBold(boolean bold) {
        for (Wtr tr : this.wtrs) {
            tr.setBold(bold);
        }
        return this;
    }

    public Wtable setBold() {
        return this.setBold(true);
    }

    public Wtc setUnderline(int row, int col, boolean underline) {
        return this.getTc(row, col).setUnderline(underline);
    }

    public Wtc setUnderline(int row, int col) {
        return this.setUnderline(row, col, true);
    }

    public Wtc setStrike(int row, int col, boolean strike) {
        return this.getTc(row, col).setStrike(strike);
    }

    public Wtc setStrike(int row, int col) {
        return this.setStrike(row, col, true);
    }

    public Wtr setStrike(int rows, boolean strike) {
        Wtr tr = this.getTr(rows);
        tr.setStrike(strike);
        return tr;
    }

    public Wtable setStrike(boolean strike) {
        for (Wtr tr : this.wtrs) {
            tr.setStrike(strike);
        }
        return this;
    }

    public Wtable setStrike() {
        return this.setStrike(true);
    }

    public Wtc setItalic(int row, int col, boolean italic) {
        return this.getTc(row, col).setItalic(italic);
    }

    public Wtc setItalic(int row, int col) {
        return this.setItalic(row, col, true);
    }

    public Wtr setItalic(int rows, boolean italic) {
        Wtr tr = this.getTr(rows);
        tr.setItalic(italic);
        return tr;
    }

    public Wtable setItalic(boolean italic) {
        for (Wtr tr : this.wtrs) {
            tr.setItalic(italic);
        }
        return this;
    }

    public Wtable setItalic() {
        return this.setItalic(true);
    }

    public Wtc replace(int row, int col, String src, String tar) {
        return this.getTc(row, col).replace(src, tar);
    }

    public Wtr replace(int rows, String src, String tar) {
        Wtr tr = this.getTr(rows);
        tr.replace(src, tar);
        return tr;
    }

    public Wtable replace(String src, String tar) {
        for (Wtr tr : this.wtrs) {
            tr.replace(src, tar);
        }
        return this;
    }

    public String getWidthUnit() {
        return this.widthUnit;
    }

    public void setWidthUnit(String widthUnit) {
        this.widthUnit = widthUnit;
        for (Wtr tr : this.wtrs) {
            tr.setWidthUnit(widthUnit);
        }
    }

    public boolean isAutoLoad() {
        return this.isAutoLoad;
    }

    public void setAutoLoad(boolean autoLoad) {
        this.isAutoLoad = autoLoad;
    }
}

