/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.office.docx.entity;

import java.util.ArrayList;
import java.util.List;
import org.anyline.office.docx.entity.WDocument;
import org.anyline.office.docx.entity.Wtable;
import org.anyline.office.docx.entity.Wtc;
import org.anyline.office.docx.util.DocxUtil;
import org.dom4j.Element;

public class Wtr {
    private WDocument doc;
    private Element src;
    private Wtable parent;
    private List<Wtc> wtcs = new ArrayList<Wtc>();
    private String widthUnit = "px";

    public Wtr(WDocument doc, Wtable parent, Element src) {
        this.doc = doc;
        this.src = src;
        this.parent = parent;
        this.load();
    }

    public Wtr reload() {
        this.load();
        return this;
    }

    private Wtr load() {
        this.wtcs.clear();
        List items = this.src.elements("tc");
        for (Element tc : items) {
            Wtc wtc = new Wtc(this.doc, this, tc);
            this.wtcs.add(wtc);
        }
        return this;
    }

    public WDocument getDoc() {
        return this.doc;
    }

    public Wtable getParent() {
        return this.parent;
    }

    public void setDoc(WDocument doc) {
        this.doc = doc;
    }

    public Element getSrc() {
        return this.src;
    }

    public void setSrc(Element src) {
        this.src = src;
    }

    public Wtr setHeight(String height) {
        int dxa = DocxUtil.dxa(height);
        Element pr = DocxUtil.addElement(this.src, "trPr");
        DocxUtil.addElement(pr, "trHeight", "val", dxa + "");
        return this;
    }

    public Wtr setHeight(int height) {
        return this.setHeight(height + this.widthUnit);
    }

    public Wtr setHeight(double height) {
        return this.setHeight(height + this.widthUnit);
    }

    public List<Wtc> getWtcs() {
        if (this.wtcs.size() == 0) {
            List elements = this.src.elements("tc");
            for (Element element : elements) {
                Wtc tc = new Wtc(this.doc, this, element);
                this.wtcs.add(tc);
            }
        }
        return this.wtcs;
    }

    public Wtc getTc(int index) {
        return this.wtcs.get(index);
    }

    public String getWidthUnit() {
        return this.widthUnit;
    }

    public void setWidthUnit(String widthUnit) {
        this.widthUnit = widthUnit;
        for (Wtc tc : this.wtcs) {
            tc.setWidthUnit(widthUnit);
        }
    }

    public Wtc getTcWithColspan(int index, boolean prev) {
        int qty = -1;
        for (Wtc tc : this.wtcs) {
            if ((qty += tc.getColspan()) == index) {
                return tc;
            }
            if (qty <= index) continue;
            if (!prev) break;
            return tc;
        }
        return null;
    }

    public List<Wtc> getTcs() {
        return this.wtcs;
    }

    private Wtr removeBorder() {
        List<Wtc> tcs = this.getWtcs();
        for (Wtc tc : tcs) {
            tc.removeBorder();
        }
        return this;
    }

    public Wtr setBorder() {
        List<Wtc> tcs = this.getWtcs();
        for (Wtc tc : tcs) {
            tc.setBorder();
        }
        return this;
    }

    public Wtr setBorder(int size, String color, String style) {
        List<Wtc> tcs = this.getWtcs();
        for (Wtc tc : tcs) {
            tc.setBorder(size, color, style);
        }
        return this;
    }

    public Wtr setColor(String color) {
        List<Wtc> tcs = this.getWtcs();
        for (Wtc tc : tcs) {
            tc.setColor(color);
        }
        return this;
    }

    public Wtr setFont(String size, String eastAsia, String ascii, String hint) {
        List<Wtc> tcs = this.getWtcs();
        for (Wtc tc : tcs) {
            tc.setFont(size, eastAsia, ascii, hint);
        }
        return this;
    }

    public Wtr setFontSize(String size) {
        List<Wtc> tcs = this.getWtcs();
        for (Wtc tc : tcs) {
            tc.setFontSize(size);
        }
        return this;
    }

    public Wtr setFontFamily(String font) {
        List<Wtc> tcs = this.getWtcs();
        for (Wtc tc : tcs) {
            tc.setFontFamily(font);
        }
        return this;
    }

    public Wtr setAlign(String align) {
        List<Wtc> tcs = this.getWtcs();
        for (Wtc tc : tcs) {
            tc.setAlign(align);
        }
        return this;
    }

    public Wtr setVerticalAlign(String align) {
        List<Wtc> tcs = this.getWtcs();
        for (Wtc tc : tcs) {
            tc.setVerticalAlign(align);
        }
        return this;
    }

    public Wtr setBackgroundColor(String color) {
        List<Wtc> tcs = this.getWtcs();
        for (Wtc tc : tcs) {
            tc.setBackgroundColor(color);
        }
        return this;
    }

    public Wtr removeContent() {
        DocxUtil.removeContent(this.src);
        return this;
    }
}

