/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.office.docx.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.anyline.entity.html.TableBuilder;
import org.anyline.office.docx.entity.WDocument;
import org.anyline.office.docx.entity.Wtc;
import org.anyline.office.docx.entity.Wtr;
import org.anyline.office.docx.util.DocxUtil;
import org.anyline.util.StyleParser;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class Wtable {
    private WDocument doc;
    private Element src;
    private String widthUnit = "px";
    private List<Wtr> wtrs = new ArrayList<Wtr>();

    public Wtable(WDocument doc) {
        this.doc = doc;
        this.load();
    }

    public Wtable(WDocument doc, Element src) {
        this.doc = doc;
        this.src = src;
        this.load();
    }

    public void reload() {
        this.load();
    }

    private void load() {
        this.wtrs.clear();
        List elements = this.src.elements("tr");
        for (Element element : elements) {
            Wtr tr = new Wtr(this.doc, this, element);
            this.wtrs.add(tr);
        }
    }

    public Wtr getTr(String bookmark) {
        Element src = this.getParent(bookmark, "tr");
        Wtr tr = new Wtr(this.doc, this, src);
        return tr;
    }

    public Element getParent(String bookmark, String tag) {
        return this.doc.getParent(bookmark, tag);
    }

    private Wtr tr(Wtr template, Element src) {
        Wtr tr = new Wtr(this.doc, this, template.getSrc().createCopy());
        tr.removeContent();
        List tds = src.elements("td");
        for (int i = 0; i < tds.size(); ++i) {
            Wtc wtc = tr.getTc(i);
            Element td = (Element)tds.get(i);
            Map styles = StyleParser.parse((String)td.attributeValue("style"));
            wtc.setHtml(td);
        }
        return tr;
    }

    private Wtr tr(Element src) {
        Element tr = this.src.addElement("w:tr");
        Wtr wtr = new Wtr(this.doc, this, tr);
        List tds = src.elements("td");
        for (int i = 0; i < tds.size(); ++i) {
            Element tc = tr.addElement("w:tc");
            Wtc wtc = new Wtc(this.doc, wtr, tc);
            Element td = (Element)tds.get(i);
            wtc.setHtml(td);
        }
        return wtr;
    }

    public void insert(String html) {
        this.insert(-1, html);
    }

    public void insert(Object data, String ... cols) {
        this.insert(-1, null, data, cols);
    }

    public void insert(int index, Object data, String ... cols) {
        Wtr template = null;
        this.insert(index, template, data, cols);
    }

    public void insert(Wtr template, Object data, String ... cols) {
        this.insert(-1, template, data, cols);
    }

    public void insert(int index, Wtr template, Object data, String ... cols) {
        ArrayList<Object> datas = null;
        if (data instanceof Collection) {
            datas = (ArrayList<Object>)data;
        } else {
            datas = new ArrayList<Object>();
            datas.add(data);
        }
        TableBuilder builder = TableBuilder.init().setFields(cols).setDatas(datas);
        String html = builder.build().build(false);
        this.insert(index, template, html);
    }

    public Wtable insert(int index, Wtr template, int qty) {
        List trs = this.src.elements("tr");
        for (int i = 0; i < qty; ++i) {
            Element newTr = template.getSrc().createCopy();
            DocxUtil.removeContent(newTr);
            if (index != -1) {
                trs.add(index++, newTr);
                continue;
            }
            trs.add(newTr);
        }
        this.reload();
        return this;
    }

    public Wtable insert(int index, int qty) {
        if (index < this.wtrs.size() - 1) {
            Wtr template = this.wtrs.get(index - 1);
            return this.insert(index, template, qty);
        }
        return this;
    }

    public void insert(int index, String html) {
        List trs = this.src.elements("tr");
        Wtr template = null;
        if (trs.size() > 1) {
            template = new Wtr(this.doc, this, (Element)trs.get(trs.size() - 1));
            if (index == -1) {
                index = trs.size() - 1;
            }
        }
        this.insert(-1, template, html);
    }

    public void insert(Wtr template, String html) {
        int index = -1;
        if (null != template) {
            List trs = this.src.elements("tr");
            index = trs.indexOf(template.getSrc());
        }
        this.insert(index, template, html);
    }

    public void insert(int index, Wtr template, String html) {
        List trs = this.src.elements("tr");
        if (index == -1 && null != template) {
            index = trs.indexOf(template.getSrc());
        }
        try {
            Document doc = DocumentHelper.parseText((String)("<root>" + html + "</root>"));
            Element root = doc.getRootElement();
            List rows = root.elements("tr");
            for (Element row : rows) {
                Element newTr = null;
                if (null != template) {
                    newTr = this.tr(template, row).getSrc();
                } else {
                    newTr = this.tr(row).getSrc();
                    trs.remove(newTr);
                }
                if (index >= 0) {
                    trs.add(index++, newTr);
                    continue;
                }
                trs.add(newTr);
            }
            if (null != template) {
                // empty if block
            }
            this.reload();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void remove(int index) {
        List trs = this.src.elements("tr");
        if (index < trs.size() && index >= 0) {
            trs.remove(index);
        }
        this.reload();
    }

    public void remove(Wtr tr) {
        List trs = this.src.elements("tr");
        trs.remove(tr.getSrc());
        this.reload();
    }

    public String getText(int rows, int cols) {
        String text = null;
        List trs = this.src.elements("tr");
        Element tr = (Element)trs.get(rows);
        List tcs = tr.elements("tc");
        Element tc = (Element)tcs.get(cols);
        text = DocxUtil.text(tc);
        return text;
    }

    public Wtable setText(int rows, int cols, String text) {
        return this.setText(rows, cols, text, null);
    }

    public Wtable setText(int rows, int cols, String text, Map<String, String> styles) {
        Wtc tc = this.getTc(rows, cols);
        if (null != tc) {
            tc.setText(text, styles);
        }
        return this;
    }

    public Wtable setHtml(int rows, int cols, String html) {
        Wtc tc = this.getTc(rows, cols);
        if (null != tc) {
            tc.setHtml(html);
        }
        return this;
    }

    public Wtable addColumns(int qty) {
        List trs = this.src.elements("tr");
        for (Element tr : trs) {
            List tcs = tr.elements();
            if (tcs.size() > 0) {
                Element tc = (Element)tcs.get(tcs.size() - 1);
                for (int i = 0; i < qty; ++i) {
                    Element newTc = tc.createCopy();
                    DocxUtil.removeContent(newTc);
                    tr.add(newTc);
                }
                continue;
            }
            for (int i = 0; i < qty; ++i) {
                tr.addElement("w:tc").addElement("w:p");
            }
        }
        this.reload();
        return this;
    }

    public Wtable addRows(int index, int qty) {
        List trs = this.src.elements("tr");
        if (trs.size() > 0) {
            Element tr = null;
            tr = index == -1 ? (Element)trs.get(trs.size() - 1) : (Element)trs.get(index - 1);
            for (int i = 0; i < qty; ++i) {
                Element newTr = tr.createCopy();
                DocxUtil.removeContent(newTr);
                if (index != -1) {
                    trs.add(index++, newTr);
                    continue;
                }
                trs.add(newTr);
            }
        }
        this.reload();
        return this;
    }

    public Wtable addRows(int qty) {
        return this.addRows(-1, qty);
    }

    public int getTrSize() {
        return this.src.elements("tr").size();
    }

    public Wtable setWidth(String width) {
        Element pr = DocxUtil.addElement(this.src, "tblPr");
        DocxUtil.addElement(pr, "tcW", "w", DocxUtil.dxa(width) + "");
        DocxUtil.addElement(pr, "tcW", "type", DocxUtil.widthType(width));
        return this;
    }

    public Wtable setWidth(int width) {
        return this.setWidth(width + this.widthUnit);
    }

    public Wtable setWidth(double width) {
        return this.setWidth(width + this.widthUnit);
    }

    public Wtable merge(int rows, int cols, int rowspan, int colspan) {
        this.reload();
        for (int r = rows; r < rows + rowspan; ++r) {
            for (int c = cols; c < cols + colspan; ++c) {
                Wtc tc = this.getTc(r, c);
                Element pr = DocxUtil.addElement(tc.getSrc(), "tcPr");
                if (rowspan > 1) {
                    if (r == rows) {
                        DocxUtil.addElement(pr, "vMerge", "val", "restart");
                    } else {
                        DocxUtil.addElement(pr, "vMerge");
                    }
                }
                if (colspan <= 1) continue;
                if (c == cols) {
                    DocxUtil.addElement(pr, "gridSpan", "val", colspan + "");
                    continue;
                }
                tc.remove();
            }
        }
        this.reload();
        return this;
    }

    public List<Wtr> getTrs() {
        return this.wtrs;
    }

    public Wtr getTr(int index) {
        return this.wtrs.get(index);
    }

    public Wtc getTc(int rows, int cols) {
        Wtr wtr = this.getTr(rows);
        if (null == wtr) {
            return null;
        }
        return wtr.getTc(cols);
    }

    public Wtable removeBorder() {
        this.removeTopBorder();
        this.removeBottomBorder();
        this.removeLeftBorder();
        this.removeRightBorder();
        this.removeInsideHBorder();
        this.removeInsideVBorder();
        this.removeTl2brBorder();
        this.removeTr2blBorder();
        return this;
    }

    public Wtable removeTopBorder() {
        this.removeBorder(this.src, "top");
        return this;
    }

    public Wtable removeLeftBorder() {
        this.removeBorder(this.src, "left");
        return this;
    }

    public Wtable removeRightBorder() {
        this.removeBorder(this.src, "right");
        return this;
    }

    public Wtable removeBottomBorder() {
        this.removeBorder(this.src, "bottom");
        return this;
    }

    public Wtable removeInsideVBorder() {
        this.removeBorder(this.src, "insideV");
        return this;
    }

    public Wtable removeTl2brBorder() {
        this.removeBorder(this.src, "tl2br");
        return this;
    }

    public Wtable removeTr2blBorder() {
        this.removeBorder(this.src, "tr2bl");
        return this;
    }

    public Wtable removeInsideHBorder() {
        this.removeBorder(this.src, "insideH");
        return this;
    }

    public Wtable removeTcBorder() {
        for (Wtr tr : this.wtrs) {
            List<Wtc> tcs = tr.getTcs();
            for (Wtc tc : tcs) {
                tc.removeBorder();
            }
        }
        return this;
    }

    public Wtable removeTcColor() {
        for (Wtr tr : this.wtrs) {
            List<Wtc> tcs = tr.getTcs();
            for (Wtc tc : tcs) {
                tc.removeColor();
            }
        }
        return this;
    }

    public Wtable removeTcBackgroundColor() {
        for (Wtr tr : this.wtrs) {
            List<Wtc> tcs = tr.getTcs();
            for (Wtc tc : tcs) {
                tc.removeBackgroundColor();
            }
        }
        return this;
    }

    private void removeBorder(Element tbl, String side) {
        Element tcPr = DocxUtil.addElement(tbl, "tblPr");
        Element borders = DocxUtil.addElement(tcPr, "tblBorders");
        Element border = DocxUtil.addElement(borders, side);
        border.addAttribute("w:val", "nil");
        DocxUtil.removeAttribute(border, "sz");
        DocxUtil.removeAttribute(border, "space");
        DocxUtil.removeAttribute(border, "color");
    }

    public Wtr removeTopBorder(int rows) {
        Wtr tr = this.getTr(rows);
        List<Wtc> tcs = tr.getTcs();
        for (Wtc tc : tcs) {
            tc.removeTopBorder();
        }
        return tr;
    }

    public Wtr removeBottomBorder(int rows) {
        Wtr tr = this.getTr(rows);
        List<Wtc> tcs = tr.getTcs();
        for (Wtc tc : tcs) {
            tc.removeBottomBorder();
        }
        return tr;
    }

    public Wtable removeLeftBorder(int cols) {
        for (Wtr tr : this.wtrs) {
            Wtc tc = tr.getTcWithColspan(cols, true);
            if (null == tc) continue;
            tc.removeLeftBorder();
        }
        return this;
    }

    public Wtable removeRightBorder(int cols) {
        for (Wtr tr : this.wtrs) {
            Wtc tc = tr.getTcWithColspan(cols, false);
            if (null == tc) continue;
            tc.removeRightBorder();
        }
        return this;
    }

    public Wtc removeLeftBorder(int rows, int cols) {
        return this.getTc(rows, cols).removeLeftBorder();
    }

    public Wtc removeRightBorder(int rows, int cols) {
        return this.getTc(rows, cols).removeRightBorder();
    }

    public Wtc removeTopBorder(int rows, int cols) {
        return this.getTc(rows, cols).removeTopBorder();
    }

    public Wtc removeBottomBorder(int rows, int cols) {
        return this.getTc(rows, cols).removeBottomBorder();
    }

    public Wtc removeTl2brBorder(int rows, int cols) {
        return this.getTc(rows, cols).removeTl2brBorder();
    }

    public Wtc removeTr2blBorder(int rows, int cols) {
        return this.getTc(rows, cols).removeBorder();
    }

    public Wtc removeBorder(int rows, int cols) {
        return this.getTc(rows, cols).removeLeftBorder().removeRightBorder().removeTopBorder().removeBottomBorder().removeTl2brBorder().removeTr2blBorder();
    }

    public Wtc setBorder(int rows, int cols) {
        return this.getTc(rows, cols).setLeftBorder().setRightBorder().setTopBorder().setBottomBorder().setTl2brBorder().setTr2blBorder();
    }

    public Wtc setBorder(int rows, int cols, int size, String color, String style) {
        return this.getTc(rows, cols).setBorder(size, color, style);
    }

    public Wtc setLeftBorder(int rows, int cols) {
        return this.getTc(rows, cols).setLeftBorder();
    }

    public Wtc setRightBorder(int rows, int cols) {
        return this.getTc(rows, cols).setRightBorder();
    }

    public Wtc setTopBorder(int rows, int cols) {
        return this.getTc(rows, cols).setTopBorder();
    }

    public Wtc setBottomBorder(int rows, int cols) {
        return this.getTc(rows, cols).setBottomBorder();
    }

    public Wtc setTl2brBorder(int rows, int cols) {
        return this.getTc(rows, cols).setTl2brBorder();
    }

    public Wtc setTl2brBorder(int rows, int cols, String top, String bottom) {
        return this.getTc(rows, cols).setTl2brBorder(top, bottom);
    }

    public Wtc setTr2blBorder(int rows, int cols) {
        return this.getTc(rows, cols).setTr2blBorder();
    }

    public Wtc setTr2blBorder(int rows, int cols, String top, String bottom) {
        return this.getTc(rows, cols).setTr2blBorder(top, bottom);
    }

    public Wtc setLeftBorder(int rows, int cols, int size, String color, String style) {
        return this.getTc(rows, cols).setLeftBorder(size, color, style);
    }

    public Wtc setRightBorder(int rows, int cols, int size, String color, String style) {
        return this.getTc(rows, cols).setRightBorder(size, color, style);
    }

    public Wtc setTopBorder(int rows, int cols, int size, String color, String style) {
        return this.getTc(rows, cols).setTopBorder(size, color, style);
    }

    public Wtc setBottomBorder(int rows, int cols, int size, String color, String style) {
        return this.getTc(rows, cols).setBottomBorder(size, color, style);
    }

    public Wtc setTl2brBorder(int rows, int cols, int size, String color, String style) {
        return this.getTc(rows, cols).setTl2brBorder(size, color, style);
    }

    public Wtc setTr2blBorder(int rows, int cols, int size, String color, String style) {
        return this.getTc(rows, cols).setTr2blBorder(size, color, style);
    }

    public Wtc setColor(int rows, int cols, String color) {
        return this.getTc(rows, cols).setColor(color);
    }

    public Wtc setFont(int rows, int cols, String size, String eastAsia, String ascii, String hint) {
        return this.getTc(rows, cols).setFont(size, eastAsia, ascii, hint);
    }

    public Wtc setFontSize(int rows, int cols, String size) {
        return this.getTc(rows, cols).setFontSize(size);
    }

    public Wtc setFontFamily(int rows, int cols, String font) {
        return this.getTc(rows, cols).setFontFamily(font);
    }

    public Wtc setWidth(int rows, int cols, String width) {
        return this.getTc(rows, cols).setWidth(width);
    }

    public Wtc setWidth(int rows, int cols, int width) {
        return this.getTc(rows, cols).setWidth(width);
    }

    public Wtc setWidth(int rows, int cols, double width) {
        return this.getTc(rows, cols).setWidth(width);
    }

    public Wtable setWidth(int cols, String width) {
        for (Wtr tr : this.wtrs) {
            tr.getTc(cols).setWidth(width);
        }
        return this;
    }

    public Wtable setWidth(int cols, int width) {
        for (Wtr tr : this.wtrs) {
            tr.getTc(cols).setWidth(width);
        }
        return this;
    }

    public Wtable setWidth(int cols, double width) {
        for (Wtr tr : this.wtrs) {
            tr.getTc(cols).setWidth(width);
        }
        return this;
    }

    public Wtr setHeight(int rows, String height) {
        Wtr tr = this.getTr(rows);
        tr.setHeight(height);
        return tr;
    }

    public Wtr setHeight(int rows, int height) {
        return this.setHeight(rows, height + this.widthUnit);
    }

    public Wtr setHeight(int rows, double height) {
        return this.setHeight(rows, height + this.widthUnit);
    }

    public Wtc setAlign(int rows, int cols, String align) {
        return this.getTc(rows, cols).setAlign(align);
    }

    public Wtc setVerticalAlign(int rows, int cols, String align) {
        return this.getTc(rows, cols).setVerticalAlign(align);
    }

    public Wtc setBottomPadding(int rows, int cols, String padding) {
        return this.getTc(rows, cols).setBottomPadding(padding);
    }

    public Wtc setBottomPadding(int rows, int cols, int padding) {
        return this.getTc(rows, cols).setBottomPadding(padding);
    }

    public Wtc setBottomPadding(int rows, int cols, double padding) {
        return this.getTc(rows, cols).setBottomPadding(padding);
    }

    public Wtc setTopPadding(int rows, int cols, String padding) {
        return this.getTc(rows, cols).setTopPadding(padding);
    }

    public Wtc setTopPadding(int rows, int cols, int padding) {
        return this.getTc(rows, cols).setTopPadding(padding);
    }

    public Wtc setTopPadding(int rows, int cols, double padding) {
        return this.getTc(rows, cols).setTopPadding(padding);
    }

    public Wtc setRightPadding(int rows, int cols, String padding) {
        return this.getTc(rows, cols).setRightPadding(padding);
    }

    public Wtc setRightPadding(int rows, int cols, int padding) {
        return this.getTc(rows, cols).setRightPadding(padding);
    }

    public Wtc setRightPadding(int rows, int cols, double padding) {
        return this.getTc(rows, cols).setRightPadding(padding);
    }

    public Wtc setLeftPadding(int rows, int cols, String padding) {
        return this.getTc(rows, cols).setLeftPadding(padding);
    }

    public Wtc setLeftPadding(int rows, int cols, int padding) {
        return this.getTc(rows, cols).setLeftPadding(padding);
    }

    public Wtc setLeftPadding(int rows, int cols, double padding) {
        return this.getTc(rows, cols).setLeftPadding(padding);
    }

    public Wtc setPadding(int rows, int cols, String side, String padding) {
        return this.getTc(rows, cols).setPadding(side, padding);
    }

    public Wtc setPadding(int rows, int cols, String side, int padding) {
        return this.getTc(rows, cols).setPadding(side, padding);
    }

    public Wtc setPadding(int rows, int cols, String side, double padding) {
        return this.getTc(rows, cols).setPadding(side, padding);
    }

    public Wtc setBackgroundColor(int rows, int cols, String color) {
        return this.getTc(rows, cols).setBackgroundColor(color);
    }

    public Wtc removeStyle(int rows, int cols) {
        return this.getTc(rows, cols).removeStyle();
    }

    public Wtc removeBackgroundColor(int rows, int cols) {
        return this.getTc(rows, cols).removeBackgroundColor();
    }

    public Wtc removeColor(int rows, int cols) {
        return this.getTc(rows, cols).removeColor();
    }

    public Wtc setBold(int rows, int cols, boolean bold) {
        return this.getTc(rows, cols).setBold(bold);
    }

    public Wtc setBold(int rows, int cols) {
        return this.setBold(rows, cols, true);
    }

    public Wtc setUnderline(int rows, int cols, boolean underline) {
        return this.getTc(rows, cols).setUnderline(underline);
    }

    public Wtc setUnderline(int rows, int cols) {
        return this.setUnderline(rows, cols, true);
    }

    public Wtc setStrike(int rows, int cols, boolean strike) {
        return this.getTc(rows, cols).setStrike(strike);
    }

    public Wtc setStrike(int rows, int cols) {
        return this.setStrike(rows, cols, true);
    }

    public Wtc setItalic(int rows, int cols, boolean italic) {
        return this.getTc(rows, cols).setItalic(italic);
    }

    public Wtc setItalic(int rows, int cols) {
        return this.setItalic(rows, cols, true);
    }

    public Wtc replace(int rows, int cols, String src, String tar) {
        return this.getTc(rows, cols).replace(src, tar);
    }

    public String getWidthUnit() {
        return this.widthUnit;
    }

    public void setWidthUnit(String widthUnit) {
        this.widthUnit = widthUnit;
        for (Wtr tr : this.wtrs) {
            tr.setWidthUnit(widthUnit);
        }
    }
}

