/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.office.docx.entity;

import java.util.ArrayList;
import java.util.List;
import org.anyline.office.docx.entity.WDocument;
import org.anyline.office.docx.entity.Wt;
import org.anyline.office.docx.util.DocxUtil;
import org.dom4j.Element;

public class Wr {
    private WDocument doc;
    private Element src;

    public Wr(WDocument doc, Element src) {
        this.doc = doc;
        this.src = src;
    }

    public WDocument getDoc() {
        return this.doc;
    }

    public void setDoc(WDocument doc) {
        this.doc = doc;
    }

    public Element getSrc() {
        return this.src;
    }

    public void setSrc(Element src) {
        this.src = src;
    }

    public List<Wt> getWts() {
        ArrayList<Wt> wts = new ArrayList<Wt>();
        List ts = this.src.elements("t");
        for (Element t : ts) {
            Wt wt = new Wt(this.doc, t);
            wts.add(wt);
        }
        return wts;
    }

    public List<String> getTexts() {
        ArrayList<String> texts = new ArrayList<String>();
        List ts = this.src.elements("t");
        for (Element t : ts) {
            texts.add(t.getTextTrim());
        }
        return texts;
    }

    public String getText() {
        Element t = this.src.element("t");
        if (null != t) {
            return t.getText();
        }
        return null;
    }

    public Wr setColor(String color) {
        Element pr = DocxUtil.addElement(this.src, "rPr");
        DocxUtil.addElement(pr, "color", "val", color.replace("#", ""));
        return this;
    }

    public Wr setFont(String size, String eastAsia, String ascii, String hint) {
        int pt = DocxUtil.fontSize(size);
        Element pr = DocxUtil.addElement(this.src, "rPr");
        DocxUtil.addElement(pr, "sz", "val", pt + "");
        DocxUtil.addElement(pr, "rFonts", "eastAsia", eastAsia);
        DocxUtil.addElement(pr, "rFonts", "ascii", ascii);
        DocxUtil.addElement(pr, "rFonts", "hint", hint);
        return this;
    }

    public Wr setFontSize(String size) {
        int pt = DocxUtil.fontSize(size);
        Element pr = DocxUtil.addElement(this.src, "rPr");
        DocxUtil.addElement(pr, "sz", "val", pt + "");
        return this;
    }

    public Wr setFontFamily(String font) {
        Element pr = DocxUtil.addElement(this.src, "rPr");
        DocxUtil.addElement(pr, "rFonts", "eastAsia", font);
        DocxUtil.addElement(pr, "rFonts", "ascii", font);
        DocxUtil.addElement(pr, "rFonts", "hAnsi", font);
        DocxUtil.addElement(pr, "rFonts", "cs", font);
        DocxUtil.addElement(pr, "rFonts", "hint", font);
        return this;
    }

    public Wr setBackgroundColor(String color) {
        Element pr = DocxUtil.addElement(this.src, "rPr");
        DocxUtil.addElement(pr, "highlight", "val", color.replace("#", ""));
        return this;
    }

    public Wr setBold(boolean bold) {
        Element pr = DocxUtil.addElement(this.src, "rPr");
        Element b = pr.element("b");
        if (bold) {
            if (null == b) {
                pr.addElement("w:b");
            }
        } else if (null != b) {
            pr.remove(b);
        }
        return this;
    }

    public Wr setUnderline(boolean underline) {
        Element pr = DocxUtil.addElement(this.src, "rPr");
        Element u = pr.element("u");
        if (underline) {
            if (null == u) {
                DocxUtil.addElement(pr, "u", "val", "single");
            }
        } else if (null != u) {
            pr.remove(u);
        }
        return this;
    }

    public Wr setStrike(boolean strike) {
        Element pr = DocxUtil.addElement(this.src, "rPr");
        Element s = pr.element("strike");
        if (strike) {
            if (null == s) {
                pr.addElement("w:strike");
            }
        } else if (null != s) {
            pr.remove(s);
        }
        return this;
    }

    public Wr setVerticalAlign(String align) {
        Element pr = DocxUtil.addElement(this.src, "rPr");
        DocxUtil.addElement(pr, "vertAlign", "val", align);
        return this;
    }

    public Wr setItalic(boolean italic) {
        Element pr = DocxUtil.addElement(this.src, "rPr");
        Element i = pr.element("i");
        if (italic) {
            if (null == i) {
                pr.addElement("w:i");
            }
        } else if (null != i) {
            pr.remove(i);
        }
        return this;
    }

    public Wr removeStyle() {
        Element pr = this.src.element("rPr");
        if (null != pr) {
            this.src.remove(pr);
        }
        return this;
    }

    public Wr removeBackgroundColor() {
        DocxUtil.removeElement(this.src, "highlight");
        return this;
    }

    public Wr removeColor() {
        DocxUtil.removeElement(this.src, "color");
        return this;
    }

    public Wr replace(String src, String tar) {
        List<Wt> wts = this.getWts();
        for (Wt wt : wts) {
            String text = wt.getText();
            text = text.replace(src, tar);
            wt.setText(text);
        }
        return this;
    }
}

