/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.office.docx.entity;

import java.util.ArrayList;
import java.util.List;
import org.anyline.office.docx.entity.WDocument;
import org.anyline.office.docx.entity.Wr;
import org.anyline.office.docx.util.DocxUtil;
import org.anyline.util.DomUtil;
import org.dom4j.Element;

public class Wp {
    private WDocument doc;
    private Element src;
    private List<Wr> wrs = new ArrayList<Wr>();

    public Wp(WDocument doc, Element src) {
        this.doc = doc;
        this.src = src;
        this.load();
    }

    public void reload() {
        this.load();
    }

    private void load() {
        this.wrs.clear();
        List elements = this.src.elements("r");
        for (Element element : elements) {
            Wr wr = new Wr(this.doc, element);
            this.wrs.add(wr);
        }
    }

    public Wp setColor(String color) {
        for (Wr wr : this.wrs) {
            wr.setColor(color);
        }
        Element pr = DocxUtil.addElement(this.src, "pPr");
        DocxUtil.addElement(pr, "color", "val", color.replace("#", ""));
        return this;
    }

    public Wp setFont(String size, String eastAsia, String ascii, String hint) {
        for (Wr wr : this.wrs) {
            wr.setFont(size, eastAsia, ascii, hint);
        }
        int pt = DocxUtil.fontSize(size);
        Element pr = DocxUtil.addElement(this.src, "pPr");
        DocxUtil.addElement(pr, "sz", "val", pt + "");
        DocxUtil.addElement(pr, "rFonts", "eastAsia", eastAsia);
        DocxUtil.addElement(pr, "rFonts", "ascii", ascii);
        DocxUtil.addElement(pr, "rFonts", "hint", hint);
        return this;
    }

    public Wp setFontSize(String size) {
        for (Wr wr : this.wrs) {
            wr.setFontSize(size);
        }
        int pt = DocxUtil.fontSize(size);
        Element pr = DocxUtil.addElement(this.src, "pPr");
        DocxUtil.addElement(pr, "sz", "val", pt + "");
        return this;
    }

    public Wp setFontFamily(String font) {
        for (Wr wr : this.wrs) {
            wr.setFontFamily(font);
        }
        Element pr = DocxUtil.addElement(this.src, "pPr");
        DocxUtil.addElement(pr, "rFonts", "eastAsia", font);
        DocxUtil.addElement(pr, "rFonts", "ascii", font);
        DocxUtil.addElement(pr, "rFonts", "hAnsi", font);
        DocxUtil.addElement(pr, "rFonts", "cs", font);
        DocxUtil.addElement(pr, "rFonts", "hint", font);
        return this;
    }

    public Wp setAlign(String align) {
        Element pr = DocxUtil.addElement(this.src, "pPr");
        DocxUtil.addElement(pr, "jc", "val", align);
        return this;
    }

    public Wp setBackgroundColor(String color) {
        Element pr = DocxUtil.addElement(this.src, "pPr");
        DocxUtil.addElement(pr, "highlight", "val", color.replace("#", ""));
        for (Wr wr : this.wrs) {
            wr.setBackgroundColor(color);
        }
        return this;
    }

    public Wp setBold(boolean bold) {
        Element pr = DocxUtil.addElement(this.src, "pPr");
        Element b = pr.element("b");
        if (bold) {
            if (null == b) {
                pr.addElement("w:b");
            }
        } else if (null != b) {
            pr.remove(b);
        }
        for (Wr wr : this.wrs) {
            wr.setBold(bold);
        }
        return this;
    }

    public Wp setUnderline(boolean underline) {
        Element pr = DocxUtil.addElement(this.src, "pPr");
        Element u = pr.element("u");
        if (underline) {
            if (null == u) {
                DocxUtil.addElement(pr, "u", "val", "single");
            }
        } else if (null != u) {
            pr.remove(u);
        }
        for (Wr wr : this.wrs) {
            wr.setUnderline(underline);
        }
        return this;
    }

    public Wp setStrike(boolean strike) {
        Element pr = DocxUtil.addElement(this.src, "pPr");
        Element s = pr.element("strike");
        if (strike) {
            if (null == s) {
                pr.addElement("w:strike");
            }
        } else if (null != s) {
            pr.remove(s);
        }
        for (Wr wr : this.wrs) {
            wr.setStrike(strike);
        }
        return this;
    }

    public Wp setItalic(boolean italic) {
        Element pr = DocxUtil.addElement(this.src, "pPr");
        Element i = pr.element("i");
        if (italic) {
            if (null == i) {
                pr.addElement("w:i");
            }
        } else if (null != i) {
            pr.remove(i);
        }
        for (Wr wr : this.wrs) {
            wr.setItalic(italic);
        }
        return this;
    }

    public Wp removeStyle() {
        Element pr = this.src.element("pPr");
        if (null != pr) {
            this.src.remove(pr);
        }
        for (Wr wr : this.wrs) {
            wr.removeStyle();
        }
        return this;
    }

    public Wp removeBackgroundColor() {
        DocxUtil.removeElement(this.src, "shd");
        return this;
    }

    public Wp removeColor() {
        DocxUtil.removeElement(this.src, "color");
        return this;
    }

    public List<String> getTexts() {
        ArrayList<String> texts = new ArrayList<String>();
        List ts = DomUtil.elements((Element)this.src, (String)"t");
        for (Element t : ts) {
            texts.add(t.getTextTrim());
        }
        return texts;
    }

    public String getText() {
        Element t = this.src.element("t");
        if (null != t) {
            return t.getText();
        }
        return null;
    }

    public Wp addWr(Wr wr) {
        this.wrs.add(wr);
        return this;
    }

    public Wp replace(String src, String tar) {
        for (Wr wr : this.wrs) {
            wr.replace(src, tar);
        }
        return this;
    }
}

