/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.office.docx.entity;

import java.io.File;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.anyline.entity.html.Table;
import org.anyline.entity.html.Td;
import org.anyline.entity.html.Tr;
import org.anyline.net.HttpUtil;
import org.anyline.office.docx.entity.Wtable;
import org.anyline.office.docx.util.DocxUtil;
import org.anyline.util.BasicUtil;
import org.anyline.util.DomUtil;
import org.anyline.util.NumberUtil;
import org.anyline.util.StyleParser;
import org.anyline.util.ZipUtil;
import org.anyline.util.regular.RegularUtil;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.security.action.GetPropertyAction;

public class WDocument {
    private static Logger log = LoggerFactory.getLogger(WDocument.class);
    private File file;
    private String xml = null;
    private Document doc = null;
    private Element body = null;
    private String relsXml = null;
    private Document relsDoc;
    private Map<String, Map<String, String>> styles = new HashMap<String, Map<String, String>>();
    private Map<String, String> replaces = new HashMap<String, String>();
    private int listNum = 0;

    public Element getBody() {
        return this.body;
    }

    public void setBody(Element body) {
        this.body = body;
    }

    public WDocument(File file) {
        this.file = file;
    }

    public WDocument(String file) {
        this.file = new File(file);
    }

    private void load() {
        if (null == this.xml) {
            try {
                this.xml = ZipUtil.read((File)this.file, (String)"word/document.xml");
                this.relsXml = ZipUtil.read((File)this.file, (String)"word/_rels/document.xml.rels");
                this.doc = DocumentHelper.parseText((String)this.xml);
                this.relsDoc = DocumentHelper.parseText((String)this.relsXml);
                this.body = this.doc.getRootElement().element("body");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void reload() {
        try {
            this.xml = ZipUtil.read((File)this.file, (String)"word/document.xml");
            this.relsXml = ZipUtil.read((File)this.file, (String)"word/_rels/document.xml.rels");
            this.doc = DocumentHelper.parseText((String)this.xml);
            this.relsDoc = DocumentHelper.parseText((String)this.relsXml);
            this.body = this.doc.getRootElement().element("body");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void flush() {
        try {
            this.xml = DomUtil.format((Document)this.doc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadStyle(String html) {
        Map map = StyleParser.load((String)html);
        for (String key : map.keySet()) {
            this.styles.put(key, (Map<String, String>)map.get(key));
        }
    }

    public void replace(String key, String content) {
        if (null == key && key.trim().length() == 0) {
            return;
        }
        this.replaces.put(key, content);
    }

    public void insert(Element parent, String html) {
        this.parseHtml(parent, null, html);
    }

    public void insert(int index, Element parent, String html) {
        List elements = parent.elements();
        if (index <= 1) {
            index = 1;
        } else if (index >= elements.size()) {
            index = elements.size() - 1;
        }
        Element prev = (Element)elements.get(index - 1);
        this.parseHtml(parent, null, html);
    }

    public Element getParent(String bookmark, String tag) {
        this.load();
        Element bk = DocxUtil.bookmark(this.doc.getRootElement(), bookmark);
        return DocxUtil.getParent(bk, tag);
    }

    public Wtable getTable(String bookmark) {
        Element src = this.getParent(bookmark, "tbl");
        Wtable table = new Wtable(this, src);
        return table;
    }

    public void setOrient(Element prev, String orient, Map<String, String> styles) {
        int index = WDocument.index(this.body, prev);
        Element p = this.body.addElement("w:p");
        Element pr = p.addElement("pPr");
        DocxUtil.setOrient(pr, orient, styles);
        List elements = this.body.elements();
        if (index > -1 && index < elements.size() - 1) {
            elements.remove(p);
            elements.add(index + 1, p);
        }
    }

    public void setOrient(Element prev, String orient) {
        this.setOrient(prev, orient, null);
    }

    public void insertPageBreak(Element prev) {
        int index = WDocument.index(this.body, prev);
        Element p = this.body.addElement("w:p");
        p.addElement("w:r").addElement("w:br").addAttribute("w:type", "page");
        p.addElement("w:r").addElement("w:lastRenderedPageBreak");
        List elements = this.body.elements();
        if (index > -1 && index < elements.size() - 1) {
            elements.remove(p);
            elements.add(index + 1, p);
        }
    }

    public static int index(Element parent, Element element) {
        int index = parent.indexOf((Node)element);
        while (element.getParent() != parent) {
            if ((element = element.getParent()).getParent() != parent) continue;
            index = parent.indexOf((Node)element);
            break;
        }
        return index;
    }

    private void replaceBookmark(Element start) {
        String id = start.attributeValue("id");
        Element end = DomUtil.element((Element)this.body, (String)"bookmarkEnd", (String)"id", (String)id);
        String name = start.attributeValue("name");
        String content = this.replaces.get(name);
        if (null == content) {
            return;
        }
        boolean isblock = DocxUtil.isBlock(content);
        Element startParent = start.getParent();
        Element endParent = end.getParent();
        if (isblock) {
            if (startParent == endParent) {
                Element nEndP = startParent.getParent().addElement("w:p");
                endParent.elements().remove(end);
                nEndP.elements().add(end);
                DocxUtil.after(nEndP, startParent);
            }
            DomUtil.remove((Element)startParent, (List)DomUtil.afters((Element)start, (String)"t"));
            DomUtil.remove((Element)endParent, (List)DomUtil.befores((Element)end, (String)"t"));
            this.parseHtml(startParent.getParent(), startParent, content);
        } else if (startParent == endParent) {
            DomUtil.remove((Element)startParent, (List)DomUtil.betweens((Element)start, (Element)end, (String[])new String[]{"t"}));
            this.parseHtml(startParent, start, content);
        } else {
            DomUtil.remove((Element)startParent, (List)DomUtil.afters((Element)start, (String)"t"));
            DomUtil.remove((Element)endParent, (List)DomUtil.befores((Element)end, (String)"t"));
            this.parseHtml(startParent, start, content);
        }
    }

    public Element pr(Element element, Map<String, String> styles) {
        return DocxUtil.pr(element, styles);
    }

    private List<Element> parseHtml(Element box, Element prev, String html) {
        ArrayList<Element> list = new ArrayList<Element>();
        if (null == html || html.trim().length() == 0) {
            return list;
        }
        this.styles.clear();
        List styles = RegularUtil.cuts((String)html, (boolean)true, (String[])new String[]{"<style", ">", "</style>"});
        for (String style : styles) {
            this.loadStyle(style);
            html = html.replace(style, "");
        }
        try {
            html = "<root>" + html + "</root>";
            Document doc = DocumentHelper.parseText((String)html);
            Element root = doc.getRootElement();
            this.parseHtml(box, prev, root, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public Element parent(Element element, String ... tags) {
        Element parent = null;
        if (this.contains(tags, element.getName())) {
            return element;
        }
        parent = element.getParent();
        if (null == parent) {
            return null;
        }
        while (!this.contains(tags, parent.getName()) && null != (parent = parent.getParent())) {
        }
        return parent;
    }

    public Element pp(Element element) {
        String tag = "p";
        Element parent = null;
        if (element.getName().equalsIgnoreCase(tag)) {
            parent = element.getParent();
        } else if (element.getName().equalsIgnoreCase("tc")) {
            parent = element;
        } else {
            parent = element.getParent();
            while (true) {
                if (null == parent) {
                    return this.doc.getRootElement().element("body");
                }
                if (parent.getName().equalsIgnoreCase(tag)) {
                    parent = parent.getParent();
                    break;
                }
                if (parent.getName().equalsIgnoreCase("tc")) break;
                parent = parent.getParent();
            }
        }
        return parent;
    }

    public Element p(Element element) {
        return this.parent(element, "p");
    }

    private boolean contains(String[] list, String item) {
        for (String i : list) {
            if (!i.equalsIgnoreCase(item)) continue;
            return true;
        }
        return false;
    }

    private void split(Element element) {
        Element parent = this.parent(element, "p");
        int pindex = DocxUtil.index(parent);
        this.split(parent.getParent(), parent, element, pindex);
    }

    private Element split(Element box, Element parent, Element stop, int index) {
        Element element = null;
        if (null != parent) {
            List elements = parent.elements();
            for (Element item : elements) {
            }
        }
        return element;
    }

    public Element table(Element box, Element after, Element src) {
        int r;
        Element tbl = this.body.addElement("w:tbl");
        Element tblPr = tbl.addElement("w:tblPr");
        Table table = new Table();
        Map<String, String> styles = this.style(src);
        this.pr(tbl, styles);
        table.setStyles(styles);
        List html_rows = src.elements("tr");
        for (Element row : html_rows) {
            Tr tr = new Tr();
            tr.setStyles(this.style(row));
            table.addTr(tr);
        }
        int rows_size = html_rows.size();
        int cols_size = 0;
        if (rows_size > 0) {
            Element html_row = (Element)html_rows.get(0);
            List cols = html_row.elements("td");
            for (Element col : cols) {
                int colspan = BasicUtil.parseInt((Object)col.attributeValue("colspan"), (int)1);
                cols_size += colspan;
            }
        }
        Td[][] cells = new Td[rows_size][cols_size];
        for (r = 0; r < rows_size; ++r) {
            Tr tr = table.getTr(r);
            for (int c = 0; c < cols_size; ++c) {
                Td td;
                cells[r][c] = td = new Td();
                tr.addTd(td);
            }
        }
        for (r = 0; r < rows_size; ++r) {
            Element html_row = (Element)html_rows.get(r);
            String row_style = html_row.attributeValue("style");
            List cols = html_row.elements("td");
            int tcIndex = 0;
            int tdIndex = 0;
            while (tdIndex < cols.size()) {
                Element html_col = (Element)cols.get(tdIndex);
                String text = html_col.getTextTrim();
                Td tc = cells[r][tcIndex];
                int merge_qty = 0;
                while (!tc.isEmpty()) {
                    tc = cells[r][tcIndex + ++merge_qty];
                }
                tc.setSrc(html_col);
                tc.setText(text);
                Map tdStyles = StyleParser.merge((Map)tc.getStyles(), this.style(html_col));
                tdStyles = StyleParser.parse((Map)tdStyles, (String)html_col.attributeValue("style"), (boolean)true);
                tc.setStyles(tdStyles);
                tc.setClazz(html_col.attributeValue("class"));
                int rowspan = BasicUtil.parseInt((Object)html_col.attributeValue("rowspan"), (int)1);
                int colspan = BasicUtil.parseInt((Object)html_col.attributeValue("colspan"), (int)1);
                if (rowspan > 1) {
                    tc.setMerge(1);
                    for (int i = r + 1; i <= r + rowspan - 1; ++i) {
                        for (int j = tcIndex + 1; j < tcIndex + colspan; ++j) {
                            Td merge = cells[i][j];
                            merge.setRemove(true);
                        }
                        Td merge = cells[i][tcIndex + merge_qty];
                        merge.setMerge(2);
                    }
                }
                if (colspan > 1) {
                    tc.setColspan(colspan);
                    for (int j = r; j < r + rowspan; ++j) {
                        if (j > r) {
                            Td merge = cells[j][tcIndex];
                            merge.setMerge(2);
                            merge.setColspan(colspan);
                        }
                        for (int i = tcIndex + merge_qty + 1; i < tcIndex + merge_qty + colspan; ++i) {
                            Td cur = cells[j][i];
                            cur.setRemove(true);
                        }
                    }
                }
                tcIndex += colspan - 1;
                ++tdIndex;
                ++tcIndex;
            }
        }
        Element word = src.element("word");
        if (null != word) {
            this.word(tbl, null, word, styles);
        }
        for (int r2 = 0; r2 < rows_size; ++r2) {
            Tr tr = table.getTr(r2);
            this.tr(tbl, tr);
        }
        DocxUtil.after(tbl, after);
        return tbl;
    }

    public Element tr(Element parent, Tr tr) {
        Element etr = parent.addElement("w:tr");
        Map styles = StyleParser.inherit((Map)tr.getStyles(), (Map)tr.getTable().getStyles());
        tr.setStyles(styles);
        this.pr(etr, tr.getStyles());
        for (Td td : tr.getTds()) {
            Element tc = this.tc(etr, td);
        }
        return etr;
    }

    public Element tc(Element parent, Td td) {
        Element tc = null;
        int merge = td.getMerge();
        int colspan = td.getColspan();
        boolean remove = td.isRemove();
        if (!remove) {
            tc = parent.addElement("w:tc");
            Element tcPr = DocxUtil.addElement(tc, "tcPr");
            if (merge > 0) {
                Element vMerge = tcPr.addElement("w:vMerge");
                if (merge == 1) {
                    vMerge.addAttribute("w:val", "restart");
                }
            }
            if (colspan > 1) {
                Element span = tcPr.addElement("w:gridSpan");
                span.addAttribute("w:val", colspan + "");
            }
            if (tcPr.elements().size() == 0) {
                // empty if block
            }
            Map styles = StyleParser.inherit((Map)td.getStyles(), (Map)td.getTr().getStyles());
            this.pr(tc, styles);
            if (merge != 2) {
                if (null != td.getSrc()) {
                    this.parseHtml(tc, null, td.getSrc(), StyleParser.inherit(null, (Map)styles));
                }
            } else {
                this.p(tc, "", null);
            }
        }
        return tc;
    }

    private Element inline(Element parent, Element prev, String text, Map<String, String> styles) {
        Element p;
        Element r;
        String pname = parent.getName();
        if (pname.equalsIgnoreCase("r")) {
            r = parent;
            this.pr(parent, styles);
            DocxUtil.after(r, prev);
        } else if (pname.equalsIgnoreCase("tc")) {
            p = parent.addElement("w:p");
            this.pr(p, styles);
            r = p.addElement("w:r");
            DocxUtil.after(r, prev);
        } else if (pname.equalsIgnoreCase("p")) {
            this.pr(parent, styles);
            r = parent.addElement("w:r");
            if ((null == styles || styles.isEmpty()) && null != prev) {
                Element prevR = null;
                if (prev.getName().equals("r")) {
                    prevR = prev;
                } else {
                    Element tmp = DocxUtil.prev(prev);
                    if (tmp.getName().equals("r")) {
                        prevR = tmp;
                    }
                }
                if (null != prevR) {
                    DocxUtil.copyStyle(r, prevR);
                }
            }
            DocxUtil.after(r, prev);
        } else if (pname.equalsIgnoreCase("body")) {
            p = parent.addElement("w:p");
            this.pr(p, styles);
            r = p.addElement("w:r");
            DocxUtil.after(p, prev);
        } else {
            throw new RuntimeException("text.parent\u5f02\u5e38:" + parent.getName());
        }
        this.pr(r, styles);
        Element t = r.addElement("w:t");
        t.setText(text.trim());
        return r;
    }

    public Element block(Element parent, Element prev, Element element, Map<String, String> styles) {
        Element box = null;
        String pname = parent.getName();
        Element newPrev = null;
        Element wp = null;
        this.pr(parent, styles);
        if (pname.equalsIgnoreCase("p")) {
            box = parent.addElement("w:r");
            prev = box.addElement("w:br");
            DocxUtil.after(box, prev);
            newPrev = parent;
            wp = parent;
        } else if (pname.equalsIgnoreCase("r")) {
            box = parent.getParent().addElement("w:r");
            prev = box.addElement("w:br");
            DocxUtil.after(box, prev);
            wp = newPrev = parent.getParent();
        } else if (pname.equalsIgnoreCase("tc")) {
            Element p = parent.element("p");
            box = null != p && DocxUtil.isEmpty(p) ? p : parent.addElement("w:p");
            DocxUtil.after(box, prev);
            newPrev = box;
            wp = box;
        } else if (pname.equalsIgnoreCase("body")) {
            newPrev = box = parent.addElement("w:p");
            DocxUtil.after(box, prev);
            wp = box;
        } else {
            throw new RuntimeException("div.parent \u5f02\u5e38:" + pname + ":" + element.getName() + ":" + element.getTextTrim());
        }
        this.pr(box, styles);
        this.parseHtml(box, prev, element, styles);
        if (null != styles && null != styles.get("page-break-after")) {
            wp.addElement("w:r").addElement("w:br").addAttribute("w:type", "page");
            wp.addElement("w:r").addElement("w:lastRenderedPageBreak");
        }
        return newPrev;
    }

    private Element ol(Element parent, Element prev, Element element, Map<String, String> styles) {
        styles = StyleParser.parse(styles, (String)element.attributeValue("style"), (boolean)true);
        if (!DocxUtil.hasParent(element, "ol")) {
            ++this.listNum;
        }
        List lis = element.elements();
        for (Element li : lis) {
            String liName = li.getName();
            if (liName.equalsIgnoreCase("ol")) {
                prev = this.ol(this.body, prev, li, styles);
                continue;
            }
            prev = this.li(this.body, prev, li, styles);
        }
        return prev;
    }

    private List<Map<String, String>> lis(Element parent) {
        ArrayList<Map<String, String>> lis = new ArrayList<Map<String, String>>();
        Iterator nodes = parent.nodeIterator();
        while (nodes.hasNext()) {
            Element element;
            String tag;
            Node node = (Node)nodes.next();
            short type = node.getNodeType();
            if (type == 3 || type != 1 || !(tag = (element = (Element)node).getName()).equalsIgnoreCase("li")) continue;
            HashMap<String, String> li = new HashMap<String, String>();
            li.put("tag", tag);
            lis.add(li);
        }
        return lis;
    }

    private Element li(Element parent, Element prev, Element element, Map<String, String> styles) {
        Element box = parent.addElement("w:p");
        int lvl = this.lvl(element);
        styles.put("list-lvl", lvl + "");
        styles.put("list-num", this.listNum + "");
        this.pr(box, styles);
        DocxUtil.after(box, prev);
        prev = this.parseHtml(box, prev, element, styles);
        return prev;
    }

    private int lvl(Element li) {
        int lvl = -1;
        while ((li = li.getParent()) != null) {
            if (!li.getName().equalsIgnoreCase("ol")) continue;
            ++lvl;
        }
        return lvl;
    }

    private Element word(Element parent, Element prev, Element element, Map<String, String> styles) {
        String path = element.getTextTrim();
        String bookmark = element.attributeValue("bookmark");
        return this.word(parent, prev, new File(path), bookmark, styles);
    }

    private Element word(Element parent, Element prev, File word, String bookmark, Map<String, String> styles) {
        Element newPrev = null;
        String wxml = ZipUtil.read((File)word, (String)"word/document.xml");
        try {
            Element wbody = DocumentHelper.parseText((String)wxml).getRootElement().element("body");
            List<Element> elements = null;
            if (null != bookmark) {
                Element start = DocxUtil.bookmark(wbody, bookmark);
                elements = DocxUtil.betweens(start, "tr", "tblGrid", "p");
            } else {
                elements = wbody.elements();
            }
            if (null != elements) {
                for (Element element : elements) {
                    String name = element.getName();
                    if ("sectPr".equalsIgnoreCase(name)) continue;
                    element.getParent().remove(element);
                    if (parent.getName().equalsIgnoreCase(element.getName())) {
                        this.addElements(parent, element.elements(), true);
                    } else {
                        parent.elements().add(element);
                    }
                    newPrev = element;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newPrev;
    }

    private void addElements(Element parent, List<Element> elements, boolean over) {
        for (Element element : elements) {
            String name = element.getName();
            element.getParent().remove(element);
            List exists = DomUtil.elements((Element)parent, (String)name, (boolean)false);
            if (null != exists && exists.size() > 0) {
                if (!over) continue;
                DomUtil.remove((Element)parent, (List)exists);
                parent.elements().add(element);
                continue;
            }
            parent.elements().add(element);
        }
    }

    private Element img(Element parent, Element prev, Element element, Map<String, String> styles) {
        int idx;
        Element p;
        Element r;
        String pname = parent.getName();
        if (pname.equalsIgnoreCase("r")) {
            r = parent;
            this.pr(parent, styles);
            DocxUtil.after(r, prev);
        } else if (pname.equalsIgnoreCase("tc")) {
            p = parent.element("p");
            if (null == p || !DocxUtil.isEmpty(p)) {
                p = parent.addElement("w:p");
            }
            this.pr(p, styles);
            r = p.addElement("w:r");
            DocxUtil.after(r, prev);
        } else if (pname.equalsIgnoreCase("p")) {
            this.pr(parent, styles);
            r = parent.addElement("w:r");
        } else if (pname.equalsIgnoreCase("body")) {
            p = parent.addElement("w:p");
            this.pr(p, styles);
            r = p.addElement("w:r");
            DocxUtil.after(p, prev);
        } else {
            throw new RuntimeException("text.parent\u5f02\u5e38:" + parent.getName());
        }
        styles = StyleParser.inherit(this.style(element), styles);
        this.pr(r, styles);
        String widthType = DocxUtil.widthType((String)styles.get("width"));
        int width = 0;
        if (!"pct".equalsIgnoreCase(widthType)) {
            width = DocxUtil.px2emu((int)DocxUtil.dxa2px(DocxUtil.dxa((String)styles.get("width"))));
        }
        String heightType = DocxUtil.widthType((String)styles.get("height"));
        int height = 0;
        if (!"pct".equalsIgnoreCase(heightType)) {
            height = DocxUtil.px2emu((int)DocxUtil.dxa2px(DocxUtil.dxa((String)styles.get("height"))));
        }
        String rdm = System.currentTimeMillis() + "";
        String rId = "rId" + rdm;
        String src = element.attributeValue("src");
        String subfix = element.attributeValue("type");
        if (null == subfix && (subfix = (idx = src.lastIndexOf(".")) != -1 ? src.substring(idx + 1) : "jpg").length() > 20) {
            subfix = "jpeg";
        }
        File tmpdir = new File(AccessController.doPrivileged(new GetPropertyAction("java.io.tmpdir")));
        File img = new File(tmpdir, "image" + rdm + "." + subfix);
        try {
            HttpUtil.download((String)src, (File)img);
            HashMap<String, File> map = new HashMap<String, File>();
            map.put("word/media/" + img.getName(), img);
            ZipUtil.append(map, (File)this.file);
            img.delete();
            Element relRoot = this.relsDoc.getRootElement();
            Element imgRel = relRoot.addElement("Relationship");
            imgRel.addAttribute("Id", rId);
            imgRel.addAttribute("Type", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/image");
            imgRel.addAttribute("Target", "media/" + img.getName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Element draw = r.addElement("w:drawing");
        Element inline = draw.addElement("wp:inline");
        inline.addAttribute("distT", "0");
        inline.addAttribute("distB", "0");
        inline.addAttribute("distL", "0");
        inline.addAttribute("distR", "0");
        Element extent = inline.addElement("wp:extent");
        extent.addAttribute("cx", width + "");
        extent.addAttribute("cy", height + "");
        Element effectExtent = inline.addElement("wp:effectExtent");
        effectExtent.addAttribute("l", "0");
        effectExtent.addAttribute("t", "0");
        effectExtent.addAttribute("r", "0");
        effectExtent.addAttribute("b", "0");
        Element docPr = inline.addElement("wp:docPr");
        int docPrId = NumberUtil.random((int)0, (int)100);
        docPr.addAttribute("id", docPrId + "");
        docPr.addAttribute("name", "\u56fe\u7247" + rdm);
        docPr.addAttribute("descr", img.getName());
        Element cNvGraphicFramePr = inline.addElement("wp:cNvGraphicFramePr");
        Element graphicFrameLocks = cNvGraphicFramePr.addElement("a:graphicFrameLocks", "http://schemas.openxmlformats.org/drawingml/2006/main");
        graphicFrameLocks.addAttribute("xmlns:a", "http://schemas.openxmlformats.org/drawingml/2006/main");
        graphicFrameLocks.addAttribute("noChangeAspect", "1");
        Element graphic = inline.addElement("a:graphic", "http://schemas.openxmlformats.org/drawingml/2006/main");
        graphic.addAttribute("xmlns:a", "http://schemas.openxmlformats.org/drawingml/2006/main");
        Element graphicData = graphic.addElement("a:graphicData");
        graphicData.addAttribute("uri", "http://schemas.openxmlformats.org/drawingml/2006/picture");
        Element pic = graphicData.addElement("pic:pic", "http://schemas.openxmlformats.org/drawingml/2006/picture");
        pic.addAttribute("xmlns:pic", "http://schemas.openxmlformats.org/drawingml/2006/picture");
        Element nvPicPr = pic.addElement("pic:nvPicPr");
        Element cNvPr = nvPicPr.addElement("pic:cNvPr");
        cNvPr.addAttribute("id", docPrId + "");
        cNvPr.addAttribute("name", img.getName());
        Element cNvPicPr = nvPicPr.addElement("pic:cNvPicPr");
        Element blipFill = pic.addElement("pic:blipFill");
        Element blip = blipFill.addElement("a:blip");
        blip.addAttribute("r:embed", rId);
        Element stretch = blipFill.addElement("a:stretch");
        Element fillRect = stretch.addElement("a:fillRect");
        Element spPr = pic.addElement("pic:spPr");
        Element xfrm = spPr.addElement("a:xfrm");
        Element off = xfrm.addElement("a:off");
        off.addAttribute("x", "0");
        off.addAttribute("y", "0");
        Element ext = xfrm.addElement("a:ext");
        ext.addAttribute("cx", width + "");
        ext.addAttribute("cy", height + "");
        Element prstGeom = spPr.addElement("a:prstGeom");
        prstGeom.addAttribute("prst", "rect");
        prstGeom.addElement("a:avLst");
        return r;
    }

    public Element parseHtml(Element parent, Element prev, Element html, Map<String, String> styles) {
        String pname = parent.getName();
        String txt = html.getTextTrim();
        if (html.elements().size() == 0) {
            txt = txt.trim();
            html.setText(txt);
        }
        Iterator nodes = html.nodeIterator();
        boolean empty = true;
        while (nodes.hasNext()) {
            Node node = (Node)nodes.next();
            String tag = node.getName();
            short type = node.getNodeType();
            if (type == 3) {
                Element r;
                String text = node.getText().trim();
                if (text.length() <= 0) continue;
                empty = false;
                prev = r = this.inline(parent, prev, text, styles);
                continue;
            }
            if (type != 1) continue;
            empty = false;
            Element element = (Element)node;
            Map itemStyles = StyleParser.inherit(this.style(element), styles);
            String display = (String)itemStyles.get("display");
            if ("none".equalsIgnoreCase(display)) continue;
            if ("table".equalsIgnoreCase(tag)) {
                Element tbl;
                Element box = null;
                if (pname.equalsIgnoreCase("tc")) {
                    box = parent;
                    this.pr(box, styles);
                } else {
                    box = pname.equalsIgnoreCase("p") ? parent.addElement("w:r") : this.doc.getRootElement().element("body");
                }
                prev = tbl = this.table(box, prev, element);
                continue;
            }
            if ("div".equalsIgnoreCase(tag)) {
                if ("inline".equalsIgnoreCase(display) || "inline-block".equalsIgnoreCase(display)) {
                    prev = this.parseHtml(parent, prev, element, itemStyles);
                    continue;
                }
                prev = this.block(parent, prev, element, itemStyles);
                continue;
            }
            if ("span".equalsIgnoreCase(tag)) {
                if ("block".equalsIgnoreCase(display)) {
                    prev = this.block(parent, prev, element, itemStyles);
                    continue;
                }
                prev = this.parseHtml(parent, prev, element, itemStyles);
                continue;
            }
            if ("img".equalsIgnoreCase(tag)) {
                Element img;
                prev = img = this.img(parent, prev, element, styles);
                continue;
            }
            if ("word".equalsIgnoreCase(tag)) {
                Element word;
                prev = word = this.word(parent, prev, element, styles);
                continue;
            }
            if ("ol".equalsIgnoreCase(tag)) {
                prev = this.ol(this.body, prev, element, itemStyles);
                continue;
            }
            if ("li".equalsIgnoreCase(tag)) {
                prev = this.li(this.body, prev, element, itemStyles);
                continue;
            }
            if ("br".equalsIgnoreCase(tag)) {
                parent.addElement("w:br");
                continue;
            }
            if ("u".equalsIgnoreCase(tag)) {
                itemStyles.put("underline", "true");
                prev = this.parseHtml(parent, prev, element, itemStyles);
                continue;
            }
            if ("b".equalsIgnoreCase(tag)) {
                itemStyles.put("font-weight", "700");
                prev = this.parseHtml(parent, prev, element, itemStyles);
                continue;
            }
            if ("i".equalsIgnoreCase(tag)) {
                itemStyles.put("italics", "true");
                prev = this.parseHtml(parent, prev, element, itemStyles);
                continue;
            }
            if ("del".equalsIgnoreCase(tag)) {
                itemStyles.put("strike", "true");
                prev = this.parseHtml(parent, prev, element, itemStyles);
                continue;
            }
            if ("sup".equalsIgnoreCase(tag)) {
                itemStyles.put("vertical-align", "superscript");
                prev = this.parseHtml(parent, prev, element, itemStyles);
                continue;
            }
            if ("sub".equalsIgnoreCase(tag)) {
                itemStyles.put("vertical-align", "subscript");
                prev = this.parseHtml(parent, prev, element, itemStyles);
                continue;
            }
            prev = this.parseHtml(parent, prev, element, itemStyles);
        }
        if (empty && "tc".equalsIgnoreCase(pname)) {
            parent.addElement("w:p");
        }
        return prev;
    }

    public Element p(Element parent, String text, Map<String, String> styles) {
        while (parent.getName().equalsIgnoreCase("p")) {
            parent = parent.getParent();
        }
        Element p = parent.addElement("w:p");
        this.pr(p, styles);
        if (null != text && text.trim().length() > 0) {
            Element r = this.r(p, text, styles);
        }
        return p;
    }

    public Element r(Element parent, String text, Map<String, String> styles) {
        Element r = null;
        if (null != text && text.trim().length() > 0) {
            r = parent.addElement("w:r");
            this.pr(r, styles);
            Element t = r.addElement("w:t");
            t.setText(text);
        }
        return r;
    }

    public Map<String, String> style(Element element) {
        String string;
        String tag;
        int index = element.getParent().elements(element.getName()).indexOf(element);
        String nth = ":nth-child(even)";
        if ((index + 1) % 2 == 0) {
            nth = ":nth-child(odd)";
        }
        Map<String, String> result = new HashMap<String, String>();
        if (null == element) {
            return result;
        }
        String parentName = null;
        ArrayList<String> parentClassList = new ArrayList<String>();
        Element parent = element.getParent();
        if (null != parent) {
            parentName = parent.getName();
            String parentClass = parent.attributeValue("class");
            if (null != parentClass) {
                String[] tmps = parentClass.trim().split(" ");
                for (String string2 : tmps) {
                    String string3 = string2.trim();
                    if (string3.length() <= 0) continue;
                    parentClassList.add(string3);
                }
            }
        }
        if ((tag = element.getName()).equalsIgnoreCase("table")) {
            result = StyleParser.parse(result, (String)"border:1px solid auto;");
        } else if (tag.equalsIgnoreCase("td")) {
            result = StyleParser.parse(result, (String)"vertical-align:center;");
        }
        String name = element.getName();
        for (String string4 : parentClassList) {
            StyleParser.merge(result, this.styles.get("." + string4 + " " + name), (boolean)true);
            StyleParser.merge(result, this.styles.get("." + string4 + " " + name + nth), (boolean)true);
        }
        if (null != parentName) {
            StyleParser.merge(result, this.styles.get(parentName + " " + name), (boolean)true);
            StyleParser.merge(result, this.styles.get(parentName + " " + name + nth), (boolean)true);
        }
        StyleParser.merge(result, this.styles.get(name), (boolean)true);
        StyleParser.merge(result, this.styles.get(name + nth), (boolean)true);
        String clazz = element.attributeValue("class");
        if (null != clazz) {
            String[] stringArray;
            for (String c : stringArray = clazz.split(" ")) {
                if (null != parentName) {
                    StyleParser.merge(result, this.styles.get(parentName + " ." + c), (boolean)true);
                    StyleParser.merge(result, this.styles.get(parentName + " ." + c + nth), (boolean)true);
                }
                for (String string5 : parentClassList) {
                    StyleParser.merge(result, this.styles.get("." + string5 + " ." + c), (boolean)true);
                    StyleParser.merge(result, this.styles.get("." + string5 + " ." + nth), (boolean)true);
                }
                StyleParser.merge(result, this.styles.get("." + c), (boolean)true);
                StyleParser.merge(result, this.styles.get("." + c + nth), (boolean)true);
            }
        }
        if (null != (string = element.attributeValue("id"))) {
            StyleParser.merge(result, this.styles.get("#" + string), (boolean)true);
        }
        result = StyleParser.parse(result, (String)element.attributeValue("style"), (boolean)true);
        return result;
    }

    public String listStyle(String key) {
        return DocxUtil.listStyle(this.file, key);
    }

    public void insert(Element prev, File file) {
        WDocument idoc = new WDocument(file);
        idoc.load();
        Element body = idoc.getBody();
        List inserts = DomUtil.elements((Element)body, (String)"p,tbl");
        int index = WDocument.index(body, prev);
        List elements = body.elements();
        for (Element insert : inserts) {
            insert.getParent().remove(insert);
            elements.add(index++, insert);
        }
    }

    public List<String> listStyles() {
        return DocxUtil.listStyles(this.file);
    }

    public void save() {
        try {
            this.load();
            List ts = DomUtil.elements((Element)this.body, (String)"t");
            for (Element t : ts) {
                String txt = t.getTextTrim();
                List<String> flags = DocxUtil.splitKey(txt);
                if (flags.size() == 0) continue;
                Collections.reverse(flags);
                Element r = t.getParent();
                List elements = r.elements();
                int index = elements.indexOf(t);
                Element prev = null;
                if (index < elements.size() - 1) {
                    prev = (Element)elements.get(index + 1);
                }
                for (int i = 0; i < flags.size(); ++i) {
                    String flag;
                    String content = flag = flags.get(i);
                    String key = null;
                    if (flag.startsWith("${") && flag.endsWith("}")) {
                        key = flag.substring(2, flag.length() - 1);
                        content = this.replaces.get(key);
                        if (null == content) {
                            content = this.replaces.get(flag);
                        }
                    } else if (flag.startsWith("{") && flag.endsWith("}")) {
                        key = flag.substring(2, flag.length() - 1);
                        content = this.replaces.get(key);
                        if (null == content) {
                            content = this.replaces.get(flag);
                        }
                    } else {
                        content = this.replaces.get(flag);
                    }
                    if (null == content) continue;
                    List<Element> list = this.parseHtml(r, prev, content);
                }
                elements.remove(t);
            }
            List bookmarks = DomUtil.elements((Element)this.body, (String)"bookmarkStart");
            for (Element bookmark : bookmarks) {
                this.replaceBookmark(bookmark);
            }
            this.checkContentTypes();
            ZipUtil.replace((File)this.file, (String)"word/document.xml", (String)DomUtil.format((Document)this.doc));
            ZipUtil.replace((File)this.file, (String)"word/document.xml", (String)DomUtil.format((Document)this.doc));
            ZipUtil.replace((File)this.file, (String)"word/_rels/document.xml.rels", (String)DomUtil.format((Document)this.relsDoc));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkContentTypes() {
        try {
            String xml = ZipUtil.read((File)this.file, (String)"[Content_Types].xml");
            Document doc = DocumentHelper.parseText((String)xml);
            Element root = doc.getRootElement();
            this.checkContentTypes(root, "png", "image/png");
            this.checkContentTypes(root, "jpg", "image/jpeg");
            this.checkContentTypes(root, "jpeg", "image/jpeg");
            this.checkContentTypes(root, "gif", "image/gif");
            this.checkContentTypes(root, "tiff", "image/tiff");
            this.checkContentTypes(root, "pict", "image/pict");
            ZipUtil.replace((File)this.file, (String)"[Content_Types].xml", (String)DomUtil.format((Document)doc));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkContentTypes(Element root, String extension, String type) {
        List elements = root.elements("Default");
        for (Element element : elements) {
            if (!extension.equals(element.attributeValue("Extension"))) continue;
            return;
        }
        Element element = root.addElement("Default");
        element.addAttribute("Extension", extension);
        element.addAttribute("ContentType", type);
    }
}

