/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.net;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.anyline.util.DateUtil;
import org.anyline.util.FileUtil;
import org.anyline.util.regular.RegularUtil;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FTPUtil {
    private static Logger log = LoggerFactory.getLogger(FTPUtil.class);
    private static Map<String, FTPUtil> instances = new HashMap<String, FTPUtil>();
    private FTPClient client = new FTPClient();
    private String host;
    private int port = 21;
    private String account;
    private String password;
    private String dir;

    public FTPUtil() {
        this.client.setControlEncoding("UTF-8");
    }

    public FTPUtil(String host, String account, String password, int port) {
        this.host = host;
        this.account = account;
        this.password = password;
        this.port = port;
        this.client.setControlEncoding("UTF-8");
        this.connect();
    }

    public FTPUtil(String host, String account, String password) {
        this.host = host;
        this.account = account;
        this.password = password;
        this.client.setControlEncoding("UTF-8");
        this.connect();
    }

    public static FTPUtil getInstance(String host, String account, String password, int port) {
        String key = "host:" + host + ", account:" + account + ", password:" + password + ", port:" + port;
        FTPUtil util = instances.get(key);
        if (null == util) {
            util = new FTPUtil(host, account, password, port);
        }
        return util;
    }

    public static FTPUtil getInstance(String host, String account, String password) {
        return FTPUtil.getInstance(host, account, password, 21);
    }

    public void setTimeOut(int defaultTimeoutSecond, int connectTimeoutSecond, int dataTimeoutSecond) {
        try {
            this.client.setDefaultTimeout(defaultTimeoutSecond * 1000);
            this.client.setConnectTimeout(connectTimeoutSecond * 1000);
            this.client.setSoTimeout(connectTimeoutSecond * 1000);
            this.client.setDataTimeout(dataTimeoutSecond * 1000);
        }
        catch (SocketException e) {
            log.error("set timeout exception:", (Throwable)e);
        }
    }

    public int fileSize(String dir) {
        int size = 0;
        try {
            this.cd(dir);
            this.client.setFileType(2);
            size = this.client.listFiles().length;
        }
        catch (IOException e) {
            log.error("check file size exception:", (Throwable)e);
        }
        return size;
    }

    public boolean downloadFile(String remote, File local) {
        boolean success = false;
        long fr = System.currentTimeMillis();
        try {
            this.client.setFileType(2);
            File _localDir = local.getParentFile();
            if (null != _localDir && !_localDir.exists()) {
                _localDir.mkdirs();
            }
            FileOutputStream is = new FileOutputStream(local);
            this.client.retrieveFile(remote, (OutputStream)is);
            success = true;
        }
        catch (IOException e) {
            log.error("download file exception:", (Throwable)e);
        }
        log.debug("[ftp download file][\u8017\u65f6:{}][length:{}][remote:{}][local:{}]", new Object[]{DateUtil.conversion((long)(System.currentTimeMillis() - fr)), FileUtil.length((long)local.length()), remote, local.getAbsolutePath()});
        return success;
    }

    public FTPClient getFTPClient() {
        return this.client;
    }

    public void setControlEncoding(String charset) {
        this.client.setControlEncoding(charset);
    }

    public void setFileType(int fileType) throws IOException {
        this.client.setFileType(fileType);
    }

    public void connect() {
        try {
            this.client.connect(this.host, this.port);
            int reply = this.client.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                this.disconnect();
            }
            if ("".equals(this.account)) {
                this.account = "anonymous";
            }
            if (!this.client.login(this.account, this.password)) {
                this.disconnect();
            }
            this.client.setFileType(2);
            this.client.enterLocalPassiveMode();
        }
        catch (Exception e) {
            log.error("connect exception:", (Throwable)e);
        }
    }

    public boolean isConnected() {
        return this.client.isConnected();
    }

    public void disconnect() {
        if (this.client.isConnected()) {
            try {
                this.client.logout();
                this.client.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieveFile(String ftpFileName, OutputStream out) throws IOException {
        try {
            FTPFile[] fileInfoArray = this.client.listFiles(ftpFileName);
            if (fileInfoArray == null || fileInfoArray.length == 0) {
                throw new FileNotFoundException("File '" + ftpFileName + "' was not found on FTP server.");
            }
            FTPFile fileInfo = fileInfoArray[0];
            long size = fileInfo.getSize();
            if (size > Integer.MAX_VALUE) {
                throw new IOException("File '" + ftpFileName + "' is too large.");
            }
            if (!this.client.retrieveFile(ftpFileName, out)) {
                throw new IOException("Error loading file '" + ftpFileName + "' from FTP server. Check FTP permissions and path.");
            }
            out.flush();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeFile(String ftpFileName, InputStream in) throws IOException {
        try {
            if (!this.client.storeFile(ftpFileName, in)) {
                throw new IOException("Can't upload file '" + ftpFileName + "' to FTP server. Check FTP permissions and path.");
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public boolean rename(String from, String to) throws IOException {
        return this.client.rename(from, to);
    }

    public void deleteFile(String ftpFileName) throws IOException {
        if (!this.client.deleteFile(ftpFileName)) {
            throw new IOException("Can't remove file '" + ftpFileName + "' from FTP server.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadFile(File local, String remote) {
        boolean result = false;
        long fr = System.currentTimeMillis();
        InputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(local));
            List<String> paths = FTPUtil.formatPath(remote);
            this.makeDir(paths.get(0));
            this.client.storeFile(remote, in);
            result = true;
        }
        catch (Exception e) {
            log.error("upload file exception:", (Throwable)e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        log.debug("[ftp upload file][\u8017\u65f6:{}][length:{}][remote:{}][local:{}]", new Object[]{DateUtil.conversion((long)(System.currentTimeMillis() - fr)), FileUtil.length((long)local.length()), remote, local.getAbsolutePath()});
        return result;
    }

    public boolean uploadFile(String remote, File local) {
        return this.uploadFile(local, remote);
    }

    public boolean upload(String remote, File local) {
        boolean result = false;
        if (!local.exists()) {
            return result;
        }
        if (local.isDirectory()) {
            this.uploadDir(remote, local);
        } else {
            this.uploadFile(remote, local);
        }
        return result;
    }

    public void uploadDir(String remotePath, File local) {
        log.debug("[ftp upload dir][remote:{}][local:{}]", (Object)remotePath, (Object)local.getAbsolutePath());
        if (null != local && local.exists()) {
            File[] files;
            if (!this.cd(remotePath)) {
                try {
                    this.client.makeDirectory(remotePath);
                }
                catch (IOException e) {
                    log.error("upload dir exception:", (Throwable)e);
                }
                this.cd(remotePath);
            }
            for (File f : files = local.listFiles()) {
                if (f.isDirectory() && !f.getName().equals(".") && !f.getName().equals("..")) {
                    this.uploadDir(remotePath + "/" + f.getName(), f);
                    continue;
                }
                if (!f.isFile()) continue;
                this.uploadFile(remotePath + "/" + f.getName(), f);
            }
        }
    }

    public boolean downloadDir(String remoteDir, File localDir) {
        boolean success = false;
        log.debug("[ftp download dir][remote:{}][local:{}]", (Object)remoteDir, (Object)localDir.getAbsolutePath());
        try {
            this.cd(remoteDir);
            this.client.setFileType(2);
            this.downloadDir(localDir);
            success = true;
        }
        catch (IOException e) {
            log.error("download dir exception:", (Throwable)e);
        }
        return success;
    }

    public boolean cd(String dir) {
        boolean result = false;
        try {
            result = this.client.changeWorkingDirectory(dir);
            String path = this.client.doCommandAsStrings("pwd", "")[0];
            this.dir = RegularUtil.cut((String)path, (String[])new String[]{"\"", "\""});
            log.debug("[ftp change directory][directory:{}]", (Object)this.dir);
        }
        catch (IOException e) {
            log.error("change dir exception:", (Throwable)e);
        }
        return result;
    }

    private void downloadDir(File localDir) {
        try {
            FTPFile[] files;
            for (FTPFile file : files = this.client.listFiles()) {
                if (file.isDirectory()) {
                    this.cd(file.getName());
                    this.downloadDir(new File(String.valueOf(localDir) + "/" + file.getName()));
                    continue;
                }
                File local = new File(localDir, file.getName());
                this.downloadFile(this.dir + "/" + file.getName(), local);
            }
        }
        catch (Exception e) {
            log.error("download dir exception:", (Throwable)e);
        }
    }

    public List<String> files(String dir) throws IOException {
        ArrayList<String> fileList = new ArrayList<String>();
        FTPFile[] ftpFiles = this.client.listFiles(dir);
        for (int i = 0; ftpFiles != null && i < ftpFiles.length; ++i) {
            FTPFile ftpFile = ftpFiles[i];
            if (!ftpFile.isFile()) continue;
            fileList.add(ftpFile.getName());
        }
        return fileList;
    }

    public void sendSiteCommand(String args) throws IOException {
        if (this.client.isConnected()) {
            try {
                this.client.sendSiteCommand(args);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String printWorkingDirectory() {
        if (!this.client.isConnected()) {
            return "";
        }
        try {
            return this.client.printWorkingDirectory();
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public boolean changeToParentDirectory() {
        if (!this.client.isConnected()) {
            return false;
        }
        try {
            return this.client.changeToParentDirectory();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public String getParentDirectory() {
        if (!this.client.isConnected()) {
            return "";
        }
        String w = this.printWorkingDirectory();
        this.changeToParentDirectory();
        String p = this.printWorkingDirectory();
        this.cd(w);
        return p;
    }

    public boolean makeDir(String path) throws IOException {
        return this.client.makeDirectory(path);
    }

    public static List<String> formatPath(String srcPath) {
        ArrayList<String> list = new ArrayList<String>(2);
        String repSrc = srcPath.replaceAll("\\\\", "/");
        int firstP = repSrc.indexOf("/");
        int lastP = repSrc.lastIndexOf("/");
        String fileName = lastP + 1 == repSrc.length() ? "" : repSrc.substring(lastP + 1);
        Object dir = firstP == -1 ? "" : repSrc.substring(firstP, lastP);
        dir = ((String)dir).length() == 1 ? dir : (String)dir + "/";
        list.add((String)dir);
        list.add(fileName);
        return list;
    }

    public String getDir() {
        return this.dir;
    }
}

