/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.net;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

class DownloaderThreadPool {
    private static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();
    private static final int CORE_POOL_SIZE = Math.max(4, Math.min(CPU_COUNT - 1, 5));
    private static final int MAXIMUM_POOL_SIZE = CPU_COUNT * 2 + 100;
    private static final BlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>(200000);
    private static ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(CORE_POOL_SIZE, MAXIMUM_POOL_SIZE, 30L, TimeUnit.SECONDS, workQueue, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setDaemon(false);
            return thread;
        }
    });

    DownloaderThreadPool() {
    }

    public static void execute(Runnable runnable, int threads) {
        threadPoolExecutor.setCorePoolSize(threads);
        threadPoolExecutor.execute(runnable);
    }

    public static void execute(Runnable runnable) {
        threadPoolExecutor.execute(runnable);
    }

    static {
        threadPoolExecutor.allowCoreThreadTimeOut(true);
    }
}

