/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.net;

import java.io.File;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.anyline.log.Log;
import org.anyline.log.LogProxy;
import org.anyline.net.DownloadTask;
import org.anyline.net.HttpClient;
import org.anyline.util.BeanUtil;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class HttpBuilder {
    private static final Log log = LogProxy.get(HttpBuilder.class);
    private CloseableHttpClient client;
    private Map<String, String> headers = new HashMap<String, String>();
    private HttpEntity entity;
    private Map<String, Object> params = new HashMap<String, Object>();
    private List<NameValuePair> pairs = new ArrayList<NameValuePair>();
    private String userAgent;
    private String url;
    private String charset = "UTF-8";
    private DownloadTask task;
    private Map<String, Object> files;
    private String returnType = "text";

    public HttpClient build() {
        HttpClient client = new HttpClient();
        try {
            Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)HttpBuilder.ignoreSSL()).build();
            PoolingHttpClientConnectionManager mananger = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            mananger.setMaxTotal(100);
            mananger.setDefaultMaxPerRoute(20);
            this.client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)mananger).build();
        }
        catch (Exception e) {
            log.error("build http client exception:", (Throwable)e);
        }
        client.setClient(this.client);
        if (null != this.headers && !this.headers.isEmpty()) {
            client.setHeaders(this.headers);
        }
        client.setEntity(this.entity);
        client.setParams(this.params);
        client.setPairs(this.pairs);
        if (null != this.userAgent) {
            client.setUserAgent(this.userAgent);
        }
        client.setUrl(this.url);
        if (null != this.charset) {
            client.setEncode(this.charset);
        }
        client.setTask(this.task);
        client.setFiles(this.files);
        client.setReturnType(this.returnType);
        return client;
    }

    public static SSLConnectionSocketFactory ignoreSSL() throws NoSuchAlgorithmException, KeyManagementException {
        SSLConnectionSocketFactory sslsf = null;
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            X509TrustManager trustManager = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            };
            sc.init(null, new TrustManager[]{trustManager}, null);
            sslsf = new SSLConnectionSocketFactory(sc, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        return sslsf;
    }

    public static HttpBuilder parse(String url) {
        HttpBuilder builder = new HttpBuilder();
        builder.setUrl(url);
        if (null != url) {
            String base = null;
            String sub = null;
            int idx_session = url.indexOf(";");
            int idx_param = url.indexOf("?");
            if (idx_param > 0) {
                if (idx_session > 0 && idx_session < idx_param) {
                    base = url.substring(0, idx_session);
                    sub = url.substring(url.indexOf("?") + 1);
                } else {
                    base = url.substring(0, url.indexOf("?"));
                    sub = url.substring(url.indexOf("?") + 1);
                }
                builder.setUrl(base);
            }
            if (null != sub) {
                String[] ps;
                for (String p : ps = sub.split("&")) {
                    String[] kv;
                    if (!p.contains("=") || (kv = p.split("=")).length != 2) continue;
                    builder.setParam(kv[0], kv[1]);
                }
            }
        }
        return builder;
    }

    public static HttpBuilder init() {
        return new HttpBuilder();
    }

    public static HttpBuilder init(String url) {
        return new HttpBuilder().setUrl(url);
    }

    public static HttpBuilder init(CloseableHttpClient client, String url) {
        return new HttpBuilder().setClient(client).setUrl(url);
    }

    public static HttpBuilder init(CloseableHttpClient client) {
        return new HttpBuilder().setClient(client);
    }

    public HttpBuilder setContentType(String type) {
        this.headers.put("Content-Type", type);
        return this;
    }

    public HttpBuilder setClient(CloseableHttpClient client) {
        this.client = client;
        return this;
    }

    public HttpBuilder setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public HttpBuilder addHeader(String key, String value) {
        this.headers.put(key, value);
        return this;
    }

    public HttpBuilder setUrl(String url) {
        this.url = url;
        return this;
    }

    public HttpBuilder setCharset(String charset) {
        this.charset = charset;
        return this;
    }

    public HttpBuilder setEntity(HttpEntity entity) {
        this.entity = entity;
        return this;
    }

    public HttpBuilder clearHeader() {
        this.headers.clear();
        return this;
    }

    public HttpBuilder setEntity(String entity) {
        try {
            this.entity = new StringEntity(entity, this.charset);
        }
        catch (Exception e) {
            log.error("create string entity exception:", (Throwable)e);
        }
        return this;
    }

    public HttpBuilder setEntity(Map<String, ?> map) {
        try {
            this.entity = new StringEntity(BeanUtil.map2json(map), this.charset);
        }
        catch (Exception e) {
            log.error("create string entity exception:", (Throwable)e);
        }
        return this;
    }

    public HttpBuilder setPairs(List<NameValuePair> pairs) {
        this.pairs = pairs;
        return this;
    }

    public HttpBuilder addPair(List<NameValuePair> pairs) {
        this.pairs = pairs;
        return this;
    }

    public HttpBuilder addDownloadTask(DownloadTask task) {
        this.task = task;
        return this;
    }

    public HttpBuilder setUploadFiles(Map<String, Object> files) {
        this.files = files;
        return this;
    }

    public HttpBuilder addUploadFiles(String key, File file) {
        if (null == this.files) {
            this.files = new HashMap<String, Object>();
        }
        this.files.put(key, file);
        return this;
    }

    public HttpBuilder addUploadFiles(String key, byte[] file) {
        if (null == this.files) {
            this.files = new HashMap<String, Object>();
        }
        this.files.put(key, file);
        return this;
    }

    public HttpBuilder setParams(Map<String, Object> params) {
        this.params = params;
        return this;
    }

    public HttpBuilder addParam(String key, String value) {
        this.params.put(key, value);
        return this;
    }

    public HttpBuilder setReturnType(String type) {
        this.returnType = type;
        return this;
    }

    public HttpBuilder setUserAgent(String agent) {
        this.userAgent = agent;
        return this;
    }

    public Object getParam(String key) {
        if (null != this.params) {
            return this.params.get(key);
        }
        return null;
    }

    public HttpBuilder setParam(String key, Object value) {
        Object param;
        if (null == this.params) {
            this.params = new HashMap<String, Object>();
        }
        if (null != (param = this.params.get(key)) && null != value) {
            ArrayList<Object> list = null;
            list = param instanceof List ? (ArrayList<Object>)param : new ArrayList<Object>();
            if (value instanceof List) {
                list.addAll((List)value);
            } else {
                list.add(value);
            }
            this.params.put(key, list);
        } else {
            this.params.put(key, value);
        }
        return this;
    }
}

