/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.net;

import com.jcraft.jsch.SftpProgressMonitor;
import org.anyline.util.DateUtil;
import org.anyline.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SFTPProgressMonitor
implements SftpProgressMonitor {
    private final Logger log = LoggerFactory.getLogger(SFTPProgressMonitor.class);
    private String remote = "";
    private String local = "";
    private long length;
    private long transfered;
    private double displayRate;
    private long startTime = 0L;
    private long displayTime;

    public SFTPProgressMonitor(String remote, long length) {
        this.remote = remote;
        this.length = length;
        this.startTime = System.currentTimeMillis();
    }

    public SFTPProgressMonitor(String remote, String local, long length) {
        this.remote = remote;
        this.local = local;
        this.length = length;
        this.startTime = System.currentTimeMillis();
    }

    public SFTPProgressMonitor(long length) {
        this.length = length;
        this.startTime = System.currentTimeMillis();
    }

    public boolean count(long count) {
        double curRate = (this.transfered + count) / this.length * 100L;
        if (curRate - this.displayRate >= 0.5 || System.currentTimeMillis() - this.displayTime > 5000L || curRate == 100.0) {
            this.displayRate = curRate;
            this.displayTime = System.currentTimeMillis();
            long delay = System.currentTimeMillis() - this.startTime;
            double expect = 0.0;
            if (delay > 0L && this.transfered > 0L) {
                expect = this.length / (this.transfered / delay);
                String total_title = "[\u6587\u4ef6\u4e0b\u8f7d][\u8fdb\u5ea6:" + FileUtil.progress((long)this.length, (long)this.transfered) + "][\u8017\u65f6:" + DateUtil.conversion((long)delay) + "/" + DateUtil.conversion((double)expect) + "(" + FileUtil.length((long)(this.transfered * 1000L / delay)) + "/s)]";
                if (null != this.local) {
                    total_title = "[local:" + this.local + "]" + total_title;
                }
                if (null != this.remote) {
                    total_title = "[remote:" + this.remote + "]" + total_title;
                }
                this.log.debug(total_title);
            }
        }
        this.transfered += count;
        return true;
    }

    public void end() {
        this.log.debug("\u4e0b\u8f7d\u5b8c\u6210.");
    }

    public void init(int op, String src, String dest, long max) {
        this.log.debug("\u5f00\u59cb\u4e0b\u8f7d.");
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }
}

