/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.net;

import java.io.ByteArrayOutputStream;
import java.util.List;

public class VCFUtil {
    public static String format(String mobile, String name) {
        StringBuilder builder = new StringBuilder();
        builder.append("BEGIN:VCARD\n");
        builder.append("ERSION:2.1\n");
        builder.append("N;CHARSET=UTF-8;ENCODING=QUOTED-PRINTABLE:;").append(VCFUtil.encode(name)).append(";;;\n");
        builder.append("TEL;CELL:").append(mobile).append("\n");
        builder.append("END:VCARD");
        return builder.toString();
    }

    public static String format(String mobile) {
        return VCFUtil.format(mobile, mobile);
    }

    public static String format(List<String> mobiles) {
        StringBuilder builder = new StringBuilder();
        for (String mobile : mobiles) {
            if (mobile.contains(",")) {
                String[] items = mobile.split(",");
                if (items.length == 1) {
                    builder.append(VCFUtil.format(items[0])).append("\n");
                    continue;
                }
                if (items.length <= 1) continue;
                builder.append(VCFUtil.format(items[0], items[1])).append("\n");
                continue;
            }
            builder.append(VCFUtil.format(mobile, mobile)).append("\n");
        }
        return builder.toString();
    }

    public static String encode(String str) {
        if (str != null) {
            try {
                char[] encode = str.toCharArray();
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < encode.length; ++i) {
                    if (encode[i] >= '!' && encode[i] <= '~' && encode[i] != '=' && encode[i] != '\n') {
                        sb.append(encode[i]);
                        continue;
                    }
                    if (encode[i] == '=') {
                        sb.append("=3D");
                        continue;
                    }
                    if (encode[i] == '\n') {
                        sb.append("\n");
                        continue;
                    }
                    StringBuffer sbother = new StringBuffer();
                    sbother.append(encode[i]);
                    String ss = sbother.toString();
                    byte[] buf = null;
                    buf = ss.getBytes("utf-8");
                    if (buf.length != 3) continue;
                    for (int j = 0; j < buf.length; ++j) {
                        String s16 = String.valueOf(Integer.toHexString(buf[j]));
                        char c16_6 = s16.charAt(6) >= 'a' && s16.charAt(6) <= 'z' ? (char)(s16.charAt(6) - 32) : s16.charAt(6);
                        char c16_7 = s16.charAt(7) >= 'a' && s16.charAt(7) <= 'z' ? (char)(s16.charAt(7) - 32) : s16.charAt(7);
                        sb.append("=" + c16_6 + c16_7);
                    }
                }
                str = sb.toString();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return str;
    }

    public static String decode(String str) {
        if (str != null) {
            try {
                StringBuffer sb = new StringBuffer(str);
                for (int i = 0; i < sb.length(); ++i) {
                    if (sb.charAt(i) != '\n' || sb.charAt(i - 1) != '=') continue;
                    sb.deleteCharAt(i - 1);
                }
                str = sb.toString();
                byte[] bytes = str.getBytes("US-ASCII");
                for (int i = 0; i < bytes.length; ++i) {
                    int b = bytes[i];
                    bytes[i] = b != 95 ? b : 32;
                }
                if (bytes != null) {
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                    for (int i = 0; i < bytes.length; ++i) {
                        byte b = bytes[i];
                        if (b == 61) {
                            try {
                                int u = Character.digit((char)bytes[++i], 16);
                                int l = Character.digit((char)bytes[++i], 16);
                                if (u == -1 || l == -1) continue;
                                buffer.write((char)((u << 4) + l));
                            }
                            catch (ArrayIndexOutOfBoundsException e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                        buffer.write(b);
                    }
                    str = new String(buffer.toByteArray(), "UTF-8");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return str;
    }
}

