/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.net;

import java.io.File;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.anyline.log.Log;
import org.anyline.log.LogProxy;
import org.anyline.net.DefaultProgress;
import org.anyline.net.DownloadListener;
import org.anyline.net.DownloadProgress;
import org.anyline.net.HttpBuilder;
import org.anyline.util.ConfigTable;
import org.anyline.util.DateUtil;
import org.anyline.util.FileUtil;

public class DownloadTask {
    private Log log = LogProxy.get(DownloadTask.class);
    private boolean openLog = true;
    private String url;
    private File local;
    private int threads;
    private long past;
    private long length;
    private long finish;
    private long start;
    private long end;
    private Map<String, String> headers;
    private Map<String, Object> params;
    private Map<String, Object> extras = new HashMap<String, Object>();
    private int index;
    private long expend;
    private long expect;
    private double rate = 0.0;
    private double lastLogRate;
    private long lastLogTime;
    private String errorMsg = "";
    private int errorCode = 0;
    private int action = 1;
    private int status = 0;
    private Map<Long, Long> records = new LinkedHashMap<Long, Long>();
    private DownloadProgress progress = new DefaultProgress();
    private DownloadListener listener;
    private boolean override = false;

    public boolean isOverride() {
        return this.override;
    }

    public void setOverride(boolean override) {
        this.override = override;
    }

    public DownloadTask() {
    }

    public long getAvgSpeed() {
        Long sum = 0L;
        Long fr = 0L;
        Iterator<Map.Entry<Long, Long>> entries = this.records.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<Long, Long> entry = entries.next();
            Long key = entry.getKey();
            Long value = entry.getValue();
            if (System.currentTimeMillis() - key > 10000L) {
                entries.remove();
                continue;
            }
            sum = sum + value;
            if (key >= fr && fr != 0L) continue;
            fr = key;
        }
        long time = System.currentTimeMillis();
        if (time > 0L) {
            return sum * 1000L / time;
        }
        return sum * 10000L;
    }

    public long getSpeed() {
        if (!this.isRunning()) {
            return 0L;
        }
        Long len = 0L;
        Long time = 0L;
        Long curTime = 0L;
        Iterator<Map.Entry<Long, Long>> entries = this.records.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<Long, Long> entry = entries.next();
            Long key = entry.getKey();
            Long value = entry.getValue();
            curTime = key;
            if (entries.hasNext()) continue;
            len = value;
            time = key - curTime;
        }
        if (time > 0L) {
            return len * 1000L / time;
        }
        return len * 10000L;
    }

    public String getAvgSpeedFormat() {
        long speed = this.getSpeed();
        return FileUtil.length((long)speed) + "/s";
    }

    public String getSpeedFormat() {
        long speed = this.getSpeed();
        return FileUtil.length((long)speed) + "/s";
    }

    public DownloadTask(String url, File local) {
        this.url = url;
        this.local = local;
    }

    public DownloadTask(String url, File local, Map<String, String> headers, Map<String, Object> params, Map<String, Object> extras) {
        this.url = url;
        this.local = local;
        this.headers = headers;
        this.params = params;
        this.extras = extras;
    }

    public DownloadTask(String url, File local, Map<String, String> headers, Map<String, Object> params) {
        this.url = url;
        this.local = local;
        this.headers = headers;
        this.params = params;
    }

    public void init(long length, long past) {
        this.length = length;
        this.past = past;
        this.start = System.currentTimeMillis();
        this.status = 0;
    }

    public void step(long len) {
        this.finish += len;
        this.rate = new BigDecimal((double)(this.finish + this.past) * 100.0 / (double)(this.length + this.past)).setScale(2, 5).doubleValue();
        if (this.finish >= this.length) {
            this.finish = this.length;
            this.rate = 100.0;
            this.end = System.currentTimeMillis();
        }
        if (this.rate == 100.0 && this.finish < this.length) {
            this.rate = 99.99;
        }
        this.expend = this.end == 0L ? System.currentTimeMillis() - this.start : this.end - this.start;
        if (this.expend > 0L) {
            this.expect = (long)((double)this.length / ((double)this.finish * 1.0 / (double)this.expend) - (double)this.expend);
            if (this.rate == 100.0) {
                this.expect = 0L;
            }
            if (ConfigTable.IS_DEBUG && this.openLog) {
                this.log();
            }
        }
        this.records.put(System.currentTimeMillis(), len);
        if (this.rate >= 100.0) {
            this.finish();
        }
    }

    public void error(int code, String message) {
        try {
            this.status = -1;
            this.log.error("[\u6587\u4ef6\u4e0b\u8f7d][\u4e0b\u8f7d\u5f02\u5e38][url:{}][code:{}][message:{}]", new Object[]{this.url, code, message});
            this.errorCode = code;
            this.errorMsg = message;
            if (null != this.listener) {
                this.listener.error(this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void finish() {
        try {
            this.status = 9;
            this.rate = 100.0;
            this.end = System.currentTimeMillis();
            this.log();
            if (ConfigTable.IS_DEBUG && this.log.isWarnEnabled()) {
                this.log.info("[\u6587\u4ef6\u4e0b\u8f7d][\u4e0b\u8f7d\u5b8c\u6210][\u8017\u65f6:{}][url:{}][local:{}]", new Object[]{this.getExpendFormat(), this.url, this.getLocal().getAbsolutePath()});
            }
            if (null != this.listener) {
                this.listener.finish(this);
            }
        }
        catch (Exception e) {
            this.log.error("finish exception:", (Throwable)e);
        }
    }

    private void log() {
        if (!ConfigTable.IS_DEBUG && !this.openLog) {
            return;
        }
        if (this.getExpend() == 0L) {
            return;
        }
        double rate = this.getFinishRate();
        if (this.openLog && (this.lastLogTime == 0L || rate - this.lastLogRate >= 0.5 || System.currentTimeMillis() - this.lastLogTime > 5000L || rate == 100.0)) {
            this.log.debug("[\u6587\u4ef6\u4e0b\u8f7d]" + this.getMessage());
            this.lastLogRate = rate;
            this.lastLogTime = System.currentTimeMillis();
        }
    }

    public void start() {
        if (!this.isRunning() && this.action == 1) {
            this.action = 1;
            this.status = 1;
            if (this.start == 0L) {
                this.start = System.currentTimeMillis();
            }
            HttpBuilder.init().addDownloadTask(this).build().download();
        } else {
            this.action = 1;
            this.status = 1;
        }
    }

    public void stop() {
        this.action = 0;
        this.status = 2;
    }

    public int getAction() {
        return this.action;
    }

    public double getFinishRate() {
        return this.rate;
    }

    public String getMessage() {
        Object msg = "[\u8fdb\u5ea6:";
        if (this.past > 0L) {
            msg = (String)msg + this.getPastFormat();
            if (this.finish > 0L) {
                msg = (String)msg + "+";
            }
        }
        if (this.finish > 0L) {
            msg = (String)msg + this.getFinishFormat();
        }
        msg = (String)msg + "/" + this.getTotalFormat() + "(" + this.getFinishRate() + "%)][\u8017\u65f6:" + this.getExpendFormat() + "/" + this.getExpectFormat() + "][\u77ac\u65f6:" + this.getSpeedFormat() + "/\u5e73\u5747:" + this.getAvgSpeedFormat() + "][url:" + this.url + "][local:" + this.local.getAbsolutePath() + "]";
        return msg;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public File getLocal() {
        return this.local;
    }

    public void setLocal(File local) {
        this.local = local;
    }

    public int getThreads() {
        return this.threads;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public long getLength() {
        return this.length;
    }

    public String getLengthFormat() {
        return FileUtil.length((long)this.getLength());
    }

    public void setLength(long length) {
        this.length = length;
    }

    public long getTotal() {
        return this.length + this.past;
    }

    public String getTotalFormat() {
        return FileUtil.length((long)this.getTotal());
    }

    public long getFinish() {
        return this.finish;
    }

    public String getFinishFormat() {
        return FileUtil.length((long)this.getFinish());
    }

    public void setFinish(long finish) {
        this.finish = finish;
    }

    public long getStart() {
        return this.start;
    }

    public void setStart(long start) {
        this.start = start;
    }

    public long getEnd() {
        return this.end;
    }

    public void setEnd(long end) {
        this.end = end;
    }

    public Map<String, Object> getExtras() {
        return this.extras;
    }

    public void setExtras(Map<String, Object> extras) {
        this.extras = extras;
    }

    public void addExtras(String key, Object value) {
        this.extras.put(key, value);
    }

    public long getExpend() {
        this.expend = this.end == 0L ? System.currentTimeMillis() - this.start : this.end - this.start;
        return this.expend;
    }

    public String getExpendFormat() {
        return DateUtil.conversion((long)this.getExpend());
    }

    public void setExpend(long expend) {
        this.expend = expend;
    }

    public long getExpect(long speed) {
        if (this.expend > 0L) {
            this.expect = (long)((double)this.length / ((double)this.finish * 1.0 / (double)this.expend) - (double)this.expend);
            if (this.rate == 100.0) {
                this.expect = 0L;
            }
        } else if (speed > 0L) {
            this.expect = (long)((double)this.length * 1.0 / (double)speed - (double)this.expend);
        }
        return this.expect;
    }

    public long getExpect() {
        return this.expect;
    }

    public String getExpectFormat(long speed) {
        return DateUtil.conversion((long)this.getExpect(speed));
    }

    public String getExpectFormat() {
        return DateUtil.conversion((long)this.getExpect());
    }

    public void setExpect(long expect) {
        this.expect = expect;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public void addParam(String key, String value) {
        if (null == this.params) {
            this.params = new LinkedHashMap<String, Object>();
        }
        this.params.put(key, value);
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public long getPast() {
        return this.past;
    }

    public String getPastFormat() {
        return FileUtil.length((long)this.getPast());
    }

    public void setPast(long past) {
        this.past = past;
    }

    public double getRate() {
        return this.rate;
    }

    public void setRate(double rate) {
        this.rate = rate;
    }

    public void openLog() {
        this.openLog = true;
    }

    public void closeLog() {
        this.openLog = false;
    }

    public DownloadProgress getProgress() {
        return this.progress;
    }

    public void setProgress(DownloadProgress progress) {
        this.progress = progress;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public void setListener(DownloadListener listener) {
        this.listener = listener;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isInit() {
        return this.status == 0;
    }

    public boolean isStop() {
        return this.status == 2;
    }

    public boolean isRunning() {
        return this.status == 1;
    }

    public boolean isError() {
        return this.status == -1;
    }

    public boolean isFinish() {
        return this.status == 9;
    }
}

