/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.net;

import java.io.File;
import org.anyline.net.DownloadListener;
import org.anyline.net.DownloadProgress;
import org.anyline.util.DateUtil;
import org.anyline.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProgress
implements DownloadProgress {
    private Logger log = LoggerFactory.getLogger(DefaultProgress.class);
    private String url;
    private File local;
    private long past;
    private long length;
    private long finish;
    private long start;
    private long expend;
    private long expect;
    private double lastLogRate;
    private long lastLogTime;
    private String message;
    private double rate;
    private int action = 1;

    public DefaultProgress() {
        this.start = System.currentTimeMillis();
    }

    public DefaultProgress(String url, File local) {
        this.url = url;
        this.local = local;
        this.start = System.currentTimeMillis();
        this.start = System.currentTimeMillis();
    }

    @Override
    public void init(String url, String thread, long total, long past) {
        this.length = total;
        this.past = past;
    }

    @Override
    public void step(String url, String thread, long finish) {
        this.finish += finish;
        this.rate = (double)(this.finish + this.past) * 100.0 / (double)(this.length + this.past);
        if (this.finish > this.length) {
            this.finish = this.length;
            this.rate = 100.0;
        }
        if (this.rate == 100.0 && finish < this.length) {
            this.rate = 99.99;
        }
        this.expend = System.currentTimeMillis() - this.start;
        if (this.expend > 0L) {
            this.expect = (long)((double)this.length / ((double)this.finish * 1.0 / (double)this.expend) - (double)this.expend);
            if (this.rate == 100.0) {
                this.expect = 0L;
            }
            this.log();
        }
    }

    @Override
    public void finish(String url, String thread) {
        this.rate = 100.0;
    }

    private void log() {
        if (this.rate - this.lastLogRate >= 0.5 || System.currentTimeMillis() - this.lastLogTime > 5000L || this.rate == 100.0) {
            long time = System.currentTimeMillis() - this.start;
            this.message = "[\u8fdb\u5ea6:" + FileUtil.progress((long)this.length, (long)this.finish) + "]" + "[\u8017\u65f6:" + DateUtil.conversion((long)time) + "/" + DateUtil.conversion((long)this.expect) + "(" + FileUtil.length((long)(this.finish * 1000L / time)) + "/s)]";
            this.log.info("[\u6587\u4ef6\u4e0b\u8f7d]{}[url:{}][local:{}]", new Object[]{this.message, this.url, this.local.getAbsolutePath()});
            this.lastLogRate = this.rate;
            this.lastLogTime = System.currentTimeMillis();
        }
    }

    @Override
    public void error(String url, String thread, int code, String message) {
    }

    @Override
    public void setErrorListener(DownloadListener listener) {
    }

    @Override
    public void setFinishListener(DownloadListener listener) {
    }

    @Override
    public int getAction() {
        return this.action;
    }

    @Override
    public void stop() {
        this.action = 0;
    }
}

