/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.net;

import java.io.File;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.anyline.net.DownloadTask;
import org.anyline.net.DownloaderThreadPool;
import org.anyline.util.BasicUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.DateUtil;
import org.anyline.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Downloader {
    private static Logger log = LoggerFactory.getLogger(Downloader.class);
    private Map<String, DownloadTask> tasks = new Hashtable<String, DownloadTask>();
    private int maxParallel = 5;
    private int curParallel;
    private double lastLogRate;
    private long lastLogTime;
    private long start;
    private long end;
    private String errorMsg = "";
    private String errorCode = "";
    private int status = 0;
    private static Hashtable<String, Downloader> instances = new Hashtable();

    public static Downloader getInstance() {
        return Downloader.getInstance("default");
    }

    public static Downloader getInstance(String key) {
        Downloader util;
        if (BasicUtil.isEmpty((Object)key)) {
            key = "default";
        }
        if (null == (util = instances.get(key))) {
            util = new Downloader();
            instances.put(key, util);
        }
        return util;
    }

    private void log() {
        if (this.getTaskSize() <= 1 || !ConfigTable.IS_DEBUG) {
            return;
        }
        if (this.getSpeed() == 0L) {
            return;
        }
        double rate = this.getFinishRate();
        if (this.lastLogTime == 0L || rate - this.lastLogRate >= 0.5 || System.currentTimeMillis() - this.lastLogTime > 5000L || rate == 100.0) {
            log.warn("[\u6587\u4ef6\u4e0b\u8f7d]" + this.getMessage());
            this.lastLogRate = rate;
            this.lastLogTime = System.currentTimeMillis();
        }
    }

    public void init() {
        this.tasks.clear();
        this.maxParallel = 5;
        this.curParallel = 0;
        this.lastLogRate = 0.0;
        this.lastLogTime = 0L;
        this.start = 0L;
        this.end = 0L;
        this.errorCode = "";
        this.errorMsg = "";
    }

    public String getMessage() {
        Object msg = "[\u8fdb\u5ea6:";
        if (this.getSumPast() > 0L) {
            msg = (String)msg + this.getSumPastFormat();
            if (this.getSumFinish() > 0L) {
                msg = (String)msg + "+";
            }
        }
        if (this.getSumFinish() > 0L) {
            msg = (String)msg + this.getSumFinishFormat();
        }
        int errorSize = this.getErrorTaskSize();
        msg = (String)msg + "/" + this.getSumTotalFormat() + "(" + this.getFinishRate() + "%)][\u5b8c\u6210\u6570\u91cf:" + this.getFinishTaskSize();
        if (errorSize > 0) {
            msg = (String)msg + "(\u5f02\u5e38:" + errorSize + ")";
        }
        msg = (String)msg + "/" + this.getTaskSize() + "][\u8017\u65f6:" + this.getExpendFormat() + "/" + this.getExpectFormat() + "][\u7f51\u901f:" + this.getSpeedFormat() + "]";
        return msg;
    }

    public void clear(boolean stop) {
        for (DownloadTask task : this.tasks.values()) {
            if (!stop) continue;
            task.stop();
        }
        this.status = 0;
        this.tasks.clear();
    }

    public void stop() {
        for (DownloadTask task : this.tasks.values()) {
            task.stop();
        }
    }

    public void stop(String url) {
        DownloadTask task = this.getTask(url);
        if (null == task) {
            log.error("[\u4efb\u52a1\u4e0d\u5b58\u5728][url:{}]", (Object)url);
            return;
        }
        if (null != task) {
            task.stop();
        }
    }

    public int getTaskSize() {
        return this.tasks.size();
    }

    public int getTaskSize(String extKey, Object extVal) {
        return this.getTasks(extKey, extVal).size();
    }

    public int getFinishTaskSize() {
        int size = 0;
        for (DownloadTask task : this.tasks.values()) {
            if (!task.isFinish()) continue;
            ++size;
        }
        return size;
    }

    public int getFinishTaskSize(String extKey, Object extVal) {
        int size = 0;
        Map<String, DownloadTask> tasks = this.getTasks(extKey, extVal);
        for (DownloadTask task : tasks.values()) {
            if (!task.isFinish()) continue;
            ++size;
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, DownloadTask> getTasks(String extKey, Object extVal) {
        HashMap<String, DownloadTask> result = new HashMap<String, DownloadTask>();
        Map<String, DownloadTask> map = this.tasks;
        synchronized (map) {
            for (DownloadTask task : this.tasks.values()) {
                Object val;
                Map<String, Object> extras = task.getExtras();
                if (null == extras || !(val = extras.get(extKey)).equals(extVal)) continue;
                result.put(task.getUrl(), task);
            }
        }
        return result;
    }

    public int getErrorTaskSize() {
        int size = 0;
        for (DownloadTask task : this.tasks.values()) {
            if (task.getErrorCode() == 0) continue;
            ++size;
        }
        return size;
    }

    public int getErrorTaskSize(String extKey, Object extVal) {
        int size = 0;
        for (DownloadTask task : this.getTasks(extKey, extVal).values()) {
            if (task.getErrorCode() == 0) continue;
            ++size;
        }
        return size;
    }

    public int getRunningTaskSize() {
        int size = 0;
        for (DownloadTask task : this.tasks.values()) {
            if (task.isFinish()) continue;
            ++size;
        }
        return size;
    }

    public int getRunningTaskSize(String extKey, Object extVal) {
        int size = 0;
        for (DownloadTask task : this.getTasks(extKey, extVal).values()) {
            if (task.isFinish()) continue;
            ++size;
        }
        return size;
    }

    public long getSumLength() {
        long length = 0L;
        for (DownloadTask task : this.tasks.values()) {
            length += task.getLength();
        }
        return length;
    }

    public String getSumLengthFormat() {
        long length = this.getSumLength();
        return FileUtil.length((long)length);
    }

    public long getSumTotal() {
        return this.getSumLength() + this.getSumPast();
    }

    public String getSumTotalFormat() {
        long total = this.getSumTotal();
        return FileUtil.length((long)total);
    }

    public long getSumPast() {
        long length = 0L;
        for (DownloadTask task : this.tasks.values()) {
            length += task.getPast();
        }
        return length;
    }

    public String getSumPastFormat() {
        long length = this.getSumPast();
        return FileUtil.length((long)length);
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public long getSumFinish() {
        long length = 0L;
        for (DownloadTask task : this.tasks.values()) {
            length += task.getFinish();
        }
        return length;
    }

    public String getSumFinishFormat() {
        long length = this.getSumFinish();
        return FileUtil.length((long)length);
    }

    public double getFinishRate() {
        BigDecimal decimal;
        long length = this.getSumLength();
        long past = this.getSumPast();
        long finish = this.getSumFinish();
        double rate = 0.0;
        if (length + past > 0L) {
            rate = (double)(finish + past) * 100.0 / (double)(length + past);
        }
        if ((rate = (decimal = new BigDecimal(rate)).setScale(2, 5).doubleValue()) == 100.0 && finish < length) {
            rate = 99.99;
        }
        return rate;
    }

    public long getAvgSpeed() {
        long finish = this.getSumFinish();
        long expend = this.getExpend();
        if (expend == 0L) {
            return 0L;
        }
        return finish * 1000L / expend;
    }

    public String getSpeedFormat() {
        long speed = this.getSpeed();
        return FileUtil.length((long)speed) + "/s";
    }

    public long getSpeed() {
        long speed = 0L;
        for (DownloadTask task : this.tasks.values()) {
            speed += task.getSpeed();
        }
        return speed;
    }

    public String getAvgSpeedFormat() {
        long speed = this.getAvgSpeed();
        return FileUtil.length((long)speed) + "/s";
    }

    public long getExpend() {
        long expend = 0L;
        expend = this.end == 0L ? System.currentTimeMillis() - this.start : this.end - this.start;
        return expend;
    }

    public String getExpendFormat() {
        long expend = this.getExpend();
        return DateUtil.conversion((long)expend);
    }

    public long getExpect() {
        long expect = 0L;
        long len = this.getSumLength() - this.getSumFinish();
        long speed = this.getSpeed();
        if (speed > 0L) {
            expect = len * 1000L / speed;
        }
        return expect;
    }

    public String getExpectFormat() {
        long expect = this.getExpect();
        return DateUtil.conversion((long)expect);
    }

    public Map<String, DownloadTask> getTasks() {
        return this.tasks;
    }

    public Downloader add(String url, File local, Map<String, String> headers, Map<String, Object> params, Map<String, Object> extras) {
        DownloadTask task = this.getTask(url);
        if (null == task) {
            task = new DownloadTask(url, local, headers, params, extras);
            task.setIndex(this.tasks.size());
        }
        return this.add(task);
    }

    public Downloader add(String url, File local, Map<String, String> headers, Map<String, Object> params) {
        return this.add(url, local, null, null, null);
    }

    public Downloader add(String url, File local) {
        return this.add(url, local, null, null);
    }

    public Downloader add(DownloadTask task) {
        String url;
        String code = url = task.getUrl();
        log.warn("[add task][code:{}][url:{}]", (Object)code, (Object)task.getUrl());
        if (null == this.tasks.get(code)) {
            this.tasks.put(code, task);
            task.setIndex(this.tasks.size());
        }
        return this;
    }

    public void start(int threads) {
        this.status = 1;
        if (this.start == 0L) {
            this.start = System.currentTimeMillis();
        }
        for (final DownloadTask task : this.tasks.values()) {
            if (this.tasks.size() > 1) {
                task.closeLog();
            }
            if (task.isRunning() || task.isFinish()) continue;
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    task.start();
                }
            });
            DownloaderThreadPool.execute(thread, threads);
        }
    }

    public void start() {
        this.start(Math.max(4, Math.min(Runtime.getRuntime().availableProcessors() - 1, 5)));
    }

    public int getMaxParallel() {
        return this.maxParallel;
    }

    public void setMaxParallel(int maxParallel) {
        this.maxParallel = maxParallel;
    }

    public int getCurParallel() {
        return this.curParallel;
    }

    public void setCurParallel(int curParallel) {
        this.curParallel = curParallel;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public DownloadTask getTask(String url) {
        String code = url;
        DownloadTask task = this.tasks.get(code);
        if (null == task) {
            log.error("[\u4efb\u52a1\u4e0d\u5b58\u5728][code:{}][url:{}]", (Object)code, (Object)url);
        }
        return task;
    }
}

