/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.net;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.anyline.net.DownloadTask;
import org.anyline.net.HttpCookie;
import org.anyline.net.HttpResponse;
import org.anyline.net.HttpUtil;
import org.anyline.util.BasicUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.FileUtil;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient {
    private static final Logger log = LoggerFactory.getLogger(HttpClient.class);
    private String protocol = "TLSv1";
    private RequestConfig requestConfig;
    private String userAgent = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/99.0.4844.74 Safari/537.36 Edg/99.0.1150.55";
    private PoolingHttpClientConnectionManager connManager;
    private int connectTimeout = 6000;
    private int socketTimeout = 6000;
    private Map<String, String> headers;
    private String url;
    private String charset = "UTF-8";
    private Map<String, Object> params = new HashMap<String, Object>();
    private HttpEntity entity = null;
    private List<NameValuePair> pairs = new ArrayList<NameValuePair>();
    private boolean autoClose = true;
    private DownloadTask task;
    private Map<String, Object> files;
    private String returnType = "text";
    private CloseableHttpClient client;

    public HttpClient() {
        RequestConfig.Builder configBuilder = RequestConfig.custom();
        configBuilder.setConnectTimeout(this.connectTimeout);
        configBuilder.setSocketTimeout(this.socketTimeout);
        configBuilder.setConnectionRequestTimeout(this.connectTimeout);
        configBuilder.setStaleConnectionCheckEnabled(true);
        this.requestConfig = configBuilder.build();
    }

    public HttpResponse post() {
        if (null != this.params && !this.params.isEmpty()) {
            List<NameValuePair> pairs = HttpUtil.packNameValuePair(this.params);
            try {
                this.entity = new UrlEncodedFormEntity(pairs, this.charset);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        HttpPost method = new HttpPost(this.url);
        if (null != this.entity) {
            method.setEntity(this.entity);
        }
        return this.exe((HttpRequestBase)method);
    }

    public HttpResponse put() {
        if (null != this.params && !this.params.isEmpty()) {
            List<NameValuePair> pairs = HttpUtil.packNameValuePair(this.params);
            try {
                this.entity = new UrlEncodedFormEntity(pairs, this.charset);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        HttpPut method = new HttpPut(this.url);
        if (null != this.entity) {
            method.setEntity(this.entity);
        }
        return this.exe((HttpRequestBase)method);
    }

    public HttpResponse get() {
        this.url = HttpUtil.mergeParam(this.url, this.params);
        if (null != this.pairs && !this.pairs.isEmpty()) {
            this.url = HttpUtil.mergeParam(this.url, URLEncodedUtils.format(this.pairs, (String)this.charset));
        }
        HttpGet method = new HttpGet(this.url);
        return this.exe((HttpRequestBase)method);
    }

    public HttpResponse delete() {
        this.url = HttpUtil.mergeParam(this.url, this.params);
        if (null != this.pairs && !this.pairs.isEmpty()) {
            this.url = HttpUtil.mergeParam(this.url, URLEncodedUtils.format(this.pairs, (String)this.charset));
        }
        HttpDelete method = new HttpDelete(this.url);
        return this.exe((HttpRequestBase)method);
    }

    public HttpResponse postStream(Map<String, String> headers, String url, String encode, HttpEntity entity) {
        HttpResponse result = new HttpResponse();
        InputStream is = null;
        if (null == this.client) {
            this.client = HttpUtil.client((String)url);
        }
        if (((String)url).startsWith("//")) {
            url = "http:" + (String)url;
        }
        HttpPost method = new HttpPost((String)url);
        if (null != entity) {
            method.setEntity(entity);
        }
        HttpClient.setHeader((HttpRequestBase)method, headers);
        try {
            CloseableHttpResponse response = this.client.execute((HttpUriRequest)method);
            is = response.getEntity().getContent();
            result.setInputStream(is);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse exe(HttpRequestBase method) {
        HttpClient.setHeader(method, this.headers);
        if (null == this.client) {
            this.client = HttpUtil.client(this.url, this.userAgent);
        }
        if (this.url.startsWith("//")) {
            this.url = "http:" + this.url;
        }
        CloseableHttpResponse response = null;
        HttpResponse result = null;
        try {
            long fr = System.currentTimeMillis();
            if (ConfigTable.IS_HTTP_LOG && log.isWarnEnabled()) {
                log.warn("[http request][method:{}][url:{}]", (Object)method.getMethod(), (Object)method.getURI());
            }
            if ("stream".equals(this.returnType)) {
                response = this.client.execute((HttpUriRequest)method);
                InputStream is = response.getEntity().getContent();
                result = new HttpResponse();
                result.setInputStream(is);
            } else {
                method.setHeader("Connection", "close");
                response = this.client.execute((HttpUriRequest)method);
                result = HttpClient.parseResult(result, response, this.charset);
            }
            if (ConfigTable.IS_HTTP_LOG && log.isWarnEnabled()) {
                log.warn("[http request][method:{}][status:{}][\u8017\u65f6:{}][url:{}]", new Object[]{method.getMethod(), result.getStatus(), System.currentTimeMillis() - fr, method.getURI()});
            }
        }
        catch (Exception e) {
            result = new HttpResponse();
            e.printStackTrace();
        }
        finally {
            if (!"stream".equals(this.returnType)) {
                try {
                    if (null != response) {
                        response.close();
                    }
                    method.releaseConnection();
                    if (this.autoClose) {
                        this.client.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean download() {
        Object finalUrl;
        boolean result = false;
        Object url = this.task.getUrl();
        if (null == this.client) {
            this.client = HttpUtil.client((String)url);
        }
        if (((String)url).startsWith("//")) {
            url = "http:" + (String)url;
        }
        if (null != (finalUrl = url) && ((String)finalUrl).startsWith("//")) {
            finalUrl = "http:" + (String)url;
        }
        finalUrl = HttpUtil.mergeParam((String)finalUrl, this.task.getParams());
        File dst = this.task.getLocal();
        if (BasicUtil.isEmpty((Object)url) || BasicUtil.isEmpty((Object)dst)) {
            return result;
        }
        long past = 0L;
        long length = 0L;
        boolean override = this.task.isOverride();
        if (dst.exists() && !override) {
            past = dst.length();
            this.task.init(length, past);
            this.task.finish();
            return true;
        }
        File parent = dst.getParentFile();
        if (null != parent && !parent.exists()) {
            parent.mkdirs();
        }
        HttpGet get = new HttpGet((String)finalUrl);
        get.setConfig(this.requestConfig);
        Map<String, String> headers = this.task.getHeaders();
        if (null != headers) {
            for (String key : headers.keySet()) {
                get.setHeader(key, headers.get(key));
            }
        }
        RandomAccessFile raf = null;
        InputStream is = null;
        File tmpFile = new File(dst.getParent(), dst.getName() + ".downloading");
        File configFile = new File(dst.getParent(), dst.getName() + ".downloading.config");
        String config = "";
        if (configFile.exists()) {
            config = FileUtil.read((File)configFile).toString();
        }
        long start = 0L;
        if (tmpFile.exists()) {
            start = tmpFile.length();
        }
        String range = "bytes=" + start + "-";
        get.setHeader("Range", range);
        try {
            CloseableHttpResponse response = this.client.execute((HttpUriRequest)get);
            int code = response.getStatusLine().getStatusCode();
            if (code == 416) {
                get.removeHeaders("Range");
                response = this.client.execute((HttpUriRequest)get);
                code = response.getStatusLine().getStatusCode();
                log.warn("[http download][\u65ad\u70b9\u8bbe\u7f6e\u5f02\u5e38][url:{}]", url);
            }
            if (code != 200 && code != 206) {
                this.task.error(code, "\u72b6\u6001\u5f02\u5e38");
                boolean bl = false;
                return bl;
            }
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                long total = entity.getContentLength();
                this.task.init(total, past);
                int buf = 0xA00000;
                if ((long)buf > total) {
                    buf = (int)total;
                }
                is = entity.getContent();
                raf = new RandomAccessFile(tmpFile, "rwd");
                raf.seek(start);
                byte[] buffer = new byte[buf];
                int len = -1;
                while ((len = is.read(buffer)) != -1) {
                    if (this.task.getAction() != 1) {
                        log.warn("[http download][break][url:{}]", url);
                        break;
                    }
                    raf.write(buffer, 0, len);
                    this.task.step(len);
                }
            }
            result = true;
        }
        catch (Exception e) {
            this.task.error(-1, e.toString());
            log.warn("[http download][\u4e0b\u8f7d\u5f02\u5e38][url:{}]", url);
            e.printStackTrace();
        }
        finally {
            if (null != raf) {
                try {
                    raf.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (null != is) {
                try {
                    is.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                this.client.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (result) {
            tmpFile.renameTo(dst);
            this.task.finish();
        }
        return result;
    }

    public HttpResponse upload() {
        if (null != this.url && this.url.startsWith("//")) {
            this.url = "http:" + this.url;
        }
        if (BasicUtil.isEmpty((Object)this.charset)) {
            this.charset = "UTF-8";
        }
        String BOUNDARY = "-----" + BasicUtil.getRandomLowerString((int)20);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.RFC6532);
        HttpPost post = new HttpPost(this.url);
        post.setConfig(this.requestConfig);
        builder.setBoundary(BOUNDARY);
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        builder.setCharset(Charset.forName(this.charset));
        ContentType contentType = ContentType.create((String)"text/plain", (Charset)Charset.forName(this.charset));
        HttpUtil.mergeParam(builder, this.params, contentType);
        if (null != this.headers) {
            for (String string : this.headers.keySet()) {
                post.setHeader(string, this.headers.get(string));
            }
        }
        Object fileLog = "";
        if (null != this.files) {
            for (String key : this.files.keySet()) {
                Object val = this.files.get(key);
                if (null == val) continue;
                if (val instanceof File) {
                    File file = (File)val;
                    builder.addBinaryBody(key, file, ContentType.MULTIPART_FORM_DATA, file.getName());
                    fileLog = (String)fileLog + "[" + key + ":" + file.getAbsolutePath() + "]";
                    continue;
                }
                if (val instanceof byte[]) {
                    byte[] bytes = (byte[])val;
                    builder.addBinaryBody(key, bytes, ContentType.MULTIPART_FORM_DATA, key);
                    fileLog = (String)fileLog + "[" + key + ":bytes]";
                    continue;
                }
                if (!(val instanceof InputStream)) continue;
                InputStream is = (InputStream)val;
                builder.addBinaryBody(key, is, ContentType.MULTIPART_FORM_DATA, key);
            }
        }
        if (ConfigTable.IS_HTTP_LOG && log.isWarnEnabled()) {
            log.warn("[http upload][url:{}]" + (String)fileLog, (Object)this.url);
        }
        HttpEntity httpEntity = builder.build();
        post.setEntity(httpEntity);
        post.addHeader("Content-Type", "multipart/form-data;boundary=" + BOUNDARY);
        HttpResponse source = this.exe((HttpRequestBase)post);
        return source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int status() {
        int code = -1;
        CloseableHttpClient client = HttpUtil.defaultSSLClient();
        CloseableHttpResponse response = null;
        if (this.url.startsWith("//")) {
            this.url = "http:" + this.url;
        }
        HttpGet method = new HttpGet(this.url);
        try {
            response = client.execute((HttpUriRequest)method);
            code = response.getStatusLine().getStatusCode();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                response.close();
                method.releaseConnection();
                client.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return code;
    }

    public static HttpResponse parseResult(HttpResponse result, CloseableHttpResponse response, String encode) {
        if (null == result) {
            result = new HttpResponse();
        }
        try {
            if (null != response) {
                Header[] all;
                HashMap<String, String> headers = new HashMap<String, String>();
                for (Header header : all = response.getAllHeaders()) {
                    String key = header.getName();
                    String value = header.getValue();
                    headers.put(key, value);
                    if (!"Set-Cookie".equalsIgnoreCase(key)) continue;
                    HttpCookie c = new HttpCookie(value);
                    result.setCookie(c);
                }
                int code = response.getStatusLine().getStatusCode();
                result.setHeaders(headers);
                result.setStatus(code);
                HttpEntity entity = response.getEntity();
                if (null != entity) {
                    result.setInputStream(entity.getContent());
                    String text = EntityUtils.toString((HttpEntity)entity, (String)encode);
                    result.setText(text);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void setHeader(HttpRequestBase method, Map<String, String> headers) {
        if (null != headers) {
            for (String key : headers.keySet()) {
                String value = headers.get(key);
                method.setHeader(key, value);
            }
        }
    }

    public CloseableHttpClient createClient() {
        CloseableHttpClient client = null;
        HttpClientBuilder builder = HttpClients.custom().setDefaultRequestConfig(this.requestConfig);
        builder.setUserAgent(this.userAgent);
        client = builder.build();
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableHttpClient ceateSSLClient(File keyFile, String protocol, String password) {
        CloseableHttpClient httpclient = null;
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            try (FileInputStream instream = new FileInputStream(keyFile);){
                keyStore.load(instream, password.toCharArray());
            }
            SSLContext sslcontext = SSLContexts.custom().loadKeyMaterial(keyStore, password.toCharArray()).build();
            String[] protocols = new String[]{protocol};
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, protocols, null, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return httpclient;
    }

    public CloseableHttpClient ceateSSLClient(File keyFile, String password) {
        return this.ceateSSLClient(keyFile, this.protocol, password);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public RequestConfig getRequestConfig() {
        return this.requestConfig;
    }

    public void setRequestConfig(RequestConfig requestConfig) {
        this.requestConfig = requestConfig;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public PoolingHttpClientConnectionManager getConnManager() {
        return this.connManager;
    }

    public void setConnManager(PoolingHttpClientConnectionManager connManager) {
        this.connManager = connManager;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setEncode(String charset) {
        this.charset = charset;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public List<NameValuePair> getPairs() {
        return this.pairs;
    }

    public void setPairs(List<NameValuePair> pairs) {
        this.pairs = pairs;
    }

    public boolean isAutoClose() {
        return this.autoClose;
    }

    public void setAutoClose(boolean autoClose) {
        this.autoClose = autoClose;
    }

    public DownloadTask getTask() {
        return this.task;
    }

    public void setTask(DownloadTask task) {
        this.task = task;
    }

    public Map<String, Object> getFiles() {
        return this.files;
    }

    public void setFiles(Map<String, Object> files) {
        this.files = files;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public CloseableHttpClient getClient() {
        return this.client;
    }

    public void setClient(CloseableHttpClient client) {
        this.client = client;
    }

    public HttpEntity getEntity() {
        return this.entity;
    }

    public void setEntity(HttpEntity entity) {
        this.entity = entity;
    }

    public Object getParam(String key) {
        if (null != this.params) {
            return this.params.get(key);
        }
        return null;
    }
}

