/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.net;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.anyline.net.DefaultProgress;
import org.anyline.net.DownloadProgress;
import org.anyline.net.DownloadTask;
import org.anyline.net.HttpBuilder;
import org.anyline.net.HttpResponse;
import org.anyline.net.SimpleX509TrustManager;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ConfigTable;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.ByteArrayBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);
    private static CloseableHttpClient default_client;
    private static CloseableHttpClient default_ssl_client;
    private static RequestConfig default_request_config;
    private static int default_connect_timeout;
    private static int default_socket_timeout;
    private static String default_user_agent;
    public static String PROTOCOL_TLSV1;

    public static HttpResponse post(String url, String charset, Map<String, Object> params) {
        return HttpUtil.post(null, url, charset, params);
    }

    public static HttpResponse post(String url, Map<String, Object> params) {
        return HttpUtil.post(null, url, "UTF-8", params);
    }

    public static HttpResponse post(String url) {
        return HttpUtil.post(null, url, "UTF-8", (HttpEntity)null);
    }

    public static HttpResponse post(Map<String, String> headers, String url) {
        return HttpUtil.post(headers, url, "UTF-8", (HttpEntity)null);
    }

    public static HttpResponse post(String url, String charset, HttpEntity entity) {
        return HttpUtil.post(null, url, charset, entity);
    }

    public static HttpResponse post(String url, HttpEntity entity) {
        return HttpUtil.post(null, url, null, entity);
    }

    public static HttpResponse post(Map<String, String> headers, String url, HttpEntity entity) {
        return HttpUtil.post(headers, url, null, entity);
    }

    public static HttpResponse post(Map<String, String> headers, String url, String charset, Map<String, Object> params) {
        return HttpBuilder.init().setHeaders(headers).setUrl(url).setCharset(charset).setParams(params).build().post();
    }

    public static HttpResponse post(Map<String, String> headers, String url, String charset, HttpEntity entity) {
        return HttpBuilder.init().setHeaders(headers).setUrl(url).setCharset(charset).setEntity(entity).build().post();
    }

    public static HttpResponse put(String url, String charset, Map<String, Object> params) {
        return HttpUtil.put(null, url, charset, params);
    }

    public static HttpResponse put(Map<String, String> headers, String url, String charset, Map<String, Object> params) {
        return HttpBuilder.init().setHeaders(headers).setUrl(url).setCharset(charset).setParams(params).build().put();
    }

    public static HttpResponse put(Map<String, String> headers, String url, String charset, HttpEntity entity) {
        return HttpBuilder.init().setHeaders(headers).setUrl(url).setCharset(charset).setEntity(entity).build().put();
    }

    public static HttpResponse stream(String url) {
        return HttpUtil.stream(null, url, "UTF-8", (HttpEntity)null);
    }

    public static HttpResponse stream(String url, String charset, HttpEntity entity) {
        return HttpUtil.stream(null, url, charset, entity);
    }

    public static HttpResponse stream(String url, String charset, Map<String, Object> params) {
        return HttpUtil.stream(null, url, charset, params);
    }

    public static HttpResponse stream(Map<String, String> headers, String url, String charset, Map<String, Object> params) {
        return HttpBuilder.init().setHeaders(headers).setUrl(url).setCharset(charset).setParams(params).setReturnType("stream").build().post();
    }

    public static HttpResponse stream(Map<String, String> headers, String url, String charset, HttpEntity entity) {
        return HttpBuilder.init().setHeaders(headers).setUrl(url).setCharset(charset).setEntity(entity).setReturnType("stream").build().post();
    }

    public static HttpResponse get(String url) {
        return HttpUtil.get(url, "UTF-8");
    }

    public static HttpResponse get(String url, String charset) {
        return HttpUtil.get(url, charset, new HashMap<String, Object>());
    }

    public static HttpResponse get(String url, String charset, Map<String, Object> params) {
        return HttpUtil.get(null, url, charset, params);
    }

    public static HttpResponse get(Map<String, String> headers, String url, String charset, Map<String, Object> params) {
        return HttpBuilder.init().setHeaders(headers).setUrl(url).setCharset(charset).setParams(params).build().get();
    }

    public static HttpResponse get(String url, String charset, List<NameValuePair> pairs) {
        return HttpUtil.get(null, url, charset, pairs);
    }

    public static HttpResponse get(Map<String, String> headers, String url, String charset, List<NameValuePair> pairs) {
        return HttpBuilder.init().setHeaders(headers).setUrl(url).setCharset(charset).setPairs(pairs).build().get();
    }

    public static HttpResponse get(Map<String, String> headers, String url, String charset) {
        return HttpBuilder.init().setHeaders(headers).setUrl(url).setCharset(charset).build().get();
    }

    public static HttpResponse get(Map<String, String> headers, String url) {
        return HttpBuilder.init().setHeaders(headers).setUrl(url).build().get();
    }

    public static HttpResponse delete(String url, String charset, Map<String, Object> params) {
        return HttpUtil.delete(null, url, charset, params);
    }

    public static HttpResponse delete(Map<String, String> headers, String url, String charset, Map<String, Object> params) {
        return HttpBuilder.init().setHeaders(headers).setUrl(url).setCharset(charset).setParams(params).build().delete();
    }

    public static HttpResponse delete(String url, String charset, List<NameValuePair> pairs) {
        return HttpUtil.delete(null, url, charset, pairs);
    }

    public static HttpResponse delete(Map<String, String> headers, String url, String charset, NameValuePair ... pairs) {
        return HttpUtil.delete(headers, url, charset, BeanUtil.array2list((Object[][])new NameValuePair[][]{pairs}));
    }

    public static HttpResponse delete(Map<String, String> headers, String url, String charset, List<NameValuePair> pairs) {
        return HttpBuilder.init().setHeaders(headers).setUrl(url).setCharset(charset).setPairs(pairs).build().delete();
    }

    public static int status(String url) {
        return HttpBuilder.init().setUrl(url).build().status();
    }

    public static DownloadTask download(String url, String dst) {
        File file = new File(dst);
        return HttpUtil.download(url, file, null, null, false);
    }

    public static DownloadTask download(String url, File dst) {
        return HttpUtil.download(url, dst, null, null, false);
    }

    public static DownloadTask download(String url, String dest, Map<String, String> headers, Map<String, Object> params) {
        File file = new File(dest);
        return HttpUtil.download(url, file, headers, params, false);
    }

    public static DownloadTask download(String url, File dst, Map<String, String> headers, Map<String, Object> params) {
        return HttpUtil.download(url, dst, headers, params, false);
    }

    public static DownloadTask download(String url, String dest, Map<String, String> headers, Map<String, Object> params, boolean override) {
        File file = new File(dest);
        return HttpUtil.download(url, file, headers, params, override);
    }

    public static DownloadTask download(String url, File dst, Map<String, String> headers, Map<String, Object> params, boolean override) {
        return HttpUtil.download((DownloadProgress)new DefaultProgress(url, dst), url, dst, headers, params, override);
    }

    public static DownloadTask download(DownloadProgress progress, String url, String dest, boolean override) {
        return HttpUtil.download(progress, url, new File(dest), null, null, override);
    }

    public static DownloadTask download(DownloadProgress progress, String url, File dst, boolean override) {
        return HttpUtil.download(progress, url, dst, null, null, override);
    }

    public static DownloadTask download(DownloadProgress progress, String url, String dest, Map<String, String> headers, Map<String, Object> params, boolean override) {
        return HttpUtil.download(progress, url, new File(dest), headers, params, override);
    }

    public static DownloadTask download(DownloadProgress progress, String url, File dst, Map<String, String> headers, Map<String, Object> params, boolean override) {
        DownloadTask task = new DownloadTask();
        task.setProgress(progress);
        task.setLocal(dst);
        task.setUrl(url);
        task.setHeaders(headers);
        task.setParams(params);
        task.setOverride(override);
        HttpBuilder.init().addDownloadTask(task).build().download();
        return task;
    }

    public static HttpResponse upload(String url, Map<String, Object> files, Map<String, String> headers, Map<String, Object> params) {
        return HttpUtil.upload(url, files, "UTF-8", headers, params);
    }

    public static HttpResponse upload(String url, Map<String, Object> files, Map<String, Object> params) {
        return HttpUtil.upload(url, files, null, params);
    }

    public static HttpResponse upload(String url, Map<String, Object> files) {
        return HttpUtil.upload(url, files, null, null);
    }

    public static HttpResponse upload(String url, Map<String, Object> files, String charset, Map<String, String> headers, Map<String, Object> params) {
        return HttpBuilder.init().setUrl(url).setCharset(charset).setHeaders(headers).setParams(params).setUploadFiles(files).build().upload();
    }

    public static String mergePath(String ... paths) {
        String result = null;
        String separator = "/";
        if (null != paths) {
            for (String path : paths) {
                if (BasicUtil.isEmpty((Object)path)) continue;
                path = path.replace("\\", "/");
                if (null == result) {
                    result = path;
                    continue;
                }
                if (result.endsWith("/")) {
                    if (path.startsWith("/")) {
                        result = result + path.substring(1);
                        continue;
                    }
                    result = result + path;
                    continue;
                }
                result = path.startsWith("/") ? result + path : result + separator + path;
            }
        }
        return result;
    }

    public static String createFullPath(String host, String url) {
        if (url.startsWith("http") || url.startsWith("//") || BasicUtil.isEmpty((Object)host)) {
            return url;
        }
        String fullPath = null;
        fullPath = url.startsWith("/") ? HttpUtil.host(host) + url : (url.startsWith("?") ? HttpUtil.parsePath(host) + url : ((host = HttpUtil.parseDir(host)).endsWith("/") ? host + url : host + "/" + url));
        return fullPath;
    }

    public static String host(String url) {
        if (null == url) {
            return null;
        }
        String str = url.replaceAll("http://", "").replaceAll("https://", "").replaceAll("//", "");
        int idx = str.indexOf("/");
        if (idx != -1) {
            str = str.substring(0, idx);
        }
        if (url.startsWith("https")) {
            return "https://" + str;
        }
        if (url.startsWith("//")) {
            return "//" + str;
        }
        return "http://" + str;
    }

    public static String domain(String url) {
        if (null == url) {
            return null;
        }
        if ((url = url.replace("http://", "").replace("https://", "")).contains(":")) {
            url = url.substring(0, url.indexOf(":"));
        }
        if (url.contains("/")) {
            url = url.substring(0, url.indexOf("/"));
        }
        return url;
    }

    public static String parsePath(String url) {
        int to = url.indexOf("?");
        if (to != -1) {
            url = url.substring(0, to);
        }
        return url;
    }

    public static String parseDir(String url) {
        String dir = null;
        if (null == url) {
            return dir;
        }
        if (url.endsWith("/")) {
            dir = url;
        } else if (HttpUtil.isHttpFile(url)) {
            int to = url.lastIndexOf("/");
            dir = url.substring(0, to);
        } else {
            dir = url;
        }
        return dir;
    }

    public static String parseFileName(String url) {
        String name = null;
        if (null != url && !(url = url.replace("://", "")).endsWith("/") && (name = url.substring(url.lastIndexOf("/") + 1)).contains("?")) {
            name = name.substring(0, name.indexOf("?"));
        }
        return name;
    }

    private static boolean isHttpFile(String path) {
        if (path.endsWith("/")) {
            return false;
        }
        String head = "http://";
        int fr = head.length();
        int l1 = path.lastIndexOf("/");
        int l2 = path.lastIndexOf(".");
        if (l1 == -1) {
            return false;
        }
        return l2 > l1 && l2 > fr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(InputStream is, String charset) {
        if (is == null) {
            return null;
        }
        ByteArrayBuffer bab = new ByteArrayBuffer(0);
        byte[] b = new byte[1024];
        int len = 0;
        try {
            while ((len = is.read(b)) != -1) {
                bab.append(b, 0, len);
            }
            String string = new String(bab.toByteArray(), charset);
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String mergeParam(String url, Map<String, Object> params) {
        if (BasicUtil.isEmpty(params)) {
            return url;
        }
        if (null == url) {
            url = "";
        }
        url = url.trim();
        String kv = BeanUtil.map2string(params);
        if (BasicUtil.isNotEmpty((Object)kv)) {
            if (url.indexOf("?") > -1) {
                if (url.indexOf("?") < url.length() - 1 && url.indexOf("&") < url.length() - 1) {
                    url = url + "&";
                }
            } else {
                url = url + "?";
            }
            url = url + kv;
        }
        return url;
    }

    public static MultipartEntityBuilder mergeParam(MultipartEntityBuilder builder, Map<String, Object> params, ContentType contetType) {
        if (null != params) {
            String[] kvs;
            String txt = BeanUtil.map2string(params);
            for (String kv : kvs = txt.split("&")) {
                String[] tmps = kv.split("=");
                if (tmps.length != 2) continue;
                builder.addTextBody(tmps[0], tmps[1], contetType);
            }
        }
        return builder;
    }

    public static String mergeParam(String url, String ... params) {
        if (BasicUtil.isEmpty((Object)url) || BasicUtil.isEmpty((Object[])params)) {
            return url;
        }
        if ((url = url.trim()).indexOf("?") > -1) {
            if (url.indexOf("?") < url.length() - 1 && url.indexOf("&") < url.length() - 1) {
                url = url + "&";
            }
        } else {
            url = url + "?";
        }
        String tmp = null;
        for (String param : params) {
            if (BasicUtil.isEmpty((Object)param)) continue;
            tmp = null == tmp ? param : tmp + "&" + param;
        }
        url = url + tmp;
        return url;
    }

    public static List<NameValuePair> packNameValuePair(Map<String, Object> params) {
        ArrayList<NameValuePair> pairs = new ArrayList<NameValuePair>();
        if (null != params) {
            for (String key : params.keySet()) {
                Object vals;
                Object value = params.get(key);
                if (null == value) continue;
                if (value instanceof String[]) {
                    for (Object val : vals = (String[])value) {
                        if (null == val) continue;
                        pairs.add((NameValuePair)new BasicNameValuePair(key, (String)val));
                        if (!ConfigTable.IS_DEBUG || !log.isWarnEnabled()) continue;
                        log.info("[request param][{}={}]", (Object)key, (Object)BasicUtil.cut((String)val, (int)0, (int)20));
                    }
                    continue;
                }
                if (value instanceof Collection) {
                    vals = (Collection)value;
                    Iterator iterator = vals.iterator();
                    while (iterator.hasNext()) {
                        Object val = iterator.next();
                        if (null == val) continue;
                        pairs.add((NameValuePair)new BasicNameValuePair(key, val.toString()));
                        if (!ConfigTable.IS_DEBUG || !log.isInfoEnabled()) continue;
                        log.info("[request param][{}={}]", (Object)key, (Object)BasicUtil.cut((String)val.toString(), (int)0, (int)20));
                    }
                    continue;
                }
                if (null == value) continue;
                pairs.add((NameValuePair)new BasicNameValuePair(key, value.toString()));
                if (!ConfigTable.IS_DEBUG || !log.isInfoEnabled()) continue;
                log.info("[request param][{}={}]", (Object)key, (Object)BasicUtil.cut((String)value.toString(), (int)0, (int)20));
            }
        }
        return pairs;
    }

    public static CloseableHttpClient client(String url) {
        if (url.contains("https://")) {
            return HttpUtil.defaultSSLClient();
        }
        return HttpUtil.defaultClient();
    }

    public static CloseableHttpClient client(String url, String userAgent) {
        if (url.contains("https://")) {
            return HttpUtil.defaultSSLClient(userAgent);
        }
        return HttpUtil.defaultClient(userAgent);
    }

    public static CloseableHttpClient defaultClient() {
        return HttpUtil.defaultClient(default_user_agent);
    }

    public static CloseableHttpClient defaultClient(String userAgent) {
        HttpClientBuilder builder = HttpClients.custom().setDefaultRequestConfig(default_request_config);
        builder.setUserAgent(userAgent);
        default_client = builder.build();
        return default_client;
    }

    public static CloseableHttpClient createClient(String userAgent) {
        CloseableHttpClient client = null;
        HttpClientBuilder builder = HttpClients.custom().setDefaultRequestConfig(default_request_config);
        builder.setUserAgent(userAgent);
        client = builder.build();
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CloseableHttpClient ceateSSLClient(File keyFile, String protocol, String password) {
        CloseableHttpClient httpclient = null;
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            try (FileInputStream instream = new FileInputStream(keyFile);){
                keyStore.load(instream, password.toCharArray());
            }
            SSLContext sslcontext = SSLContexts.custom().loadKeyMaterial(keyStore, password.toCharArray()).build();
            String[] protocols = new String[]{protocol};
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, protocols, null, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return httpclient;
    }

    public static CloseableHttpClient defaultSSLClient() {
        return HttpUtil.defaultSSLClient(default_user_agent);
    }

    public static CloseableHttpClient defaultSSLClient(String userAgent) {
        try {
            if (null != default_ssl_client) {
                return default_ssl_client;
            }
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
            httpClientBuilder.setUserAgent(userAgent);
            httpClientBuilder.setMaxConnTotal(10000);
            httpClientBuilder.setMaxConnPerRoute(1000);
            httpClientBuilder.evictIdleConnections(15L, TimeUnit.SECONDS);
            SocketConfig.Builder socketConfigBuilder = SocketConfig.custom();
            socketConfigBuilder.setTcpNoDelay(true);
            httpClientBuilder.setDefaultSocketConfig(socketConfigBuilder.build());
            RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
            requestConfigBuilder.setConnectTimeout(default_connect_timeout);
            requestConfigBuilder.setSocketTimeout(default_socket_timeout);
            httpClientBuilder.setDefaultRequestConfig(requestConfigBuilder.build());
            SSLContext ctx = SSLContext.getInstance("TLS");
            SimpleX509TrustManager tm = new SimpleX509TrustManager(null);
            ctx.init(null, new TrustManager[]{tm}, null);
            httpClientBuilder.setSslcontext(ctx);
            httpClientBuilder.setConnectionManagerShared(true);
            default_ssl_client = httpClientBuilder.build();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return default_ssl_client;
    }

    public static String encode(String src, boolean cn) {
        if (cn) {
            try {
                return URLEncoder.encode(src, "UTF-8");
            }
            catch (Exception e) {
                return src;
            }
        }
        String result = src;
        result = result.replace(" ", "").replace("\n", "").replace("\r", "").replace("\t", "").replace("~", "%7E").replace("!", "%21").replace("@", "%40").replace("#", "%23").replace("$", "%24").replace("%", "%25").replace("^", "%5E").replace("&", "%26").replace("(", "%28").replace(")", "%29").replace("=", "%3D").replace("`", "%60").replace("+", "%2B").replace("{", "%7B").replace("}", "%7D").replace("[", "%5B").replace("]", "%5D").replace("<", "%3C").replace(">", "%3E").replace(",", "%2C").replace("/", "%2F").replace("\\", "%5C").replace("?", "%3F").replace(";", "%3B").replace("'", "%27").replace(":", "%3A").replace("\"", "%22");
        return result;
    }

    static {
        default_connect_timeout = 72000;
        default_socket_timeout = 72000;
        default_user_agent = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/99.0.4844.74 Safari/537.36 Edg/99.0.1150.55";
        PROTOCOL_TLSV1 = "TLSv1";
    }
}

