/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.net;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.anyline.net.DefaultProgress;
import org.anyline.net.DownloadProgress;
import org.anyline.net.DownloadTask;
import org.anyline.net.HttpCookie;
import org.anyline.net.HttpResult;
import org.anyline.net.SimpleX509TrustManager;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.FileUtil;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.ByteArrayBuffer;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    public static String PROTOCOL_TLSV1 = "TLSv1";
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);
    private static PoolingHttpClientConnectionManager connManager;
    private static RequestConfig requestConfig;
    private static String userAgent;
    private static int MAX_TIMEOUT;
    private static CloseableHttpClient client;
    private static CloseableHttpClient sslClient;
    private Map<String, HttpUtil> instances = new HashMap<String, HttpUtil>();

    public HttpUtil getInstance() {
        return this.getInstance("default");
    }

    public HttpUtil getInstance(String key) {
        HttpUtil instance;
        if (BasicUtil.isEmpty((Object)key)) {
            key = "default";
        }
        if (null == (instance = this.instances.get(key))) {
            instance = new HttpUtil();
            this.instances.put(key, instance);
        }
        return instance;
    }

    public static HttpResult post(CloseableHttpClient client, String url, String encode, HttpEntity ... entitys) {
        return HttpUtil.post(client, null, url, encode, entitys);
    }

    public static HttpResult post(CloseableHttpClient client, Map<String, String> headers, String url, String encode, HttpEntity ... entitys) {
        ArrayList<HttpEntity> list = new ArrayList<HttpEntity>();
        if (null != entitys) {
            for (HttpEntity entity : entitys) {
                list.add(entity);
            }
        }
        return HttpUtil.post(client, headers, url, encode, list);
    }

    public static HttpResult post(CloseableHttpClient client, String url, String encode, Map<String, Object> params) {
        return HttpUtil.post(client, null, url, encode, params);
    }

    public static HttpResult post(CloseableHttpClient client, Map<String, String> headers, String url, String encode, Map<String, Object> params) {
        ArrayList<HttpEntity> entitys = new ArrayList<HttpEntity>();
        if (null != params && !params.isEmpty()) {
            List<NameValuePair> pairs = HttpUtil.packNameValuePair(params);
            try {
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(pairs, encode);
                entitys.add((HttpEntity)entity);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return HttpUtil.post(client, headers, url, encode, entitys);
    }

    public static HttpResult post(CloseableHttpClient client, Map<String, String> headers, String url, String encode, List<HttpEntity> entitys) {
        if (null == client) {
            HttpUtil.client(url);
        }
        if (url.startsWith("//")) {
            url = "http:" + url;
        }
        HttpResult result = new HttpResult();
        HttpPost method = new HttpPost(url);
        if (null != entitys) {
            for (HttpEntity entity : entitys) {
                method.setEntity(entity);
            }
        }
        HttpUtil.setHeader((HttpRequestBase)method, headers);
        result = HttpUtil.exe(client, (HttpRequestBase)method, encode);
        return result;
    }

    public static HttpResult post(String url, String encode, HttpEntity ... entitys) {
        return HttpUtil.post(HttpUtil.client(url), url, encode, entitys);
    }

    public static HttpResult post(Map<String, String> headers, String url, String encode, HttpEntity ... entitys) {
        return HttpUtil.post(HttpUtil.client(url), headers, url, encode, entitys);
    }

    public static HttpResult post(String url, String encode, Map<String, Object> params) {
        return HttpUtil.post(HttpUtil.client(url), url, encode, params);
    }

    public static HttpResult post(Map<String, String> headers, String url, String encode, Map<String, Object> params) {
        return HttpUtil.post(HttpUtil.client(url), headers, url, encode, params);
    }

    public static HttpResult post(String url, Map<String, Object> params) {
        return HttpUtil.post(HttpUtil.client(url), null, url, "UTF-8", params);
    }

    public static HttpResult post(Map<String, String> headers, String url, String encode, List<HttpEntity> entitys) {
        return HttpUtil.post(HttpUtil.client(url), headers, url, encode, entitys);
    }

    public static HttpResult put(CloseableHttpClient client, String url, String encode, HttpEntity ... entitys) {
        return HttpUtil.put(client, null, url, encode, entitys);
    }

    public static HttpResult put(CloseableHttpClient client, Map<String, String> headers, String url, String encode, HttpEntity ... entitys) {
        ArrayList<HttpEntity> list = new ArrayList<HttpEntity>();
        if (null != entitys) {
            for (HttpEntity entity : entitys) {
                list.add(entity);
            }
        }
        return HttpUtil.put(client, headers, url, encode, list);
    }

    public static HttpResult put(CloseableHttpClient client, String url, String encode, Map<String, Object> params) {
        return HttpUtil.put(client, null, url, encode, params);
    }

    public static HttpResult put(CloseableHttpClient client, Map<String, String> headers, String url, String encode, Map<String, Object> params) {
        ArrayList<HttpEntity> entitys = new ArrayList<HttpEntity>();
        if (null != params && !params.isEmpty()) {
            List<NameValuePair> pairs = HttpUtil.packNameValuePair(params);
            try {
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(pairs, encode);
                entitys.add((HttpEntity)entity);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return HttpUtil.put(client, headers, url, encode, entitys);
    }

    public static HttpResult put(CloseableHttpClient client, Map<String, String> headers, String url, String encode, List<HttpEntity> entitys) {
        if (null == client) {
            client = HttpUtil.client(url);
        }
        if (url.startsWith("//")) {
            url = "http:" + url;
        }
        HttpResult result = new HttpResult();
        HttpPut method = new HttpPut(url);
        if (null != entitys) {
            for (HttpEntity entity : entitys) {
                method.setEntity(entity);
            }
        }
        HttpUtil.setHeader((HttpRequestBase)method, headers);
        result = HttpUtil.exe(client, (HttpRequestBase)method, encode);
        return result;
    }

    public static HttpResult put(String url, String encode, HttpEntity ... entitys) {
        return HttpUtil.put(HttpUtil.client(url), url, encode, entitys);
    }

    public static HttpResult put(Map<String, String> headers, String url, String encode, HttpEntity ... entitys) {
        return HttpUtil.put(HttpUtil.client(url), headers, url, encode, entitys);
    }

    public static HttpResult put(String url, String encode, Map<String, Object> params) {
        return HttpUtil.put(HttpUtil.client(url), url, encode, params);
    }

    public static HttpResult put(String url, Map<String, Object> params) {
        return HttpUtil.put(HttpUtil.client(url), url, "UTF-8", params);
    }

    public static HttpResult put(Map<String, String> headers, String url, String encode, Map<String, Object> params) {
        return HttpUtil.put(HttpUtil.client(url), headers, url, encode, params);
    }

    public static HttpResult put(Map<String, String> headers, String url, String encode, List<HttpEntity> entitys) {
        return HttpUtil.put(HttpUtil.client(url), headers, url, encode, entitys);
    }

    public static HttpResult get(CloseableHttpClient client, String url) {
        return HttpUtil.get(client, url, "UTF-8");
    }

    public static HttpResult get(CloseableHttpClient client, String url, String encode) {
        return HttpUtil.get(client, url, encode, new HashMap<String, Object>());
    }

    public static HttpResult get(CloseableHttpClient client, String url, String encode, Map<String, Object> params) {
        return HttpUtil.get(client, null, url, encode, params);
    }

    public static HttpResult get(CloseableHttpClient client, Map<String, String> headers, String url, String encode, Map<String, Object> params) {
        List<NameValuePair> pairs = HttpUtil.packNameValuePair(params);
        return HttpUtil.get(client, headers, url, encode, pairs);
    }

    public static HttpResult get(CloseableHttpClient client, String url, String encode, List<NameValuePair> pairs) {
        return HttpUtil.get(client, null, url, encode, pairs);
    }

    public static HttpResult get(CloseableHttpClient client, Map<String, String> headers, String url, String encode, List<NameValuePair> pairs) {
        if (null == client) {
            client = HttpUtil.client(url);
        }
        if (url.startsWith("//")) {
            url = "http:" + url;
        }
        HttpResult result = new HttpResult();
        if (null != pairs && !pairs.isEmpty()) {
            String params = URLEncodedUtils.format(pairs, (String)encode);
            url = url.contains("?") ? url + "&" + params : url + "?" + params;
        }
        HttpGet method = new HttpGet(url);
        HttpUtil.setHeader((HttpRequestBase)method, headers);
        result = HttpUtil.exe(client, (HttpRequestBase)method, encode);
        return result;
    }

    public static HttpResult get(String url) {
        return HttpUtil.get(url, "UTF-8");
    }

    public static HttpResult get(String url, String encode) {
        return HttpUtil.get(url, encode, new HashMap<String, Object>());
    }

    public static HttpResult get(String url, String encode, Map<String, Object> params) {
        return HttpUtil.get(HttpUtil.client(url), url, encode, params);
    }

    public static HttpResult get(String url, Map<String, Object> params) {
        return HttpUtil.get(HttpUtil.client(url), url, "UTF-8", params);
    }

    public static HttpResult get(Map<String, String> headers, String url, String encode, Map<String, Object> params) {
        return HttpUtil.get(HttpUtil.client(url), headers, url, encode, params);
    }

    public static HttpResult get(Map<String, String> headers, String url, String encode) {
        return HttpUtil.get(HttpUtil.client(url), headers, url, encode, new HashMap<String, Object>());
    }

    public static HttpResult get(String url, String encode, List<NameValuePair> pairs) {
        return HttpUtil.get(HttpUtil.client(url), url, encode, pairs);
    }

    public static HttpResult get(Map<String, String> headers, String url, String encode, List<NameValuePair> pairs) {
        return HttpUtil.get(HttpUtil.client(url), headers, url, encode, pairs);
    }

    public static HttpResult delete(CloseableHttpClient client, String url, String encode, Map<String, Object> params) {
        return HttpUtil.delete(client, null, url, encode, params);
    }

    public static HttpResult delete(CloseableHttpClient client, Map<String, String> headers, String url, String encode, Map<String, Object> params) {
        List<NameValuePair> pairs = HttpUtil.packNameValuePair(params);
        return HttpUtil.delete(client, headers, url, encode, pairs);
    }

    public static HttpResult delete(CloseableHttpClient client, String url, String encode, List<NameValuePair> pairs) {
        return HttpUtil.delete(client, null, url, encode, pairs);
    }

    public static HttpResult delete(CloseableHttpClient client, Map<String, String> headers, String url, String encode, NameValuePair ... pairs) {
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        if (null != pairs) {
            for (NameValuePair pair : pairs) {
                list.add(pair);
            }
        }
        return HttpUtil.delete(client, headers, url, encode, list);
    }

    public static HttpResult delete(CloseableHttpClient client, Map<String, String> headers, String url, String encode, List<NameValuePair> pairs) {
        if (null == client) {
            client = HttpUtil.client(url);
        }
        if (url.startsWith("//")) {
            url = "http:" + url;
        }
        HttpResult result = new HttpResult();
        if (null != pairs) {
            String params = URLEncodedUtils.format(pairs, (String)encode);
            url = url.contains("?") ? url + "&" + params : url + "?" + params;
        }
        HttpDelete method = new HttpDelete(url);
        HttpUtil.setHeader((HttpRequestBase)method, headers);
        result = HttpUtil.exe(client, (HttpRequestBase)method, encode);
        return result;
    }

    public static HttpResult delete(String url, String encode, Map<String, Object> params) {
        return HttpUtil.delete(HttpUtil.client(url), url, encode, params);
    }

    public static HttpResult delete(Map<String, String> headers, String url, String encode, Map<String, Object> params) {
        return HttpUtil.delete(HttpUtil.client(url), headers, url, encode, params);
    }

    public static HttpResult delete(String url, String encode, List<NameValuePair> pairs) {
        return HttpUtil.delete(HttpUtil.client(url), url, encode, pairs);
    }

    public static HttpResult delete(Map<String, String> headers, String url, String encode, List<NameValuePair> pairs) {
        return HttpUtil.delete(HttpUtil.client(url), headers, url, encode, pairs);
    }

    public static HttpResult delete(Map<String, String> headers, String url, String encode, NameValuePair ... pairs) {
        return HttpUtil.delete(HttpUtil.client(url), headers, url, encode, pairs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpResult exe(CloseableHttpClient client, HttpRequestBase method, String encode) {
        CloseableHttpResponse response = null;
        HttpResult result = null;
        try {
            long fr = System.currentTimeMillis();
            if (ConfigTable.isDebug() && log.isWarnEnabled()) {
                log.warn("[http request][method:{}][url:{}]", (Object)method.getMethod(), (Object)method.getURI());
            }
            method.setHeader("Connection", "close");
            response = client.execute((HttpUriRequest)method);
            result = HttpUtil.parseResult(result, response, encode);
            if (ConfigTable.isDebug() && log.isWarnEnabled()) {
                log.warn("[http request][method:{}][status:{}][\u8017\u65f6:{}][url:{}]", new Object[]{method.getMethod(), result.getStatus(), System.currentTimeMillis() - fr, method.getURI()});
            }
        }
        catch (Exception e) {
            result = new HttpResult();
            e.printStackTrace();
        }
        finally {
            try {
                if (null != response) {
                    response.close();
                }
                method.releaseConnection();
                if (client == HttpUtil.client) {
                    client.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private static void setHeader(HttpRequestBase method, Map<String, String> headers) {
        if (null != headers) {
            for (String key : headers.keySet()) {
                String value = headers.get(key);
                method.setHeader(key, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int status(String url) {
        int code = -1;
        CloseableHttpClient client = HttpUtil.defaultSSLClient();
        CloseableHttpResponse response = null;
        if (url.startsWith("//")) {
            url = "http:" + url;
        }
        HttpGet method = new HttpGet(url);
        try {
            response = client.execute((HttpUriRequest)method);
            code = response.getStatusLine().getStatusCode();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                response.close();
                method.releaseConnection();
                client.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return code;
    }

    private static HttpResult parseResult(HttpResult result, CloseableHttpResponse response, String encode) {
        if (null == result) {
            result = new HttpResult();
        }
        try {
            if (null != response) {
                HttpEntity entity;
                Header[] all;
                HashMap<String, String> headers = new HashMap<String, String>();
                for (Header header : all = response.getAllHeaders()) {
                    String key = header.getName();
                    String value = header.getValue();
                    headers.put(key, value);
                    if (!"Set-Cookie".equalsIgnoreCase(key)) continue;
                    HttpCookie c = new HttpCookie(value);
                    result.setCookie(c);
                }
                int code = response.getStatusLine().getStatusCode();
                result.setHeaders(headers);
                result.setStatus(code);
                if (code == 200 && null != (entity = response.getEntity())) {
                    result.setInputStream(entity.getContent());
                    String text = EntityUtils.toString((HttpEntity)entity, (String)encode);
                    result.setText(text);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static DownloadTask download(String url, String dst) {
        File file = new File(dst);
        return HttpUtil.download(HttpUtil.client(url), new DefaultProgress(url, file), url, file, null, null, false);
    }

    public static DownloadTask download(String url, File dst) {
        return HttpUtil.download(HttpUtil.client(url), new DefaultProgress(url, dst), url, dst, null, null, false);
    }

    public static DownloadTask download(String url, String dst, Map<String, String> headers, Map<String, Object> params) {
        File file = new File(dst);
        return HttpUtil.download(HttpUtil.client(url), new DefaultProgress(url, file), url, file, headers, params, false);
    }

    public static DownloadTask download(String url, File dst, Map<String, String> headers, Map<String, Object> params) {
        return HttpUtil.download(HttpUtil.client(url), new DefaultProgress(url, dst), url, dst, headers, params, false);
    }

    public static DownloadTask download(String url, String dst, Map<String, String> headers, Map<String, Object> params, boolean override) {
        File file = new File(dst);
        return HttpUtil.download(HttpUtil.client(url), new DefaultProgress(url, file), url, file, headers, params, override);
    }

    public static DownloadTask download(String url, File dst, Map<String, String> headers, Map<String, Object> params, boolean override) {
        return HttpUtil.download(HttpUtil.client(url), new DefaultProgress(url, dst), url, dst, headers, params, override);
    }

    public static DownloadTask download(DownloadProgress progress, String url, String dst, boolean override) {
        return HttpUtil.download(HttpUtil.client(url), progress, url, new File(dst), null, null, override);
    }

    public static DownloadTask download(DownloadProgress progress, String url, File dst, boolean override) {
        return HttpUtil.download(HttpUtil.client(url), progress, url, dst, null, null, override);
    }

    public static DownloadTask download(DownloadProgress progress, String url, String dst, Map<String, String> headers, Map<String, Object> params, boolean override) {
        return HttpUtil.download(HttpUtil.client(url), progress, url, new File(dst), headers, params, override);
    }

    public static DownloadTask download(DownloadProgress progress, String url, File dst, Map<String, String> headers, Map<String, Object> params, boolean override) {
        return HttpUtil.download(HttpUtil.client(url), progress, url, dst, headers, params, override);
    }

    public static DownloadTask download(CloseableHttpClient client, DownloadProgress progress, String url, File dst, Map<String, String> headers, Map<String, Object> params, boolean override) {
        DownloadTask task = new DownloadTask();
        task.setProgress(progress);
        task.setLocal(dst);
        task.setUrl(url);
        task.setHeaders(headers);
        task.setParams(params);
        task.setOverride(override);
        HttpUtil.download(client, task);
        return task;
    }

    public static boolean download(DownloadTask task) {
        return HttpUtil.download(HttpUtil.client(task.getUrl()), task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean download(CloseableHttpClient client, DownloadTask task) {
        boolean result = false;
        String url = task.getUrl();
        String finalUrl = url;
        if (null != finalUrl && finalUrl.startsWith("//")) {
            finalUrl = "http:" + url;
        }
        finalUrl = HttpUtil.mergeParam(finalUrl, task.getParams());
        File dst = task.getLocal();
        if (BasicUtil.isEmpty((Object)url) || BasicUtil.isEmpty((Object)dst)) {
            return result;
        }
        long past = 0L;
        long length = 0L;
        boolean override = task.isOverride();
        if (dst.exists() && !override) {
            past = dst.length();
            task.init(length, past);
            task.finish();
            return true;
        }
        File parent = dst.getParentFile();
        if (null != parent && !parent.exists()) {
            parent.mkdirs();
        }
        HttpGet get = new HttpGet(finalUrl);
        get.setConfig(requestConfig);
        Map<String, String> headers = task.getHeaders();
        if (null != headers) {
            for (String key : headers.keySet()) {
                get.setHeader(key, headers.get(key));
            }
        }
        RandomAccessFile raf = null;
        InputStream is = null;
        File tmpFile = new File(dst.getParent(), dst.getName() + ".downloading");
        File configFile = new File(dst.getParent(), dst.getName() + ".downloading.config");
        String config = "";
        if (configFile.exists()) {
            config = FileUtil.read((File)configFile).toString();
        }
        long start = 0L;
        if (tmpFile.exists()) {
            start = tmpFile.length();
        }
        String range = "bytes=" + start + "-";
        get.setHeader("Range", range);
        try {
            CloseableHttpResponse response = client.execute((HttpUriRequest)get);
            int code = response.getStatusLine().getStatusCode();
            if (code == 416) {
                get.removeHeaders("Range");
                response = client.execute((HttpUriRequest)get);
                code = response.getStatusLine().getStatusCode();
                log.warn("[http download][\u65ad\u70b9\u8bbe\u7f6e\u5f02\u5e38][url:{}]", (Object)url);
            }
            if (code != 200 && code != 206) {
                task.error(code, "\u72b6\u6001\u5f02\u5e38");
                boolean bl = false;
                return bl;
            }
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                long total = entity.getContentLength();
                task.init(total, past);
                int buf = 0xA00000;
                if ((long)buf > total) {
                    buf = (int)total;
                }
                is = entity.getContent();
                raf = new RandomAccessFile(tmpFile, "rwd");
                raf.seek(start);
                byte[] buffer = new byte[buf];
                int len = -1;
                while ((len = is.read(buffer)) != -1) {
                    if (task.getAction() != 1) {
                        log.warn("[http download][break][url:{}]", (Object)url);
                        break;
                    }
                    raf.write(buffer, 0, len);
                    task.step(len);
                }
            }
            result = true;
        }
        catch (Exception e) {
            task.error(-1, e.getMessage());
            log.warn("[http download][\u4e0b\u8f7d\u5f02\u5e38][url:{}]", (Object)url);
            e.printStackTrace();
        }
        finally {
            if (null != raf) {
                try {
                    raf.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (null != is) {
                try {
                    is.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                client.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (result) {
            tmpFile.renameTo(dst);
            task.finish();
        }
        return result;
    }

    public static HttpResult upload(String url, Map<String, File> files, String encode, Map<String, String> headers, Map<String, Object> params) {
        return HttpUtil.upload(HttpUtil.client(url), url, files, encode, headers, params);
    }

    public static HttpResult upload(String url, Map<String, File> files, Map<String, String> headers, Map<String, Object> params) {
        return HttpUtil.upload(url, files, "UTF-8", headers, params);
    }

    public static HttpResult upload(String url, Map<String, File> files, Map<String, Object> params) {
        return HttpUtil.upload(url, files, null, params);
    }

    public static HttpResult upload(String url, Map<String, File> files) {
        return HttpUtil.upload(url, files, null, null);
    }

    public static HttpResult upload(CloseableHttpClient client, String url, Map<String, File> files, String encode, Map<String, String> headers, Map<String, Object> params) {
        if (null != url && url.startsWith("//")) {
            url = "http:" + url;
        }
        if (BasicUtil.isEmpty((Object)encode)) {
            encode = "UTF-8";
        }
        String BOUNDARY = "-----" + BasicUtil.getRandomLowerString((int)20);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.RFC6532);
        HttpPost post = new HttpPost(url);
        post.setConfig(requestConfig);
        builder.setBoundary(BOUNDARY);
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        builder.setCharset(Charset.forName(encode));
        ContentType contentType = ContentType.create((String)"text/plain", (Charset)Charset.forName(encode));
        HttpUtil.mergeParam(builder, params, contentType);
        if (null != headers) {
            for (String string : headers.keySet()) {
                post.setHeader(string, headers.get(string));
            }
        }
        String fileLog = "";
        for (String key : files.keySet()) {
            File file = files.get(key);
            builder.addBinaryBody(key, file, ContentType.MULTIPART_FORM_DATA, file.getName());
            fileLog = fileLog + "[" + key + ":" + file.getAbsolutePath() + "]";
        }
        if (ConfigTable.isDebug() && log.isWarnEnabled()) {
            log.warn("[http upload][url:{}]" + fileLog, (Object)url);
        }
        HttpEntity httpEntity = builder.build();
        post.setEntity(httpEntity);
        post.addHeader("Content-Type", "multipart/form-data;boundary=" + BOUNDARY);
        HttpResult source = HttpUtil.exe(client, (HttpRequestBase)post, encode);
        return source;
    }

    public static HttpResult postStream(CloseableHttpClient client, String url, String encode, HttpEntity ... entitys) {
        return HttpUtil.postStream(client, null, url, encode, entitys);
    }

    public static HttpResult postStream(CloseableHttpClient client, Map<String, String> headers, String url, String encode, HttpEntity ... entitys) {
        ArrayList<HttpEntity> list = new ArrayList<HttpEntity>();
        if (null != entitys) {
            for (HttpEntity entity : entitys) {
                list.add(entity);
            }
        }
        return HttpUtil.postStream(client, headers, url, encode, list);
    }

    public static HttpResult postStream(CloseableHttpClient client, String url, String encode, Map<String, Object> params) {
        return HttpUtil.postStream(client, null, url, encode, params);
    }

    public static HttpResult postStream(CloseableHttpClient client, Map<String, String> headers, String url, String encode, Map<String, Object> params) {
        ArrayList<HttpEntity> entitys = new ArrayList<HttpEntity>();
        if (null != params && !params.isEmpty()) {
            List<NameValuePair> pairs = HttpUtil.packNameValuePair(params);
            try {
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(pairs, encode);
                entitys.add((HttpEntity)entity);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return HttpUtil.postStream(client, headers, url, encode, entitys);
    }

    public static HttpResult postStream(CloseableHttpClient client, Map<String, String> headers, String url, String encode, List<HttpEntity> entitys) {
        HttpResult result = new HttpResult();
        InputStream is = null;
        if (null == client) {
            client = HttpUtil.client(url);
        }
        if (url.startsWith("//")) {
            url = "http:" + url;
        }
        HttpPost method = new HttpPost(url);
        if (null != entitys) {
            for (HttpEntity entity : entitys) {
                method.setEntity(entity);
            }
        }
        HttpUtil.setHeader((HttpRequestBase)method, headers);
        try {
            CloseableHttpResponse response = client.execute((HttpUriRequest)method);
            is = response.getEntity().getContent();
            result.setInputStream(is);
        }
        catch (Exception e) {
            // empty catch block
        }
        return result;
    }

    public static HttpResult postStream(String url, String encode, HttpEntity ... entitys) {
        return HttpUtil.postStream(HttpUtil.client(url), url, encode, entitys);
    }

    public static HttpResult postStream(Map<String, String> headers, String url, String encode, HttpEntity ... entitys) {
        return HttpUtil.postStream(HttpUtil.client(url), headers, url, encode, entitys);
    }

    public static HttpResult postStream(String url, String encode, Map<String, Object> params) {
        return HttpUtil.postStream(HttpUtil.client(url), url, encode, params);
    }

    public static HttpResult postStream(Map<String, String> headers, String url, String encode, Map<String, Object> params) {
        return HttpUtil.postStream(HttpUtil.client(url), headers, url, encode, params);
    }

    public static HttpResult postStream(String url, Map<String, Object> params) {
        return HttpUtil.postStream(HttpUtil.client(url), null, url, "UTF-8", params);
    }

    public static HttpResult postStream(Map<String, String> headers, String url, String encode, List<HttpEntity> entitys) {
        return HttpUtil.postStream(HttpUtil.client(url), headers, url, encode, entitys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(InputStream is, String encode) {
        if (is == null) {
            return null;
        }
        ByteArrayBuffer bab = new ByteArrayBuffer(0);
        byte[] b = new byte[1024];
        int len = 0;
        try {
            while ((len = is.read(b)) != -1) {
                bab.append(b, 0, len);
            }
            String string = new String(bab.toByteArray(), encode);
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String host(String url) {
        if (null == url) {
            return null;
        }
        String str = url.replaceAll("http://", "").replaceAll("https://", "").replaceAll("//", "");
        int idx = str.indexOf("/");
        if (idx != -1) {
            str = str.substring(0, idx);
        }
        if (url.startsWith("https")) {
            return "https://" + str;
        }
        if (url.startsWith("//")) {
            return "//" + str;
        }
        return "http://" + str;
    }

    public static String domain(String url) {
        if (null == url) {
            return null;
        }
        if ((url = url.replace("http://", "").replace("https://", "")).contains(":")) {
            url = url.substring(0, url.indexOf(":"));
        }
        if (url.contains("/")) {
            url = url.substring(0, url.indexOf("/"));
        }
        return url;
    }

    public static String parsePath(String url) {
        int to = url.indexOf("?");
        if (to != -1) {
            url = url.substring(0, to);
        }
        return url;
    }

    public static String parseDir(String url) {
        String dir = null;
        if (null == url) {
            return dir;
        }
        if (url.endsWith("/")) {
            dir = url;
        } else if (HttpUtil.isHttpFile(url)) {
            int to = url.lastIndexOf("/");
            dir = url.substring(0, to);
        } else {
            dir = url;
        }
        return dir;
    }

    public static String parseFileName(String url) {
        String name = null;
        if (null != url && !(url = url.replace("://", "")).endsWith("/") && (name = url.substring(url.lastIndexOf("/") + 1)).contains("?")) {
            name = name.substring(0, name.indexOf("?"));
        }
        return name;
    }

    private static boolean isHttpFile(String path) {
        if (path.endsWith("/")) {
            return false;
        }
        String head = "http://";
        int fr = head.length();
        int l1 = path.lastIndexOf("/");
        int l2 = path.lastIndexOf(".");
        if (l1 == -1) {
            return false;
        }
        return l2 > l1 && l2 > fr;
    }

    public static String mergeParam(String url, Map<String, Object> params) {
        if (BasicUtil.isEmpty(params)) {
            return url;
        }
        if (null == url) {
            url = "";
        }
        url = url.trim();
        String kv = BeanUtil.map2string(params);
        if (BasicUtil.isNotEmpty((Object)kv)) {
            if (url.indexOf("?") > -1) {
                if (url.indexOf("?") < url.length() - 1 && url.indexOf("&") < url.length() - 1) {
                    url = url + "&";
                }
            } else {
                url = url + "?";
            }
            url = url + kv;
        }
        return url;
    }

    public static MultipartEntityBuilder mergeParam(MultipartEntityBuilder builder, Map<String, Object> params, ContentType contetType) {
        if (null != params) {
            String[] kvs;
            String txt = BeanUtil.map2string(params);
            for (String kv : kvs = txt.split("&")) {
                String[] tmps = kv.split("=");
                if (tmps.length != 2) continue;
                builder.addTextBody(tmps[0], tmps[1], contetType);
            }
        }
        return builder;
    }

    public static String mergeParam(String url, String ... params) {
        if (BasicUtil.isEmpty((Object)url) || BasicUtil.isEmpty((Object[])params)) {
            return url;
        }
        if ((url = url.trim()).indexOf("?") > -1) {
            if (url.indexOf("?") < url.length() - 1 && url.indexOf("&") < url.length() - 1) {
                url = url + "&";
            }
        } else {
            url = url + "?";
        }
        String tmp = null;
        for (String param : params) {
            if (BasicUtil.isEmpty((Object)param)) continue;
            tmp = null == tmp ? param : tmp + "&" + param;
        }
        url = url + tmp;
        return url;
    }

    public static List<NameValuePair> packNameValuePair(Map<String, Object> params) {
        ArrayList<NameValuePair> pairs = new ArrayList<NameValuePair>();
        if (null != params) {
            for (String key : params.keySet()) {
                Object vals;
                Object value = params.get(key);
                if (null == value) continue;
                if (value instanceof String[]) {
                    for (Object val : vals = (String[])value) {
                        if (null == val) continue;
                        pairs.add((NameValuePair)new BasicNameValuePair(key, (String)val));
                        if (!ConfigTable.isDebug() || !log.isWarnEnabled()) continue;
                        log.warn("[request param][{}={}]", (Object)key, (Object)BasicUtil.cut((String)val, (int)0, (int)20));
                    }
                    continue;
                }
                if (value instanceof Collection) {
                    vals = (Collection)value;
                    Iterator iterator = vals.iterator();
                    while (iterator.hasNext()) {
                        Object val = iterator.next();
                        if (null == val) continue;
                        pairs.add((NameValuePair)new BasicNameValuePair(key, val.toString()));
                        if (!ConfigTable.isDebug() || !log.isWarnEnabled()) continue;
                        log.warn("[request param][{}={}]", (Object)key, (Object)BasicUtil.cut((String)val.toString(), (int)0, (int)20));
                    }
                    continue;
                }
                if (null == value) continue;
                pairs.add((NameValuePair)new BasicNameValuePair(key, value.toString()));
                if (!ConfigTable.isDebug() || !log.isWarnEnabled()) continue;
                log.warn("[request param][{}={}]", (Object)key, (Object)BasicUtil.cut((String)value.toString(), (int)0, (int)20));
            }
        }
        return pairs;
    }

    private static CloseableHttpClient client(String url) {
        if (url.contains("https://")) {
            return HttpUtil.defaultSSLClient();
        }
        return HttpUtil.defaultClient();
    }

    private static CloseableHttpClient defaultClient() {
        HttpClientBuilder builder = HttpClients.custom().setDefaultRequestConfig(requestConfig);
        builder.setUserAgent(userAgent);
        client = builder.build();
        return client;
    }

    public static CloseableHttpClient createClient(String userAgent) {
        CloseableHttpClient client = null;
        HttpClientBuilder builder = HttpClients.custom().setDefaultRequestConfig(requestConfig);
        builder.setUserAgent(userAgent);
        client = builder.build();
        return client;
    }

    public static CloseableHttpClient createClient() {
        CloseableHttpClient client = null;
        HttpClientBuilder builder = HttpClients.custom().setDefaultRequestConfig(requestConfig);
        builder.setUserAgent(userAgent);
        client = builder.build();
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CloseableHttpClient ceateSSLClient(File keyFile, String protocol, String password) {
        CloseableHttpClient httpclient = null;
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            try (FileInputStream instream = new FileInputStream(keyFile);){
                keyStore.load(instream, password.toCharArray());
            }
            SSLContext sslcontext = SSLContexts.custom().loadKeyMaterial(keyStore, password.toCharArray()).build();
            String[] protocols = new String[]{protocol};
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, protocols, null, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return httpclient;
    }

    public static CloseableHttpClient ceateSSLClient(File keyFile, String password) {
        return HttpUtil.ceateSSLClient(keyFile, PROTOCOL_TLSV1, password);
    }

    public static String mergePath(String ... paths) {
        String result = null;
        String separator = "/";
        if (null != paths) {
            for (String path : paths) {
                if (BasicUtil.isEmpty((Object)path)) continue;
                path = path.replace("\\", "/");
                if (null == result) {
                    result = path;
                    continue;
                }
                if (result.endsWith("/")) {
                    if (path.startsWith("/")) {
                        result = result + path.substring(1);
                        continue;
                    }
                    result = result + path;
                    continue;
                }
                result = path.startsWith("/") ? result + path : result + separator + path;
            }
        }
        return result;
    }

    public static String createFullPath(String host, String url) {
        if (url.startsWith("http") || url.startsWith("//") || BasicUtil.isEmpty((Object)host)) {
            return url;
        }
        String fullPath = null;
        fullPath = url.startsWith("/") ? HttpUtil.host(host) + url : (url.startsWith("?") ? HttpUtil.parsePath(host) + url : ((host = HttpUtil.parseDir(host)).endsWith("/") ? host + url : host + "/" + url));
        return fullPath;
    }

    public static void setUserAgent(String agent) {
        userAgent = agent;
    }

    public static CloseableHttpClient defaultSSLClient() {
        try {
            if (sslClient != null) {
                return sslClient;
            }
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
            httpClientBuilder.setMaxConnTotal(10000);
            httpClientBuilder.setMaxConnPerRoute(1000);
            httpClientBuilder.evictIdleConnections(15L, TimeUnit.SECONDS);
            SocketConfig.Builder socketConfigBuilder = SocketConfig.custom();
            socketConfigBuilder.setTcpNoDelay(true);
            httpClientBuilder.setDefaultSocketConfig(socketConfigBuilder.build());
            RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
            requestConfigBuilder.setConnectTimeout(30000);
            requestConfigBuilder.setSocketTimeout(30000);
            httpClientBuilder.setDefaultRequestConfig(requestConfigBuilder.build());
            SSLContext ctx = SSLContext.getInstance("TLS");
            SimpleX509TrustManager tm = new SimpleX509TrustManager(null);
            ctx.init(null, new TrustManager[]{tm}, null);
            httpClientBuilder.setSslcontext(ctx);
            httpClientBuilder.setConnectionManagerShared(true);
            sslClient = httpClientBuilder.build();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sslClient;
    }

    public static boolean isUrl(String src) {
        if (null == src) {
            return false;
        }
        if (src.startsWith("http://") || src.startsWith("https://")) {
            return true;
        }
        if (src.startsWith("//")) {
            int index1 = (src = src.substring(2)).indexOf(".");
            if (index1 == -1) {
                return false;
            }
            int index2 = src.indexOf("/");
            if (index1 < index2) {
                return true;
            }
            if (index2 == -1) {
                return true;
            }
        }
        return false;
    }

    static {
        userAgent = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36";
        MAX_TIMEOUT = 72000;
        MAX_TIMEOUT = ConfigTable.getInt((String)"HTTP_MAX_TIMEOUT", (int)72000);
        connManager = new PoolingHttpClientConnectionManager();
        connManager.setMaxTotal(100);
        connManager.setDefaultMaxPerRoute(connManager.getMaxTotal());
        RequestConfig.Builder configBuilder = RequestConfig.custom();
        configBuilder.setConnectTimeout(MAX_TIMEOUT);
        configBuilder.setSocketTimeout(MAX_TIMEOUT);
        configBuilder.setConnectionRequestTimeout(MAX_TIMEOUT);
        configBuilder.setStaleConnectionCheckEnabled(true);
        requestConfig = configBuilder.build();
    }
}

