/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.net;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import org.anyline.util.Base64Util;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;

public class RSAUtil {
    public static final String CHARSET = "UTF-8";
    public static final String RSA_ALGORITHM = "RSA";
    public static final String SIGNATURE_ALGORITHM = "MD5withRSA";

    public static Map<String, String> createKeys(int keySize) {
        KeyPairGenerator kpg = null;
        try {
            kpg = KeyPairGenerator.getInstance(RSA_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        kpg.initialize(keySize);
        KeyPair keyPair = kpg.generateKeyPair();
        PublicKey publicKey = keyPair.getPublic();
        String publicKeyStr = Base64.encodeBase64URLSafeString((byte[])publicKey.getEncoded());
        PrivateKey privateKey = keyPair.getPrivate();
        String privateKeyStr = Base64.encodeBase64URLSafeString((byte[])privateKey.getEncoded());
        HashMap<String, String> keys = new HashMap<String, String>();
        keys.put("public", publicKeyStr);
        keys.put("private", privateKeyStr);
        return keys;
    }

    public static RSAPublicKey getPublicKey(String publicKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(Base64.decodeBase64((String)publicKey));
        RSAPublicKey key = (RSAPublicKey)keyFactory.generatePublic(x509KeySpec);
        return key;
    }

    public static RSAPrivateKey getPrivateKey(String privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(Base64.decodeBase64((String)privateKey));
        RSAPrivateKey key = (RSAPrivateKey)keyFactory.generatePrivate(pkcs8KeySpec);
        return key;
    }

    public static String publicEncrypt(String data, RSAPublicKey publicKey) throws Exception {
        try {
            Cipher cipher = Cipher.getInstance(RSA_ALGORITHM);
            cipher.init(1, publicKey);
            return Base64.encodeBase64URLSafeString((byte[])RSAUtil.rsaSplitCodec(cipher, 1, data.getBytes(CHARSET), publicKey.getModulus().bitLength()));
        }
        catch (Exception e) {
            throw new Exception("[\u516c\u94a5\u52a0\u5bc6\u5f02\u5e38][\u52a0\u5bc6\u6570\u636e:" + data + "]", e);
        }
    }

    public static String privateDecrypt(String data, RSAPrivateKey privateKey) throws Exception {
        try {
            Cipher cipher = Cipher.getInstance(RSA_ALGORITHM);
            cipher.init(2, privateKey);
            return new String(RSAUtil.rsaSplitCodec(cipher, 2, Base64.decodeBase64((String)data), privateKey.getModulus().bitLength()), CHARSET);
        }
        catch (Exception e) {
            throw new Exception("[\u79c1\u94a5\u89e3\u5bc6\u5f02\u5e38][\u89e3\u5bc6\u6570\u636e:" + data + "]", e);
        }
    }

    public static String privateEncrypt(String data, RSAPrivateKey privateKey) throws Exception {
        try {
            Cipher cipher = Cipher.getInstance(RSA_ALGORITHM);
            cipher.init(1, privateKey);
            return Base64.encodeBase64URLSafeString((byte[])RSAUtil.rsaSplitCodec(cipher, 1, data.getBytes(CHARSET), privateKey.getModulus().bitLength()));
        }
        catch (Exception e) {
            throw new Exception("[\u79c1\u94a5\u52a0\u5bc6\u5f02\u5e38][\u52a0\u5bc6\u6570\u636e:" + data + "]", e);
        }
    }

    public static String publicDecrypt(String data, RSAPublicKey publicKey) throws Exception {
        try {
            Cipher cipher = Cipher.getInstance(RSA_ALGORITHM);
            cipher.init(2, publicKey);
            return new String(RSAUtil.rsaSplitCodec(cipher, 2, Base64.decodeBase64((String)data), publicKey.getModulus().bitLength()), CHARSET);
        }
        catch (Exception e) {
            throw new Exception("[\u516c\u94a5\u89e3\u5bc6\u5f02\u5e38][\u89e3\u5bc6\u6570\u636e:" + data + "]", e);
        }
    }

    private static byte[] rsaSplitCodec(Cipher cipher, int opmode, byte[] datas, int keySize) throws Exception {
        int maxBlock = 0;
        maxBlock = opmode == 2 ? keySize / 8 : keySize / 8 - 11;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        try {
            while (datas.length > offSet) {
                byte[] buff = datas.length - offSet > maxBlock ? cipher.doFinal(datas, offSet, maxBlock) : cipher.doFinal(datas, offSet, datas.length - offSet);
                out.write(buff, 0, buff.length);
                offSet = ++i * maxBlock;
            }
        }
        catch (Exception e) {
            throw new Exception("[\u52a0\u5bc6\u5f02\u5e38][\u52a0\u89e3\u5bc6\u9600\u503c:" + maxBlock + "]", e);
        }
        byte[] resultDatas = out.toByteArray();
        IOUtils.closeQuietly((OutputStream)out);
        return resultDatas;
    }

    public static String sign(byte[] data, String privateKey) throws Exception {
        RSAPrivateKey privateK = RSAUtil.getPrivateKey(privateKey);
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initSign(privateK);
        signature.update(data);
        return Base64Util.encode((byte[])signature.sign());
    }

    public static String sign(String data, String privateKey) throws Exception {
        return RSAUtil.sign(data.getBytes(), privateKey);
    }

    public static boolean verify(byte[] data, String publicKey, String sign) throws Exception {
        RSAPublicKey publicK = RSAUtil.getPublicKey(publicKey);
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initVerify(publicK);
        signature.update(data);
        return signature.verify(Base64Util.decode((String)sign));
    }

    public static boolean verify(String data, String publicKey, String sign) throws Exception {
        return RSAUtil.verify(data.getBytes(), publicKey, sign);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RSAPrivateKey getPrivateKey(File file, String keyAlgorithm) {
        RSAPrivateKey privateKey = null;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            privateKey = RSAUtil.getPrivateKey(inputStream, keyAlgorithm);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return privateKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RSAPublicKey getPublicKey(File file) {
        RSAPublicKey publicKey = null;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            publicKey = RSAUtil.getPublicKey(inputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return publicKey;
    }

    public static RSAPublicKey getPublicKey(InputStream inputStream) throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder sb = new StringBuilder();
        String readLine = null;
        while ((readLine = br.readLine()) != null) {
            if (readLine.charAt(0) == '-') continue;
            sb.append(readLine);
            sb.append('\r');
        }
        return RSAUtil.getPublicKey(sb.toString());
    }

    public static RSAPrivateKey getPrivateKey(InputStream inputStream, String keyAlgorithm) throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder sb = new StringBuilder();
        String readLine = null;
        while ((readLine = br.readLine()) != null) {
            if (readLine.charAt(0) == '-') continue;
            sb.append(readLine);
            sb.append('\r');
        }
        return RSAUtil.getPrivateKey(sb.toString());
    }
}

