/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.net;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.anyline.net.FTPUtil;
import org.anyline.net.SFTPProgressMonitor;
import org.anyline.util.BasicUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SFTPUtil {
    private final Logger log = LoggerFactory.getLogger(SFTPUtil.class);
    private static Map<String, SFTPUtil> instances = new HashMap<String, SFTPUtil>();
    private String host;
    private int port = 22;
    private String user;
    private String password;
    private ChannelSftp client;
    private Session session;

    public SFTPUtil() throws Exception {
    }

    public SFTPUtil(String host, int port, String user, String password) throws Exception {
        this(host, user, password, 22);
    }

    public SFTPUtil(String host, String user, String password) throws Exception {
        this(host, user, password, 22);
    }

    public SFTPUtil(String host, String user, String password, int port) throws Exception {
        this.host = host;
        this.user = user;
        this.password = password;
        Channel channel = null;
        JSch jsch = new JSch();
        this.session = jsch.getSession(this.user, this.host, this.port);
        if (BasicUtil.isNotEmpty((Object)this.password)) {
            this.session.setPassword(this.password);
        }
        Properties sshConfig = new Properties();
        sshConfig.put("StrictHostKeyChecking", "no");
        this.session.setConfig(sshConfig);
        this.session.connect();
        channel = this.session.openChannel("sftp");
        channel.connect();
        this.client = (ChannelSftp)channel;
    }

    public static SFTPUtil getInstance(String host, String account, String password, int port) {
        String key = "host:" + host + ",account:" + account + ",password:" + password + ",port:" + port;
        SFTPUtil util = instances.get(key);
        if (null == util) {
            try {
                util = new SFTPUtil(host, account, password, port);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return util;
    }

    public static SFTPUtil getInstance(String host, String account, String password) {
        return SFTPUtil.getInstance(host, account, password, 22);
    }

    public void download(String remote, String local) throws Exception {
        File localFile = new File(local);
        try (FileOutputStream os = null;){
            if (!localFile.exists()) {
                File parentFile = localFile.getParentFile();
                if (!parentFile.exists()) {
                    parentFile.mkdirs();
                }
                localFile.createNewFile();
            }
            os = new FileOutputStream(localFile);
            List<String> list = FTPUtil.formatPath(remote);
            long fr = System.currentTimeMillis();
            if (ConfigTable.isDebug() && this.log.isWarnEnabled()) {
                this.log.warn("[\u6587\u4ef6\u4e0b\u8f7d][file:{}]", (Object)(list.get(0) + list.get(1)));
            }
            String remotePath = list.get(0) + list.get(1);
            SftpATTRS attr = this.client.stat(remotePath);
            long length = attr.getSize();
            SFTPProgressMonitor process = new SFTPProgressMonitor(remotePath, local, length);
            this.client.get(remotePath, (OutputStream)os, (SftpProgressMonitor)process);
            if (ConfigTable.isDebug() && this.log.isWarnEnabled()) {
                this.log.warn("[\u6587\u4ef6\u4e0b\u8f7d\u5b8c\u6210][\u8017\u65f6:{}][file:{}]", (Object)(System.currentTimeMillis() - fr), (Object)(list.get(0) + list.get(1)));
            }
        }
    }

    public boolean disconnect() {
        if (this.session != null && this.session.isConnected()) {
            this.session.disconnect();
        }
        if (this.client != null) {
            if (this.client.isConnected()) {
                this.client.disconnect();
            }
            this.client.exit();
        }
        return true;
    }

    public int fileSize(String remoteDir) {
        int size;
        block2: {
            size = 0;
            try {
                Vector files = this.client.ls(remoteDir);
                size = files.size();
            }
            catch (Exception e) {
                if (!ConfigTable.isDebug() || !this.log.isWarnEnabled()) break block2;
                this.log.warn("[\u68c0\u6d4b\u6587\u4ef6\u6570\u91cf][result:fail][msg:{}]", (Object)e.getMessage());
            }
        }
        return size;
    }

    public void deleteFile(String path) throws SftpException {
        List<String> list = FTPUtil.formatPath(path);
        String dir = list.get(0);
        String file = list.get(1);
        if (this.dirExist(dir + file)) {
            this.client.rm(list.get(0) + list.get(1));
        }
    }

    public void deleteDir(String path) throws SftpException {
        Vector vector = this.client.ls(path);
        if (vector.size() == 1) {
            this.client.rm(path);
        } else if (vector.size() == 2) {
            this.client.rmdir(path);
        } else {
            String fileName = "";
            for (ChannelSftp.LsEntry en : vector) {
                fileName = en.getFilename();
                if (".".equals(fileName) || "..".equals(fileName)) continue;
                this.deleteDir(path + "/" + fileName);
            }
            this.client.rmdir(path);
        }
    }

    public void uploadFile(String localFile, String remoteDir, String remoteFile) throws SftpException {
        long fr = System.currentTimeMillis();
        this.mkdir(remoteDir);
        this.client.cd(remoteDir);
        this.client.put(localFile, remoteFile);
        if (ConfigTable.isDebug() && this.log.isWarnEnabled()) {
            this.log.warn("[\u6587\u4ef6\u4e0a\u4f20][\u8017\u65f6:{}][local:{}][remote:{}]", new Object[]{DateUtil.conversion((long)(System.currentTimeMillis() - fr)), localFile, remoteDir + "/" + remoteFile});
        }
    }

    public void uploadFile(File localFile, String remoteDir, String remoteFile) throws SftpException {
        this.uploadFile(localFile.getAbsolutePath(), remoteDir, remoteFile);
    }

    public boolean uploadFile(String localFile) throws SftpException {
        File file = new File(localFile);
        if (file.exists()) {
            List<String> list = FTPUtil.formatPath(localFile);
            this.uploadFile(localFile, list.get(0), list.get(1));
            return true;
        }
        return false;
    }

    public boolean mkdir(String dir) throws SftpException {
        if (BasicUtil.isEmpty((Object)dir)) {
            return false;
        }
        String md = dir.replaceAll("\\\\", "/");
        if (md.indexOf("/") != 0 || md.length() == 1) {
            return false;
        }
        return this.mkdirs(md);
    }

    public boolean mkdirs(String dir) throws SftpException {
        String[] dirArr = dir.split("/");
        String base = "";
        for (String d : dirArr) {
            if (BasicUtil.isEmpty((Object)d) || this.dirExist((base = base + "/" + d) + "/")) continue;
            this.client.mkdir(base + "/");
        }
        return true;
    }

    public boolean dirExist(String dir) {
        try {
            Vector vector = this.client.ls(dir);
            return null != vector;
        }
        catch (SftpException e) {
            return false;
        }
    }

    public List<String> files(String dir) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Vector files = this.client.ls(dir);
            for (ChannelSftp.LsEntry file : files) {
                String nm = file.getFilename();
                if (".".equals(nm) || "..".equals(nm)) continue;
                list.add(nm);
            }
        }
        catch (Exception e) {
            this.log.warn("[scan dir error][dir:{}][error:{}]", (Object)dir, (Object)e.getMessage());
        }
        if (ConfigTable.isDebug() && this.log.isWarnEnabled()) {
            this.log.warn("[scan dir][dir:{}][file size:{}]", (Object)dir, (Object)list.size());
        }
        return list;
    }

    public boolean fileExists(String dir, String file) {
        List<String> files = this.files(dir);
        if (ConfigTable.isDebug() && this.log.isWarnEnabled()) {
            this.log.warn("[check file exists][dir:{}][file:{}]", (Object)dir, (Object)file);
        }
        for (String item : files) {
            if (!item.equals(file)) continue;
            return true;
        }
        return false;
    }

    public boolean fileExists(String path) {
        List<String> list = FTPUtil.formatPath(path);
        String dir = list.get(0);
        String file = list.get(1);
        if (ConfigTable.isDebug() && this.log.isWarnEnabled()) {
            this.log.warn("[check file exists][path:" + path + "]");
        }
        return this.fileExists(dir, file);
    }
}

