/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.nc;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.anyline.util.ConfigTable;
import org.anyline.util.DateUtil;
import org.anyline.util.MD5Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class NCUtil {
    private static Logger log = LoggerFactory.getLogger(NCUtil.class);
    private String file;
    private NetcdfFile nc;
    private static Hashtable<String, NCUtil> instances = new Hashtable();

    public static NCUtil getInstance(String file) {
        String key = MD5Util.crypto((String)file);
        NCUtil util = instances.get(key);
        if (null == util) {
            util = new NCUtil(file);
            instances.put(key, util);
        }
        return util;
    }

    public NCUtil(String file) {
        this.file = file;
    }

    public boolean open() {
        try {
            long fr = System.currentTimeMillis();
            this.nc = NetcdfFile.open((String)this.file);
            if (ConfigTable.isDebug() && log.isWarnEnabled()) {
                log.warn("[open file][\u8017\u65f6:{}][file:{}]", (Object)DateUtil.conversion((long)(System.currentTimeMillis() - fr)), (Object)this.file);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean close() {
        try {
            this.nc.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public List<Variable> getVariables() {
        return this.nc.getVariables();
    }

    public List<String> getVariableNames() {
        ArrayList<String> list = new ArrayList<String>();
        List<Variable> variables = this.getVariables();
        for (Variable var : variables) {
            list.add(var.getFullName());
        }
        return list;
    }

    public String info() {
        return this.nc.getDetailInfo();
    }

    public Variable findVariable(String var) {
        return this.nc.findVariable(var);
    }

    public Array getVariableValues(String var) {
        Array array = null;
        try {
            Variable variable = this.findVariable(var);
            if (null != variable) {
                array = variable.read();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return array;
    }

    public Array getVariableValues(String var, int[] origin, int[] shape) {
        Array array = null;
        try {
            Variable variable = this.findVariable(var);
            if (null != variable) {
                array = variable.read(origin, shape);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return array;
    }
}

