/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.nacos.util;

import java.util.Hashtable;
import org.anyline.entity.DataRow;
import org.anyline.nacos.util.NacosUtil;
import org.anyline.util.AnylineConfig;
import org.anyline.util.BasicUtil;
import org.anyline.util.ConfigTable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="anyline.nacos.config")
public class NacosConfig
extends AnylineConfig {
    private static Hashtable<String, AnylineConfig> instances = new Hashtable();
    public static String DEFAULT_ADDRESS = null;
    public static int DEFAULT_PORT = 8848;
    public static int DEFAULT_TIMEOUT = 3000;
    public static String DEFAULT_NAMESPACE = "";
    public static String DEFAULT_GROUP = "DEFAULT_GROUP";
    public static boolean DEFAULT_AUTO_SCAN = true;
    public static String DEFAULT_SCAN_PACKAGE = "org.anyline,org.anyboot";
    public static String DEFAULT_SCAN_CLASS = "";
    public String ADDRESS = DEFAULT_ADDRESS;
    public int PORT = DEFAULT_PORT;
    public int TIMEOUT = DEFAULT_TIMEOUT;
    public String NAMESPACE = DEFAULT_NAMESPACE;
    public String GROUP = DEFAULT_GROUP;
    public boolean AUTO_SCAN = DEFAULT_AUTO_SCAN;
    public String SCAN_PACKAGE = DEFAULT_SCAN_PACKAGE;
    public String SCAN_CLASS = DEFAULT_SCAN_CLASS;
    @Value(value="${anyline.nacos.scan.packages:org.anyline,org.anyboot}")
    public String scanPackpage;
    @Value(value="${anyline.nacos.scan.types:}")
    public String scanClass;
    @Value(value="${nacos.config.server-addr:}")
    public String bootAddress;
    @Value(value="${nacos.config.namespace:}")
    public String bootNamespace;
    @Value(value="${nacos.config.group:DEFAULT_GROUP}")
    public String bootGroup;
    @Value(value="${spring.cloud.nacos.config.server-addr:}")
    public String cloudAddress;
    @Value(value="${spring.cloud.nacos.config.namespace:}")
    public String cloudNamespace;
    @Value(value="${spring.cloud.nacos.config.group:DEFAULT_GROUP}")
    public String cloudGroup;

    public static Hashtable<String, AnylineConfig> getInstances() {
        return instances;
    }

    public NacosConfig() {
        this.auto();
    }

    public void auto() {
        if (BasicUtil.isNotEmpty((Object)this.bootAddress)) {
            NacosConfig.register("boot", this.bootAddress, 8848, this.bootGroup, this.bootNamespace, true, this.scanPackpage, this.scanClass);
        }
        if (BasicUtil.isNotEmpty((Object)this.cloudAddress)) {
            NacosConfig.register("cloud", this.cloudAddress, 8848, this.cloudGroup, this.cloudNamespace, true, this.scanPackpage, this.scanClass);
        }
    }

    public static void parse(String content) {
        NacosConfig.parse(NacosConfig.class, (String)content, instances, (String[])compatibles);
    }

    public static void init() {
        NacosConfig.load();
    }

    public static NacosConfig getInstance() {
        return NacosConfig.getInstance("default");
    }

    public static NacosConfig getInstance(String key) {
        if (BasicUtil.isEmpty((Object)key)) {
            key = "default";
        }
        if (ConfigTable.getReload() > 0 && (System.currentTimeMillis() - lastLoadTime) / 1000L > (long)ConfigTable.getReload()) {
            NacosConfig.load();
        }
        NacosConfig config = (NacosConfig)instances.get(key);
        return config;
    }

    private static synchronized void load() {
        NacosConfig.load(instances, NacosConfig.class, (String)"anyline-nacos.xml", (String[])new String[0]);
        lastLoadTime = System.currentTimeMillis();
    }

    public static NacosConfig register(String instance, String address, int port, String group, String namespace, boolean auto, String pack, String clazz) {
        DataRow row = new DataRow();
        row.put("ADDRESS", (Object)address);
        row.put("PORT", (Object)port);
        row.put("GROUP", (Object)group);
        row.put("NAMESPACE", (Object)namespace);
        row.put("AUTO_SCAN", (Object)auto);
        row.put("SCAN_PACKAGE", (Object)pack);
        row.put("SCAN_CLASS", (Object)clazz);
        NacosConfig config = (NacosConfig)NacosConfig.parse(NacosConfig.class, (String)instance, (DataRow)row, instances, (String[])compatibles);
        NacosUtil util = NacosUtil.getInstance(instance);
        if (null != util) {
            util.scan();
        }
        return config;
    }

    public static NacosConfig register(String instance, String address, int port, String group, String namespace) {
        return NacosConfig.register(instance, address, port, group, namespace, DEFAULT_AUTO_SCAN, null, null);
    }

    public static NacosConfig register(String instance, String address, int port) {
        return NacosConfig.register(instance, address, port, DEFAULT_GROUP, DEFAULT_NAMESPACE, DEFAULT_AUTO_SCAN, null, null);
    }

    public static NacosConfig register(String address, int port) {
        return NacosConfig.register(DEFAULT_GROUP, address, port, DEFAULT_GROUP, DEFAULT_NAMESPACE, DEFAULT_AUTO_SCAN, null, null);
    }

    public static NacosConfig register(String address, int port, String pack, String clazz) {
        return NacosConfig.register(DEFAULT_GROUP, address, port, DEFAULT_GROUP, DEFAULT_NAMESPACE, DEFAULT_AUTO_SCAN, pack, clazz);
    }

    private static void debug() {
    }

    static {
        NacosConfig.init();
        NacosConfig.debug();
    }
}

