/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.plugin.springmvc;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.util.Map;
import org.anyline.util.ConfigTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.view.JstlView;

public class TemplateView
extends JstlView {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String ANYLINE_TEMPLATE_NAME = "template_name";
    public static final String ANYLINE_STYLE_TEMPLATE_DES = "style_template_des";
    public static final String ANYLINE_TEMPLATE_NAME_DEFAULT = "default";
    public static final String ANYLINE_TEMPLATE_CONTENT_PATH = "anyline_template_content_path";
    private String template;
    private String content;

    public TemplateView() {
    }

    public TemplateView(String name) {
        super(name);
    }

    public TemplateView(String content, String template) {
        super(content);
        this.content = content;
        this.template = template;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void render(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String template = null;
        if (null != model) {
            template = (String)model.get(ANYLINE_TEMPLATE_NAME);
        }
        if (null == template) {
            template = this.getTemplate();
        }
        if (null != template) {
            String content_url = this.getContent();
            if (null == content_url || content_url.trim().equals("")) {
                content_url = this.getUrl();
            }
            if (null == content_url || content_url.trim().equals("")) {
                content_url = this.getBeanName();
            }
            Object template_url = "";
            String prefix = content_url.substring(0, content_url.indexOf(this.getBeanName()));
            template_url = !template.contains(prefix) && !template.startsWith("/") ? prefix + template : template;
            this.setUrl((String)template_url);
            this.setContent(content_url);
            File file = new File(ConfigTable.getWebRoot(), content_url);
            if (!file.exists()) {
                this.log.error("[\u6587\u4ef6\u4e0d\u5b58\u5728]:[url:{}]", (Object)content_url);
                content_url = ConfigTable.getString((String)"DEFAULT_CONTENT_PAGE_PATH");
            }
            request.setAttribute(ANYLINE_TEMPLATE_CONTENT_PATH, (Object)content_url);
            request.setAttribute("template_content_path", (Object)content_url);
        }
        super.render(model, request, response);
    }
}

