/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.plugin.springmvc;

import java.util.Locale;
import org.anyline.plugin.springmvc.TemplateView;
import org.springframework.beans.BeanUtils;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.AbstractUrlBasedView;
import org.springframework.web.servlet.view.InternalResourceView;
import org.springframework.web.servlet.view.UrlBasedViewResolver;

public class TemplateResourceViewResolver
extends UrlBasedViewResolver {
    private Boolean alwaysInclude;
    private Boolean exposeContextBeansAsAttributes;
    private String[] exposedContextBeanNames;

    public TemplateResourceViewResolver() {
        Class<TemplateView> viewClass = this.requiredViewClass();
        if (viewClass.equals(InternalResourceView.class)) {
            viewClass = TemplateView.class;
        }
        this.setViewClass(viewClass);
    }

    protected Class requiredViewClass() {
        return InternalResourceView.class;
    }

    public void setAlwaysInclude(boolean alwaysInclude) {
        this.alwaysInclude = alwaysInclude;
    }

    public void setExposeContextBeansAsAttributes(boolean exposeContextBeansAsAttributes) {
        this.exposeContextBeansAsAttributes = exposeContextBeansAsAttributes;
    }

    public void setExposedContextBeanNames(String ... exposedContextBeanNames) {
        this.exposedContextBeanNames = exposedContextBeanNames;
    }

    protected View loadView(String viewName, Locale locale) throws Exception {
        AbstractUrlBasedView view = this.buildView(viewName);
        return (View)this.getApplicationContext().getAutowireCapableBeanFactory().initializeBean((Object)view, viewName);
    }

    protected AbstractUrlBasedView buildView(String viewName) throws Exception {
        TemplateView view = (TemplateView)((Object)BeanUtils.instantiateClass((Class)this.getViewClass()));
        if (!((String)viewName).contains(this.getPrefix()) && !((String)viewName).startsWith("/")) {
            viewName = this.getPrefix() + (String)viewName;
        }
        if (!((String)viewName).endsWith(this.getSuffix())) {
            viewName = (String)viewName + this.getSuffix();
        }
        view.setUrl((String)viewName);
        String contentType = this.getContentType();
        if (contentType != null) {
            view.setContentType(contentType);
        }
        view.setRequestContextAttribute(this.getRequestContextAttribute());
        view.setAttributesMap(this.getAttributesMap());
        if (this.alwaysInclude != null) {
            view.setAlwaysInclude(this.alwaysInclude);
        }
        if (this.exposeContextBeansAsAttributes != null) {
            view.setExposeContextBeansAsAttributes(this.exposeContextBeansAsAttributes);
        }
        if (this.exposedContextBeanNames != null) {
            view.setExposedContextBeanNames(this.exposedContextBeanNames);
        }
        view.setPreventDispatchLoop(true);
        return view;
    }
}

