/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.plugin.springmvc;

import org.anyline.web.util.WebUtil;
import org.springframework.web.servlet.ModelAndView;

public class TemplateModelAndView
extends ModelAndView {
    public static final String DATA_URL = "anyline_template_data_url";
    public static final String STYLE_URL = "anyline_template_style_url";
    public static final String DATA_PARSER = "anyline_template_data_parser";
    public static final String CONTENT_URL = "anyline_template_content_url";
    public static final String PAGE_TITLE = "anyline_template_page_title";
    private String fromClass = "";

    public TemplateModelAndView setTitle(String title) {
        this.addObject(PAGE_TITLE, title);
        return this;
    }

    public TemplateModelAndView setData(String url) {
        if (null != url && !url.startsWith("/")) {
            String base = (String)this.getModel().get(CONTENT_URL);
            if (null != (base = base.substring(0, base.lastIndexOf("/")))) {
                url = base.endsWith("/") ? base + url : base + "/" + url;
            }
        }
        this.addObject(DATA_URL, url);
        return this;
    }

    public TemplateModelAndView setStyle(String template) {
        try {
            String data_template = this.createFullTemplatePath(template);
            this.addObject("style_template_des", WebUtil.encrypt((Object)data_template, (String[])new String[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    public String createFullTemplatePath(String path) {
        String method;
        String viewName = this.getViewName();
        String data_template = viewName.substring(0, viewName.lastIndexOf("/") + 1).replace("/page/", "/template/style/") + path;
        int idx = data_template.indexOf(":");
        if (idx > 0 && (method = data_template.substring(idx + 1)).indexOf(".") == -1) {
            data_template = data_template.replace(method, this.fromClass + "." + method);
        }
        return data_template;
    }

    public TemplateModelAndView setDataParser(String ... parser) {
        String str = "{";
        int size = parser.length;
        for (int i = 0; i < size; ++i) {
            String p = parser[i];
            str = str + "'" + p.replace(":", "':'") + "'";
            if (i >= size - 1) continue;
            str = str + ",";
        }
        str = str + "}";
        this.addObject(DATA_PARSER, str);
        return this;
    }

    public String getFromClass() {
        return this.fromClass;
    }

    public void setFromClass(String fromClass) {
        this.fromClass = fromClass;
    }
}

