/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.controller.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.PageNavi;
import org.anyline.jdbc.config.ConfigStore;
import org.anyline.jdbc.config.TableBuilder;
import org.anyline.jdbc.config.db.SQL;
import org.anyline.service.AnylineService;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.CharUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.DESUtil;
import org.anyline.util.FileUtil;
import org.anyline.web.controller.AbstractBasicController;
import org.anyline.web.util.WebUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

public class AnylineController
extends AbstractBasicController {
    @Autowired(required=false)
    @Qualifier(value="anyline.service")
    protected AnylineService service;
    protected HttpServletRequest _request;
    protected HttpServletResponse _response;

    protected HttpServletRequest getRequest() {
        if (null == this._request) {
            this._request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        }
        return this._request;
    }

    @Autowired
    protected void setRequest(HttpServletRequest request) {
        this._request = request;
        try {
            this._request.setCharacterEncoding(ConfigTable.getString((String)"HTTP_ENCODEING", (String)"UTF-8"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected HttpServletResponse getResponse() {
        if (null == this._response) {
            this._response = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
        }
        return this._response;
    }

    @Autowired
    public void setResponse(HttpServletResponse response) {
        this._response = response;
        try {
            this._response.setCharacterEncoding(ConfigTable.getString((String)"HTTP_ENCODEING", (String)"UTF-8"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected HttpSession getSession() {
        return this.getRequest().getSession();
    }

    protected ServletContext getServlet() {
        return this.getSession().getServletContext();
    }

    public <T> T entity(Class<T> clazz, boolean keyEncrypt, boolean valueEncrypt, String ... params) {
        return (T)this.entity(this.getRequest(), clazz, keyEncrypt, valueEncrypt, params);
    }

    public <T> T entity(Class<T> clazz, boolean keyEncrypt, String ... params) {
        return (T)this.entity(this.getRequest(), clazz, keyEncrypt, false, params);
    }

    public <T> T entity(Class<T> clazz, String ... params) {
        return (T)this.entity(this.getRequest(), clazz, false, false, params);
    }

    @Deprecated
    public DataRow entity(boolean keyEncrypt, boolean valueEncrypt, String ... params) {
        return this.entity(this.getRequest(), DataRow.KEY_CASE.CONFIG, null, keyEncrypt, valueEncrypt, params);
    }

    @Deprecated
    public DataRow entity(DataRow.KEY_CASE keyCase, boolean keyEncrypt, String ... params) {
        return this.entity(this.getRequest(), keyCase, null, keyEncrypt, false, params);
    }

    public DataRow entity(TableBuilder table) {
        return this.entity(table, null);
    }

    public DataRow entity(TableBuilder table, DataRow row) {
        List metadatas = this.service.metadata(table.getTable());
        List<String> params = this.params(metadatas);
        return this.entity(this.getRequest(), null, row, false, false, params);
    }

    protected ConfigStore parseConfig(boolean navi, String ... configs) {
        return this.parseConfig(this.getRequest(), navi, configs);
    }

    public DataRow entity(DataRow.KEY_CASE keyCase, DataRow row, boolean keyEncrypt, boolean valueEncrypt, String ... params) {
        return this.entity(this.getRequest(), keyCase, row, keyEncrypt, valueEncrypt, params);
    }

    public DataRow entity(DataRow row, boolean keyEncrypt, boolean valueEncrypt, String ... params) {
        return this.entity(this.getRequest(), DataRow.KEY_CASE.CONFIG, row, keyEncrypt, valueEncrypt, params);
    }

    public DataRow entity(DataRow.KEY_CASE keyCase, DataRow row, boolean keyEncrypt, String ... params) {
        return this.entity(this.getRequest(), keyCase, row, keyEncrypt, false, params);
    }

    public DataRow entity(DataRow row, boolean keyEncrypt, String ... params) {
        return this.entity(this.getRequest(), DataRow.KEY_CASE.CONFIG, row, keyEncrypt, false, params);
    }

    public DataRow entity(DataRow.KEY_CASE keyCase, DataRow row, String ... params) {
        return this.entity(this.getRequest(), keyCase, row, false, false, params);
    }

    public DataRow entity(DataRow row, String ... params) {
        String param;
        if (null != params && params.length == 1 && (param = params[0]).startsWith("{") && param.endsWith("}")) {
            String table = param.substring(1, param.length() - 1);
            return this.entity(TableBuilder.init((String)table), row);
        }
        return this.entity(this.getRequest(), DataRow.KEY_CASE.CONFIG, row, false, false, params);
    }

    public DataRow entity(DataRow.KEY_CASE keyCase, boolean keyEncrypt, boolean valueEncrypt, String ... params) {
        return this.entity(this.getRequest(), keyCase, null, keyEncrypt, valueEncrypt, params);
    }

    public DataRow entity(boolean keyEncrypt, String ... params) {
        return this.entity(this.getRequest(), DataRow.KEY_CASE.CONFIG, null, keyEncrypt, false, params);
    }

    public DataRow entity(DataRow.KEY_CASE keyCase, String ... params) {
        return this.entity(this.getRequest(), keyCase, null, false, false, params);
    }

    public DataRow entity(String ... params) {
        String param;
        if (null != params && params.length == 1 && (param = params[0]).startsWith("{") && param.endsWith("}")) {
            String table = param.substring(1, param.length() - 1);
            return this.entity(TableBuilder.init((String)table));
        }
        return this.entity(this.getRequest(), DataRow.KEY_CASE.CONFIG, null, false, false, params);
    }

    public DataSet entitys(DataRow.KEY_CASE keyCase, boolean keyEncrypt, boolean valueEncrypt, String ... params) {
        return this.entitys(this.getRequest(), keyCase, keyEncrypt, valueEncrypt, params);
    }

    public DataSet entitys(boolean keyEncrypt, boolean valueEncrypt, String ... params) {
        return this.entitys(this.getRequest(), DataRow.KEY_CASE.CONFIG, keyEncrypt, valueEncrypt, params);
    }

    public DataSet entitys(DataRow.KEY_CASE keyCase, boolean keyEncrypt, String ... params) {
        return this.entitys(this.getRequest(), keyCase, keyEncrypt, false, params);
    }

    public DataSet entitys(boolean keyEncrypt, String ... params) {
        return this.entitys(this.getRequest(), DataRow.KEY_CASE.CONFIG, keyEncrypt, false, params);
    }

    public DataSet entitys(DataRow.KEY_CASE keyCase, String ... params) {
        return this.entitys(this.getRequest(), keyCase, false, false, params);
    }

    public DataSet entitys(String ... params) {
        return this.entitys(this.getRequest(), DataRow.KEY_CASE.CONFIG, false, false, params);
    }

    public DataSet entitys(TableBuilder table) {
        List metadatas = this.service.metadata(table.getTable());
        List<String> params = this.params(metadatas);
        return this.entitys(this.getRequest(), null, false, false, params);
    }

    public DataSet entitys(SQL sql) {
        List metadatas = this.service.metadata(sql.getTable());
        List<String> params = this.params(metadatas);
        return this.entitys(this.getRequest(), null, false, false, params);
    }

    private List<String> params(List<String> metadatas) {
        ArrayList<String> params;
        block4: {
            String keyCase;
            block3: {
                params = new ArrayList<String>();
                keyCase = ConfigTable.getString((String)"HTTP_PARAM_KEYS_CASE");
                if (!"camel".equals(keyCase)) break block3;
                if (null == metadatas) break block4;
                for (String key : metadatas) {
                    params.add(key + ":" + BeanUtil.camel((String)key.toLowerCase()));
                }
                break block4;
            }
            if ("Camel".equals(keyCase) && null != metadatas) {
                for (String key : metadatas) {
                    key = CharUtil.toUpperCaseHeader((String)key.toLowerCase());
                    params.add(key + ":" + BeanUtil.Camel((String)key));
                }
            }
        }
        return params;
    }

    protected ConfigStore parseConfig(int vol, String ... configs) {
        return this.parseConfig(this.getRequest(), vol, configs);
    }

    protected ConfigStore parseConfig(int fr, int to, String ... configs) {
        return this.parseConfig(this.getRequest(), fr, to, configs);
    }

    protected ConfigStore parseConfig(String ... conditions) {
        return this.parseConfig(this.getRequest(), false, conditions);
    }

    protected ConfigStore condition(boolean navi, String ... configs) {
        return this.parseConfig(this.getRequest(), navi, configs);
    }

    protected ConfigStore condition(int vol, String ... configs) {
        return this.parseConfig(this.getRequest(), vol, configs);
    }

    protected ConfigStore condition(int fr, int to, String ... configs) {
        return this.parseConfig(this.getRequest(), fr, to, configs);
    }

    protected ConfigStore condition(String ... conditions) {
        return this.parseConfig(this.getRequest(), false, conditions);
    }

    protected ConfigStore where(boolean navi, String ... configs) {
        return this.parseConfig(this.getRequest(), navi, configs);
    }

    protected ConfigStore where(int vol, String ... configs) {
        return this.parseConfig(this.getRequest(), vol, configs);
    }

    protected ConfigStore where(int fr, int to, String ... configs) {
        return this.parseConfig(this.getRequest(), fr, to, configs);
    }

    protected ConfigStore where(String ... conditions) {
        return this.parseConfig(this.getRequest(), false, conditions);
    }

    protected String getParam(String key, boolean keyEncrypt, boolean valueEncrypt, String ... defs) {
        return this.getParam(this.getRequest(), key, keyEncrypt, valueEncrypt, defs);
    }

    protected String getParam(String key, boolean valueEncrypt, String ... defs) {
        return this.getParam(this.getRequest(), key, false, valueEncrypt, defs);
    }

    protected String getParam(String key, String ... defs) {
        return this.getParam(this.getRequest(), key, false, false, defs);
    }

    protected List<Object> getParams(String key, boolean keyEncrypt, boolean valueEncrypt) {
        return this.getParams(this.getRequest(), key, keyEncrypt, valueEncrypt);
    }

    protected List<Object> getParams(String key, boolean valueEncrypt) {
        return this.getParams(this.getRequest(), key, false, valueEncrypt);
    }

    protected List<Object> getParams(String key) {
        return this.getParams(this.getRequest(), key, false, false);
    }

    protected String param(String key, boolean keyEncrypt, boolean valueEncrypt, String ... defs) {
        return this.getParam(this.getRequest(), key, keyEncrypt, valueEncrypt, defs);
    }

    protected String param(String key, boolean valueEncrypt, String ... defs) {
        return this.getParam(this.getRequest(), key, false, valueEncrypt, defs);
    }

    protected String param(String key, String ... defs) {
        return this.getParam(this.getRequest(), key, false, false, defs);
    }

    protected List<Object> params(String key, boolean keyEncrypt, boolean valueEncrypt) {
        return this.getParams(this.getRequest(), key, keyEncrypt, valueEncrypt);
    }

    protected List<Object> params(String key, boolean valueEncrypt) {
        return this.getParams(this.getRequest(), key, false, valueEncrypt);
    }

    protected List<Object> params(String key) {
        return this.getParams(this.getRequest(), key, false, false);
    }

    protected int getInt(String key, boolean keyEncrypt, boolean valueEncrypt) throws Exception {
        return this.getInt(this.getRequest(), key, keyEncrypt, valueEncrypt);
    }

    protected int getInt(String key, boolean valueEncrypt) throws Exception {
        return this.getInt(this.getRequest(), key, valueEncrypt);
    }

    protected int getInt(String key) throws Exception {
        return this.getInt(this.getRequest(), key);
    }

    protected int getInt(String key, boolean keyEncrypt, boolean valueEncrypt, int def) {
        return this.getInt(this.getRequest(), key, keyEncrypt, valueEncrypt, def);
    }

    protected int getInt(String key, boolean valueEncrypt, int def) {
        return this.getInt(this.getRequest(), key, valueEncrypt, def);
    }

    protected int getInt(String key, int def) {
        return this.getInt(this.getRequest(), key, def);
    }

    protected double getDouble(String key, boolean keyEncrypt, boolean valueEncrypt) throws Exception {
        return this.getDouble(this.getRequest(), key, keyEncrypt, valueEncrypt);
    }

    protected double getDouble(String key, boolean valueEncrypt) throws Exception {
        return this.getDouble(this.getRequest(), key, valueEncrypt);
    }

    protected double getDouble(String key) throws Exception {
        return this.getDouble(this.getRequest(), key);
    }

    protected double getDouble(String key, boolean keyEncrypt, boolean valueEncrypt, double def) {
        return this.getDouble(this.getRequest(), key, keyEncrypt, valueEncrypt, def);
    }

    protected double getDouble(String key, boolean valueEncrypt, double def) {
        return this.getDouble(this.getRequest(), key, valueEncrypt, def);
    }

    protected double getDouble(String key, double def) {
        return this.getDouble(this.getRequest(), key, def);
    }

    protected boolean checkRequired(boolean keyEncrypt, boolean valueEncrypt, String ... params) {
        return this.checkRequired(this.getRequest(), keyEncrypt, valueEncrypt, params);
    }

    protected boolean checkRequired(String ... params) {
        return this.checkRequired(this.getRequest(), false, false, params);
    }

    protected boolean isAjaxRequest() {
        return this.isAjaxRequest(this.getRequest());
    }

    protected void setRequestMessage(String key, Object value, String type) {
        this.setRequestMessage(this.getRequest(), key, value, type);
    }

    protected void setRequestMessage(String key, Object value) {
        this.setRequestMessage(this.getRequest(), key, value, null);
    }

    protected void setRequestMessage(Object value) {
        this.setRequestMessage(this.getRequest(), BasicUtil.getRandomLowerString((int)10), value, null);
    }

    protected void setMessage(String key, Object value, String type) {
        this.setRequestMessage(this.getRequest(), key, value, type);
    }

    protected void setMessage(String key, Object value) {
        this.setMessage(this.getRequest(), key, value, null);
    }

    protected void setMessage(Object value) {
        this.setMessage(this.getRequest(), BasicUtil.getRandomLowerString((int)10), value);
    }

    protected void setSessionMessage(String key, Object value, String type) {
        this.setSessionMessage(this.getRequest().getSession(), key, value, type);
    }

    protected void setSessionMessage(String key, Object value) {
        this.setSessionMessage(this.getRequest().getSession(), key, value, null);
    }

    protected void setSessionMessage(Object value) {
        this.setSessionMessage(this.getRequest().getSession(), BasicUtil.getRandomLowerString((int)10), value, null);
    }

    protected boolean hasReffer() {
        return this.hasReffer(this.getRequest());
    }

    protected boolean isSpider() {
        return !this.hasReffer(this.getRequest());
    }

    protected boolean isWap() {
        return WebUtil.isWap((HttpServletRequest)this.getRequest());
    }

    public String result(String code, boolean result, Object data, String message) {
        DataSet messages = (DataSet)this.getRequest().getAttribute("REQUEST_ATTR_MESSAGE");
        if (null != messages) {
            for (int i = 0; i < messages.size(); ++i) {
                DataRow msg = messages.getRow(i);
                String tmp = msg.getStringNvl("value", new String[]{""});
                if (!BasicUtil.isNotEmpty((Object)tmp)) continue;
                message = BasicUtil.nvl((String[])new String[]{message, ""}) + "\n" + tmp;
            }
            this.getRequest().removeAttribute("REQUEST_ATTR_MESSAGE");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        String dataType = null;
        if (null == data) {
            message = (String)BasicUtil.nvl((String[])new String[]{message, "\u6ca1\u6709\u8fd4\u56de\u6570\u636e"});
            data = "";
        } else if (data instanceof DataSet) {
            DataSet set = (DataSet)data;
            message = message + (String)BasicUtil.nvl((String[])new String[]{message, set.getMessage()});
            dataType = "list";
            data = set.getRows();
            PageNavi navi = set.getNavi();
            if (null != navi) {
                HashMap<String, Integer> navi_ = new HashMap<String, Integer>();
                navi_.put("page", navi.getCurPage());
                navi_.put("pages", navi.getTotalPage());
                navi_.put("rows", navi.getTotalRow());
                navi_.put("vol", navi.getPageRows());
                map.put("navi", navi_);
            }
        } else if (data instanceof Iterable) {
            dataType = "list";
        } else if (data instanceof DataRow) {
            dataType = "map";
        } else if (data instanceof Map) {
            dataType = "map";
        } else if (data instanceof String) {
            dataType = "string";
            data = data.toString();
        } else if (data instanceof Number) {
            dataType = "number";
            data = data.toString();
        } else {
            dataType = "map";
        }
        if (!result && null != data) {
            message = message + data.toString();
        }
        map.put("type", dataType);
        map.put("result", result);
        map.put("message", message);
        map.put("data", data);
        map.put("success", result);
        map.put("code", code);
        map.put("request_time", this.getRequest().getParameter("_anyline_request_time"));
        map.put("response_time_fr", this.getRequest().getAttribute("_anyline_response_time_fr"));
        map.put("response_time_to", System.currentTimeMillis());
        if (ConfigTable.isDebug() && this.log.isWarnEnabled()) {
            this.log.warn("[controller return][result:{}][message:{}]", (Object)result, (Object)message);
        }
        this.getResponse().setContentType("application/json;charset=utf-8");
        this.getResponse().setHeader("Content-type", "application/json;charset=utf-8");
        this.getResponse().setCharacterEncoding("UTF-8");
        return BeanUtil.map2json(map);
    }

    protected String fail(String msg, boolean encrypt) {
        if (encrypt) {
            msg = DESUtil.encryptParamValue((String)msg);
        }
        String code = ConfigTable.getString((String)"HTTP_FAIL_CODE", (String)"-1");
        return this.result(code, false, null, msg);
    }

    protected String fail(String code, String msg, boolean encrypt) {
        if (encrypt) {
            msg = DESUtil.encryptParamValue((String)msg);
        }
        return this.result(code, false, null, msg);
    }

    protected String fail(String msg) {
        String code = ConfigTable.getString((String)"HTTP_FAIL_CODE", (String)"-1");
        return this.result(code, false, null, msg);
    }

    protected String fail(String code, String msg) {
        return this.result(code, false, null, msg);
    }

    protected String fail() {
        String msg = null;
        return this.fail(msg);
    }

    protected String success(Object data, boolean encrypt) {
        String code = ConfigTable.getString((String)"HTTP_SUCCESS_CODE", (String)"200");
        if (encrypt && null != data) {
            return this.result(code, true, DESUtil.encryptParamValue((String)data.toString()), null);
        }
        return this.result(code, true, data, null);
    }

    protected String success(Object data) {
        String code = ConfigTable.getString((String)"HTTP_SUCCESS_CODE", (String)"200");
        return this.result(code, true, data, null);
    }

    protected String success(Object ... data) {
        String code = ConfigTable.getString((String)"HTTP_SUCCESS_CODE", (String)"200");
        return this.result(code, true, data, null);
    }

    public String navi(boolean adapt, HttpServletRequest request, HttpServletResponse response, DataSet data, String page, Object ext) {
        Map map;
        if (null == request) {
            request = this.getRequest();
        }
        if (null == response) {
            response = this.getResponse();
        }
        if (null == data) {
            data = (DataSet)request.getAttribute("_anyline_navi_data");
        } else {
            request.setAttribute("_anyline_navi_data", (Object)data);
        }
        PageNavi navi = null;
        if (null != data) {
            navi = data.getNavi();
        }
        if (page != null && !page.startsWith("/")) {
            page = "/WEB-INF/" + page;
        }
        String clientType = "web";
        if (WebUtil.isWap((HttpServletRequest)request)) {
            clientType = "wap";
        }
        if (null != page) {
            if (adapt) {
                page = page.replace("/web/", "/" + clientType + "/");
                page = page.replace("/wap/", "/" + clientType + "/");
            }
            page = page.replace("${client_type}", clientType);
            page = page.replace("${client}", clientType);
        }
        if (null != request) {
            map = (Map)request.getAttribute("anyline_template_variable");
            if (null == map) {
                map = (Map)request.getSession().getAttribute("anyline_template_variable");
            }
            if (null != map) {
                for (String key : map.keySet()) {
                    Object value = map.get(key);
                    if (null == value) continue;
                    page = page.replace("${" + key + "}", value.toString());
                }
            }
        }
        map = super.navi(request, response, (Object)data, navi, page, ext);
        return this.success((Object)map);
    }

    public String navi(HttpServletRequest request, HttpServletResponse response, DataSet data, String page, Object ext) {
        return this.navi(false, request, response, data, page, ext);
    }

    public String navi(HttpServletRequest request, HttpServletResponse response, DataSet data, String page) {
        return this.navi(request, response, data, page, null);
    }

    public String navi(boolean adapt, HttpServletRequest request, HttpServletResponse response, DataSet data, String page) {
        return this.navi(adapt, request, response, data, page, null);
    }

    public String navi(HttpServletResponse response, String page) {
        return this.navi(null, response, null, page, null);
    }

    public String navi(HttpServletResponse response, DataSet data, String page) {
        return this.navi(this.getRequest(), response, data, page, null);
    }

    public List<File> upload(File dir) throws IllegalStateException, IOException {
        ArrayList<File> result = new ArrayList<File>();
        HttpServletRequest request = this.getRequest();
        CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
        if (multipartResolver.isMultipart(request)) {
            MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest)request;
            Iterator iter = multiRequest.getFileNames();
            while (iter.hasNext()) {
                String fileName;
                MultipartFile file = multiRequest.getFile((String)iter.next());
                if (file == null || !BasicUtil.isNotEmpty((Object)(fileName = file.getOriginalFilename()))) continue;
                String sufName = FileUtil.getSuffixFileName((String)fileName);
                File localFile = new File(dir, BasicUtil.getRandomLowerString((int)10) + "." + sufName);
                file.transferTo(localFile);
                result.add(localFile);
            }
        }
        return result;
    }
}

