/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.mimio.util;

import io.minio.BucketExistsArgs;
import io.minio.ComposeObjectArgs;
import io.minio.ComposeSource;
import io.minio.GetObjectArgs;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.ListObjectsArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.ObjectWriteResponse;
import io.minio.PutObjectArgs;
import io.minio.RemoveBucketArgs;
import io.minio.RemoveObjectArgs;
import io.minio.Result;
import io.minio.StatObjectArgs;
import io.minio.StatObjectResponse;
import io.minio.http.Method;
import io.minio.messages.Bucket;
import io.minio.messages.Item;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Hashtable;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.anyline.mimio.util.MinioConfig;
import org.anyline.util.AnylineConfig;
import org.anyline.util.BasicUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinioUtil {
    private static final Logger log = LoggerFactory.getLogger(MinioUtil.class);
    private MinioClient client;
    private MinioConfig config = null;
    private static Hashtable<String, MinioUtil> instances = new Hashtable();

    public MinioUtil() {
    }

    public MinioUtil(String endpoint, String bucket, String key, String secret) {
        MinioConfig config = new MinioConfig();
        config.ENDPOINT = endpoint;
        config.ACCESS_KEY = key;
        config.ACCESS_SECRET = secret;
        config.BUCKET = bucket;
        this.config = config;
        this.client = MinioClient.builder().endpoint(endpoint).credentials(key, secret).build();
    }

    public static Hashtable<String, MinioUtil> getInstances() {
        return instances;
    }

    public static MinioUtil getInstance() {
        return MinioUtil.getInstance("default");
    }

    public MinioClient getClient() {
        return this.client;
    }

    public void setClient(MinioClient client) {
        this.client = client;
    }

    public MinioConfig getConfig() {
        return this.config;
    }

    public void setConfig(MinioConfig config) {
        this.config = config;
    }

    public static MinioUtil getInstance(String key) {
        MinioConfig config;
        MinioUtil util;
        if (BasicUtil.isEmpty((Object)key)) {
            key = "default";
        }
        if (null == (util = instances.get(key)) && null != (config = MinioConfig.getInstance(key))) {
            util = new MinioUtil();
            util.config = config;
            util.client = MinioClient.builder().endpoint(config.ENDPOINT).credentials(config.ACCESS_KEY, config.ACCESS_SECRET).build();
            instances.put(key, util);
        }
        return util;
    }

    public void createBucket(String bucket) throws Exception {
        if (!this.client.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucket)).build())) {
            this.client.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucket)).build());
        }
    }

    public List<Bucket> getAllBuckets() throws Exception {
        return this.client.listBuckets();
    }

    public Optional<Bucket> getBucket(String bucket) throws Exception {
        return this.client.listBuckets().stream().filter(b -> b.name().equals(bucket)).findFirst();
    }

    public void removeBucket(String bucket) throws Exception {
        this.client.removeBucket((RemoveBucketArgs)((RemoveBucketArgs.Builder)RemoveBucketArgs.builder().bucket(bucket)).build());
    }

    public String putObject(String bucket, String obj, InputStream stream, Long size) throws Exception {
        PutObjectArgs putObjectArgs = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucket)).object(obj)).stream(stream, size.longValue(), (long)this.config.PART_SIZE).build();
        ObjectWriteResponse objectWriteResponse = this.client.putObject(putObjectArgs);
        return objectWriteResponse.object();
    }

    public String putObject(String obj, InputStream stream, Long size) throws Exception {
        return this.putObject(this.config.BUCKET, obj, stream, size);
    }

    public List<Item> getAllObjectsByPrefix(String bucket, String prefix, boolean recursive) throws Exception {
        ArrayList<Item> objectList = new ArrayList<Item>();
        ListObjectsArgs listObjectsArgs = (ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(bucket)).prefix(prefix).recursive(recursive).build();
        Iterable objectsIterator = this.client.listObjects(listObjectsArgs);
        while (objectsIterator.iterator().hasNext()) {
            objectList.add((Item)((Result)objectsIterator.iterator().next()).get());
        }
        return objectList;
    }

    public List<Item> getAllObjectsByPrefix(String prefix, boolean recursive) throws Exception {
        return this.getAllObjectsByPrefix(this.config.BUCKET, prefix, recursive);
    }

    public String getObjectURL(String bucket, String obj) throws Exception {
        GetPresignedObjectUrlArgs args = (GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().bucket(bucket)).method(Method.GET).expiry(7, TimeUnit.DAYS).object(obj)).build();
        return this.client.getPresignedObjectUrl(args);
    }

    public String getObjectURL(String obj) throws Exception {
        return this.getObjectURL(this.config.BUCKET, obj);
    }

    public InputStream getObject(String bucket, String obj) throws Exception {
        GetObjectArgs getObjectArgs = (GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucket)).object(obj)).build();
        return this.client.getObject(getObjectArgs);
    }

    public InputStream getObject(String obj) throws Exception {
        return this.getObject(this.config.BUCKET, obj);
    }

    public String putObject(String bucket, String obj, String base64) throws Exception {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(base64.getBytes());
        byte[] byt = new byte[]{};
        try {
            byt = Base64.getDecoder().decode(base64);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        inputStream = new ByteArrayInputStream(byt);
        this.putObject(bucket, obj, inputStream, Long.valueOf(byt.length));
        return obj;
    }

    public String putObject(String obj, String base64) throws Exception {
        return this.putObject(this.config.BUCKET, obj, base64);
    }

    public String putObject(String bucket, String obj, File file) throws Exception {
        this.putObject(bucket, obj, new FileInputStream(file), file.length());
        return obj;
    }

    public String putObject(String obj, File file) throws Exception {
        return this.putObject(this.config.BUCKET, obj, file);
    }

    public StatObjectResponse getObjectInfo(String bucket, String obj) throws Exception {
        StatObjectArgs statObjectArgs = (StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(bucket)).object(obj)).build();
        return this.client.statObject(statObjectArgs);
    }

    public StatObjectResponse getObjectInfo(String obj) throws Exception {
        return this.getObjectInfo(this.config.BUCKET, obj);
    }

    public void removeObject(String bucket, String obj) throws Exception {
        this.client.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(bucket)).object(obj)).build());
    }

    public void removeObject(String obj) throws Exception {
        this.removeObject(this.config.BUCKET, obj);
    }

    public String presignedUrl(String bucket, String obj) throws Exception {
        GetPresignedObjectUrlArgs getPresignedObjectUrlArgs = (GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(Method.PUT).bucket(bucket)).object(obj)).expiry(7, TimeUnit.DAYS).build();
        return this.client.getPresignedObjectUrl(getPresignedObjectUrlArgs);
    }

    public String presignedUrl(String obj) throws Exception {
        return this.presignedUrl(this.config.BUCKET, obj);
    }

    public String composeObject(String bucket, List<String> chunks, String target) throws Exception {
        ArrayList<ComposeSource> sources = new ArrayList<ComposeSource>(chunks.size());
        for (String chunkName : chunks) {
            ComposeSource composeSource = (ComposeSource)((ComposeSource.Builder)((ComposeSource.Builder)ComposeSource.builder().bucket(bucket)).object(chunkName)).build();
            sources.add(composeSource);
        }
        ComposeObjectArgs composeObjectArgs = (ComposeObjectArgs)((ComposeObjectArgs.Builder)((ComposeObjectArgs.Builder)ComposeObjectArgs.builder().bucket(bucket)).sources(sources).object(target)).build();
        ObjectWriteResponse objectWriteResponse = this.client.composeObject(composeObjectArgs);
        return objectWriteResponse.object();
    }

    public String composeObject(List<String> chunks, String target) throws Exception {
        return this.composeObject(this.config.BUCKET, chunks, target);
    }

    static {
        Hashtable<String, AnylineConfig> configs = MinioConfig.getInstances();
        for (String key : configs.keySet()) {
            instances.put(key, MinioUtil.getInstance(key));
        }
    }
}

