/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.mimio.util;

import java.io.File;
import java.util.Hashtable;
import org.anyline.entity.DataRow;
import org.anyline.mimio.util.MinioUtil;
import org.anyline.util.AnylineConfig;
import org.anyline.util.BasicUtil;
import org.anyline.util.ConfigTable;

public class MinioConfig
extends AnylineConfig {
    private static Hashtable<String, AnylineConfig> instances = new Hashtable();
    private static File configDir;
    public static String DEFAULT_ACCESS_KEY;
    public static String DEFAULT_ACCESS_SECRET;
    public static String DEFAULT_ENDPOINT;
    public static String DEFAULT_BUCKET;
    public static int DEFAULT_PART_SIZE;
    public static String DEFAULT_DIR;
    public static int DEFAULT_EXPIRE_SECOND;
    public String ACCESS_KEY = DEFAULT_ACCESS_KEY;
    public String ACCESS_SECRET = DEFAULT_ACCESS_SECRET;
    public String ENDPOINT = DEFAULT_ENDPOINT;
    public String BUCKET = DEFAULT_BUCKET;
    public int PART_SIZE = DEFAULT_PART_SIZE;
    public String DIR = DEFAULT_DIR;
    public int EXPIRE_SECOND = DEFAULT_EXPIRE_SECOND;
    public static String CONFIG_NAME;

    public static Hashtable<String, AnylineConfig> getInstances() {
        return instances;
    }

    public static void parse(String content) {
        MinioConfig.parse(MinioConfig.class, (String)content, instances, (String[])compatibles);
    }

    public static void init() {
        MinioConfig.load();
    }

    public static void setConfigDir(File dir) {
        configDir = dir;
        MinioConfig.init();
    }

    public static MinioConfig getInstance() {
        return MinioConfig.getInstance("default");
    }

    public static MinioConfig getInstance(String key) {
        if (BasicUtil.isEmpty((Object)key)) {
            key = "default";
        }
        if (ConfigTable.getReload() > 0 && (System.currentTimeMillis() - lastLoadTime) / 1000L > (long)ConfigTable.getReload()) {
            MinioConfig.load();
        }
        return (MinioConfig)instances.get(key);
    }

    private static synchronized void load() {
        MinioConfig.load(instances, MinioConfig.class, (String)CONFIG_NAME, (String[])new String[0]);
        lastLoadTime = System.currentTimeMillis();
    }

    private static void debug() {
    }

    public static MinioConfig register(String instance, DataRow row) {
        MinioConfig config = (MinioConfig)MinioConfig.parse(MinioConfig.class, (String)instance, (DataRow)row, instances, (String[])compatibles);
        MinioUtil.getInstance(instance);
        return config;
    }

    public static MinioConfig register(DataRow row) {
        return MinioConfig.register("default", row);
    }

    static {
        DEFAULT_ACCESS_KEY = "";
        DEFAULT_ACCESS_SECRET = "";
        DEFAULT_ENDPOINT = "";
        DEFAULT_BUCKET = "";
        DEFAULT_PART_SIZE = 1;
        DEFAULT_DIR = "";
        DEFAULT_EXPIRE_SECOND = 3600;
        CONFIG_NAME = "anyline-minio.xml";
        MinioConfig.init();
        MinioConfig.debug();
    }
}

