/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.mimio.util;

import org.anyline.entity.DataRow;
import org.anyline.mimio.util.MinioConfig;
import org.anyline.mimio.util.MinioUtil;
import org.anyline.util.BasicUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component(value="anyline.minio.load.bean")
public class MinioBean
implements InitializingBean {
    @Value(value="${anyline.minio.key:}")
    public String ACCESS_KEY;
    @Value(value="${anyline.minio.secret:}")
    public String ACCESS_SECRET;
    @Value(value="${anyline.minio.endpoint:}")
    public String ENDPOINT;
    @Value(value="${anyline.minio.bucket:}")
    public String BUCKET;
    @Value(value="${anyline.minio.part:1}")
    public int PART_SIZE;
    @Value(value="${anyline.minio.dir:}")
    public String DIR;
    @Value(value="${anyline.minio.expire:3600}")
    public int EXPIRE_SECOND;

    public void afterPropertiesSet() {
        this.ACCESS_KEY = (String)BasicUtil.evl((Object[])new String[]{this.ACCESS_KEY, MinioConfig.DEFAULT_ACCESS_KEY});
        if (BasicUtil.isEmpty((Object)this.ACCESS_KEY)) {
            return;
        }
        DataRow row = new DataRow();
        row.put("ACCESS_KEY", BasicUtil.evl((Object[])new String[]{this.ACCESS_KEY, MinioConfig.DEFAULT_ACCESS_KEY}));
        row.put("ACCESS_SECRET", BasicUtil.evl((Object[])new String[]{this.ACCESS_SECRET, MinioConfig.DEFAULT_ACCESS_SECRET}));
        row.put("ENDPOINT", BasicUtil.evl((Object[])new String[]{this.ENDPOINT, MinioConfig.DEFAULT_ENDPOINT}));
        row.put("BUCKET", BasicUtil.evl((Object[])new String[]{this.BUCKET, MinioConfig.DEFAULT_BUCKET}));
        row.put("PART_SIZE", BasicUtil.evl((Object[])new Integer[]{this.PART_SIZE, MinioConfig.DEFAULT_PART_SIZE}));
        row.put("DIR", BasicUtil.evl((Object[])new String[]{this.DIR, MinioConfig.DEFAULT_DIR}));
        row.put("EXPIRE_SECOND", BasicUtil.evl((Object[])new Integer[]{this.EXPIRE_SECOND, MinioConfig.DEFAULT_EXPIRE_SECOND}));
        MinioConfig.register(row);
    }

    @Bean(value={"anyline.minio.init.util"})
    public MinioUtil instance() {
        return MinioUtil.getInstance();
    }
}

