/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.ldap.util;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.ldap.util.LdapConfig;
import org.anyline.util.AnylineConfig;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapUtil {
    private static Logger log = LoggerFactory.getLogger(LdapUtil.class);
    private LdapConfig config = null;
    private DirContext dc = null;
    private static Hashtable<String, LdapUtil> instances = new Hashtable();

    public static Hashtable<String, LdapUtil> getInstances() {
        return instances;
    }

    public static LdapUtil getInstance() {
        return LdapUtil.getInstance("default");
    }

    public static LdapUtil getInstance(String key) {
        LdapUtil util;
        if (BasicUtil.isEmpty((Object)key)) {
            key = "default";
        }
        if (null == (util = instances.get(key))) {
            LdapConfig config;
            util = new LdapUtil();
            util.config = config = LdapConfig.getInstance(key);
            instances.put(key, util);
        }
        return util;
    }

    public boolean login(String account, String password) throws Exception {
        try {
            this.connect(account, password).close();
        }
        catch (Exception e) {
            log.warn("[ldap login][result:false][msg:{}]", (Object)e.toString());
            throw e;
        }
        return true;
    }

    public DirContext connect(String account, String password) throws Exception {
        if (null != account && !((String)account).endsWith(this.config.DOMAIN)) {
            account = (String)account + "@" + this.config.DOMAIN;
        }
        Hashtable<String, Object> env = new Hashtable<String, Object>();
        env.put("java.naming.security.principal", account);
        env.put("java.naming.security.credentials", password);
        env.put("java.naming.provider.url", this.config.URL);
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.security.authentication", this.config.SECURITY_AUTHENTICATION);
        if (this.config.CONNECT_TIMEOUT > 0) {
            env.put("com.sun.jndi.ldap.connect.timeout", "" + this.config.CONNECT_TIMEOUT);
        }
        if (this.config.READ_TIMEOUT > 0) {
            env.put("com.sun.jndi.ldap.read.timeout", "" + this.config.READ_TIMEOUT);
        }
        try {
            this.dc = new InitialLdapContext(env, null);
        }
        catch (Exception e) {
            log.warn("[ldap connect][result:false][msg:{}]", (Object)e.toString());
            throw e;
        }
        return this.dc;
    }

    public boolean addUser(String uid, String ou, String password, Map<String, String> attributes) {
        try {
            BasicAttributes attrs = new BasicAttributes();
            BasicAttribute objclassSet = new BasicAttribute("objectClass");
            objclassSet.add("UserPrincipalName");
            objclassSet.add("employeeID");
            attrs.put(objclassSet);
            attrs.put("ou", ou);
            List keys = BeanUtil.getMapKeys(attributes);
            for (String key : keys) {
                attrs.put(key, attributes.get(key));
            }
            byte[] unicodePassword = null;
            try {
                unicodePassword = password.getBytes("UTF-16LE");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            attrs.put("unicodePwd", unicodePassword);
            this.dc.createSubcontext("uid=" + uid + ",ou=" + ou + "," + this.config.ROOT, (Attributes)attrs);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean changeOU(String dn, String ou) {
        String newDN = dn.split(",")[0] + "," + ou;
        try {
            this.dc.rename(dn, newDN);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean addOrganizationalUnit(String name) {
        try {
            BasicAttributes attrs = new BasicAttributes();
            BasicAttribute objclassSet = new BasicAttribute("objectClass");
            objclassSet.add("top");
            objclassSet.add("organizationalUnit");
            attrs.put(objclassSet);
            attrs.put("ou", name);
            attrs.put("description", name);
            this.dc.createSubcontext("ou=" + name + "," + this.config.ROOT, (Attributes)attrs);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean rename(String fr, String to) {
        try {
            this.dc.rename(fr, to);
            return true;
        }
        catch (NamingException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean delete(String dn) {
        try {
            this.dc.destroySubcontext(dn);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    public boolean update(String dn, Map<String, String> params) {
        try {
            ModificationItem[] mods = new ModificationItem[1];
            List keys = BeanUtil.getMapKeys(params);
            int index = 0;
            for (String key : keys) {
                String value = params.get(key);
                BasicAttribute attr = new BasicAttribute(key, value);
                ModificationItem mod = new ModificationItem(2, attr);
                mods[index++] = mod;
            }
            this.dc.modifyAttributes(dn + "," + this.config.ROOT, mods);
            return true;
        }
        catch (NamingException e) {
            e.printStackTrace();
            return false;
        }
    }

    public DataSet search(String base, int scope, String filter) {
        DataSet set = new DataSet();
        SearchControls sc = new SearchControls();
        sc.setSearchScope(scope);
        NamingEnumeration<SearchResult> ne = null;
        try {
            ne = this.dc.search(base, filter, sc);
            while (ne.hasMore()) {
                DataRow row = new DataRow();
                SearchResult sr = ne.next();
                String name = sr.getName();
                if (base != null && !base.equals("")) {
                    row.put("name", (Object)(name + "," + base));
                } else {
                    row.put("name", (Object)name);
                }
                Attributes at = sr.getAttributes();
                NamingEnumeration<? extends Attribute> attrs = at.getAll();
                while (attrs.hasMore()) {
                    Attribute attr = attrs.next();
                    String attrId = attr.getID();
                    NamingEnumeration<?> values = attr.getAll();
                    ArrayList<String> vals = new ArrayList<String>();
                    while (values.hasMore()) {
                        Object oneVal = values.nextElement();
                        if (oneVal instanceof String) {
                            vals.add((String)oneVal);
                            continue;
                        }
                        vals.add(new String((byte[])oneVal));
                    }
                    row.put(attrId, vals);
                }
                set.add(row);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return set;
    }

    static {
        Hashtable<String, AnylineConfig> configs = LdapConfig.getInstances();
        for (String key : configs.keySet()) {
            instances.put(key, LdapUtil.getInstance(key));
        }
    }
}

