/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.ldap.util;

import org.anyline.entity.DataRow;
import org.anyline.ldap.util.LdapConfig;
import org.anyline.ldap.util.LdapUtil;
import org.anyline.util.BasicUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component(value="anyline.ldap.load.bean")
public class LdapBean
implements InitializingBean {
    @Value(value="${anyline.ldap.address:}")
    private String ADDRESS;
    @Value(value="${anyline.ldap.port:389}")
    private int PORT;
    @Value(value="${anyline.ldap.domain:}")
    private String DOMAIN;
    @Value(value="${anyline.ldap.root:}")
    private String ROOT;
    @Value(value="${anyline.ldap.auth:}")
    private String SECURITY_AUTHENTICATION;
    @Value(value="${anyline.ldap.url:}")
    private String URL;
    @Value(value="${anyline.ldap.connectTimeout:0}")
    private int CONNECT_TIMEOUT;
    @Value(value="${anyline.ldap.readTimeout:0}")
    private int READ_TIMEOUT;

    public void afterPropertiesSet() {
        this.ADDRESS = (String)BasicUtil.evl((Object[])new String[]{this.ADDRESS, LdapConfig.DEFAULT_ADDRESS});
        if (BasicUtil.isEmpty((Object)this.ADDRESS)) {
            return;
        }
        DataRow row = new DataRow();
        row.put("ADDRESS", BasicUtil.evl((Object[])new String[]{this.ADDRESS, LdapConfig.DEFAULT_ADDRESS}));
        row.put("PORT", BasicUtil.evl((Object[])new Integer[]{this.PORT, LdapConfig.DEFAULT_PORT}));
        row.put("DOMAIN", BasicUtil.evl((Object[])new String[]{this.DOMAIN, LdapConfig.DEFAULT_DOMAIN}));
        row.put("ROOT", BasicUtil.evl((Object[])new String[]{this.ROOT, LdapConfig.DEFAULT_ROOT}));
        row.put("SECURITY_AUTHENTICATION", BasicUtil.evl((Object[])new String[]{this.SECURITY_AUTHENTICATION, LdapConfig.DEFAULT_SECURITY_AUTHENTICATION}));
        row.put("URL", BasicUtil.evl((Object[])new String[]{this.URL, LdapConfig.DEFAULT_URL}));
        row.put("CONNECT_TIMEOUT", BasicUtil.evl((Object[])new Integer[]{this.CONNECT_TIMEOUT, LdapConfig.DEFAULT_CONNECT_TIMEOUT}));
        row.put("READ_TIMEOUT", BasicUtil.evl((Object[])new Integer[]{this.READ_TIMEOUT, LdapConfig.DEFAULT_READ_TIMEOUT}));
        LdapConfig.register(row);
    }

    @Bean(value={"anyline.ldap.init.util"})
    public LdapUtil instance() {
        return LdapUtil.getInstance();
    }
}

