/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.ldap.util;

import java.util.Hashtable;
import org.anyline.entity.DataRow;
import org.anyline.ldap.util.LdapUtil;
import org.anyline.util.AnylineConfig;
import org.anyline.util.BasicUtil;
import org.anyline.util.ConfigTable;

public class LdapConfig
extends AnylineConfig {
    public static String CONFIG_NAME = "anyline-ldap.xml";
    private static Hashtable<String, AnylineConfig> instances = new Hashtable();
    public static String DEFAULT_ADDRESS;
    public static int DEFAULT_PORT;
    public static String DEFAULT_DOMAIN;
    public static String DEFAULT_ROOT;
    public static String DEFAULT_SECURITY_AUTHENTICATION;
    public static String DEFAULT_URL;
    public static int DEFAULT_CONNECT_TIMEOUT;
    public static int DEFAULT_READ_TIMEOUT;
    public String ADDRESS = DEFAULT_ADDRESS;
    public int PORT = DEFAULT_PORT;
    public String DOMAIN = DEFAULT_DOMAIN;
    public String ROOT = DEFAULT_ROOT;
    public String SECURITY_AUTHENTICATION = DEFAULT_SECURITY_AUTHENTICATION;
    public String URL = DEFAULT_URL;
    public int CONNECT_TIMEOUT = DEFAULT_CONNECT_TIMEOUT;
    public int READ_TIMEOUT = DEFAULT_READ_TIMEOUT;

    public static Hashtable<String, AnylineConfig> getInstances() {
        return instances;
    }

    public static void parse(String content) {
        LdapConfig.parse(LdapConfig.class, (String)content, instances, (String[])compatibles);
    }

    public static void init() {
        LdapConfig.load();
    }

    public static LdapConfig getInstance() {
        return LdapConfig.getInstance("default");
    }

    public static LdapConfig getInstance(String key) {
        if (BasicUtil.isEmpty((Object)key)) {
            key = "default";
        }
        if (ConfigTable.getReload() > 0 && (System.currentTimeMillis() - lastLoadTime) / 1000L > (long)ConfigTable.getReload()) {
            LdapConfig.load();
        }
        LdapConfig config = (LdapConfig)instances.get(key);
        if (null == config.URL) {
            config.URL = "ldap://" + config.ADDRESS + ":" + config.PORT;
        }
        return config;
    }

    private static synchronized void load() {
        LdapConfig.load(instances, LdapConfig.class, (String)CONFIG_NAME, (String[])new String[0]);
        lastLoadTime = System.currentTimeMillis();
    }

    private static void debug() {
    }

    public static LdapConfig register(String instance, DataRow row) {
        LdapConfig config = (LdapConfig)LdapConfig.parse(LdapConfig.class, (String)instance, (DataRow)row, instances, (String[])compatibles);
        LdapUtil.getInstance(instance);
        return config;
    }

    public static LdapConfig register(DataRow row) {
        return LdapConfig.register("default", row);
    }

    static {
        DEFAULT_PORT = 389;
        DEFAULT_CONNECT_TIMEOUT = 0;
        DEFAULT_READ_TIMEOUT = 0;
        LdapConfig.init();
        LdapConfig.debug();
    }
}

