/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.jdbc.config.db.impl.mysql;

import org.anyline.entity.PageNavi;
import org.anyline.jdbc.config.db.OrderStore;
import org.anyline.jdbc.config.db.SQLCreater;
import org.anyline.jdbc.config.db.impl.BasicSQLCreaterImpl;
import org.anyline.jdbc.config.db.run.RunSQL;
import org.springframework.stereotype.Repository;

@Repository(value="anyline.jdbc.creater.mysql")
public class SQLCreaterImpl
extends BasicSQLCreaterImpl
implements SQLCreater {
    public SQLCreater.DB_TYPE type() {
        return SQLCreater.DB_TYPE.MYSQL;
    }

    public SQLCreaterImpl() {
        this.delimiterFr = "`";
        this.delimiterTo = "`";
    }

    public String getDelimiterFr() {
        return this.delimiterFr;
    }

    public String getDelimiterTo() {
        return this.delimiterTo;
    }

    public String parseFinalQueryTxt(RunSQL run) {
        PageNavi navi;
        OrderStore orders;
        String sql = run.getBaseQueryTxt();
        String cols = run.getFetchColumns();
        if (!"*".equals(cols)) {
            String reg = "(?i)^select[\\s\\S]+from";
            sql = sql.replaceAll(reg, "SELECT " + cols + " FROM ");
        }
        if (null != (orders = run.getOrderStore())) {
            sql = sql + orders.getRunText(this.getDelimiterFr() + this.getDelimiterTo());
        }
        if (null != (navi = run.getPageNavi())) {
            int limit = navi.getLastRow() - navi.getFirstRow() + 1;
            if (limit < 0) {
                limit = 0;
            }
            sql = sql + " LIMIT " + navi.getFirstRow() + "," + limit;
        }
        sql = sql.replaceAll("WHERE\\s*1=1\\s*AND", "WHERE");
        return sql;
    }

    public String concat(String ... args) {
        String result = "";
        if (null != args && args.length > 0) {
            result = "concat(";
            int size = args.length;
            for (int i = 0; i < size; ++i) {
                String arg = args[i];
                if (i > 0) {
                    result = result + ",";
                }
                result = result + arg;
            }
            result = result + ")";
        }
        return result;
    }
}

