/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.util.img;

import com.sun.imageio.plugins.gif.GIFImageReader;
import com.sun.imageio.plugins.gif.GIFImageReaderSpi;
import com.sun.imageio.plugins.gif.GIFImageWriter;
import com.sun.imageio.plugins.gif.GIFImageWriterSpi;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.FileImageOutputStream;
import org.anyline.util.ConfigTable;
import org.anyline.util.NumberUtil;
import org.anyline.util.img.AnimatedGifEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GifUtil {
    private static Logger log = LoggerFactory.getLogger(GifUtil.class);

    public static List<File> split(File file, File dir) {
        ArrayList<File> files = new ArrayList<File>();
        FileImageInputStream in = null;
        FileImageOutputStream out = null;
        try {
            if (null != dir && !dir.exists()) {
                dir.mkdirs();
            }
            in = new FileImageInputStream(file);
            GIFImageReaderSpi readerSpi = new GIFImageReaderSpi();
            GIFImageReader gifReader = (GIFImageReader)readerSpi.createReaderInstance();
            gifReader.setInput(in);
            int size = gifReader.getNumImages(true);
            GIFImageWriterSpi writerSpi = new GIFImageWriterSpi();
            GIFImageWriter writer = (GIFImageWriter)writerSpi.createWriterInstance();
            for (int i = 0; i < size; ++i) {
                File target = new File(dir, file.getName().replace(".gif", "_" + i + ".jpg"));
                out = new FileImageOutputStream(target);
                writer.setOutput(out);
                writer.write(gifReader.read(i));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return files;
    }

    public static synchronized void create(int delay, String tar, String ... srcs) {
        ArrayList<File> list = new ArrayList<File>();
        for (String src : srcs) {
            list.add(new File(src));
        }
        GifUtil.create(delay, new File(tar), list);
    }

    public static synchronized void create(int delay, String tar, List<String> srcs) {
        ArrayList<File> list = new ArrayList<File>();
        for (String src : srcs) {
            list.add(new File(src));
        }
        GifUtil.create(delay, new File(tar), list);
    }

    public static synchronized void create(int delay, File tar, File ... srcs) {
        ArrayList<File> list = new ArrayList<File>();
        for (File src : srcs) {
            list.add(src);
        }
        GifUtil.create(delay, tar, list);
    }

    public static synchronized void create(int delay, File tar, List<File> srcs) {
        try {
            long fr = 0L;
            File dir = tar.getParentFile();
            if (null != dir && !dir.exists()) {
                dir.mkdirs();
            }
            AnimatedGifEncoder e = new AnimatedGifEncoder();
            e.setRepeat(0);
            e.start(tar.getAbsolutePath());
            int size = srcs.size();
            BufferedImage[] src = new BufferedImage[size];
            for (int i = 0; i < size; ++i) {
                File item = srcs.get(i);
                fr = System.currentTimeMillis();
                e.setDelay(delay);
                src[i] = ImageIO.read(item);
                e.addFrame(src[i]);
                if (!ConfigTable.isDebug() || !log.isWarnEnabled()) continue;
                log.warn("[\u5408\u6210 gif][\u7b2c{}/{}\u5e27][gif:{}][\u6e90\u6587\u4ef6:{}][\u8017\u65f6:{}]", new Object[]{i + 1, size, tar.getAbsolutePath(), item.getAbsoluteFile(), System.currentTimeMillis() - fr});
            }
            e.finish();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static synchronized void create(int min, int max, File tar, List<File> srcs) {
        try {
            long fr = 0L;
            File dir = tar.getParentFile();
            if (null != dir && !dir.exists()) {
                dir.mkdirs();
            }
            AnimatedGifEncoder e = new AnimatedGifEncoder();
            e.setRepeat(0);
            e.start(tar.getAbsolutePath());
            int size = srcs.size();
            BufferedImage[] src = new BufferedImage[size];
            for (int i = 0; i < size; ++i) {
                File item = srcs.get(i);
                fr = System.currentTimeMillis();
                int delay = NumberUtil.random((int)min, (int)max);
                e.setDelay(delay);
                src[i] = ImageIO.read(item);
                e.addFrame(src[i]);
                if (!ConfigTable.isDebug() || !log.isWarnEnabled()) continue;
                log.warn("[\u5408\u6210 gif][\u7b2c{}/{}\u5e27][gif:{}][\u6e90\u6587\u4ef6:{}][\u8017\u65f6:{}]", new Object[]{i + 1, size, tar.getAbsoluteFile(), item.getAbsoluteFile(), System.currentTimeMillis() - fr});
            }
            e.finish();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

