/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.util;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.anyline.util.DateUtil;
import org.anyline.util.ImgUtil;
import org.anyline.util.NumberUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatermarkUtil {
    protected static final Logger log = LoggerFactory.getLogger(WatermarkUtil.class);
    private int degree = 0;
    private Color color = Color.LIGHT_GRAY;
    private String fontName = "\u5b8b\u4f53";
    private int fontStyle = 3;
    private int fontSize = 30;
    private float alpha = 0.3f;
    private float x = 0.0f;
    private float y = 0.0f;

    public WatermarkUtil() {
        this.x = 0.0f;
        this.y = 0.0f;
    }

    public WatermarkUtil(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public WatermarkUtil(float x, float y) {
        this.x = x;
        this.y = y;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean markText(String text, File src, File target) {
        if (null == text || null == src || null == target || !src.exists()) {
            return false;
        }
        long fr = System.currentTimeMillis();
        File dir = target.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        InputStream is = null;
        OutputStream os = null;
        Image buffImg = null;
        try {
            BufferedImage srcImg = ImageIO.read(src);
            buffImg = new BufferedImage(((Image)srcImg).getWidth(null), ((Image)srcImg).getHeight(null), 1);
            int width = ((BufferedImage)buffImg).getWidth();
            int height = ((BufferedImage)buffImg).getHeight();
            Graphics2D g = ((BufferedImage)buffImg).createGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.drawImage(srcImg.getScaledInstance(((Image)srcImg).getWidth(null), ((Image)srcImg).getHeight(null), 4), 0, 0, null);
            if (this.degree != 0) {
                g.rotate(Math.toRadians(this.degree), (double)width / 2.0, (double)height / 2.0);
            }
            g.setColor(this.color);
            g.setFont(new Font(this.fontName, this.fontStyle, this.fontSize));
            g.setComposite(AlphaComposite.getInstance(10, this.alpha));
            int[] offset = this.finalOffset(width, height);
            g.drawString(text, offset[0], offset[1]);
            g.dispose();
            os = new FileOutputStream(target);
            String format = "jpg";
            if (target.getName().toLowerCase().endsWith("png")) {
                format = "png";
            }
            ImageIO.write((RenderedImage)((Object)buffImg), format, os);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != buffImg) {
                    buffImg.flush();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (null != is) {
                    is.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (null != os) {
                    os.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        log.warn("[\u6dfb\u52a0\u6c34\u5370][\u8017\u65f6:{}][text:{}][src:{}][target:{}]", new Object[]{DateUtil.conversion((long)(System.currentTimeMillis() - fr)), text, src.getAbsoluteFile(), target.getAbsoluteFile()});
        return true;
    }

    public void markText(String text, String src, String target) {
        this.markText(text, new File(src), new File(target));
    }

    public void markText(String text, File src) {
        this.markText(text, src, src);
    }

    public void markText(String text, String src) {
        this.markText(text, src, src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markIcon(File icon, int iconWidth, int iconHeight, File src, File target) {
        OutputStream os = null;
        Image buffImg = null;
        long fr = System.currentTimeMillis();
        int _x = 0;
        int _y = 0;
        try {
            BufferedImage srcImg = ImageIO.read(src);
            buffImg = new BufferedImage(((Image)srcImg).getWidth(null), ((Image)srcImg).getHeight(null), 1);
            int width = ((BufferedImage)buffImg).getWidth();
            int height = ((BufferedImage)buffImg).getHeight();
            int icon_width = iconWidth;
            int icon_height = iconHeight;
            Graphics2D g = ((BufferedImage)buffImg).createGraphics();
            buffImg = g.getDeviceConfiguration().createCompatibleImage(((Image)srcImg).getWidth(null), ((Image)srcImg).getHeight(null), 3);
            g = ((BufferedImage)buffImg).createGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.drawImage(srcImg.getScaledInstance(((Image)srcImg).getWidth(null), ((Image)srcImg).getHeight(null), 4), 0, 0, null);
            if (this.degree != 0) {
                g.rotate(Math.toRadians(this.degree), (double)width / 2.0, (double)height / 2.0);
            }
            ImageIcon imgIcon = new ImageIcon(icon.getAbsolutePath());
            Image img = imgIcon.getImage();
            float alpha = 0.5f;
            g.setComposite(AlphaComposite.getInstance(10, alpha));
            int[] offset = this.finalOffset(width, height);
            _x = offset[0] - icon_width;
            _y = offset[1] - icon_height;
            if (_x < 0) {
                _x = 0;
            }
            if (_y < 0) {
                _y = 0;
            }
            g.drawImage(img, _x, _y, icon_width, icon_height, null);
            g.setComposite(AlphaComposite.getInstance(3));
            g.dispose();
            os = new FileOutputStream(target);
            String format = "jpg";
            if (target.getName().toLowerCase().endsWith("png")) {
                format = "png";
            }
            if ("jpg".equals(format)) {
                BufferedImage tag = new BufferedImage(((BufferedImage)buffImg).getWidth(), ((BufferedImage)buffImg).getHeight(), 4);
                Graphics gg = tag.getGraphics();
                gg.drawImage(buffImg, 0, 0, null);
                gg.dispose();
                buffImg = tag;
            }
            ImageIO.write((RenderedImage)((Object)buffImg), format, os);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                buffImg.flush();
            }
            catch (Exception e) {}
            try {
                if (null != os) {
                    os.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        log.warn("[\u6dfb\u52a0\u6c34\u5370][\u8017\u65f6:{}][x:{}][y:{}][icon:{}][src:{}][target:{}]", new Object[]{DateUtil.conversion((long)(System.currentTimeMillis() - fr)), _x, _y, icon.getAbsoluteFile(), src.getAbsoluteFile(), target.getAbsoluteFile()});
    }

    public void markIcon(File icon, File src, File target) {
        int[] iconOffset = ImgUtil.size((File)icon);
        int icon_width = iconOffset[0];
        int icon_height = iconOffset[1];
        this.markIcon(icon, icon_width, icon_height, src, target);
    }

    private int[] finalOffset(int width, int height) {
        float x = this.x;
        float y = this.y;
        if (!NumberUtil.isInt((float)x)) {
            x = (float)width * x;
        }
        if (!NumberUtil.isInt((float)y)) {
            y = (float)height * y;
        }
        if (x < 0.0f) {
            x = (float)width + x;
        }
        if (y < 0.0f) {
            y = (float)height + y;
        }
        int[] result = new int[]{(int)x, (int)y};
        return result;
    }

    public void offset(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void offset(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void markIcon(String icon, String src, String target) {
        this.markIcon(new File(icon), new File(src), new File(target));
    }

    public void markIcon(File icon, File src) {
        this.markIcon(icon, src, src);
    }

    public void markIcon(String icon, String src) {
        this.markIcon(icon, src, src);
    }

    public Integer getDegree() {
        return this.degree;
    }

    public void setDegree(Integer degree) {
        this.degree = degree;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(int fontStyle) {
        this.fontStyle = fontStyle;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }
}

