/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.environment.spring.data.jdbc.runtime;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import javax.sql.DataSource;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.jdbc.runtime.JDBCRuntimeHolder;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.runtime.init.AbstractRuntime;
import org.anyline.data.util.DataSourceUtil;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceUtils;

public class SpringJDBCRuntime
extends AbstractRuntime
implements DataRuntime {
    protected JdbcTemplate processor;

    public SpringJDBCRuntime(String key, JdbcTemplate jdbc, DriverAdapter adapter) {
        this.setKey(key);
        this.setProcessor(jdbc);
        this.setAdapter(adapter);
    }

    public SpringJDBCRuntime() {
    }

    public JdbcTemplate jdbc() {
        return this.processor;
    }

    public DataSource getDataSource() {
        if (null != this.processor) {
            return this.processor.getDataSource();
        }
        return null;
    }

    public Object getProcessor() {
        return this.processor;
    }

    public void setProcessor(Object processor) {
        this.processor = (JdbcTemplate)processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public String getFeature(boolean connection) {
        if (null == this.feature) {
            if (connection || null == this.driver || null == this.url) {
                jdbc = this.jdbc();
                if (null != jdbc) {
                    datasource = null;
                    con = null;
                    try {
                        datasource = jdbc.getDataSource();
                        con = DataSourceUtils.getConnection((DataSource)datasource);
                        meta = con.getMetaData();
                        url = meta.getURL();
                        if (null == this.adapterKey) {
                            this.adapterKey = DataSourceUtil.parseAdapterKey((String)url);
                        }
                        this.feature = this.driver + "_" + meta.getDatabaseProductName().toLowerCase().replace(" ", "") + "_" + url;
                        if (null != this.version) ** GOTO lbl27
                        this.version = meta.getDatabaseProductVersion();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        if (null != con && !DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)datasource)) {
                            DataSourceUtils.releaseConnection((Connection)con, (DataSource)datasource);
                        }
                    }
                }
            } else {
                this.feature = this.driver + "_" + this.url;
            }
        }
lbl27:
        // 7 sources

        if (null == this.adapterKey) {
            this.adapterKey = DataSourceUtil.parseAdapterKey((String)this.feature);
        }
        return this.feature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVersion() {
        JdbcTemplate jdbc;
        if (null == this.version && null != (jdbc = this.jdbc())) {
            DataSource datasource = null;
            Connection con = null;
            try {
                datasource = jdbc.getDataSource();
                con = DataSourceUtils.getConnection((DataSource)datasource);
                DatabaseMetaData meta = con.getMetaData();
                this.version = meta.getDatabaseProductVersion();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (null != con && !DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)datasource)) {
                    DataSourceUtils.releaseConnection((Connection)con, (DataSource)datasource);
                }
            }
        }
        return this.version;
    }

    public boolean destroy() throws Exception {
        JDBCRuntimeHolder.instance().destroy(this.key);
        return true;
    }
}

