/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.environment.spring.data.transaction;

import javax.sql.DataSource;
import org.anyline.data.transaction.TransactionDefine;
import org.anyline.data.transaction.TransactionManage;
import org.anyline.data.transaction.TransactionState;
import org.anyline.data.transaction.init.DefaultTransactionManage;
import org.anyline.data.transaction.init.DefaultTransactionState;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class SpringTransactionManage
extends DefaultTransactionManage
implements TransactionManage {
    private final DataSourceTransactionManager manager;

    public SpringTransactionManage(DataSource datasource) {
        this.manager = new DataSourceTransactionManager();
        this.manager.setDataSource(datasource);
    }

    public SpringTransactionManage(DataSourceTransactionManager manager) {
        this.manager = manager;
    }

    public TransactionState start(TransactionDefine define) throws Exception {
        TransactionStatus status = this.manager.getTransaction(this.definition(define));
        TransactionState state = this.state(status);
        TransactionManage.records.put(state, this);
        return state;
    }

    public void commit(TransactionState state) {
        Object origin = state.getOrigin();
        this.manager.commit((TransactionStatus)origin);
        TransactionManage.records.remove(state);
    }

    public void rollback(TransactionState state) {
        Object origin = state.getOrigin();
        this.manager.rollback((TransactionStatus)origin);
        TransactionManage.records.remove(state);
    }

    private TransactionDefinition definition(TransactionDefine define) {
        DefaultTransactionDefinition definition = new DefaultTransactionDefinition();
        definition.setPropagationBehavior(define.getPropagationBehavior());
        String behaviorName = define.getPropagationBehaviorName();
        if (null != behaviorName) {
            definition.setPropagationBehaviorName(behaviorName);
        }
        definition.setIsolationLevel(define.getIsolationLevel());
        definition.setName(define.getName());
        definition.setTimeout(define.getTimeout());
        definition.setReadOnly(define.isReadOnly());
        return definition;
    }

    private TransactionState state(TransactionStatus status) {
        DefaultTransactionState state = new DefaultTransactionState();
        state.setOrigin((Object)status);
        return state;
    }
}

