/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.environment.spring.data.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.anyline.adapter.EntityAdapter;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.adapter.DriverWorker;
import org.anyline.data.handler.ConnectionHandler;
import org.anyline.data.handler.DataHandler;
import org.anyline.data.handler.ResultSetHandler;
import org.anyline.data.handler.StreamHandler;
import org.anyline.data.jdbc.adapter.JDBCAdapter;
import org.anyline.data.jdbc.handler.SimpleConnectionHandler;
import org.anyline.data.jdbc.util.JDBCUtil;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.run.Run;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.PageNavi;
import org.anyline.environment.spring.data.jdbc.SpringJDBCUtil;
import org.anyline.metadata.ACTION;
import org.anyline.metadata.BaseMetadata;
import org.anyline.metadata.Catalog;
import org.anyline.metadata.Column;
import org.anyline.metadata.Index;
import org.anyline.metadata.Parameter;
import org.anyline.metadata.Procedure;
import org.anyline.metadata.Schema;
import org.anyline.metadata.Table;
import org.anyline.metadata.View;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ConfigTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.CallableStatementCallback;
import org.springframework.jdbc.core.CallableStatementCreator;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Component;

@Component(value="anyline.environment.spring.data.driver.worker.jdbc")
public class SpringJDBCWorker
implements DriverWorker {
    private Logger log = LoggerFactory.getLogger(SpringJDBCWorker.class);

    public Class<? extends DriverAdapter> supportAdapterType() {
        return JDBCAdapter.class;
    }

    public DataSource getDataSource(DriverAdapter adapter, DataRuntime runtime) {
        JdbcTemplate jdbc = this.jdbc(runtime);
        if (null == jdbc) {
            return null;
        }
        return jdbc.getDataSource();
    }

    public Connection getConnection(DriverAdapter adapter, DataRuntime runtime, DataSource datasource) {
        return DataSourceUtils.getConnection((DataSource)datasource);
    }

    public void releaseConnection(DriverAdapter adapter, DataRuntime runtime, Connection connection, DataSource datasource) {
        if (null != connection && !DataSourceUtils.isConnectionTransactional((Connection)connection, (DataSource)datasource)) {
            DataSourceUtils.releaseConnection((Connection)connection, (DataSource)datasource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T extends BaseMetadata> void checkSchema(DriverAdapter adapter, DataRuntime runtime, DataSource ds, T meta) {
        String schema;
        if (null == meta || null != meta.getCheckSchemaTime()) {
            return;
        }
        String catalog = meta.getCatalogName();
        if (null == catalog) {
            catalog = runtime.getCatalog();
        }
        if (null == (schema = meta.getSchemaName())) {
            schema = runtime.getSchema();
        }
        if (null == catalog && null == schema) {
            Connection con = null;
            try {
                if (!adapter.empty((BaseMetadata)meta.getCatalog()) && !adapter.empty((BaseMetadata)meta.getSchema())) return;
                con = DataSourceUtils.getConnection((DataSource)ds);
                this.checkSchema(adapter, runtime, con, meta);
                return;
            }
            catch (Exception e) {
                this.log.warn("[check schema][fail:{}]", (Object)e.toString());
                return;
            }
            finally {
                if (null != con && !DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                    DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
                }
            }
        } else {
            meta.setCatalog(catalog);
            meta.setSchema(schema);
        }
    }

    public <T extends BaseMetadata> void checkSchema(DriverAdapter adapter, DataRuntime runtime, T meta) {
        if (null != meta) {
            String schema;
            String catalog = meta.getCatalogName();
            if (null == catalog) {
                catalog = runtime.getCatalog();
            }
            if (null == (schema = meta.getSchemaName())) {
                schema = runtime.getSchema();
            }
            if (null == catalog && null == schema) {
                JdbcTemplate jdbc = this.jdbc(runtime);
                if (null == jdbc) {
                    return;
                }
                this.checkSchema(adapter, runtime, jdbc.getDataSource(), meta);
            } else {
                meta.setCatalog(catalog);
                meta.setSchema(schema);
            }
        }
    }

    public <T extends BaseMetadata> void checkSchema(DriverAdapter adapter, DataRuntime runtime, Connection con, T meta) {
        String schema;
        if (null == meta) {
            return;
        }
        String catalog = meta.getCatalogName();
        if (null == catalog) {
            catalog = runtime.getCatalog();
        }
        if (null == (schema = meta.getSchemaName())) {
            schema = runtime.getSchema();
        }
        if (null == catalog && null == schema) {
            try {
                if (adapter.empty((BaseMetadata)meta.getCatalog())) {
                    catalog = con.getCatalog();
                }
            }
            catch (Exception e) {
                this.log.warn("[check catalog][result:fail][exception:{}]", (Object)e.toString());
            }
            try {
                if (adapter.empty((BaseMetadata)meta.getSchema())) {
                    schema = con.getSchema();
                }
            }
            catch (Exception e) {
                this.log.warn("[check schema][result:fail][exception:{}]", (Object)e.toString());
            }
            adapter.correctSchemaFromJDBC(runtime, meta, catalog, schema, true, true);
            meta.setCheckSchemaTime(new Date());
        } else {
            meta.setCatalog(catalog);
            meta.setSchema(schema);
        }
    }

    private JdbcTemplate jdbc(DataRuntime runtime) {
        return (JdbcTemplate)runtime.getProcessor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet select(final DriverAdapter adapter, DataRuntime runtime, String random, final boolean system, ACTION.DML action, Table table, final ConfigStore configs, Run run, String sql, List<Object> values, LinkedHashMap<String, Column> columns) throws Exception {
        DataHandler handler;
        final DataSet set = new DataSet();
        long fr = System.currentTimeMillis();
        final DataRuntime rt = runtime;
        final long[] mid = new long[]{System.currentTimeMillis()};
        final boolean[] process = new boolean[]{false};
        final LinkedHashMap<String, Column> metadatas = new LinkedHashMap<String, Column>();
        if (null != columns) {
            metadatas.putAll(columns);
        }
        set.setMetadata(metadatas);
        JdbcTemplate jdbc = this.jdbc(runtime);
        if (null == jdbc) {
            return set;
        }
        DataHandler _handler = null;
        if (null != configs && (handler = configs.handler()) instanceof StreamHandler) {
            _handler = (StreamHandler)handler;
        }
        handler = _handler;
        long[] count = new long[]{0L};
        if (null != handler) {
            DataSource datasource = null;
            Connection con = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            boolean keep = handler.keep();
            try {
                datasource = jdbc.getDataSource();
                con = DataSourceUtils.getConnection((DataSource)datasource);
                ps = con.prepareStatement(sql, 1003, 1007);
                ps.setFetchSize(handler.size());
                ps.setFetchDirection(1000);
                JDBCUtil.queryTimeout((Statement)ps, (ConfigStore)configs);
                if (null != values && !values.isEmpty()) {
                    int idx = 0;
                    for (Object value : values) {
                        ps.setObject(++idx, value);
                    }
                }
                rs = ps.executeQuery();
                if (keep && handler instanceof ResultSetHandler) {
                    SimpleConnectionHandler ch = new SimpleConnectionHandler(datasource, con, (Statement)ps, rs);
                    ch.setWorker((DriverWorker)this);
                    handler.handler((ConnectionHandler)ch);
                    ((ResultSetHandler)handler).read(rs);
                }
                while (rs.next()) {
                    count[0] = count[0] + 1L;
                    boolean next = JDBCUtil.stream((DriverAdapter)adapter, (StreamHandler)handler, (ResultSet)rs, (ConfigStore)configs, (boolean)true, (DataRuntime)runtime, null);
                    if (next) continue;
                }
            }
            finally {
                if (!keep) {
                    if (null != rs && !rs.isClosed()) {
                        rs.close();
                    }
                    this.releaseConnection(adapter, runtime, con, datasource);
                }
            }
        } else {
            fr = System.currentTimeMillis();
            if (null != values && values.size() > 0) {
                jdbc.query(sql, values.toArray(), new RowCallbackHandler(){

                    public void processRow(ResultSet rs) throws SQLException {
                        if (!process[0]) {
                            mid[0] = System.currentTimeMillis();
                            process[0] = true;
                        }
                        DataRow row = JDBCUtil.row((DriverAdapter)adapter, (boolean)system, (DataRuntime)rt, (LinkedHashMap)metadatas, (ConfigStore)configs, (ResultSet)rs);
                        set.add(row);
                    }
                });
            } else {
                jdbc.query(sql, new RowCallbackHandler(){

                    public void processRow(ResultSet rs) throws SQLException {
                        if (!process[0]) {
                            mid[0] = System.currentTimeMillis();
                            process[0] = true;
                        }
                        DataRow row = JDBCUtil.row((DriverAdapter)adapter, (boolean)system, (DataRuntime)rt, (LinkedHashMap)metadatas, (ConfigStore)configs, (ResultSet)rs);
                        set.add(row);
                    }
                });
            }
            count[0] = set.size();
        }
        if (!process[0]) {
            mid[0] = System.currentTimeMillis();
        }
        configs.setLastPackageTime(System.currentTimeMillis() - mid[0]);
        configs.setLastExecuteTime(mid[0] - fr);
        return set;
    }

    public DataSet querys(DriverAdapter adapter, DataRuntime runtime, String random, final Procedure procedure, final PageNavi navi) throws Exception {
        final List inputs = procedure.getInputs();
        final List outputs = procedure.getOutputs();
        final String rdm = random;
        final DataRuntime rt = runtime;
        JdbcTemplate jdbc = this.jdbc(runtime);
        if (null == jdbc) {
            return new DataSet();
        }
        DataSet set = (DataSet)jdbc.execute(new CallableStatementCreator(){

            public CallableStatement createCallableStatement(Connection conn) throws SQLException {
                Parameter param;
                int i;
                String sql = "{call " + procedure.getName() + "(";
                int sizeIn = inputs.size();
                int sizeOut = outputs.size();
                int size = sizeIn + sizeOut;
                for (int i2 = 0; i2 < size; ++i2) {
                    sql = sql + "?";
                    if (i2 >= size - 1) continue;
                    sql = sql + ",";
                }
                sql = sql + ")}";
                CallableStatement cs = conn.prepareCall(sql);
                for (i = 1; i <= sizeIn; ++i) {
                    param = (Parameter)inputs.get(i - 1);
                    Object value = param.getValue();
                    if (null == value || "NULL".equalsIgnoreCase(value.toString())) {
                        value = null;
                    }
                    cs.setObject(i, value, (int)param.getType());
                }
                for (i = 1; i <= sizeOut; ++i) {
                    param = (Parameter)outputs.get(i - 1);
                    if (null == param.getValue()) {
                        cs.registerOutParameter(i + sizeIn, (int)param.getType());
                        continue;
                    }
                    cs.setObject(i, param.getValue(), (int)param.getType());
                }
                JDBCUtil.queryTimeout((Statement)cs, null);
                return cs;
            }
        }, (CallableStatementCallback)new CallableStatementCallback<Object>(){

            public Object doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
                ResultSet rs = cs.executeQuery();
                DataSet set = new DataSet();
                ResultSetMetaData rsmd = rs.getMetaData();
                int cols = rsmd.getColumnCount();
                for (int i = 1; i <= cols; ++i) {
                    String name = rsmd.getColumnLabel(i);
                    if (null == name) {
                        name = rsmd.getColumnName(i);
                    }
                    set.addHead(name);
                }
                long mid = System.currentTimeMillis();
                int index = 0;
                long first = -1L;
                long last = -1L;
                if (null != navi) {
                    first = navi.getFirstRow();
                    last = navi.getLastRow();
                }
                while (rs.next()) {
                    if (first == -1L || (long)index >= first && (long)index <= last) {
                        DataRow row = new DataRow();
                        for (int i = 1; i <= cols; ++i) {
                            row.put(false, rsmd.getColumnLabel(i), rs.getObject(i));
                        }
                        set.addRow(row);
                    }
                    if (first == -1L || (long)(++index) <= last && (first != 0L || last != 0L)) continue;
                }
                if (null != navi) {
                    navi.setTotalRow((long)index);
                    set.setNavi(navi);
                    navi.setDataSize(set.size());
                }
                set.setDatalink(rt.datasource());
                if (ConfigTable.IS_LOG_SQL_TIME && SpringJDBCWorker.this.log.isInfoEnabled()) {
                    SpringJDBCWorker.this.log.info("{}[\u5c01\u88c5\u8017\u65f6:{}ms][\u5c01\u88c5\u884c\u6570:{}]", new Object[]{rdm, System.currentTimeMillis() - mid, set.size()});
                }
                return set;
            }
        });
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> maps(DriverAdapter adapter, DataRuntime runtime, String random, ConfigStore configs, Run run) throws Exception {
        DataHandler handler;
        List maps = null;
        String sql = run.getFinalQuery();
        List values = run.getValues();
        JdbcTemplate jdbc = this.jdbc(runtime);
        if (null == jdbc) {
            return new ArrayList<Map<String, Object>>();
        }
        StreamHandler _handler = null;
        if (null != configs && (handler = configs.handler()) instanceof StreamHandler) {
            _handler = (StreamHandler)handler;
        }
        long[] count = new long[]{0L};
        boolean[] process = new boolean[]{false};
        StreamHandler handler2 = _handler;
        long fr = System.currentTimeMillis();
        long[] mid = new long[]{System.currentTimeMillis()};
        if (null != handler2) {
            block17: {
                DataSource datasource = null;
                Connection con = null;
                PreparedStatement ps = null;
                ResultSet rs = null;
                boolean keep = handler2.keep();
                try {
                    datasource = jdbc.getDataSource();
                    con = DataSourceUtils.getConnection((DataSource)datasource);
                    ps = con.prepareStatement(sql, 1003, 1007);
                    ps.setFetchSize(handler2.size());
                    ps.setFetchDirection(1000);
                    JDBCUtil.queryTimeout((Statement)ps, (ConfigStore)configs);
                    if (null != values && !values.isEmpty()) {
                        int idx = 0;
                        for (Object value : values) {
                            ps.setObject(++idx, value);
                        }
                    }
                    rs = ps.executeQuery();
                    if (keep && handler2 instanceof ResultSetHandler) {
                        SimpleConnectionHandler ch = new SimpleConnectionHandler(datasource, con, (Statement)ps, rs);
                        ch.setWorker((DriverWorker)this);
                        handler2.handler((ConnectionHandler)ch);
                        ((ResultSetHandler)handler2).read(rs);
                        break block17;
                    }
                    while (rs.next()) {
                        count[0] = count[0] + 1L;
                        boolean next = JDBCUtil.stream((DriverAdapter)adapter, (StreamHandler)handler2, (ResultSet)rs, (ConfigStore)configs, (boolean)true, (DataRuntime)runtime, null);
                        if (next) continue;
                        break;
                    }
                }
                finally {
                    if (!keep) {
                        if (null != rs && !rs.isClosed()) {
                            rs.close();
                        }
                        this.releaseConnection(adapter, runtime, con, datasource);
                    }
                }
            }
            maps = new ArrayList();
        } else {
            maps = null != values && !values.isEmpty() ? jdbc.queryForList(sql, values.toArray()) : jdbc.queryForList(sql);
            mid[0] = System.currentTimeMillis();
            count[0] = maps.size();
        }
        boolean slow = false;
        if (ConfigStore.SLOW_SQL_MILLIS((ConfigStore)configs) > 0L && mid[0] - fr > ConfigStore.SLOW_SQL_MILLIS((ConfigStore)configs)) {
            slow = true;
            this.log.warn("{}[slow cmd][action:select][\u6267\u884c\u8017\u65f6:{}ms]{}", new Object[]{random, mid[0] - fr, run.log(ACTION.DML.SELECT, ConfigStore.IS_SQL_LOG_PLACEHOLDER((ConfigStore)configs))});
            if (null != adapter.getDMListener()) {
                adapter.getDMListener().slow(runtime, random, ACTION.DML.SELECT, null, sql, values, null, true, maps, mid[0] - fr);
            }
        }
        if (!slow && this.log.isInfoEnabled() && ConfigStore.IS_LOG_SQL_TIME((ConfigStore)configs)) {
            this.log.info("{}[action:select][\u6267\u884c\u8017\u65f6:{}ms]", (Object)random, (Object)(mid[0] - fr));
        }
        if (!slow && this.log.isInfoEnabled() && ConfigStore.IS_LOG_SQL_TIME((ConfigStore)configs)) {
            this.log.info("{}[action:select][\u5c01\u88c5\u8017\u65f6:{}ms][\u5c01\u88c5\u884c\u6570:{}]", new Object[]{random, System.currentTimeMillis() - mid[0], count[0]});
        }
        return maps;
    }

    public Map<String, Object> map(DriverAdapter adapter, DataRuntime runtime, String random, ConfigStore configs, Run run) throws Exception {
        Map map = null;
        String sql = run.getFinalExists();
        List values = run.getValues();
        JdbcTemplate jdbc = this.jdbc(runtime);
        if (null == jdbc) {
            return new HashMap<String, Object>();
        }
        map = null != values && !values.isEmpty() ? jdbc.queryForMap(sql, values.toArray()) : jdbc.queryForMap(sql);
        return map;
    }

    public long insert(DriverAdapter adapter, DataRuntime runtime, String random, Object data, final ConfigStore configs, Run run, String generatedKey, final String[] pks) throws Exception {
        long cnt = -1L;
        GeneratedKeyHolder keyholder = null;
        JdbcTemplate jdbc = this.jdbc(runtime);
        if (null == jdbc) {
            return -1L;
        }
        final String cmd = run.getFinalInsert();
        int batch = run.getBatch();
        final List values = run.getValues();
        if (batch > 1) {
            cnt = this.batch(jdbc, cmd, batch, run.getVol(), values);
        } else if (adapter.supportKeyHolder(runtime, configs)) {
            keyholder = new GeneratedKeyHolder();
            cnt = jdbc.update(new PreparedStatementCreator(){

                public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                    PreparedStatement ps = null;
                    ps = null != pks && pks.length > 0 ? con.prepareStatement(cmd, pks) : con.prepareStatement(cmd, 1);
                    int idx = 0;
                    if (null != values) {
                        for (Object obj : values) {
                            ps.setObject(++idx, obj);
                        }
                    }
                    JDBCUtil.updateTimeout((Statement)ps, (ConfigStore)configs);
                    return ps;
                }
            }, (KeyHolder)keyholder);
        } else {
            cnt = null != values && !values.isEmpty() ? (long)jdbc.update(cmd, values.toArray()) : (long)jdbc.update(cmd);
        }
        this.identity(adapter, runtime, random, data, configs, (KeyHolder)keyholder, generatedKey);
        return cnt;
    }

    public boolean identity(DriverAdapter adapter, DataRuntime runtime, String random, Object data, ConfigStore configs, KeyHolder keyholder, String generatedKey) {
        block18: {
            try {
                if (null == keyholder) {
                    return false;
                }
                if (!adapter.supportKeyHolder(runtime, configs)) {
                    return false;
                }
                List keys = keyholder.getKeyList();
                if (null == generatedKey && keys.size() > 0) {
                    Map key = (Map)keys.get(0);
                    generatedKey = (String)key.keySet().iterator().next();
                }
                if (data instanceof Collection) {
                    Long num;
                    Object last;
                    Object item;
                    ArrayList ids = new ArrayList();
                    Collection list = (Collection)data;
                    Iterator iterator = list.iterator();
                    if (iterator.hasNext() && BasicUtil.isNotEmpty((boolean)true, (Object)EntityAdapter.getPrimaryValue(item = iterator.next()))) {
                        return true;
                    }
                    if (BasicUtil.isEmpty((Object)generatedKey)) {
                        return false;
                    }
                    int i = 0;
                    int data_size = list.size();
                    if (list.size() == keys.size()) {
                        for (Object item2 : list) {
                            Map key = (Map)keys.get(i);
                            Object id = key.get(generatedKey);
                            ids.add(id);
                            EntityAdapter.setPrimaryValue(item2, id);
                            ++i;
                        }
                    } else if (null != keys && !keys.isEmpty() && (last = ((Map)keys.get(0)).get(generatedKey)) instanceof Number && null != (num = BasicUtil.parseLong((Object)last.toString(), null))) {
                        num = num - (long)data_size + 1L;
                        for (Object item3 : list) {
                            Long l = num;
                            Long l2 = num = Long.valueOf(num + 1L);
                            EntityAdapter.setPrimaryValue(item3, (Object)l);
                        }
                    }
                    if (ConfigStore.IS_LOG_SQL((ConfigStore)configs) && this.log.isWarnEnabled()) {
                        this.log.info("{}[exe insert][\u751f\u6210\u4e3b\u952e:{}]", (Object)random, ids);
                    }
                    break block18;
                }
                if (null != keys && !keys.isEmpty() && BasicUtil.isEmpty((boolean)true, (Object)EntityAdapter.getPrimaryValue((Object)data))) {
                    Object id = ((Map)keys.get(0)).get(generatedKey);
                    EntityAdapter.setPrimaryValue((Object)data, id);
                    if (ConfigStore.IS_LOG_SQL((ConfigStore)configs) && this.log.isWarnEnabled()) {
                        this.log.info("{}[exe insert][\u751f\u6210\u4e3b\u952e:{}]", (Object)random, id);
                    }
                }
            }
            catch (Exception e) {
                if (ConfigStore.IS_PRINT_EXCEPTION_STACK_TRACE((ConfigStore)configs)) {
                    e.printStackTrace();
                }
                if (ConfigStore.IS_LOG_SQL_WHEN_ERROR((ConfigStore)configs)) {
                    this.log.warn("{}[exe insert][\u8fd4\u56de\u4e3b\u952e\u5931\u8d25]", (Object)random);
                }
                return false;
            }
        }
        return true;
    }

    public long batch(JdbcTemplate jdbc, String sql, int batch, final int vol, final List<Object> values) {
        int size;
        int line = size = values.size();
        if (vol > 0) {
            line = size / vol;
        }
        if (null == jdbc) {
            return line;
        }
        final int _line = line;
        jdbc.batchUpdate(sql, new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                for (int p = 1; p <= vol; ++p) {
                    ps.setObject(p, values.get(vol * i + p - 1));
                }
            }

            public int getBatchSize() {
                return _line;
            }
        });
        return line;
    }

    public long update(DriverAdapter adapter, DataRuntime runtime, String random, Table dest, Object data, ConfigStore configs, Run run) throws Exception {
        Object[] vals;
        long result = 0L;
        String cmd = run.getFinalUpdate();
        List values = run.getValues();
        int batch = run.getBatch();
        JdbcTemplate jdbc = this.jdbc(runtime);
        if (null == jdbc) {
            return -1L;
        }
        result = batch > 1 ? this.batch(jdbc, cmd, batch, run.getVol(), values) : ((vals = values.toArray()).length > 0 ? (long)jdbc.update(cmd, vals) : (long)jdbc.update(cmd));
        return result;
    }

    public List<Object> execute(DriverAdapter adapter, DataRuntime runtime, String random, final Procedure procedure, String sql, final List<Parameter> inputs, final List<Parameter> outputs) throws Exception {
        List<Object> list = new ArrayList<Object>();
        JdbcTemplate jdbc = this.jdbc(runtime);
        if (null == jdbc) {
            return list;
        }
        final int sizeIn = inputs.size();
        final int sizeOut = outputs.size();
        int size = sizeIn + sizeOut;
        list = (List)jdbc.execute(sql, (CallableStatementCallback)new CallableStatementCallback<Object>(){

            public Object doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
                Parameter param;
                int i;
                ArrayList<Object> result = new ArrayList<Object>();
                int returnIndex = 0;
                if (procedure.hasReturn()) {
                    returnIndex = 1;
                    cs.registerOutParameter(1, 12);
                }
                for (i = 1; i <= sizeIn; ++i) {
                    param = (Parameter)inputs.get(i - 1);
                    Object value = param.getValue();
                    if (null == value || "NULL".equalsIgnoreCase(value.toString())) {
                        value = null;
                    }
                    cs.setObject(i + returnIndex, value, (int)param.getType());
                }
                for (i = 1; i <= sizeOut; ++i) {
                    param = (Parameter)outputs.get(i - 1);
                    if (null == param.getValue()) {
                        cs.registerOutParameter(i + sizeIn + returnIndex, (int)param.getType());
                        continue;
                    }
                    cs.setObject(i + sizeIn + returnIndex, param.getValue(), (int)param.getType());
                }
                cs.execute();
                if (procedure.hasReturn()) {
                    result.add(cs.getObject(1));
                }
                if (sizeOut > 0) {
                    for (i = 1; i <= sizeOut; ++i) {
                        Object output = cs.getObject(sizeIn + returnIndex + i);
                        result.add(output);
                    }
                }
                return result;
            }
        });
        return list;
    }

    public long execute(DriverAdapter adapter, DataRuntime runtime, String random, ConfigStore configs, Run run) throws Exception {
        long result = -1L;
        JdbcTemplate jdbc = this.jdbc(runtime);
        if (null == jdbc) {
            return result;
        }
        int batch = run.getBatch();
        String sql = run.getFinalExecute();
        List values = run.getValues();
        result = batch > 1 ? this.batch(jdbc, sql, batch, run.getVol(), values) : (null != values && !values.isEmpty() ? (long)jdbc.update(sql, values.toArray()) : (long)jdbc.update(sql));
        return result;
    }

    public LinkedHashMap<String, Column> metadata(DriverAdapter adapter, DataRuntime runtime, String random, Run run, boolean comment) {
        LinkedHashMap columns = null;
        JdbcTemplate jdbc = this.jdbc(runtime);
        String sql = run.getFinalQuery(false);
        if (ConfigTable.IS_LOG_SQL && this.log.isInfoEnabled()) {
            this.log.info("{}[action:metadata][cmd:\n{}\n]", (Object)random, (Object)sql);
        }
        if (null == jdbc) {
            return new LinkedHashMap<String, Column>();
        }
        SqlRowSet rs = jdbc.queryForRowSet(sql);
        try {
            columns = SpringJDBCUtil.columns(adapter, runtime, true, null, null, rs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String product(DriverAdapter adapter, DataRuntime runtime, boolean create, String product) {
        JdbcTemplate jdbc;
        Connection con;
        DataSource datasource;
        block5: {
            datasource = null;
            con = null;
            jdbc = this.jdbc(runtime);
            if (null != jdbc) break block5;
            String string = null;
            if (null == con || DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)datasource)) return string;
            DataSourceUtils.releaseConnection((Connection)con, (DataSource)datasource);
            return string;
        }
        try {
            datasource = jdbc.getDataSource();
            con = DataSourceUtils.getConnection((DataSource)datasource);
            product = con.getMetaData().getDatabaseProductName();
        }
        catch (Exception e) {
            try {
                this.log.warn("[check product][fail:{}]", (Object)e.toString());
            }
            catch (Throwable throwable) {
                if (null == con || DataSourceUtils.isConnectionTransactional(con, datasource)) throw throwable;
                DataSourceUtils.releaseConnection(con, (DataSource)datasource);
                throw throwable;
            }
            if (null == con || DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)datasource)) return product;
            DataSourceUtils.releaseConnection((Connection)con, (DataSource)datasource);
            return product;
        }
        if (null == con || DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)datasource)) return product;
        DataSourceUtils.releaseConnection((Connection)con, (DataSource)datasource);
        return product;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String version(DriverAdapter adapter, DataRuntime runtime, boolean create, String version) {
        JdbcTemplate jdbc;
        DataSource ds;
        Connection con;
        block5: {
            con = null;
            ds = null;
            jdbc = this.jdbc(runtime);
            if (null != jdbc) break block5;
            String string = null;
            if (null == con || DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) return string;
            DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            return string;
        }
        try {
            ds = jdbc.getDataSource();
            con = DataSourceUtils.getConnection((DataSource)ds);
            version = con.getMetaData().getDatabaseProductVersion();
        }
        catch (Exception e) {
            try {
                this.log.warn("[check version][fail:{}]", (Object)e.toString());
            }
            catch (Throwable throwable) {
                if (null == con || DataSourceUtils.isConnectionTransactional(con, ds)) throw throwable;
                DataSourceUtils.releaseConnection(con, (DataSource)ds);
                throw throwable;
            }
            if (null == con || DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) return version;
            DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            return version;
        }
        if (null == con || DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) return version;
        DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Table> LinkedHashMap<String, T> tables(DriverAdapter adapter, DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, Catalog catalog, Schema schema, String pattern, int types) throws Exception {
        JdbcTemplate jdbc;
        Connection con;
        DataSource ds;
        block8: {
            LinkedHashMap linkedHashMap;
            ds = null;
            con = null;
            try {
                jdbc = this.jdbc(runtime);
                if (null != jdbc) break block8;
                linkedHashMap = new LinkedHashMap();
            }
            catch (Throwable throwable) {
                if (null != con && !DataSourceUtils.isConnectionTransactional(con, ds)) {
                    DataSourceUtils.releaseConnection(con, (DataSource)ds);
                }
                throw throwable;
            }
            if (null != con && !DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
            return linkedHashMap;
        }
        ds = jdbc.getDataSource();
        con = DataSourceUtils.getConnection((DataSource)ds);
        DatabaseMetaData dbmd = con.getMetaData();
        String catalogName = null;
        String schemaName = null;
        if (null != catalog) {
            catalogName = catalog.getName();
        }
        if (null != schema) {
            schemaName = schema.getName();
        }
        String[] tmp = adapter.correctSchemaFromJDBC(catalogName, schemaName);
        String[] tps = (String[])BeanUtil.list2array((List)adapter.names(Table.types((int)types)));
        ResultSet set = dbmd.getTables(tmp[0], tmp[1], pattern, tps);
        tables = JDBCUtil.tables((DriverAdapter)adapter, (DataRuntime)runtime, (boolean)create, tables, (ResultSet)set);
        if (null != con && !DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
            DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
        }
        return tables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Table> List<T> tables(DriverAdapter adapter, DataRuntime runtime, boolean create, List<T> tables, Catalog catalog, Schema schema, String pattern, int types) throws Exception {
        JdbcTemplate jdbc;
        Connection con;
        DataSource ds;
        block8: {
            ArrayList arrayList;
            ds = null;
            con = null;
            try {
                jdbc = this.jdbc(runtime);
                if (null != jdbc) break block8;
                arrayList = new ArrayList();
            }
            catch (Throwable throwable) {
                if (null != con && !DataSourceUtils.isConnectionTransactional(con, ds)) {
                    DataSourceUtils.releaseConnection(con, (DataSource)ds);
                }
                throw throwable;
            }
            if (null != con && !DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
            return arrayList;
        }
        ds = jdbc.getDataSource();
        con = DataSourceUtils.getConnection((DataSource)ds);
        DatabaseMetaData dbmd = con.getMetaData();
        String catalogName = null;
        String schemaName = null;
        if (null != catalog) {
            catalogName = catalog.getName();
        }
        if (null != schema) {
            schemaName = schema.getName();
        }
        String[] tmp = adapter.correctSchemaFromJDBC(catalogName, schemaName);
        String[] tps = (String[])BeanUtil.list2array((List)adapter.names(Table.types((int)types)));
        ResultSet set = dbmd.getTables(tmp[0], tmp[1], pattern, tps);
        tables = JDBCUtil.tables((DriverAdapter)adapter, (DataRuntime)runtime, (boolean)create, tables, (ResultSet)set);
        if (null != con && !DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
            DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
        }
        return tables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends View> LinkedHashMap<String, T> views(DriverAdapter adapter, DataRuntime runtime, boolean create, LinkedHashMap<String, T> views, Catalog catalog, Schema schema, String pattern, int types) throws Exception {
        JdbcTemplate jdbc;
        Connection con;
        DataSource ds;
        block8: {
            LinkedHashMap linkedHashMap;
            ds = null;
            con = null;
            try {
                jdbc = this.jdbc(runtime);
                if (null != jdbc) break block8;
                linkedHashMap = new LinkedHashMap();
            }
            catch (Throwable throwable) {
                if (null != con && !DataSourceUtils.isConnectionTransactional(con, ds)) {
                    DataSourceUtils.releaseConnection(con, (DataSource)ds);
                }
                throw throwable;
            }
            if (null != con && !DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
            return linkedHashMap;
        }
        ds = jdbc.getDataSource();
        con = DataSourceUtils.getConnection((DataSource)ds);
        DatabaseMetaData dbmd = con.getMetaData();
        String catalogName = null;
        String schemaName = null;
        if (null != catalog) {
            catalogName = catalog.getName();
        }
        if (null != schema) {
            schemaName = schema.getName();
        }
        String[] tmp = adapter.correctSchemaFromJDBC(catalogName, schemaName);
        ResultSet set = dbmd.getTables(tmp[0], tmp[1], pattern, new String[]{"VIEW"});
        views = JDBCUtil.views((DriverAdapter)adapter, (DataRuntime)runtime, (boolean)create, views, (ResultSet)set);
        if (null != con && !DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
            DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
        }
        return views;
    }

    public <T extends Table> List<T> views(DriverAdapter adapter, DataRuntime runtime, boolean create, List<T> views, Catalog catalog, Schema schema, String pattern, int types) throws Exception {
        return views;
    }

    public <T extends Column> LinkedHashMap<String, T> columns(DriverAdapter adapter, DataRuntime runtime, boolean create, LinkedHashMap<String, T> columns, Table table, String sql) throws Exception {
        SqlRowSet set = this.jdbc(runtime).queryForRowSet(sql);
        columns = SpringJDBCUtil.columns(adapter, runtime, true, columns, table, set);
        return columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Column> LinkedHashMap<String, T> metadata(DriverAdapter adapter, DataRuntime runtime, boolean create, LinkedHashMap<String, T> columns, Table table, String pattern) throws Exception {
        DataSource ds = null;
        Connection con = null;
        DatabaseMetaData metadata = null;
        try {
            ds = this.jdbc(runtime).getDataSource();
            con = DataSourceUtils.getConnection((DataSource)ds);
            metadata = con.getMetaData();
            columns = JDBCUtil.metadata((DriverAdapter)adapter, (DataRuntime)runtime, (boolean)true, columns, (DatabaseMetaData)metadata, (Table)table, (String)pattern);
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
        }
        finally {
            if (!DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
        }
        return columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Index> LinkedHashMap<String, T> indexs(DriverAdapter adapter, DataRuntime runtime, boolean create, LinkedHashMap<String, T> indexs, Table table, boolean unique, boolean approximate) throws Exception {
        JdbcTemplate jdbc;
        DataSource ds = null;
        Connection con = null;
        if (null == indexs) {
            indexs = new LinkedHashMap();
        }
        if (null == (jdbc = this.jdbc(runtime))) {
            return new LinkedHashMap();
        }
        try {
            ds = jdbc.getDataSource();
            con = DataSourceUtils.getConnection((DataSource)ds);
            DatabaseMetaData dbmd = con.getMetaData();
            adapter.checkName(runtime, null, (BaseMetadata)table);
            String[] tmp = adapter.correctSchemaFromJDBC(table.getCatalogName(), table.getSchemaName());
            ResultSet set = dbmd.getIndexInfo(tmp[0], tmp[1], table.getName(), unique, approximate);
            Map keys = JDBCUtil.keys((ResultSet)set);
            LinkedHashMap<String, Column> columns = null;
            while (set.next()) {
                String name = JDBCUtil.string((Map)keys, (String)"INDEX_NAME", (ResultSet)set);
                if (null == name) continue;
                Index index = (Index)indexs.get(name.toUpperCase());
                if (null == index) {
                    if (!create) continue;
                    index = new Index();
                    indexs.put(name.toUpperCase(), index);
                    index.setName(JDBCUtil.string((Map)keys, (String)"INDEX_NAME", (ResultSet)set));
                    index.setUnique(JDBCUtil.bool((Map)keys, (String)"NON_UNIQUE", (ResultSet)set, (Boolean)false) == false);
                    String catalog = (String)BasicUtil.evl((Object[])new String[]{JDBCUtil.string((Map)keys, (String)"TABLE_CATALOG", (ResultSet)set), JDBCUtil.string((Map)keys, (String)"TABLE_CAT", (ResultSet)set)});
                    String schema = (String)BasicUtil.evl((Object[])new String[]{JDBCUtil.string((Map)keys, (String)"TABLE_SCHEMA", (ResultSet)set), JDBCUtil.string((Map)keys, (String)"TABLE_SCHEM", (ResultSet)set)});
                    adapter.correctSchemaFromJDBC(runtime, (BaseMetadata)index, catalog, schema);
                    if (!adapter.equals(table.getCatalog(), index.getCatalog()) || !adapter.equals(table.getSchema(), index.getSchema())) continue;
                    index.setTable(JDBCUtil.string((Map)keys, (String)"TABLE_NAME", (ResultSet)set));
                    indexs.put(name.toUpperCase(), index);
                    columns = new LinkedHashMap<String, Column>();
                    index.setColumns(columns);
                    if (name.equalsIgnoreCase("PRIMARY")) {
                        index.setCluster(true);
                        index.setPrimary(true);
                    } else if (name.equalsIgnoreCase("PK_" + table.getName())) {
                        index.setCluster(true);
                        index.setPrimary(true);
                    }
                } else {
                    columns = index.getColumns();
                }
                String columnName = JDBCUtil.string((Map)keys, (String)"COLUMN_NAME", (ResultSet)set);
                Column col = table.getColumn(columnName.toUpperCase());
                Column column = null;
                if (null != col) {
                    column = (Column)col.clone();
                } else {
                    column = new Column();
                    column.setName(columnName);
                }
                String order = JDBCUtil.string((Map)keys, (String)"ASC_OR_DESC", (ResultSet)set);
                order = null != order && order.startsWith("D") ? "DESC" : "ASC";
                column.setOrder(order);
                column.setPosition(JDBCUtil.integer((Map)keys, (String)"ORDINAL_POSITION", (ResultSet)set, null));
                columns.put(column.getName().toUpperCase(), column);
            }
        }
        finally {
            if (null != con && !DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
        }
        return indexs;
    }
}

