/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.mongodb.datasource;

import com.mongodb.client.MongoDatabase;
import java.util.ArrayList;
import java.util.List;
import org.anyline.annotation.Component;
import org.anyline.data.datasource.DataSourceHolder;
import org.anyline.data.datasource.DataSourceLoader;
import org.anyline.data.datasource.init.AbstractDataSourceLoader;
import org.anyline.data.mongodb.datasource.MongoDataSourceHolder;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.util.DataSourceUtil;
import org.anyline.util.BasicUtil;
import org.anyline.util.ConfigTable;

@Component(value="anyline.environment.data.datasource.loader.mongo")
public class MongoDataSourceLoader
extends AbstractDataSourceLoader
implements DataSourceLoader {
    private final MongoDataSourceHolder holder = MongoDataSourceHolder.instance();

    public DataSourceHolder holder() {
        return this.holder;
    }

    public List<String> load() {
        ArrayList<String> list = new ArrayList<String>();
        boolean loadDefault = true;
        if (!ConfigTable.environment().containsBean("anyline.datasource..default")) {
            MongoDatabase datasource = null;
            DataRuntime runtime = null;
            try {
                datasource = (MongoDatabase)ConfigTable.environment().getBean(MongoDatabase.class);
            }
            catch (Exception e) {
                runtime = null;
            }
            if (null != datasource) {
                try {
                    runtime = this.holder().create("default", (Object)datasource, false);
                    loadDefault = false;
                }
                catch (Exception e) {
                    runtime = null;
                    log.error("\u52a0\u8f7dmongo\u6570\u636e\u6e90 \u5f02\u5e38:", (Throwable)e);
                }
            }
            if (null != runtime) {
                String url = ConfigTable.environment().string("spring.datasource.,anyline.datasource.", "url,uri");
                runtime.setUrl(url);
                if (BasicUtil.isNotEmpty((Object)url)) {
                    runtime.setAdapterKey(DataSourceUtil.parseAdapterKey((String)url));
                } else {
                    String adapterKey = ConfigTable.environment().string("spring.datasource.,anyline.datasource.", "adapter");
                    if (BasicUtil.isNotEmpty((Object)adapterKey)) {
                        runtime.setAdapterKey(adapterKey);
                    }
                }
            }
        } else {
            loadDefault = false;
        }
        list.addAll(this.load("spring.datasource", loadDefault));
        list.addAll(this.load("anyline.datasource", loadDefault));
        Object def = ConfigTable.environment().getBean("anyline.service.default");
        if (null == ConfigTable.environment().getBean("anyline.service") && null != def) {
            ConfigTable.environment().regBean("anyline.service", def);
        }
        return list;
    }

    protected List<String> load(String head, boolean loadDefault) {
        String prefixs;
        String def;
        ArrayList<String> list = new ArrayList<String>();
        if (loadDefault && !ConfigTable.worker.containsBean("anyline.service.default") && null != (def = this.holder().create("default", head))) {
            list.add(def);
        }
        if (null == (prefixs = ConfigTable.environment().string(null, head + ".list"))) {
            prefixs = ConfigTable.environment().string(null, head + "-list");
        }
        if (null != prefixs) {
            for (String prefix : prefixs.split(",")) {
                try {
                    String datasource;
                    if (ConfigTable.worker.containsBean("anyline.service." + prefix) || null == (datasource = this.holder().create(prefix, head + "." + prefix))) continue;
                    list.add(datasource);
                }
                catch (Exception e) {
                    log.error("[\u6ce8\u5165\u6570\u636e\u6e90\u5931\u8d25][type:mongo][key:{}][msg:{}]", (Object)prefix, (Object)e.toString());
                }
            }
        }
        return list;
    }
}

