/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.mongodb.datasource;

import com.mongodb.ConnectionString;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.anyline.annotation.Component;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.adapter.DriverAdapterHolder;
import org.anyline.data.datasource.DataSourceHolder;
import org.anyline.data.datasource.init.AbstractDataSourceHolder;
import org.anyline.data.mongodb.runtime.MongoRuntime;
import org.anyline.data.mongodb.runtime.MongoRuntimeHolder;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.util.BasicUtil;
import org.anyline.util.ConfigTable;

@Component(value="anyline.environment.data.datasource.holder.mongo")
public class MongoDataSourceHolder
extends AbstractDataSourceHolder
implements DataSourceHolder {
    private static final MongoDataSourceHolder instance = new MongoDataSourceHolder();

    public static MongoDataSourceHolder instance() {
        return instance;
    }

    public MongoDataSourceHolder() {
        DataSourceHolder.register((Object)"mongodb", (DataSourceHolder)this);
        DataSourceHolder.register(MongoClient.class, (DataSourceHolder)this);
        DataSourceHolder.register(MongoDatabase.class, (DataSourceHolder)this);
    }

    public String reg(String key, String prefix) {
        try {
            if (BasicUtil.isNotEmpty((Object)prefix) && !((String)prefix).endsWith(".")) {
                prefix = (String)prefix + ".";
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            String url = (String)this.value((String)prefix, "url", String.class, null);
            if (BasicUtil.isEmpty((Object)url)) {
                return null;
            }
            return this.inject(key, (String)prefix, map, true);
        }
        catch (Exception e) {
            log.error("\u6ce8\u518cMongo\u6570\u636e\u6e90 \u5f02\u5e38:", (Throwable)e);
            return null;
        }
    }

    public String create(String key, DatabaseType database, String url, String user, String password) throws Exception {
        return null;
    }

    public String create(String key, String prefix) {
        return this.reg(key, prefix);
    }

    public DataSource create(String key, Connection connection, boolean override) {
        return null;
    }

    public boolean validate(DataRuntime runtime) throws Exception {
        MongoClient client = ((MongoRuntime)runtime).client();
        client.listDatabaseNames();
        return true;
    }

    public String regTransactionManager(String key, DataSource datasource, boolean primary) {
        return "";
    }

    public String regTransactionManager(String key, MongoClient client, MongoDatabase database, boolean primary) {
        return "";
    }

    public String runtime(String key, String datasource, boolean override) throws Exception {
        return null;
    }

    public DataRuntime runtime(String key, Object datasource, String database, DatabaseType type, DriverAdapter adapter, boolean override) throws Exception {
        DataRuntime runtime = null;
        MongoClient client = null;
        if (datasource instanceof MongoClient) {
            client = (MongoClient)datasource;
            datasource = client.getDatabase(database);
        }
        if (datasource instanceof MongoDatabase) {
            if (null != ConfigTable.worker) {
                DataSourceHolder.check((String)key, (boolean)override);
                this.regTransactionManager(key, client, (MongoDatabase)datasource, true);
                runtime = MongoRuntimeHolder.instance().reg(key, client, (MongoDatabase)datasource);
                if (null == adapter && null != type) {
                    adapter = DriverAdapterHolder.getAdapter((DatabaseType)type);
                }
                if (null != adapter) {
                    runtime.setAdapter(adapter);
                }
            } else if (!caches.containsKey(key) || override) {
                caches.put(key, datasource);
            }
        }
        return runtime;
    }

    public String inject(String key, Map params, boolean over) throws Exception {
        return this.inject(key, null, params, over);
    }

    public String inject(String key, String prefix, Map<String, Object> params, boolean override) throws Exception {
        DataSourceHolder.check((String)key, (boolean)override);
        String datasource_id = "anyline.datasource." + key;
        try {
            String url = (String)this.value(params, "url", String.class, null);
            if (BasicUtil.isEmpty((Object)url)) {
                url = (String)this.value(prefix, "url", String.class, null);
            }
            if (BasicUtil.isEmpty((Object)url)) {
                return null;
            }
            String database = (String)this.value(params, "database", String.class, null);
            if (BasicUtil.isEmpty((Object)database)) {
                database = (String)this.value(prefix, "database", String.class, null);
            }
            if (!url.toLowerCase().startsWith("mongodb:")) {
                return null;
            }
            if (BasicUtil.isEmpty((Object)database)) {
                log.error("[\u6ce8\u5165\u6570\u636e\u6e90\u5931\u8d25][type:mongo][key:{}][msg:\u672a\u8bbe\u7f6edatabase]", (Object)key);
                return null;
            }
            ConnectionString connection = new ConnectionString(url);
            MongoClient client = MongoClients.create((ConnectionString)connection);
            DataSourceHolder.params.put(key, params);
            MongoDatabase db = client.getDatabase(database);
            MongoRuntimeHolder.instance().reg(key, client, db);
        }
        catch (Exception e) {
            log.error("[\u6ce8\u5165\u6570\u636e\u6e90\u5931\u8d25][type:mongo][key:{}][msg:{}]", (Object)key, (Object)e.toString());
            log.error("\u6ce8\u5165\u6570\u636e\u6e90 \u5f02\u5e38:", (Throwable)e);
            return null;
        }
        return datasource_id;
    }
}

