/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.mongodb.runtime;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.adapter.DriverAdapterHolder;
import org.anyline.data.mongodb.entity.MongoDataRow;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.runtime.RuntimeHolder;
import org.anyline.util.ConfigTable;

public class MongoRuntime
implements DataRuntime {
    private String origin;
    private String key;
    protected String feature;
    protected String version;
    protected DriverAdapter adapter;
    protected MongoClient client;
    protected MongoDatabase database;
    protected RuntimeHolder holder;
    protected String url;
    protected String driver;

    public MongoRuntime() {
        ConfigTable.DEFAULT_MONGO_ENTITY_CLASS = MongoDataRow.class;
    }

    public void setFeature(String feature) {
        this.feature = feature;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Object getProcessor() {
        return this.database;
    }

    public void setProcessor(Object processor) {
        if (processor instanceof MongoClient) {
            this.client = (MongoClient)processor;
        } else if (processor instanceof MongoDatabase) {
            this.database = (MongoDatabase)processor;
        }
    }

    public DriverAdapter getAdapter() {
        if (null == this.adapter) {
            String ds = this.key;
            this.adapter = DriverAdapterHolder.getAdapter((String)ds, (DataRuntime)this);
        }
        return this.adapter;
    }

    public String datasource() {
        String ds = this.key;
        return ds;
    }

    public void setAdapter(DriverAdapter adapter) {
        this.adapter = adapter;
    }

    public MongoRuntime(String key, MongoClient client, MongoDatabase database, DriverAdapter adapter) {
        this.setKey(key);
        this.setProcessor(database);
        this.setAdapter(adapter);
    }

    public MongoClient client() {
        return this.client;
    }

    public String origin() {
        return this.origin;
    }

    public void origin(String origin) {
        this.origin = origin;
    }

    public String getFeature(boolean connection) {
        if (null == this.feature && null != this.client) {
            this.feature = this.client.getClass().getName();
        }
        return this.feature;
    }

    public void setClient(MongoClient client) {
        this.client = client;
    }

    public MongoDatabase getDatabase() {
        return this.database;
    }

    public void setDatabase(MongoDatabase database) {
        this.database = database;
    }

    public String getVersion() {
        return this.version;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public RuntimeHolder getHolder() {
        return this.holder;
    }

    public void setHolder(RuntimeHolder holder) {
        this.holder = holder;
    }
}

